#!/bin/sh

# This script returns additional CFLAGS, for compiling the ovcam drivers, that
# cannot be autodetected easily by the Makefile or the C preprocessor


# RedHat 9 and Fedora 1 kernels have a different remap_page_range() signature
#  (same as 2.5/2.6 kernel)
# Is it a RedHat/Fedora system?
if [ -f /etc/redhat-release ]; then
	# RedHat _9_ system?
	if [ -n "$(grep Shrike /etc/redhat-release)" ]; then
		# RedHat kernel?
		if [ -n "$(uname -r | sed -n '/2.4.[0-9][0-9]-[0-9]/p')" ]; then
			echo "-DRH9_REMAP"
		fi
	# Fedora 1 system?
	elif [ -n "$(grep Yarrow /etc/redhat-release)" ]; then
		# Fedora kernel?
		if [ -n "$(uname -r | sed -n '/2.4.[0-9][0-9]-[0-9]/p')" ]; then
			echo "-DRH9_REMAP"
		fi
	fi
fi
