'\"
'\" Copyright (c) 2003-2004 Paul H Alfille, MD
'\" (paul.alfille@gmail.com)
'\"
'\" Device manual page for the OWFS -- 1-wire filesystem package
'\" Based on Dallas Semiconductor, Inc's datasheets, and trial and error.
'\"
'\" Free for all use. No waranty. None. Use at your own risk.
'\" $Id$
'\"
.TH DS2450 3  2003 "OWFS Manpage" "One-Wire File System"
.SH NAME
.TP
.B DS2450
Quad A/D Converter
.SH SYNOPSIS
.SS Voltage * 4  and Memory.
.PP
.B 20
[.]XXXXXXXXXXXX[XX][/[
.B PIO.[A-D|ALL]
|
.B volt.[A-D|ALL]
|
.B volt2.[A-D|ALL]
]]
.PP
.B 20
[.]XXXXXXXXXXXX[XX][/[
.B 8bit/volt.[A-D|ALL]
|
.B 8bit/volt2.[A-D|ALL]
]]
.PP
.B 20
[.]XXXXXXXXXXXX[XX][/[
.B memory
|
.B pages/page.[0-3|ALL]
|
.B power
]
.PP
.B 20
[.]XXXXXXXXXXXX[XX][/[
.B alarm/high.[A-D|ALL]
|
.B alarm/low.[A-D|ALL]
|
.B set_alarm/high.[A-D|ALL]
|
.B set_alarm/low.[A-D|ALL]
|
.B set_alarm/unset
|
.B set_alarm/volthigh.[A-D|ALL]
|
.B set_alarm/volt2high.[A-D|ALL]
|
.B set_alarm/voltlow.[A-D|ALL]
|
.B set_alarm/volt2low.[A-D|ALL]
]
.PP
.B 20
[.]XXXXXXXXXXXX[XX][/[
.so man3/standard_mini.3so
]]
.SS CO2 sensor
.PP
.B 20
[.]XXXXXXXXXXXX[XX][/[
.B CO2/ppm
|
.B CO2/power
|
.B CO2/status
]
.SH FAMILY CODE
.PP
.I 20
.SH SPECIAL PROPERTIES
.SS alarm/high.A ... alarm/high.D alarm.high.ALL
.SS alarm/high.A ... alarm/high.D alarm.high.ALL
.I read-write, binary
.br
The alarm state of the voltage channel. The alarm state is set one of two ways:
.TP
voltage conversion
Whenever the
.I DS2450
measures a voltage on a channel, that voltage is compared to the high and low limits
.I set_alarm/volthigh
and/or
.I set_alarm/voltlow
and if the alarm is enabled
.I set_alarm/high
and/or
.I set_alarm/low
the corresponding flag is set in
.I alarm/high
and/or
.I alarm/low
.TP
manual set
The flag can be set by a direct write to
.I alarm/high
or
.I alarm/low
.SS memory
.I read-write, binary
.br
32 bytes of data. Much has special implications. See the datasheet.
.SS pages/page.0 ... pages/page.3 pages/page.ALL
.I read-write, binary
.br
Memory is split into 4 pages of 8 bytes each. Mostly for reading and setting device properties. See the datasheet for details.
.br
.I ALL
is an aggregate of the pages. Each page is accessed sequentially.
.SS PIO.A ... PIO.D PIO.ALL
.I read-write, yes-no
.br
Pins used for digital control. 1 turns the switch on (conducting). 0 turns the switch off (non-conducting).
.br
Control is specifically enabled. Reading
.I volt
will turn off this control.
.br
.I ALL
is an aggregate of the voltages. Readings are made separately.
.SS power
.I read-write, yes-no
.br
Is the
.I DS2450
externally powered? (As opposed to parasitically powered from the data line).
.br
The analog A/D  will be kept on continuously. And the bus will be released during a conversion allowing other devices to communicate.
.br
Set true (1) only if Vcc powered (not parasitically powered). Unfortunately, the
.I DS2450
cannot sense it's powered state. This flag must be explicitly written, and thus is a potential source of error if incorrectly set.
.br
It is always safe to leave
.I power
set to the default 0 (off) state.
.SS set_alarm/high.A ... set_alarm/high.D set_alarm/high.ALL
.SS set_alarm/low.A ... set_alarm/low.D set_alarm/low.ALL
.I read-write, yes-no
.br
Enabled status of the voltage threshold. 1 is on. 0 is off.
.SS set_alarm/volthigh.A ... set_alarm/volthigh.D set_alarm/volthigh.ALL
.SS set_alarm/volt2high.A ... set_alarm/volt2high.D set_alarm/volt2high.ALL
.SS set_alarm/voltlow.A ... set_alarm/voltlow.D set_alarm/voltlow.ALL
.SS set_alarm/volt2low.A ... set_alarm/volt2low.D set_alarm/volt2low.ALL
.I read-write, floating point
.br
The upper or lower limit for the voltage measured before triggering an alarm.
.br
Note that the alarm must be enabled
.I alarm/high
or
.I alarm.low
and an actual reading must be requested
.I volt
for the alarm state to actually be set. The alarm state can be sensed at
.I alarm/high
and
.I alarm/low
.SS set_alarm/unset
.I read-write, yes-no
.br
Status of the power-on-reset (POR) flag.
.br
The POR is set when the
.I DS2450
is first powered up, and will match the alarm state until explicitly cleared. (By writing 0 to it).
.br
The purpose of the POR is to alert the user that the chip is not yet fully configured, especially alarm thresholds and enabling.
.SS volt.A ... volt.D volt.ALL
.SS 8bit/volt.A ... 8bit/volt.D 8bit/volt.ALL
.I read-only, floating point
.br
Voltage read, 16 bit resolution (or 8 bit for the 
.I 8bit
directory). Range 0 - 5.10V.
.br
Output (
.I PIO
) is specifically disabled.
.br
.I ALL
is an aggregate of the voltages. Readings are made separately.
.SS volt2.A ... volt2.D volt2.ALL
.SS 8bit/volt2.A ... 8bit/volt2.D 8bit/volt2.ALL
.I read-only, floating point
.br
Voltage read, 16 bit resolution (or 8 bit for the 
.I 8bit
directory). Range 0 - 2.55V.
.br
Output (
.I PIO
) is specifically disabled.
.br
.I ALL
is an aggregate of the voltages. Readings are made separately.
.SH CO2 (Carbon Dioxide) SENSOR PROPERTIES
The CO2 sensor is a device constructed from a SenseAir K30 and a
.I DS2450
.SS CO2/power
.I read-only, floating point
.br
Supply voltage to the CO2 sensor (should be around 5V)
.SS CO2/ppm
.I read-only, unsigned
.br
CO2 level in ppm (parts per million). Range 0-5000.
.SS CO2/status
.I read-only, yes-no
.br
Is the internal voltage correct (around 3.2V)?
.SH STANDARD PROPERTIES
.so man3/standard.3so
.SH ALARMS
None.
.SH DESCRIPTION
.so man3/description.3so
.SS DS2450
The
.B DS2450 (3)
is a (supposedly) high resolution A/D converter with 4 channels. Actual resolutin is reporterd to be 8 bits. The channels can also function as switches. Voltage sensing (with temperature and current, but sometimes restricted voltrage ranges) can also be obtained with the
.B DS2436
,
.B DS2438
and
.B DS276x
.SH ADDRESSING
.so man3/addressing.3so
.SH DATASHEET
.TP
DS2450
http://pdfserv.maxim-ic.com/en/ds/DS2450.pdf
.TP
CO2 sensor
http://www.senseair.se/Datablad/k30%20.pdf
.TP 
CO2 device
https://www.m.nu/co2meter-version-2-p-259.html?language=en
.SH SEE ALSO
.so man3/seealso.3so
.SH AVAILABILITY
http://www.owfs.org
.SH AUTHOR
Paul Alfille (paul.alfille@gmail.com)
