dnl
dnl checking for image stuff
dnl
AC_DEFUN([AC_CHECK_IMAGES], [
    AC_ARG_ENABLE([images], 
                  AC_HELP_STRING([--disable-images],
                                 [do not activate image support]),
                  [enable_images=no], [enable_images=yes])

    if test x"$enable_images" = xyes; then
        AC_PATH_PROG(giftopnm_path, giftopnm, no)
        AC_PATH_PROG(pngtopnm_path, pngtopnm, no)
        AC_PATH_PROG(jpgtopnm_path, jpegtopnm, no)
        AC_PATH_PROG(pamscale_path, pamscale, no)
        AC_PATH_PROG(pnmpad_path, pnmpad, no)
        AC_PATH_PROG(ppmtoy4m_path, ppmtoy4m, no)
        AC_PATH_PROG(mpeg2enc_path, mpeg2enc, no)
        AC_PATH_PROG(composite_path, composite, no)
        AC_PATH_PROG(convert_path, convert, no)

        if test "$giftopnm_path" != no && 
           test "$pngtopnm_path" != no &&
           test "$jpgtopnm_path" != no &&
           test "$pamscale_path" != no &&
           test "$pnmpad_path"   != no &&
           test "$mpeg2enc_path" != no &&
           test "$ppmtoy4m_path" != no &&
           test "$composite_path" != no &&
           test "$convert_path" != no ; then
            AC_DEFINE_UNQUOTED([BIN_GIFTOPNM], ["${giftopnm_path}"], [path to giftopnm])
            AC_DEFINE_UNQUOTED([BIN_PNGTOPNM], ["${pngtopnm_path}"], [path to pngtopnm])
            AC_DEFINE_UNQUOTED([BIN_JPGTOPNM], ["${jpgtopnm_path}"], [path to jpegtopnm])
            AC_DEFINE_UNQUOTED([BIN_PAMSCALE], ["${pamscale_path}"], [path to pamscale])
            AC_DEFINE_UNQUOTED([BIN_PNMPAD],   ["${pnmpad_path}"],   [path to pnmpad])
            AC_DEFINE_UNQUOTED([BIN_PPMTOY4M], ["${ppmtoy4m_path}"], [path to ppmtoy4m])
            AC_DEFINE_UNQUOTED([BIN_MPEG2ENC], ["${mpeg2enc_path}"], [path to mpeg2enc])
            AC_DEFINE_UNQUOTED([BIN_COMPOSITE],["${composite_path}"],[path to composite])
            AC_DEFINE_UNQUOTED([BIN_CONVERT],  ["${convert_path}"],  [path to convert])
            AC_DEFINE([HAVE_IMAGE_TOOLS], [1], [We have all necessary tools we need in the image section.])
            have_image_tools=yes
        else
            AC_MSG_WARN([*** You need mjpegtools, netpbm and imagemagic for the image section! ***])
            have_image_tools=no
        fi
    fi
])
