
/*
 * Copyright (C) 2004-2005 Maximilian Schwerin
 *
 * This file is part of oxine a free media player.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 * $Id: environment.h,v 1.9 2006/01/18 15:18:53 mschwerin Exp $
 *
 */

#ifndef HAVE_ENVIRONMENT_H
#define HAVE_ENVIRONMENT_H

#include "oxine.h"

typedef struct {
    char *device;
    char *mountpoint;
    // interesting for cdroms
    int is_disc_in;
    int is_type_cd;
} disc_entry_t;

disc_entry_t *get_first_disc (oxine_t * oxine);
disc_entry_t *get_next_disc (disc_entry_t * disc_entry);

const char *get_dir_home (void);
const char *get_dir_oxine (void);
const char *get_dir_oxine_cache (void);
const char *get_dir_oxine_tmp (void);

const char *get_file_config (void);

const char *get_file_mediamarks_music (void);
const char *get_file_mediamarks_video (void);
const char *get_file_mediamarks_image (void);

const char *get_file_lirc_config (void);
const char *get_file_dvb_channels (void);
const char *get_file_favorites (void);
const char *get_file_lastplaylist (void);

int mkdir_recursive (const char *mrl, mode_t mode);
int file_is_newer (const char *mrl1, const char *mrl2);

char *filename_escape_to_uri (const char *filename);
char *filename_escape_for_shell (const char *filename);

void environment_free (void);

#endif
