
/*
 * Copyright (C) 2004-2005 Maximilian Schwerin
 *
 * This file is part of oxine a free media player.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 * $Id: logger.h,v 1.3 2005/11/23 13:15:26 mschwerin Exp $
 *
 */

#ifndef HAVE_LOGGER_H
#define HAVE_LOGGER_H

#define LEVEL_FATAL (0)
#define LEVEL_ERROR (1)
#define LEVEL_WARN  (2)
#define LEVEL_INFO  (3)
#define LEVEL_DEBUG (4)

void _log (int level, const char *file, int line, const char *format, ...);

#ifdef DEBUG
#define debug(...) _log(LEVEL_DEBUG, __FILE__, __LINE__, __VA_ARGS__)
#else
#define debug(...) ;
#endif

#define log(level,...)  _log(level, __FILE__, __LINE__, __VA_ARGS__)
#define info(...)       _log(LEVEL_INFO, __FILE__, __LINE__, __VA_ARGS__)
#define warn(...)       _log(LEVEL_WARN, __FILE__, __LINE__, __VA_ARGS__)
#define error(...)      _log(LEVEL_ERROR, __FILE__, __LINE__, __VA_ARGS__)
#define fatal(...)      _log(LEVEL_FATAL, __FILE__, __LINE__, __VA_ARGS__)

#endif
