//
// C++ Implementation: columncontrol
//
// Description: 
//
//
// Author: Benjamin Mesing <bensmail@gmx.net>, (C) 2005
//
// Copyright: See COPYING file that comes with this distribution
//
//
#include "columncontroldlg.h"

ColumnControlDlg::ColumnControlDlg(QWidget* parent)
 : QDialog(parent)
{
	setupUi(this);
}


ColumnControlDlg::~ColumnControlDlg()
{
}


void ColumnControlDlg::setContent(const QStringList & shown, const QStringList & hidden)
{
   _pShownList->insertStringList(shown);
   _pHiddenList->insertStringList(hidden);
}



QStringList ColumnControlDlg::getShown()
{
   QStringList result;
   for (uint i=0; i<_pShownList->count(); ++i)
      result.push_back(_pShownList->text(i));
   return result;
}


QStringList ColumnControlDlg::getHidden()
{
   QStringList result;
   for (uint i=0; i<_pHiddenList->count(); ++i)
      result.push_back(_pHiddenList->text(i));
   return result;
}

void ColumnControlDlg::on__pHideButton_clicked()
{
   Q3ListBoxItem* pItem = _pShownList->selectedItem();
   // if nothing is selected
   if (pItem == 0)
      return;
   Q3ListBoxItem* pPrev = pItem->prev();
   _pHiddenList->insertItem(pItem->text());
   _pShownList->removeItem(_pShownList->index(pItem));
	if (pPrev)
		_pShownList->setSelected(pPrev, true);
	else
		_pShownList->setSelected(0, true);

}

void ColumnControlDlg::on__pShowButton_clicked()
{
   Q3ListBoxItem* pItem = _pHiddenList->selectedItem();
   // if nothing is selected
	if (pItem == 0)
      return;
   Q3ListBoxItem* pPrev = pItem->prev();
   _pShownList->insertItem(pItem->text());
   _pHiddenList->removeItem(_pHiddenList->index(pItem));
	if (pPrev)
		_pHiddenList->setSelected(pPrev, true);
	else
		_pHiddenList->setSelected(0, true);
}


void ColumnControlDlg::on__pUpButton_clicked()
{
   Q3ListBoxItem* pItem = _pShownList->selectedItem();
   if (!pItem)
		return;
	int index = _pShownList->index(pItem);
	QString text = pItem->text();
   // if it is already the first item
	if (index==0)
      return;
   _pShownList->removeItem(index);
   _pShownList->insertItem(text, index-1);
	_pShownList->setSelected(index-1, true);
}

void ColumnControlDlg::on__pDownButton_clicked()
{
   Q3ListBoxItem* pItem = _pShownList->selectedItem();
   if (!pItem)
		return;
   int index = _pShownList->index(pItem);
	QString text = pItem->text();
	// if it is already the last item
   if (index==_pShownList->count()-1)
      return;
   _pShownList->removeItem(index);
   _pShownList->insertItem(text, index+1);
	_pShownList->setSelected(index+1, true);
}

