//=======================================================================
// common.cc
//-----------------------------------------------------------------------
// This file is part of the package paco
// Copyright (C) 2004-2009 David Rosal
// For more information visit http://paco.sourceforge.net
//=======================================================================

#include "config.h"
#include "common.h"
#include <sstream>
#include <iomanip>
#include <fnmatch.h>

using std::string;
using namespace Paco;


//
// Check whether @path matches any path in the colon-separated @list of paths.
// Shell-like wildcards in @list are expanded.
//
bool Paco::inPaths(string const& path, string const& list)
{   
	std::istringstream s(list + ":");
	string buf;
	while (getline(s, buf, ':') && buf.size()) {
		if (buf == "/" || !fnmatch(buf.c_str(), path.c_str(), 0) || !path.find(buf + "/"))
			return true;
	}
	return false;
}


string Paco::toString(float size, int unit /* = HUMAN_READABLE */)
{
	if (size < 0)
		return "@";

	std::ostringstream s;
	
	if (unit == HUMAN_READABLE) {
		if (size < KILOBYTE)
			s << static_cast<int>(size);
		else if (size < MEGABYTE)
			s << static_cast<long>(size) / KILOBYTE << "k";
		else if (size < (10 * MEGABYTE))
			s << std::setprecision(2) << size / MEGABYTE << "M";
		else
			s << static_cast<long>(size / MEGABYTE) << "M";
	}
	else
		s << static_cast<long>(size / unit);
		
	return s.str();
}


string Paco::toString(long size, int unit /* = HUMAN_READABLE */)
{
	return toString(static_cast<float>(size), unit);
}


X::X(string const& msg)
:
	std::runtime_error(msg)
{ }


XErrno::XErrno(string const& msg)
:
	std::runtime_error(msg + ": " + strerror(errno))
{ }

