/* 
 * This file is subject to the terms and conditions of the GNU General Public
 * License.  See the file "COPYING" in the main directory of this archive
 * for more details.
 *
 * Copyright (C) Hewlett-Packard (Paul Bame) paul_bame@hp.com
 */
#include <asm/pdc.h>
#include "bootloader.h"
#undef PAGE0
#define	PAGE0	((struct zeropage *)0x00000000)

/* don't wait for a character -- return 0 if none is currently available */
int
getchar(void)
{
    char buf;
    int count;
    
    count = pdc_iodc_cin(&buf, 1);
    if (count > 0)
    {
	return buf;
    }
    else
    {
	return 0;		/* got nothing, or error */
    }
}

void
puts(const char *s)
{
    const char *nuline = s;

    while ((nuline = strchr(s, '\n')) != NULL)
    {
	pdc_iodc_cout(s, nuline - s + 1);
	pdc_iodc_cout("\r", 1);
	s = nuline + 1;
    }
    if (*s != '\0')
	pdc_iodc_cout(s, strlen(s));
}

void
putchar(char c)
{
    char buf[2];

    buf[0] = c;
    buf[1] = '\0';
    puts(buf);
}

int printf(const char *fmt, ...)
{
	char buf[1024];
	va_list args;
	int i;

	if (fmt == 0 || fmt[0] == 0)
		asm("\nprintf_test1: b,n .");

	va_start(args, fmt);
	i = vsprintf(buf, fmt, args);
	va_end(args);
	puts(buf);
	return i;
}
