#ifndef fooclientwindowhhfoo
#define fooclientwindowhhfoo

/* $Id: ClientWindow.hh 51 2006-04-07 21:11:09Z lennart $ */

/***
  This file is part of paman.
 
  paman is free software; you can redistribute it and/or modify
  it under the terms of the GNU Lesser General Public License as published
  by the Free Software Foundation; either version 2 of the License,
  or (at your option) any later version.
 
  paman is distributed in the hope that it will be useful, but
  WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
  General Public License for more details.
 
  You should have received a copy of the GNU Lesser General Public License
  along with paman; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
  USA.
***/

#include <gtkmm.h>
#include <libglademm.h>

class ClientWindow;

#include "ServerInfoManager.hh"

class ClientWindow : public Gtk::Window {
public:
    ClientWindow(BaseObjectType* cobject, const Glib::RefPtr<Gnome::Glade::Xml>& refGlade);
    static ClientWindow* create();

    Gtk::Label *nameLabel,
        *driverLabel,
        *indexLabel,
        *ownerModuleLabel;

    Gtk::Button *closeButton,
        *toOwnerModuleButton,
        *killButton;

    uint32_t owner_module;
    uint32_t index;
    
    void updateInfo(const ClientInfo &i);

    virtual void onCloseButton();
    virtual void onToOwnerModuleButton();
    virtual bool on_delete_event(GdkEventAny* e);
    virtual void onKillButton();
};

#endif
