/*
**  NSStringExtensions.m
**
**  Copyright (c) 2001, 2002
**
**  Author: Ludovic Marcotte <ludovic@Sophos.ca>
**          Jonathan B. Leffert <jonathan@leffert.net>
**
**  This library is free software; you can redistribute it and/or
**  modify it under the terms of the GNU Lesser General Public
**  License as published by the Free Software Foundation; either
**  version 2.1 of the License, or (at your option) any later version.
**  
**  This library is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
**  Lesser General Public License for more details.
**  
**  You should have received a copy of the GNU Lesser General Public
**  License along with this library; if not, write to the Free Software
**  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
*/

#import <Pantomime/NSStringExtensions.h>

#import <Pantomime/Constants.h>

@implementation NSString (PantomimeStringExtensions)

- (NSString *) stringByTrimmingWhiteSpaces
{
#ifdef GNUSTEP_BASE_VERSION
  return [self stringByTrimmingSpaces];
#else
  NSMutableString *mutableCopy = nil;
  NSRange theRange;

  mutableCopy = [[NSMutableString alloc] initWithString: self];

  theRange.location = 0;
  theRange.length = 1;

  while ( [mutableCopy hasPrefix: @" "] )
    {
      [mutableCopy deleteCharactersInRange: theRange];
    }

  theRange.location = [mutableCopy length] - 1;
  while ( [mutableCopy hasSuffix: @" "] )
    {
      [mutableCopy deleteCharactersInRange: theRange];      
      theRange.location = [mutableCopy length] - 1;
    }

  return AUTORELEASE(mutableCopy);
#endif
}


- (int) indexOfCharacter: (unichar) theCharacter
{
  int i;
  
  for (i = 0; i < [self length]; i++)
    {
      if ([self characterAtIndex: i] == theCharacter)
	{
	  return i;
	}
    }
  
  return -1;
}

- (BOOL) hasCaseInsensitivePrefix: (NSString *) thePrefix
{
  if ( thePrefix )
    {
      return [[self uppercaseString] hasPrefix: [thePrefix uppercaseString]];
    }
  
  return NO;
}

- (BOOL) hasCaseInsensitiveSuffix: (NSString *) theSuffix
{
  if ( theSuffix )
    {
      return [[self uppercaseString] hasSuffix: [theSuffix uppercaseString]];
    }
  
  return NO;
}

- (NSString *) stringFromQuotedString
{
  if ([self hasPrefix:@"\""] && [self hasSuffix:@"\""])
    {
      return [self substringWithRange: NSMakeRange(1, [self length] - 2)];
    }
  
  return self;
}

- (NSString *) stringByRemovingLineFeedCharacters
{
  register char *src, *dest;
  char *string;
  
  if ([self length] == 0)
    {
      return @"";
    }

  string = (char *)[self cString];
  
  /* DESTRUCTIVELY elide \n from string */
  src = dest = string;
  
  while (*src != '\0')
    {
      if (*src == '\n')
	{
	  ++src;
	}
      else
	{
	  *dest++ = *src++;
	}
    }
  
  *dest = '\0';

  return [NSString stringWithCString: string];  
}

@end
