/*
**  main.m
**
**  This is a small and simple (but useful) test framework.
**
**  Copyright (c) 2001, 2002
**
**  Author:  Alexander Malmberg <alexander@malmberg.org>
**
**  This library is free software; you can redistribute it and/or
**  modify it under the terms of the GNU Lesser General Public
**  License as published by the Free Software Foundation; either
**  version 2.1 of the License, or (at your option) any later version.
**  
**  This library is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
**  Lesser General Public License for more details.
**  
**  You should have received a copy of the GNU Lesser General Public
**  License along with this library; if not, write to the Free Software
**  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
*/

#include <Foundation/NSObject.h>
#include <Foundation/NSAutoreleasePool.h>
#include <Foundation/NSArray.h>

#include "TestCase.h"

int main(int argc, char **argv)
{
	CREATE_AUTORELEASE_POOL(arp);
	Class cl;
	void *state;
	struct objc_method_list *m;
	int i,j;
	const char *n;
	NSMutableArray *classes=[[NSMutableArray alloc] init];

	char *test;

	if (argc>1)
		test=argv[1];
	else
		test=NULL;

	state=NULL;
	while ((cl=objc_next_class(&state)))
	{
		if (strncmp(cl->name,"test",4)) continue;
		[classes addObject: cl];
	}

	for (j=0;j<[classes count];j++)
	{
		cl=[classes objectAtIndex: j];

		for (m=cl->methods;m;m=m->method_next)
		{
			for (i=0;i<m->method_count;i++)
			{
				n=sel_get_name(m->method_list[i].method_name);
				if (strncmp(n,"test",4)) continue;

				if (test)
					if (strcmp(test,n))
						continue;

				printf("running test '%s':\n",n);
				[cl runTestWithName: n];
			}
		}
		state=NULL;
	}

	DESTROY(arp);
	return 0;
}

