/*
**  POP3Message.m
**
**  Copyright (c) 2001, 2002, 2003
**
**  Author: Ludovic Marcotte <ludovic@Sophos.ca>
**
**  This library is free software; you can redistribute it and/or
**  modify it under the terms of the GNU Lesser General Public
**  License as published by the Free Software Foundation; either
**  version 2.1 of the License, or (at your option) any later version.
**  
**  This library is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
**  Lesser General Public License for more details.
**  
**  You should have received a copy of the GNU Lesser General Public
**  License along with this library; if not, write to the Free Software
**  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
*/

#include <Pantomime/POP3Message.h>

#include <Pantomime/Constants.h>
#include <Pantomime/POP3Folder.h>

@implementation POP3Message 

- (id) init
{
  self = [super init];
  
  [self setUID: nil];

  return self;
}


//
//
//
- (void) dealloc
{
  RELEASE(UID);
  [super dealloc];
}


//
// NSCoding protocol
//
- (void) encodeWithCoder: (NSCoder *) theCoder
{
  // Must also encode Message's superclass
  [super encodeWithCoder: theCoder];
  
  [theCoder encodeObject: [self UID]];
}


//
//
//
- (id) initWithCoder: (NSCoder *) theCoder
{
  // Must also decode Message's superclass
  self = [super initWithCoder: theCoder];

  [self setUID: [theCoder decodeObject]];

  return self;
}


//
// access / mutation methods
//
- (NSString *) UID
{
  return UID;
}


//
//
//
- (void) setUID: (NSString *) theUID
{
  if ( theUID )
    {
      RETAIN(theUID);
      RELEASE(UID);
      UID = theUID;
    }
  else
    {
      DESTROY(UID);
    }
}


//
// POP3 specific implementation of the rawSource method.
//
- (NSData *) rawSource
{
  POP3Folder *aFolder;

  aFolder = (POP3Folder *)[self folder];
  
  return [aFolder prefetchMessageAtIndex: [self messageNumber]];
}

@end
