class NP_Server
{
   const char *address, *home;
   int connected, seconds, timeout, fd;

   char error_message[ 2048 ];

   int ( *busy_callback )( void *, int, int );
   void *busy_callback_data;
   
   int wait_for_activity( int );
   int open_server( char *, int ( * )( void *, int, int ), void *, int );
   
   int np_fgets( char *, int );
   int np_read( char * );
   void np_fputs_error();
   int np_fputs( char * );
   
   int write_timestamp( char * );
   int getlist( char * );
   int get_newgroups( char * );

   int sort_server( char * );
   int sort_file( char *, void ( *SIGALRM_handler )( int ));

 public:

   NP_Server();
   ~NP_Server();
   
   do_connect( const char *, char *, int ( * )( void *, int, int ), void * );
   disconnect();

   void print_error() { fprintf( stderr, "%s\n", error_message ); };
   char *get_error() { return error_message; };
   
   const char *get_address();
   int get_list();
   int sort_list( char *, void( *SIGALRM_handler )( int ));

   int get_string( char *buffer, int size );
   int put_string( char * );
};

int compare( const void *, const void * );
