#include "npfile.h"
#include "npstringarray.h"

struct np_ref_node_t
{
   char *reference;
   struct np_ref_node_t *next, *prev;
};

struct np_thread_node_t
{
   char *subject;
   char *from;
   char *date;
   char *message_id;
   char *server;
   char *group;

   long offset;
   long size;

   int gap, ordinal, tree_ordinal;

   struct np_ref_node_t *references;

   int is_article, is_unseen, is_requested, is_child, child_count,
      descendents, unseen_descendents, requested_descendents,
      header_descendents;

   struct np_thread_node_t *next, *prev, *spool_next, *spool_prev, *parent,
      *child_head, *child_tail, *child_prev, *child_next;

   void *item, *label;
};

class NP_Threads
{
   char error_message[ 1024 ], *home, *server, *group;

   int total, unseen, headers, requested;

   load( char *, char *, int, int );
   sort();
   thread();
   fill_gaps();

   void recursively_fill_gaps( np_thread_node_t *, np_thread_node_t *, int );
   np_thread_node_t *make_phony_root( NP_Stringarray& );
   make( int, int );

   int make_refs( np_ref_node_t **, char *, NP_File& );
   void make_ref_list( np_ref_node_t **, char * );
   void dup_line( char **, char *, int );

   np_thread_node_t *threads, *spool_beginning;

 public:

   NP_Threads() { threads = NULL; server = NULL; group = NULL;
                  home = getenv( "HOME" ); };
   ~NP_Threads() { clear(); };

   np_thread_node_t *get_tree( char *, char *, int, int, int );
   np_thread_node_t *get_spool_beginning();

   void recursively_count_descendents( int *, int *, int *, int *,
                                       np_thread_node_t * );
   void get_totals( int *, int *, int *, int * );

   void clear();
   void assign( np_thread_node_t * );

   void print_error() { printf( "%s\n", error_message ); };
   char *get_error() { return error_message; };
};
