#include <stdlib.h>
#include <stdio.h>
#include <unistd.h>
#include <signal.h>

#include <X11/Xlib.h>
#include <gdk/gdkx.h>
#include <gtk/gtk.h>

#include "npfile.h"
#include "npstringarray.h"
#include "npgroup.h"
#include "npnode.h"
#include "nptree.h"
#include "npcollections.h"

void configure_button_callback( GtkWidget *widget, gpointer data )
{
   NP_Collections *collections = ( NP_Collections *)data;

   if ( collections->summary_pid )
      kill( collections->summary_pid, SIGUSR2 );

   pid_t pid;
   switch( pid = fork() )
   {
   case -1:
      perror( "fork" );
      break;

   case 0:
      close( ConnectionNumber( gdk_display ));
      execlp( "npconfig", "npconfig", NULL );
      perror( "execlp" );
      _exit( 1 );
      break;

   default:
      char buffer[ 128 ];
      snprintf( buffer, sizeof buffer, "%d", pid );
      if ( collections->children.add_item( buffer ))
         collections->children.print_error();
      break;
   }
   
   return;
}

