#include <stdlib.h>
#include <stdio.h>
#include <signal.h>
#include <unistd.h>
#include <sys/wait.h>

#include <gtk/gtk.h>

#include "npstringarray.h"
#include "npfile.h"
#include "npgroup.h"
#include "npnode.h"
#include "nptree.h"
#include "npcollections.h"

NP_Collections::~NP_Collections()
{
   if ( master_group_list != NULL )
      free( master_group_list );

   if ( tree_nodes != NULL )
   {
      if ( total_nodes )
      {
         for( int i = 0; i < total_nodes; ++i )
         {
            if ( tree_nodes[ i ].group_nodes != NULL )
               free( tree_nodes[ i ].group_nodes );

            if ( tree_nodes[ i ].messages != NULL )
               free( tree_nodes[ i ].messages );

            if ( tree_nodes[ i ].unseen != NULL )
               free( tree_nodes[ i ].unseen );

            if ( tree_nodes[ i ].headers != NULL )
               free( tree_nodes[ i ].headers );

            if ( tree_nodes[ i ].requested != NULL )
               free( tree_nodes[ i ].requested );
         }
      }

      free( tree_nodes );
   }
   
   char buffer[ 1024 ];
   snprintf( buffer, sizeof buffer, "%s/.npcollections:pid", home );
   remove( buffer );

   if ( summary_file != NULL )
      fclose( summary_file );

   int total = children.get_total();
   if ( total < 0 )
      children.print_error();
   else
      if ( total )
      {
         signal( SIGCHLD, SIG_IGN );
         for( int i = 0; i < total; ++i )
         {
            char *text = ( char *)children[ i ];
            if ( text == NULL )
            {
               children.print_error();
               continue;
            }
            
            pid_t pid = atoi( children[ i ] );
            if ( pid <= 0 )
            {
               children.print_error();
               continue;
            }

            kill( pid, SIGTERM );
            if ( !waitpid( pid, NULL, WNOHANG ))
            {
               sleep( 1 );
               kill( pid, SIGKILL );
            }
         }
      }

   if ( feedback_id != -1 )
      gdk_input_remove( feedback_id );

   SIGCHLD_handler( 0 );

   snprintf( buffer, sizeof buffer, "%s/.npcollections:font", home );
   FILE *font_file;
   if (( font_file = fopen( buffer, "w" )) != NULL )
   {
      int i = 1;
      if ( item == first_item )
         i = 0;
      else if ( item == second_item )
         i = 1;
      else if ( item == third_item )
         i = 2;

      fprintf( font_file, "%d\n", i );
      fclose( font_file );
   }

   save_size();

   return;
}
