#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <ctype.h>
#include <errno.h>

#include "npserver.h"

int NP_Server::sort_server( char *server )
{
   char buffer[ 1024 ], second_buffer[ 1024 ],
      **array, *test, *home;
   FILE *newsrc, *temp;
   int length;
   unsigned int count, i;


   snprintf( buffer, sizeof buffer, "%s/.peruser4-newsrc", 
             home = getenv( "HOME" ));
   if (( newsrc = fopen( buffer, "r" )) == NULL )
   {
      snprintf( error_message, sizeof error_message,
                "NP_Server: sort_server(): fopen() returned error: %s.",
                strerror( errno ));
      return 1;
   }

   strcat( buffer, ".tmp" );
   if (( temp = fopen( buffer, "w" )) == NULL )
   {
      fclose( newsrc );
      snprintf( error_message, sizeof error_message,
                "NP_Server: sort_server(): fopen() returned error: %s.",
                strerror( errno ));
      return 1;
   }

   length = strlen( server );

   while( ( test = fgets( buffer, sizeof buffer, newsrc )) != NULL )
      if ( !strncmp( buffer, server, length ))
         break;

   if ( test == NULL )
   {
      fclose( newsrc );
      fclose( temp );
      strcpy( error_message,
              "NP_Server: sort_server(): "
              "no such server in ~/.peruser4-newsrc" );
      return 1;
   }

   count = 0;
   while( fgets( buffer, sizeof buffer, newsrc ) != NULL )
   {
      if ( !isspace( buffer[ 0 ] ))
         break;

      ++count;
   }

   if (( array = ( char **)calloc( count, sizeof *array )) == NULL )
   {
      perror( "calloc" );
      exit( 1 );
   }

   rewind( newsrc );

   while( fgets( buffer, sizeof buffer, newsrc ) != NULL )
      if ( !strncmp( buffer, server, length ))
         break;

   for( i = 0; i < count; ++i )
   {
      fgets( buffer, sizeof buffer, newsrc );

      if (( array[ i ]
               = ( char *)malloc( strlen(
                  buffer + ( length =
                             strspn( buffer, " \t" )))))
            == NULL )
      {
         perror( "malloc" );
         exit( 1 );
      }

      strcpy( array[ i ], strtok( buffer + length, "\n" ));
   }

   qsort( array, count, sizeof *array, compare );

   rewind( newsrc );

   length = strlen( server );
   while( fgets( buffer, sizeof buffer, newsrc ) != NULL )
   {
      fputs( buffer, temp );

      if ( !strncmp( buffer, server, length ))
         break;
   }

   for( i = 0; i < count; ++i )
   {
      fprintf( temp, "\t%s\n", array[ i ] );
      free( array[ i ] );
   }

   free( array );

   for( i = 0; i < count; ++i )
      fgets( buffer, sizeof buffer, newsrc );

   while( fgets( buffer, sizeof buffer, newsrc ) != NULL )
      fputs( buffer, temp );

   fclose( newsrc );
   fclose( temp );

   snprintf( buffer, sizeof buffer, "%s/.peruser4-newsrc", home );
   strcpy( second_buffer, buffer );
   strcat( second_buffer, ".tmp" );

   rename( second_buffer, buffer );

   return 0;
}
