#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <ctype.h>
#include <errno.h>

#include "npfile.h"
#include "npstringarray.h"
#include "npsubscription.h"

int NP_Subscription::load()
{
   if ( total )
      if ( clear() )
         return 1;
   
   if ( newsrc_file.openr( newsrc_path ))
   {
      snprintf( error_message, sizeof error_message, "NP_Subscription: "
                "load(): %s", newsrc_file.get_error() );
      if ( errno != ENOENT )
         return 1;
   }

   if ( authentication.load() )
   {
      snprintf( error_message, sizeof error_message, "NP_Subscription: "
                "load(): %s", authentication.get_error() );
      newsrc_file.close();
      return 1;
   }

   int server, count;
   char *line, *pointer;
   server = -1;
   count = 0;
   
   while(( line = newsrc_file.get_string() ) != NULL )
   {
      ++count;

      if ( isspace( line[ 0 ] ))
      {
         strtok( line, ":" );
         if (( pointer = strtok( NULL, "\n" )) == NULL )
            pointer = "0";
            
         if ( add_group( server, line + strspn( line, " \t" ),
                         pointer + strspn( pointer, " \t" )))
            return 1;
       
         continue;
      }

      ++server;

      if ( add_server( strtok( line, "\n" )))
      {
         newsrc_file.close();
         return 1;
      }
   }

   newsrc_file.close();
   
   return 0;
}
