#include <signal.h>
#include <sys/wait.h>

#include "npsummary.h"

extern void *summary_p;

void SIGCHLD_handler( int signo )
{
   NP_Summary *summary = (NP_Summary *)summary_p;

   pid_t pid;
   while(( pid = waitpid( -1, NULL, WNOHANG )) > 0 )
   {
      if ( summary->text_pid && summary->text_pid == pid )
      {
         summary->text_pid = 0;
         fclose( summary->output );
         summary->output = NULL;
      }
      
      if ( summary->compose_pid && summary->compose_pid == pid )
         summary->compose_pid = 0;

      char buffer[ 128 ];
      snprintf( buffer, sizeof buffer, "%d", pid );
      int result;
      if (( result = summary->children.remove_item( buffer )))
         if ( result != 2 )
            summary->children.print_error();
   }

   signal( SIGCHLD, SIGCHLD_handler );

   return;
}
         
