#include "npsummary.h"

extern NP_Summary *summary_p;

int request_shortcut_callback( GtkWidget *widget, GdkEvent *event )
{
   if ( event->button.button != 1 )
      return FALSE;

   if ( event->type != GDK_2BUTTON_PRESS )
      return FALSE;

   return request_button_callback( widget, event );
}

int request_current_wrapper( GtkWidget *widget, GdkEvent *event )
{
   static int running = 0;
   if ( running )
      return FALSE;
   else
      running = 1;

   if ( event->button.button != 3 || event->type != GDK_BUTTON_PRESS )
   {
      running = 0;
      return FALSE;
   }

   NP_Summary *summary =
      ( NP_Summary *)gtk_object_get_data( GTK_OBJECT( widget ),
                                          "object" );
   if ( summary == NULL )
   {
      fprintf( stderr,
            "NULL summary pointer in request_current_wrapper()\n" );
      return FALSE;
   }

   np_thread_node_t *old_node = summary->current_node;
   void *old_selection = summary->selected_item;

   summary->selected_item = widget;
   summary->current_node = 
      ( np_thread_node_t *)gtk_object_get_data( GTK_OBJECT( widget ), 
                                                "node" );
   if ( summary->current_node == NULL )
   {
      summary->current_node = old_node;
      summary->selected_item = old_selection;
      running = 0;
      return FALSE;
   }

   request_current_callback( NULL, summary );

   summary->current_node = old_node;
   summary->selected_item = old_selection;

   running = 0;

   gtk_signal_emit_stop_by_name( GTK_OBJECT( widget ), "button_press_event" );

   return TRUE;
}
