#include <signal.h>
#include <unistd.h>

#include "nptext.h"

void signal_handler( int signo )
{
   _exit( signo );
}

void *text_p;

NP_Text::NP_Text( int *argc, char ***argv )
{
   text_p = this;
   reading = 0;
   compose_pid = 0;
   home = getenv( "HOME" );

   server = group = text = NULL;
   input = NULL;

   gtk_init( argc, argv );
   signal( SIGCHLD, SIGCHLD_handler );
   signal( SIGTERM, SIGTERM_handler );
   signal( SIGQUIT, SIGTERM_handler );
   signal( SIGUSR1, SIGUSR1_handler );
   signal( SIGUSR2, SIGUSR2_handler );
   signal( SIGSEGV, signal_handler );
   
   char buffer[ 1024 ];
   FILE *file;
   snprintf( buffer, sizeof buffer, "%s/.nptext:pid", home );
   if (( file = fopen( buffer, "w" )) == NULL )
   {
      perror( "fopen" );
      exit( 1 );
   }
   fprintf( file, "%d\n", getpid());
   fclose( file );

   window = gtk_window_new( GTK_WINDOW_TOPLEVEL );
   gtk_widget_realize( window );
   gtk_window_set_policy( GTK_WINDOW( window ), TRUE, TRUE, TRUE );

   gtk_container_border_width( GTK_CONTAINER( window ), 10 );
   gtk_signal_connect( GTK_OBJECT( window ), "delete_event",
                       GTK_SIGNAL_FUNC( close_button_callback ), NULL );
   gtk_signal_connect( GTK_OBJECT( window ), "destroy",
                       GTK_SIGNAL_FUNC( close_button_callback ), NULL );
   gtk_window_set_title( GTK_WINDOW( window ),
                         "News Peruser Message Viewer" );
   gtk_widget_realize( window );

   GtkWidget *frame = gtk_frame_new( NULL );
   gtk_widget_show( frame );
   gtk_container_add( GTK_CONTAINER( window ), frame );

   GtkWidget *table = gtk_table_new( 40, 80, FALSE );
   gtk_widget_show( table );
   gtk_container_border_width( GTK_CONTAINER( table ), 10 );
   gtk_container_add( GTK_CONTAINER( frame ), table );

   GtkWidget *vbox = gtk_vbox_new( FALSE, 0 );
   gtk_widget_show( vbox );
   gtk_table_attach_defaults( GTK_TABLE( table ), vbox, 0, 40, 0, 1 );

   subject_label = gtk_label_new( "" );
   gtk_misc_set_alignment( GTK_MISC( subject_label ), 0.0, 0.5 );
   gtk_widget_show( subject_label );
   gtk_box_pack_start( GTK_BOX( vbox ), subject_label, FALSE, FALSE, 0 );

   GdkColor subject_col = { 0, 0xcc00, 0, 0 };
   GdkColor from_col = { 0, 0, 0, 0xffff };
   GdkColor date_col = { 0, 0, 0xaa00, 0 };

   subject_style = gtk_style_copy( GTK_WIDGET( window )->style );
   subject_style->fg[ GTK_STATE_NORMAL ] = subject_col;
   gtk_widget_set_style( subject_label, subject_style );

   from_label = gtk_label_new( "" );
   gtk_misc_set_alignment( GTK_MISC( from_label ), 0.0, 0.5 );
   gtk_widget_show( from_label );
   gtk_box_pack_start( GTK_BOX( vbox ), from_label, FALSE, FALSE, 0 );

   from_style = gtk_style_copy( GTK_WIDGET( window )->style );
   from_style->fg[ GTK_STATE_NORMAL ] = from_col;
   gtk_widget_set_style( from_label, from_style );

   date_label = gtk_label_new( "" );
   gtk_misc_set_alignment( GTK_MISC( date_label ), 0.0, 0.5 );
   gtk_widget_show( date_label );
   gtk_box_pack_start( GTK_BOX( vbox ), date_label, FALSE, FALSE, 0 );

   date_style = gtk_style_copy( GTK_WIDGET( window )->style );
   date_style->fg[ GTK_STATE_NORMAL ] = date_col;
   gtk_widget_set_style( date_label, date_style );

   GtkWidget *scroll = gtk_scrolled_window_new( NULL, NULL );
   gtk_widget_show( scroll );
   gtk_scrolled_window_set_policy( GTK_SCROLLED_WINDOW( scroll ),
                                   GTK_POLICY_AUTOMATIC, 
                                   GTK_POLICY_AUTOMATIC );

   gtk_table_attach( GTK_TABLE( table ), scroll, 0, 39, 1, 78,
                     GTK_FILL | GTK_EXPAND, 
                     GTK_FILL | GTK_EXPAND, 0, 10 );

   text_style = gtk_style_copy( GTK_WIDGET( window )->style );

   text_widget = gtk_text_new( NULL, NULL );
   gtk_text_set_word_wrap( GTK_TEXT( text_widget ), 0 );
   gtk_widget_set_style( GTK_WIDGET( text_widget ), text_style );
   gtk_widget_show( text_widget );

   gtk_text_set_editable( GTK_TEXT( text_widget ), FALSE );
   GtkWidget *toolbar = gtk_toolbar_new( GTK_ORIENTATION_HORIZONTAL,
                                         GTK_TOOLBAR_TEXT );
   gtk_widget_show( toolbar );
   gtk_container_add( GTK_CONTAINER( scroll ), text_widget );

   reply_button = gtk_button_new_with_label( " Reply " );
   gtk_object_set_data( GTK_OBJECT( reply_button ), "what", ( gpointer) 0 );
   gtk_signal_connect( GTK_OBJECT( reply_button ), "clicked",
                       GTK_SIGNAL_FUNC( answer_buttons_callback ), this );

   gtk_toolbar_insert_element( GTK_TOOLBAR( toolbar ),
                               GTK_TOOLBAR_CHILD_WIDGET, reply_button,
                               NULL,
                               "Compose a reply to this message to be sent by "
                               "email to the author.", NULL, NULL, NULL, NULL,
                               GTK_TOOLBAR( toolbar )->num_children );

   follow_up_button = gtk_button_new_with_label( " Follow-Up " );
   gtk_object_set_data( GTK_OBJECT( follow_up_button ), "what", ( gpointer)1 );
   gtk_signal_connect( GTK_OBJECT( follow_up_button ), "clicked",
                       GTK_SIGNAL_FUNC( answer_buttons_callback ), this );
   
   gtk_toolbar_insert_element( GTK_TOOLBAR( toolbar ),
                               GTK_TOOLBAR_CHILD_WIDGET, follow_up_button,
                               NULL, "Compose a follow-up to this"
                               " message to be posted to the newsgroup.",
                               NULL, NULL, NULL, NULL,
                               GTK_TOOLBAR( toolbar )->num_children );

   both_button = gtk_button_new_with_label( " Both " );
   gtk_object_set_data( GTK_OBJECT( both_button ), "what", ( gpointer)2 );
   gtk_signal_connect( GTK_OBJECT( both_button ), "clicked",
                       GTK_SIGNAL_FUNC( answer_buttons_callback ), this );
   
   gtk_toolbar_insert_element( GTK_TOOLBAR( toolbar ),
                               GTK_TOOLBAR_CHILD_WIDGET, both_button, NULL,
                               "Compose a message that will be both sent by "
                               "email to the author and also posted to the "
                               "newsgroup.", NULL, NULL, NULL, NULL,
                               GTK_TOOLBAR( toolbar )->num_children );

   gtk_toolbar_append_space( GTK_TOOLBAR( toolbar ));

   cancel_button = gtk_button_new_with_label( " Cancel " );
   gtk_object_set_data( GTK_OBJECT( cancel_button ), "what", ( gpointer)3 );
   gtk_signal_connect( GTK_OBJECT( cancel_button ), "clicked",
                       GTK_SIGNAL_FUNC( answer_buttons_callback ), this );

   gtk_toolbar_insert_element( GTK_TOOLBAR( toolbar ), 
                               GTK_TOOLBAR_CHILD_WIDGET, cancel_button, NULL,
                               "Create a \"Cancel\" message, which when "
                               "posted, will cause news servers to delete "
                               "the current article.", NULL, NULL, NULL, NULL,
                               GTK_TOOLBAR( toolbar )->num_children );

   supersede_button = gtk_button_new_with_label( " Supersede " );
   gtk_object_set_data( GTK_OBJECT( supersede_button ), "what", ( gpointer)4 );
   gtk_signal_connect( GTK_OBJECT( supersede_button ), "clicked",
                       GTK_SIGNAL_FUNC( answer_buttons_callback ), this );

   gtk_toolbar_insert_element( GTK_TOOLBAR( toolbar ),
                               GTK_TOOLBAR_CHILD_WIDGET,
                               supersede_button, NULL,
                               "Create a \"Supersedes\" message, which when "
                               "posted, will cause news servers to replace "
                               "the current message with the superseding "
                               "message.", NULL,
                               NULL, NULL, NULL,
                               GTK_TOOLBAR( toolbar )->num_children );

   gtk_toolbar_append_space( GTK_TOOLBAR( toolbar ));

   edit_button = gtk_button_new_with_label( " Edit " );
   gtk_object_set_data( GTK_OBJECT( edit_button ), "what", ( gpointer)5 );
   gtk_signal_connect( GTK_OBJECT( edit_button ), "clicked",
                       GTK_SIGNAL_FUNC( answer_buttons_callback ), this );
   
   gtk_toolbar_insert_element( GTK_TOOLBAR( toolbar ),
                               GTK_TOOLBAR_CHILD_WIDGET, edit_button, NULL,
                               "Edit the current message", NULL, NULL, NULL,
                               NULL, 
                               GTK_TOOLBAR( toolbar )->num_children );
   
   gtk_toolbar_append_space( GTK_TOOLBAR( toolbar ));

   gtk_toolbar_append_item( GTK_TOOLBAR( toolbar ), " Export ",
                            "Write the message to a text file.", NULL, NULL,
                            GTK_SIGNAL_FUNC( export_callback ), this );

   toolbar = gtk_toolbar_new( GTK_ORIENTATION_HORIZONTAL, GTK_TOOLBAR_TEXT );
   gtk_widget_show( toolbar );
   gtk_table_attach_defaults( GTK_TABLE( table ), toolbar, 25, 35, 79, 80 );

   gtk_toolbar_append_item( GTK_TOOLBAR( toolbar ), " Show Header ",
                            "If the current message is a full article, show "
                            "or hide the article header.", NULL, NULL,
                            GTK_SIGNAL_FUNC( show_header_button_callback ),
                            this );

   toolbar = gtk_toolbar_new( GTK_ORIENTATION_HORIZONTAL, GTK_TOOLBAR_TEXT );
   gtk_widget_show( toolbar );
   gtk_table_attach_defaults( GTK_TABLE( table ), toolbar, 35, 40, 79, 80 );

   // font button and menu 

   menu = gtk_menu_new();

   first_item = gtk_menu_item_new_with_label( " Small Proportional " );
   gtk_widget_show( first_item );
   gtk_object_set_data( GTK_OBJECT( first_item ), "font", ( gpointer)0 );
   gtk_signal_connect( GTK_OBJECT( first_item ), "activate",
                       GTK_SIGNAL_FUNC( font_menu_callback ), this );
   gtk_menu_append( GTK_MENU( menu ), first_item );

   second_item = gtk_menu_item_new_with_label( " Medium Proportional " );
   gtk_widget_show( second_item );
   gtk_object_set_data( GTK_OBJECT( second_item ), "font", ( gpointer)1 );
   gtk_signal_connect( GTK_OBJECT( second_item ), "activate",
                       GTK_SIGNAL_FUNC( font_menu_callback ), this );
   gtk_menu_append( GTK_MENU( menu ), second_item );

   third_item = gtk_menu_item_new_with_label( " Large Porportional " );
   gtk_widget_show( third_item );
   gtk_object_set_data( GTK_OBJECT( third_item ), "font" , ( gpointer)2 );
   gtk_signal_connect( GTK_OBJECT( third_item ), "activate",
                       GTK_SIGNAL_FUNC( font_menu_callback ), this );
   gtk_menu_append( GTK_MENU( menu ), third_item );

   fourth_item = gtk_menu_item_new_with_label( " Small Fixed " );
   gtk_widget_show( fourth_item );
   gtk_object_set_data( GTK_OBJECT( fourth_item ), "font" , ( gpointer)3 );
   gtk_signal_connect( GTK_OBJECT( fourth_item ), "activate",
                       GTK_SIGNAL_FUNC( font_menu_callback ), this );
   gtk_menu_append( GTK_MENU( menu ), fourth_item );

   fifth_item = gtk_menu_item_new_with_label( " Medium Fixed " );
   gtk_widget_show( fifth_item );
   gtk_object_set_data( GTK_OBJECT( fifth_item ), "font" , ( gpointer)4 );
   gtk_signal_connect( GTK_OBJECT( fifth_item ), "activate",
                       GTK_SIGNAL_FUNC( font_menu_callback ), this );
   gtk_menu_append( GTK_MENU( menu ), fifth_item );

   sixth_item = gtk_menu_item_new_with_label( " Large Fixed " );
   gtk_widget_show( sixth_item );
   gtk_object_set_data( GTK_OBJECT( sixth_item ), "font" , ( gpointer)5 );
   gtk_signal_connect( GTK_OBJECT( sixth_item ), "activate",
                       GTK_SIGNAL_FUNC( font_menu_callback ), this );
   gtk_menu_append( GTK_MENU( menu ), sixth_item );

   font_button = gtk_button_new_with_label( " Fonts " );
   gtk_widget_show( font_button );
   gtk_object_set_data( GTK_OBJECT( font_button ), "object", this );
   gtk_signal_connect_object( GTK_OBJECT( font_button ), "clicked",
                              GTK_SIGNAL_FUNC( fonts_button_callback ),
                              GTK_OBJECT( menu ));

   gtk_toolbar_insert_element( GTK_TOOLBAR( toolbar ), 
                               GTK_TOOLBAR_CHILD_WIDGET,
                               font_button, NULL,
                            "Change the size of the fonts used in the tree.",
                            NULL, NULL, NULL, NULL,
                            GTK_TOOLBAR( toolbar )->num_children );

   gtk_toolbar_append_space( GTK_TOOLBAR( toolbar ));

   gtk_toolbar_append_item( GTK_TOOLBAR( toolbar ), " Close ",
                            "Close Window.", NULL, NULL,
                            GTK_SIGNAL_FUNC( close_button_callback ), this );

   input_id = gdk_input_add( fileno( stdin ), GDK_INPUT_READ, 
                             input_callback, this );

   item = NULL;
   FILE *font_file;
   snprintf( buffer, sizeof buffer, "%s/.nptext:font", home );
   if (( font_file = fopen( buffer, "r" )) != NULL )
   {
      if ( fgets( buffer, sizeof buffer, font_file ) != NULL )
      {
         switch( atoi( buffer ))
         {
            case 0:
               item = first_item;
               break;

            case 1:
               item = second_item;
               break;

            case 2:
               item = third_item;
               break;

            case 3:
               item = fourth_item;
               break;

            case 4:
               item = fifth_item;
               break;

            case 5:
               item = sixth_item;
               break;
         }

         if ( item != NULL )
            font_menu_callback( item, this );
      }

      fclose( font_file );
   }

   set_size();
   gtk_widget_show( window );

   return;
}
