
/* $Id: sda.h,v 1.10 2001/08/06 21:18:49 bsmith Exp $ */
/*
    Defines the interface object for the simplified distributed array
    */

#ifndef __SDA_H
#define __SDA_H

#include "src/dm/da/daimpl.h"

typedef struct _SDA* SDA;

EXTERN int SDACreate3d(MPI_Comm,DAPeriodicType,DAStencilType,
                int,int,int,int,int,int,int,int,int *,int *,int *,SDA *);
EXTERN int SDACreate2d(MPI_Comm,DAPeriodicType,DAStencilType,
                int,int,int,int,int,int,int *,int *,SDA *);
EXTERN int SDACreate1d(MPI_Comm,DAPeriodicType,int,int,int,int*,SDA *);
EXTERN int SDADestroy(SDA);
EXTERN int SDALocalToLocalBegin(SDA,PetscScalar*,InsertMode,PetscScalar*);
EXTERN int SDALocalToLocalEnd(SDA,PetscScalar*,InsertMode,PetscScalar*);

EXTERN int SDAGetCorners(SDA,int*,int*,int*,int*,int*,int*);
EXTERN int SDAGetGhostCorners(SDA,int*,int*,int*,int*,int*,int*);

#endif
