/* $Id: poisson2.h,v 1.1 2001/10/25 15:55:45 knepley Exp $ */

/* Main include file for the Poisson test problem */

#ifndef __POISSON_H
#define __POISSON_H

#include "petscsles.h"
#include "gsolver.h"

extern int POISSON_COOKIE;
extern int POISSON_ComputeField;

struct _PoissonContext {
  PETSCHEADER(int)
  Grid                   grid;        /* The problem grid */

  MeshBoundary2D         boundaryCtx; /* Describes the domain boundary */
  MeshGeometryContext    geometryCtx; /* Describes the domain geometry */

  SLES                   sles;        /* The linear solver context */
  GMat                   A;           /* The system matrix */
  GVec                   u;           /* The solution vector */
  GVec                   f;           /* The rhs vector */
  GVec                   uExact;      /* The exact solution vector */

  GVec                   constantU;   /* The constant vector over field u */
  MatNullSpace           nullSpace;   /* The psace spanned by uConstant */

  int                    dim;         /* The problem dimension */
  PetscTruth             linear;      /* Using linear elements (as opposed to quadratic) */
  PetscTruth             flipDisc;    /* Whether to use smoother discretization for u or v */
  int                    refineStep;  /* The step to start refining the mesh */
  int                    numLoops;    /* The number of systems to solve */

  GVecErrorKSPMonitorCtx monitorCtx;  /* Specialized monitor for grid vector linear solves */
};
typedef struct _PoissonContext *PoissonContext;

/* Creation functions */
EXTERN int PoissonContextCreate(MPI_Comm, PoissonContext *);
EXTERN int PoissonContextSetup(PoissonContext);
EXTERN int PoissonContextCreateMeshBoundary(PoissonContext);
EXTERN int PoissonContextDestroyMeshBoundary(PoissonContext);
EXTERN int PoissonContextCreateMesh(PoissonContext, Mesh *);
EXTERN int PoissonContextCreateGrid(PoissonContext);
EXTERN int PoissonContextRefineGrid(PoissonContext);
EXTERN int PoissonCreateStructures(PoissonContext);

/* Setup functions */
EXTERN int PoissonSetupGrid(PoissonContext);
EXTERN int PoissonSetupRhsFunction(Grid, PoissonContext);
EXTERN int PoissonSetupBC(Grid, PoissonContext);
EXTERN int PoissonSetupKSP(KSP, PoissonContext);
EXTERN int PoissonSetupPC(PC, PoissonContext);
EXTERN int PoissonSetupStructures(PoissonContext);

/* Cleanup functions */
EXTERN int PoissonDestroyStructures(PoissonContext);
EXTERN int PoissonDestroy(PoissonContext);
EXTERN int PoissonContextDestroy(PoissonContext);

/* Checking functions */
EXTERN int MatCheckSymmetry(Mat);
EXTERN int PoissonCheckSolution(PoissonContext, GVec, const char []);

/* Callback functions */
EXTERN int SolutionFunction(int, int, double *, double *, double *, PetscScalar *, void*);
EXTERN int GradientSolutionFunction(int, int, double *, double *, double *, PetscScalar *, void*);
EXTERN int RhsFunction(int, int, double *, double *, double *, PetscScalar *, void*);

/* Solver functions */
EXTERN int PoissonSolve(PoissonContext, GVec, GVec, int *);
EXTERN int PoissonComputeField(PoissonContext);

#endif /* __POISSON_H */
