
/* Mat */
typedef struct _p_Mat* Mat;

/* MatType */
typedef const char* MatType;
#define MATSAME            "same"
#define MATSEQMAIJ         "seqmaij"
#define MATMPIMAIJ         "mpimaij"
#define MATMAIJ            "maij"
#define MATIS              "is"
#define MATMPIROWBS        "mpirowbs"
#define MATSEQAIJ          "seqaij"
#define MATMPIAIJ          "mpiaij"
#define MATAIJ             "aij"
#define MATSHELL           "shell"
#define MATSEQBDIAG        "seqbdiag"
#define MATMPIBDIAG        "mpibdiag"
#define MATBDIAG           "bdiag"
#define MATSEQDENSE        "seqdense"
#define MATMPIDENSE        "mpidense"
#define MATDENSE           "dense"
#define MATSEQBAIJ         "seqbaij"
#define MATMPIBAIJ         "mpibaij"
#define MATBAIJ            "baij"
#define MATMPIADJ          "mpiadj"
#define MATSEQSBAIJ        "seqsbaij"
#define MATMPISBAIJ        "mpisbaij"
#define MATSBAIJ           "sbaij"
#define MATDAAD            "daad"
#define MATMFFD            "mffd"
#define MATNORMAL          "normal"
#define MATLRC             "lrc"
#define MATSEQAIJSPOOLES   "seqaijspooles"
#define MATMPIAIJSPOOLES   "mpiaijspooles"
#define MATSEQSBAIJSPOOLES "seqsbaijspooles"
#define MATMPISBAIJSPOOLES "mpisbaijspooles"
#define MATAIJSPOOLES      "aijspooles"
#define MATSBAIJSPOOLES    "sbaijspooles"
#define MATSUPERLU         "superlu"
#define MATSUPERLU_DIST    "superlu_dist"
#define MATUMFPACK         "umfpack"
#define MATESSL            "essl"
#define MATLUSOL           "lusol"
#define MATAIJMUMPS        "aijmumps"
#define MATSBAIJMUMPS      "sbaijmumps"
#define MATDSCPACK         "dscpack"
#define MATMATLAB          "matlab"
#define MATSEQCSRPERM      "seqcsrperm"
#define MATMPICSRPERM      "mpicsrperm"
#define MATCSRPERM         "csrperm"
#define MATSEQCRL          "seqcrl"
#define MATMPICRL          "mpicrl"
#define MATCRL             "crl"
#define MATPLAPACK         "plapack"
#define MATSCATTER         "scatter"
#define MATBLOCKMAT        "blockmat"
#define MATCOMPOSITE       "composite"
#define MATSEQFFTW         "seqfftw"

/* MatReuse */
typedef enum {
  MAT_INITIAL_MATRIX,
  MAT_REUSE_MATRIX
} MatReuse;

/* MatAssemblyType */
typedef enum {
  MAT_FLUSH_ASSEMBLY=1,
  MAT_FINAL_ASSEMBLY=0
} MatAssemblyType;

/* MatDuplicateOption */
typedef enum {
  MAT_DO_NOT_COPY_VALUES,
  MAT_COPY_VALUES
} MatDuplicateOption;

/* MatInfoType */
typedef enum {
  MAT_LOCAL=1,
  MAT_GLOBAL_MAX=2,
  MAT_GLOBAL_SUM=3
} MatInfoType;

/* MatStructure */
typedef enum {
  SAME_NONZERO_PATTERN,
  DIFFERENT_NONZERO_PATTERN,
  SAME_PRECONDITIONER,
  SUBSET_NONZERO_PATTERN
} MatStructure;

/* MatOrderingType */
typedef char* MatOrderingType;
#define MATORDERING_NATURAL     "natural"
#define MATORDERING_ND          "nd"
#define MATORDERING_1WD         "1wd"
#define MATORDERING_RCM         "rcm"
#define MATORDERING_QMD         "qmd"
#define MATORDERING_ROWLENGTH   "rowlength"
#define MATORDERING_DSC_ND      "dsc_nd"
#define MATORDERING_DSC_MMD     "dsc_mmd"
#define MATORDERING_DSC_MDF     "dsc_mdf"
#define MATORDERING_CONSTRAINED "constrained"
#define MATORDERING_IDENTITY    "identity"
#define MATORDERING_REVERSE     "reverse"

%constant MatOrderingType MATORDERING_OWD = MATORDERING_1WD;

typedef enum {
  MAT_ROW_ORIENTED,
  MAT_NEW_NONZERO_LOCATIONS,
  MAT_SYMMETRIC,
  MAT_STRUCTURALLY_SYMMETRIC,
  MAT_NEW_DIAGONALS,
  MAT_IGNORE_OFF_PROC_ENTRIES,
  MAT_NEW_NONZERO_LOCATION_ERR,
  MAT_NEW_NONZERO_ALLOCATION_ERR,
  MAT_USE_HASH_TABLE,
  MAT_KEEP_ZEROED_ROWS,
  MAT_IGNORE_ZERO_ENTRIES,
  MAT_USE_INODES,
  MAT_HERMITIAN,
  MAT_SYMMETRY_ETERNAL,
  MAT_USE_COMPRESSEDROW,
  MAT_IGNORE_LOWER_TRIANGULAR,
  MAT_ERROR_LOWER_TRIANGULAR,
  MAT_GETROW_UPPERTRIANGULAR
} MatOption;

/* MatNullSpace */
typedef struct _p_MatNullSpace* MatNullSpace;


/*
 * Local Variables:
 * mode: C
 * End:
 */
