/*
 * pftp -- sends files from host to host through free choosable ports
 *
 * Copyright (C) 1996-2000 Ben Schluricke
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or (at
 * your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the emplied warranty of MERCHANT-
 * ABILITY OF FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
 * Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 * 
 *    Written by Ben Schluricke
 *    E-Mail:    support@pftp.de
 *
 * This program is dedicated to my girl-friend, Heather O'Rourke.
 *
 *
 */
#ifdef USE_POSIX_THREAD
#define _REENTRANT
#include <pthread.h>
#endif
#include <stdio.h>
#include <unistd.h>
#include <stdlib.h>
#include <sys/ioctl.h>
#include <sys/stat.h>
#include <errno.h>
#include <dirent.h>
#include <ctype.h>
#include <string.h>
#include "status.h"

extern void Server(int);
extern int argum(int, char **, int *);
extern void Client(int, client_type *);
#if !defined __RH_CYGLINT__
extern void set_tty(int);
#endif
extern void create_data_info(char *);
extern void init_to_zero(void);

/*
 * Definition of some global variables
 */
status_type *statstr[MAXCLIENTS+1]; /* status structure vector */
#ifdef USE_POSIX_THREAD
pthread_mutex_t interactiv;
int CHILDNUM=0; /* number of children currently running */
long OUTPUT=0;
#endif
const char *pftp_alloc_error_str="** calloc: Cannot allocate enough memory.\n";
short pftpnoroot=1; /* let root login when running as daemon or from inetd */
int s=0; /* Socket */
FILE *slfp; /* pointer to stderr or server log file or NULL */
#if !defined __RH_CYGLINT__
volatile short _WINROWS_; /* Number of rows on the screen */
volatile short _WINCOLS_; /* Number of columns on the screen */
#endif
char *pftplog; /* holds the name of the log file if any */
char *_CLIENTHOSTNAME_[MAXCLIENTHOSTS]; /* specified client host names */
char *filter[SONAME]; /* holds the name of the filter program and its arguments */
char *client_destdir=NULL; /* Destination directory if sending to the daemon */
char *data_subject; /* subject of data sent */
char *data_info; /* subject of data sent */


#if !defined SunOS && !defined NEXTSTEP && !defined __RH_CYGLINT__
void exiting(void) {
#ifndef USE_POSIX_THREAD
   if ((*statstr)->isparent && (*statstr)->ttys) set_tty(0);
#else
   if ((*statstr)->ttys) set_tty(0);
#endif
}
#endif


int main(int argc, char **argv)
{
   int portn=0, y=0;

   slfp = stderr;

   /*
    * Initialize some vars to zero and create first statstr.
    */
   init_to_zero();

   /*
    * Get terminal modes if stderr is a terminal.
    */
#if !defined __RH_CYGLINT__
   if (isatty(0)) set_tty(3);
#endif

   /*
    * Get name of resource file.
    */
   if (!getuid()) {
      strcpy((*statstr)->home, PFTPSYSTEMRC);
   }
   else {
      char *tmpstr=getenv(__HOMEDIR_ENV__);
      if (tmpstr) {
         strcpy((*statstr)->home, getenv(__HOMEDIR_ENV__));
         strcat((*statstr)->home, PFTPRESOURCE);
      }
      else {
        fprintf(stderr, "** Cannot open pftp resource file.\n** Variable `%s' has to be set appropriately!\n", __HOMEDIR_ENV__);
         exit(PFTP_OPEN_RC_ERR);
      }
   }

   /*
    * Checking options.
    */
   y = argum(argc, argv, &portn);

   /*
    * Get terminal modes if stderr is a terminal.
    */
   if (isatty(0) && slfp) {
#if !defined SunOS && !defined NEXTSTEP && !defined __RH_CYGLINT__
      (*statstr)->ttys = BIT_ONE;
      atexit(exiting);
#endif
   }

   /*
    * Get Portnumber.
    */
   if (argc > 1) {
      if (!portn || (atoi(argv[1]) > 0 && strlen(argv[1]) < 6)) {
         portn = atoi(argv[1]);
      }
   }
   if (!((*statstr)->_PFTP_DAEMON_ & BIT_TWO) && portn < 1) {
         fprintf(stderr, "**\n** The resource file contains no default portnumber.\n**\n");
         exit(PFTP_PORT_ERR);
   }

   /*
    * Start the server.
    */
   if (y) {
      pid_t p_pid=0;

      if (!getuid() && portn < 1025) portn = INETD_PORT;
      else if (getuid() && portn < 1025) {
         fprintf(stderr, "** Portnumber has to be bigger then 1024 or be\n** started with super user privileges on port %d.\n", INETD_PORT);
         exit(PFTP_PORT_ERR);
      }
      if (!isatty(2) || slfp != stderr) {
         if (!(*statstr)->_SKIP_ && !(*statstr)->OVERWRITE) {
            (*statstr)->_SKIP_ = 1;
         }
      }
#ifdef USE_POSIX_THREAD
         CHILDNUM = 0;
#endif
      if ((*statstr)->use_udp && !(*statstr)->_STANDARD_INPUT_ && !(*statstr)->testbsize) {
         (*statstr)->_STANDARD_INPUT_ = BIT_ONE;
      }
      if ((*statstr)->_PFTP_DAEMON_) {
         /*
          * Freeing unused memory.
          */
         if (pftplog) {
            free(pftplog);
            pftplog = NULL;
         }

         /*
          * Start the daemon.
          */
         if (((*statstr)->_PFTP_DAEMON_ & BIT_ONE)) {
            if ((p_pid = fork()) < 0) {
               fprintf(stderr, "** fork: %s\n", _PFTP_ERROR_ARRAY_);
               exit(PFTP_FORK_ERR);
            }
            if (p_pid && slfp) {
#if defined TIOCNOTTY && defined Linux
               /*
                * Clear the controlling terminal.
                */
               if (!ioctl(1, TIOCNOTTY, (char *)NULL))
#endif
               if (*_CLIENTHOSTNAME_) fputc('\n', slfp);
               fprintf(slfp, "*** Daemon started with pid %d listening on port %d ***\n", p_pid, portn);
            }
            close(2);
         }
         else if (getuid()) {
            fprintf(stderr, "** pftp needs root privileges to be started by the internet daemon.\n");
            exit(PFTP_NO_ROOT);
         }
         slfp = NULL;
      }
      if ((*statstr)->testbsize) {
         (*statstr)->FORCE_STDOUT = 1;
         (*statstr)->exit_afc = 1;
      }
      if (!((*statstr)->maxclients)) (*statstr)->maxclients = MAXCLIENTS;
      if (!p_pid) Server(portn);
   }
   /*
    * Start the client.
    */
   else {
      client_type *clientstr;
      if ((*statstr)->KDE_FRONTEND) {
         (*statstr)->show_percent = 1;
         slfp = stderr;
      }
#ifdef NEXTSTEP
      if ((*statstr)->_RECURS_) {
         fprintf(stderr, "** Sorry, '-r' is not supported for the client on NEXTSTEP systems!\n");
         exit(PFTP_MCLOPTION_ERR);
      }
#endif
      /*
       * Create the info file if `-M' was given.
       */
      if (*((*statstr)->from) && (*statstr)->delete_info) {
         struct stat buf;
         create_data_info(data_info);
         if (!stat(data_info, &buf) && !buf.st_size) {
            if (!(*statstr)->KDE_FRONTEND && slfp) {
               fprintf(slfp, "** Message file is empty. Sending was discarded.\n");
            }
            unlink(data_info);
            exit(PFTP_NO_ERR);
         }
      }
      MEM_CHECK((clientstr = (client_type *)calloc(1, sizeof(client_type))));
#ifdef USE_POSIX_THREAD
      CHILDNUM = -1;
#endif
      clientstr->argc = argc - 1;
      clientstr->argv = argv;
      Client(portn, clientstr);   
   }

   exit(PFTP_NO_ERR);
}
