#!/bin/sh
#
# $Progeny: detectmodules.sh,v 1.21 2002/04/19 20:14:35 branden Exp $
#
# Echo module names found from the discover database as well as those in the
# pcmcia modules package.  These should be output sorted by priority,
# most important modules first.

if [ "$#" -lt "1" ] ; then
    echo "Usage: $0 kernel_version" 1>&2
    exit 1
fi

version=$1 ; shift

report_module() {
    if [ `find /lib/modules/$version -name $1.o -print | wc -l` -gt 0 ]; then
	echo $1
    fi
}

# basic set of modules
# XXX: CLEANUP NEEDED
if expr "$version" : "^2\.2" > /dev/null 2>&1; then
  BASE_MODULES="af_packet isofs nfs nls_cp437 ide-scsi mousedev vfat \
      unix agpgart sd_mod sr_mod i82365 ds"
elif expr "$version" : "^2\.4" > /dev/null 2>&1; then
  BASE_MODULES="af_packet isofs nfs nls_cp437 ide-probe-mod ide-disk \
      ide-scsi mousedev vfat unix agpgart sd_mod sr_mod i82365 ds efivars"
else
  echo "BASE_MODULES LIST FOR UNRECOGNIZED KERNEL $version GOES HERE"
  exit 1
fi

# list basic modules first
for module in $BASE_MODULES
do
    report_module $module
done

# pull the initial module listing out of the discover database based on it
# being a cdrom|scsi module
# XXX: When PGI supports a boot medium other than CD/DVD-ROM again, we will
# have to add any module type needed to access the medium with the modules
# archive (e.g., ethernet), or tell the person building PGI-build to mark
# those modules as essential.
for module in `awk '{ if (match($2, "cdrom|ether|scsi|usb") \
     && !match($3, "(ignore|unknown)")) print $3 }' \
     /usr/share/discover/*.lst | sort -u`
do
    report_module $module
done

# Fix bugs/omissions in discover database:
report_module pcnet32

# add pcmcia modules
for file in `dpkg --listfiles pcmcia-modules-$version | grep /lib/modules`
do
    if [ ! -d $file ] ; then
        report_module `basename $file` | sed 's/\.o//'
    fi
done

# vim:ai:et:sts=2:sw=2:tw=0:
