#!/usr/bin/env python

# Phatch - Photo Batch Processor
# Copyright (C) 2007-2008  www.stani.be
#
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see http://www.gnu.org/licenses/

"""Local launch script for all platforms"""

import os, sys

if hasattr(sys,"frozen"):
    FILE    = sys.argv[0]
    PHATCH_PYTHON_PATH = os.path.dirname(os.path.abspath(FILE))
    
    PATHS = {
        "PHATCH_PYTHON_PATH": PHATCH_PYTHON_PATH,
        "PHATCH_IMAGE_PATH" : os.path.join(PHATCH_PYTHON_PATH,'images'),
        "PHATCH_LOCALE_PATH": os.path.join(PHATCH_PYTHON_PATH,'locale'),
        "PHATCH_DOCS_PATH"  : os.path.join(PHATCH_PYTHON_PATH,'docs'),
        "PHATCH_ACTIONLISTS_PATH": os.path.join(PHATCH_PYTHON_PATH,"actionlists"),
    }
else:
    abs = os.path.abspath
    FILE    =  __file__
    PHATCH_PYTHON_PATH = os.path.dirname(os.path.abspath(FILE))

    PATHS = {
        "PHATCH_PYTHON_PATH": PHATCH_PYTHON_PATH,
        "PHATCH_IMAGE_PATH" : abs(os.path.join(PHATCH_PYTHON_PATH,'..','images')),
        "PHATCH_LOCALE_PATH": abs(os.path.join(PHATCH_PYTHON_PATH,'..','locale')),
        "PHATCH_DOCS_PATH"  : abs(os.path.join(PHATCH_PYTHON_PATH,'..','docs')),
        "PHATCH_ACTIONLISTS_PATH": abs(os.path.join(PHATCH_PYTHON_PATH,'..',"actionlists")),
    }

from core import config

def init_config_paths():
    #override paths with local paths
    return config.init_config_paths(config_paths = PATHS)

def main():
    config_paths    = init_config_paths()
    import app
    app.main(config_paths, app_file = FILE)

if __name__ == '__main__':
    main()
    
