<?php

/*************************************************************************\
* Bookkeeping (phpGroupWare app)                                          *
* http://www.phpgroupware.org                                             *
* Written by Rick Bakker <r.bakker@linvision.com>                         *
* --------------------------------------------                            *
* This program is free software; you can redistribute it and/or modify it *
* under the terms of the GNU General Public License as published by the   *
* Free Software Foundation; either version 2 of the License, or (at your  *
* option) any later version.                                              *
\*************************************************************************/

/* $Id: index.php,v 1.15 2001/06/18 22:13:57 darw1n Exp $ */

// $HTTP_POST_VARS
$bookkeeping_account_id = $HTTP_POST_VARS['bookkeeping_account_id'];
$submit                 = $HTTP_POST_VARS['submit'];

//
//
//
$phpgw_info['flags']['currentapp'] = 'bookkeeping';
include('../header.inc.php');

$bookkeeping_info['bookkeeping_account_id'] = $phpgw->session->appsession('id', 'bookkeeping');

//
//
//
$bookkeeping       = CreateObject('bookkeeping.bookkeeping');
$template_header   = CreateObject('phpgwapi.Template',PHPGW_APP_TPL);
$template_modules  = CreateObject('phpgwapi.Template',PHPGW_APP_TPL);
$template          = CreateObject('phpgwapi.Template',PHPGW_APP_TPL);
$template_footer   = CreateObject('phpgwapi.Template',PHPGW_APP_TPL);

if ($submit == '')
{
	if ($bookkeeping_info['bookkeeping_account_id'] != '')
	{
		$access = $bookkeeping->access_to_bookkeeping_account($bookkeeping_info['bookkeeping_account_id'], $phpgw_info['user']['account_id']);
		if ($access == '1')
		{
			$index_sub = '&nbsp;';
			$modules = $bookkeeping->show_all_modules($bookkeeping_info['bookkeeping_account_id']);
		}
		elseif ($access == '2')
		{
			$index_sub = '&nbsp;';
			$modules = $bookkeeping->show_modules($bookkeeping_info['bookkeeping_account_id'], $phpgw_info['user']['account_id']);
		}
		else
		{
			$template_sub = CreateObject('phpgwapi.Template',PHPGW_APP_TPL);
			$bookkeeping_account = $bookkeeping->get_bookkeeping_account_list($phpgw_info['user']['account_id']);
			if (count($bookkeeping_account == 0))
			{
				$template_sub->set_file(array('index_sub1' => 'index_sub1.tpl'));
				$template_sub->set_var('message', lang('no_access_to_a_bookkeeping_account'));
				$template_sub->parse('index_sub', 'index_sub1', true);
				$modules = '&nbsp;';
			}
			elseif (count($bookkeeping_account == 1))
			{
				$template_sub->set_file(array('index_sub2' => 'index_sub2.tpl'));
				$template_sub->set_var('message', lang('Automatically selected your only bookkeeping account.'));
				$bookkeeping_info['bookkeeping_account_id'] = $bookkeeping_account[0]['bookkeeping_account_id'];
				$phpgw->session->appsession('id', 'bookkeeping', $bookkeeping_info['bookkeeping_account_id']);
				$template_sub->parse('index_sub', 'index_sub2', true);
				if ($bookkeeping->is_admin($bookkeeping_info['bookkeeping_account_id']))
				{
					$modules = $bookkeeping->show_all_modules($phpgw_info['bookkeeping']['bookkeeping_id']);
				}
				else
				{
					$modules = $bookkeeping->show_modules($phpgw_info['bookkeeping']['bookkeeping_id'], $phpgw_info['user']['account_id']);
				}
			}
			else
			{
				$template_sub->set_file(array('index_sub3' => 'index_sub3.tpl'));
				$template_sub->set_var('actionurl', $phpgw->link('/bookkeeping/index.php'));
				$template_sub->set_var('selectbox_title', lang('choose_a_bookkeeping_account'));
				$selectbox = '<select name="bookkeeping_account_id">';
				for ($i=0; $i < count($bookkeeping_account); $i++)
				{
					$selectbox .= ('<option value="' . $bookkeeping_account[$i]['bookkeeping_account_id'] . '">' . $bookkeeping_account[$i]['bookkeeping_account'] . '</option>');
				}
				$selectbox .= '</select>';
				$template_sub->set_var('selectbox', $selectbox);
				$template_sub->set_var('submit', lang('submit'));
				$template_sub->parse('index_sub', 'index_sub3', true);
				$modules = '&nbsp;';
			}
		}
	}
	elseif (isset($phpgw_info['preferences']['bookkeeping']['bookkeeping_id']))
	{
		if ($bookkeeping->access_to_bookkeeping_account($phpgw_info['preferences']['bookkeeping']['bookkeeping_id'], $phpgw_info['user']['id']))
		{
			$phpgw_info['bookkeeping']['bookkeeping_id'] = $phpgw_info['preferences']['bookkeeping']['bookkeeping_id'];
			$modules = $bookkeeping->show_modules($phpgw_info['preferences']['bookkeeping']['bookkeeping_id']);
			$index_sub = '';
		}
		else
		{
			unset($phpgw_info['preferences']['bookkeeping']['bookkeeping_id']);
			$modules = '';
			// Automatisch naar niets als de user geen rechten meer heeft.
			$index_sub ='Verander je default bookkeeping_account';
		}
	}
	else
	{
		$template_sub = CreateObject('phpgwapi.Template',PHPGW_APP_TPL);
		$bookkeeping_account = $bookkeeping->get_bookkeeping_account_list($phpgw_info['user']['account_id']);

		if (count($bookkeeping_account) == 0)
		{
			$template_sub->set_file(array('index_sub1' => 'index_sub1.tpl'));
			$template_sub->set_var('message', lang('no_access_enzo'));
			$index_sub = $template_sub->parse('index_sub', 'index_sub1', true);
			$modules = '&nbsp;';
		}
		elseif (count($bookkeeping_account) == 1)
		{
			$template_sub->set_file(array('index_sub2' => 'index_sub2.tpl'));
			$template_sub->set_var('message', lang('Automatically selected your only bookkeeping account.'));
			$bookkeeping_info['bookkeeping_account_id'] = $bookkeeping_account[0]['bookkeeping_account_id'];
			$phpgw->session->appsession('id', 'bookkeeping', $bookkeeping_info['bookkeeping_account_id']);
			$index_sub = $template_sub->parse('index_sub', 'index_sub2', true);
			if ($bookkeeping->is_admin($bookkeeping_info['bookkeeping_account_id'],$phpgw_info['user']['account_id']))
			{
				$index_sub = '&nbsp;';
				$modules = $bookkeeping->show_all_modules($bookkeeping_info['bookkeeping_account_id']);
			}
			else
			{
				$index_sub = '&nbsp;';
				$modules = $bookkeeping->show_modules($phpgw_info['bookkeeping']['bookkeeping_id'], $phpgw_info['user']['account_id']);
			}
		}
		else
		{
			$template_sub->set_file(array('index_sub3' => 'index_sub3.tpl'));
			$template_sub->set_var('actionurl', $phpgw->link('/bookkeeping/index.php'));
			$template_sub->set_var('selectbox_title', lang('choose_a_bookkeeping_account'));
			$selectbox = '<select name="bookkeeping_account_id">';
			for ($i=0; $i < count($bookkeeping_account); $i)
			{       
				$selectbox .= '<option value="' . $bookkeeping_account[$i]['bookkeeping_account_id'] . '">' . $bookkeeping_account[$i]['bookkeeping_account'] . '</option>';
			}
			$selectbox .= '</select>';
			$template_sub->set_var('selectbox', $selectbox);
			$template_sub->set_var('submit', lang('submit'));
			$index_sub = $template_sub->parse('index_sub', 'index_sub3', true);
			$modules = '&nbsp;';
		}
	}
}
else
{
	if ($bookkeeping->is_admin($bookkeeping_info['bookkeeping_account_id']))
	{
		$modules = $bookkeeping->show_all_modules($phpgw_info['bookkeeping']['bookkeeping_id']);
	}
	else
	{
		$modules = $bookkeeping->show_modules($phpgw_info['bookkeeping']['bookkeeping_id'], $phpgw_info['user']['account_id']);
	}
	$index_sub = '&nbsp;';
}

//
//
//
$template_header->set_file(array('bookkeeping_header' => 'bookkeeping_header.tpl'));
$template_header->set_var('head_color', $phpgw_info['theme']['th_bg']);
$template_header->set_var('lang_app_title', lang('bookkeeping'));
$template_header->set_var('lang_module', lang('module'));
$template_header->set_var('module', '');
$template_header->set_var('lang_bookkeeping_account', lang('bookkeeping_account'));
if ($bookkeeping_info['bookkeeping_account_id'] != '')
{
	$phpgw->db->query("SELECT bookkeeping_account FROM phpgw_bk_ba WHERE bookkeeping_account_id='" . $bookkeeping_info['bookkeeping_account_id'] . "'");
	$phpgw->db->next_record();
	$bookkeeping_account = $phpgw->db->f('bookkeeping_account');
}
else
{
	$bookkeeping_account = '&nbsp;';
}
$template_header->set_var('bookkeeping_account', $bookkeeping_account);
$template_header->parse('out', 'bookkeeping_header', true);
$template_header->p('out');

//
//
//
$template_modules->set_file(array('bookkeeping_modules' => 'bookkeeping_modules.tpl'));
$template_modules->set_var('modules', $modules);
$template_modules->parse('out', 'bookkeeping_modules', true);
$template_modules->p('out');

//
//
//
$template->set_file(array('index' => 'index.tpl'));
$template->set_var('index_sub', $index_sub);
$template->parse('out', 'index', true);
$template->p('out');

//
//
//
$template_footer->set_file(array('bookkeeping_footer' => 'bookkeeping_footer.tpl'));
$template_footer->set_var('head_color', $phpgw_info['theme']['th_bg']);
$template_footer->parse('out', 'bookkeeping_footer', true);
$template_footer->p('out');

//
//
//
$phpgw->common->phpgw_footer();

?>
