#include	<stdio.h>
#include	<ctype.h>
#include	"pic.h"
#include	"picy.h"

static reset();
extern char *sprintf(), *strcpy();

struct	obj	*objlist[MAXOBJ];	/* store the elements here */
int	nobj	= 0;

struct attr	attr[40];	/* attributes stored here as collected */
int	nattr	= 0;	/* number of entries in attr_list */

struct	text	text[MAXTEXT];	/* text strings stored here as collected */
int	ntext	= 0;
int	ntext1	= 0;	/* record ntext here on entry to each figure */

float	curx	= 0;
float	cury	= 0;

int	hvmode	= R_DIR;	/* R => join left to right, D => top to bottom,
 etc. */

int	codegen	= 0;	/* 1=>output for this picture; 0=>no output */

float	deltx	= 6;	/* max x value in output, for scaling */
float	delty	= 6;	/* max y value in output, for scaling */
int	dbg	= 0;
extern	FILE	*yyin;	/* input file pointer */
FILE	*TEXFILE;	/* Output file */
int	lineno	= 0;
char	*filename	= "-";
int	synerr	= 0;
char	*cmdname;
int	crop	= 1;	/* trim off exterior white space if non-zero */
int	res	= 1000;		/* pseudo-resolution */

float	sxmin;		/* lower limit from s command */
float	symin;
float	sxmax	= 4096;	/* upper */
float	symax	= 4096;

float	xmin	= 30000;	/* min values found in actual data */
float	ymin	= 30000;
float	xmax	= -30000;	/* max */
float	ymax	= -30000;

main(argc, argv)
	char **argv;
{
	char TEXfilename[BUFSIZ], buffer[BUFSIZ], *bp, *rindex();

	cmdname = argv[0];
	while (argc > 1 && *argv[1] == '-') {
		switch (argv[1][1]) {
		case 'd':
			dbg = 1;
			break;
		}
		argc--;
		argv++;
	}
	setdefaults();
	if (argc <= 1) {
		fprintf(stderr, "pic2fig: No input file specified\n");
	} else
		while (argc-- > 1) {
			if ((yyin = fopen(*++argv, "r")) == NULL) {
				(void) sprintf(TEXfilename, "%s.pic", *argv);
				if ((yyin = fopen(TEXfilename, "r")) == NULL) {
				    fprintf(stderr, "pic2fig: can't open %s\n",
					*argv);
				    exit(1);
				}
			}
			filename = *argv;
			(void) sprintf(TEXfilename, "%s.fig", filename);
			(void) strcpy (buffer, filename);
			if ((bp = rindex (buffer, '.')) && strcmp (bp, ".pic") 
== 0) {
			    *bp = NULL;
			    (void) sprintf(TEXfilename, "%s.fig", buffer);
			}
#ifdef EUNICE
	/* Open up a VMS style file, can't use standard fopen */
			{int tmpfd;
			  if (((tmpfd = creat(TEXfilename,0644,"txt"))==-1) ||
			      ((TEXFILE = fdopen(tmpfd,"w"))==NULL)) {
			    fprintf(stderr,"Unable to open %s\n",TEXfilename);
			    exit(1);
			  }
			}
#else EUNICE
			TEXFILE = fopen(TEXfilename, "w");
			if (TEXFILE == NULL) {
			   fprintf(stderr, "Unable to open %s\n", TEXfilename);
			   exit(1);
			}
#endif EUNICE
			getdata(yyin);
			fclose(yyin);
			fclose(TEXFILE);
		}
	exit(0);
}

static struct {
	char *name;
	float val;
} defaults[] ={
	"scale", SCALE,
	"lineht", HT,
	"linewid", HT,
	"moveht", HT,
	"movewid", HT,
	"dashwid", HT10,
	"boxht", HT,
	"boxwid", WID,
	"circlerad", HT2,
	"arcrad", HT2,
	"ellipseht", HT,
	"ellipsewid", WID,
	"arrowht", HT5,
	"arrowwid", HT10,
	"textht", HT,
	"textwid", WID,
	NULL, 0
};

setdefaults()	/* set default sizes for variables like boxht */
{
	int i;
	YYSTYPE v;

	for (i = 0; defaults[i].name != NULL; i++) {
		v.f = defaults[i].val;
		makevar(tostring(defaults[i].name), VARNAME, v);
	}
}


checkscale(s)	/* if s is "scale", adjust default variables */
	char *s;
{
	int i;
	float scale;

	if (strcmp(s, "scale") == 0) {
		scale = getfval("scale");
		for (i = 1; defaults[i].name != NULL; i++)
			setfval(defaults[i].name, defaults[i].val * scale);
	}
}

getdata(fin)
	register FILE *fin;
{
	char buf[1000], buf1[50];
	FILE *svyyin;
	int svlineno;
	char *svfilename, *p;

	lineno = 0;
	while (fgets(buf, sizeof buf, fin) != NULL) {
		lineno++;
		if (*buf == '.' && *(buf+1) == 'P' && *(buf+2) == 'S') {
			for (p = &buf[3]; isspace(*p); p++)
				;
			if (*p++ == '<') {
				svyyin = yyin;
				svlineno = lineno;
				svfilename = filename;
				sscanf(p, "%s", buf1);
				if ((yyin = fopen(buf1, "r")) == NULL) {
					fprintf(stderr, "pic2fig: can't open %s\n"
, buf1);
					exit(1);
				}
				lineno = 0;
				filename = p;
				getdata(yyin);
				fclose(yyin);
				lineno = svlineno;
				yyin = svyyin;
				filename = svfilename;
				continue;
			}
			reset();
			yyparse();
			/* yylval now contains 'E' or 'F' from .PE or .PF */
			if (isspace(buf[3]) &&
				(isdigit(buf[4]) ||
					(buf[4]=='.' && isdigit(buf[5]))))
						/* assume next thing is width */
				deltx = delty = atof(&buf[4]);
			else {
				deltx = xmax - xmin;
				if (deltx <= 0)
					deltx = ymax - ymin;
				deltx = deltx / getfval("scale");
				delty = deltx;
			}
			dprintf("deltx = %.3f\n", deltx);
			if (codegen && !synerr) {
				openpl();
				print();	/* assumes \n at end */
				closepl();
			}
			fflush(stdout);
		}
		else
			fputs(buf, TEXFILE);
	}
}

static reset()
{
	struct obj *op;
	int i;
	extern int nstack;

	for (i = 0; i < nobj; i++) {
		op = objlist[i];
		if (op->o_type == BLOCK)
			freesymtab((struct symtab *)op->o_dotdash);	/* funn
y place */
		free((char *)objlist[i]);
	}
	nobj = 0;
	nattr = 0;
	for (i = 0; i < ntext; i++)
		if (text[i].t_val) free(text[i].t_val);
	ntext = ntext1 = 0;
	codegen = synerr = 0;
	nstack = 0;
	curx = cury = 0;
	hvmode = R_DIR;
	sxmin = symin = 0;
	sxmax = symax = 4096;
	xmin = ymin = 30000;
	xmax = ymax = -30000;
}
