/*
 * Picviz - Parallel coordinates ploter
 * Copyright (C) 2008 Sebastien Tricaud <toady@gscore.org>
 * Copyright (C) 2008 Philippe Saade <psaade@gmail.com>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation version 3.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * $Id: render.c 374 2009-01-20 18:08:24Z toady $
 */

#include <stdio.h>
#include <string.h>
#include <math.h>
#include <assert.h>

#include <picviz.h>
#include <linuxlist.h>
#include <learn.h>

PicvizBool picviz_axis_is_relative(PicvizAxis *axis)
{
        char *relative;
        relative = picviz_properties_get(axis->props, "relative");
        if (relative) {
                if ( ! strcmp(relative, "true")) {
                        return BOOL_TRUE;
                }
        }

        return BOOL_FALSE;
}

//void picviz_render_line(PicvizImage *image, PicvizLine *line)
//{
//
//}

void picviz_render_image(PicvizImage *image)
{
        int ret;
        PicvizAxis *axis;
        struct line_t *line;
        struct axisplot_t *axisplot;
        PcvHeight strheight, maxval;
	/* XXX: Use axis->ymin/max instead */
        PcvHeight string_max[PICVIZ_MAX_AXES];
        int i = 1;
        int axis_position;
        int line_removal_candidate;

        picviz_learn(image);

        if (! engine.__axis_label_exists) {
                image->header_height = 0;
        }

        llist_for_each_entry(axis, &image->axes, list) {
			/* XXX: This is not just for strings but also for log type */
                        if ((picviz_is_string_algo_basic(axis)) || axis->type == DATATYPE_LN) {
                                string_max[i] = picviz_line_max_get(image, &image->lines, i);
                                i++;
                        }
        }

        /*
         * FIXME: ideally, this should be done while parsing...
         */
        llist_for_each_entry(line, &image->lines, list) {
                llist_for_each_entry(axisplot, &line->axisplot, list) {
                        PicvizAxis *axis = (PicvizAxis *)picviz_axis_get(image, axisplot->axis_id);

                        if ( ! picviz_is_string_algo_basic(axis)) {
                                if (picviz_axis_is_relative(axis)) {
                                        strheight = picviz_line_value_get_from_string_dummy(image, axis, 1, axisplot->strval);

                                        if ( strheight < axis->ymin )
                                                axis->ymin = strheight;

                                        if ( strheight > axis->ymax)
                                                axis->ymax = strheight;
                                }
                        }
                }
        }

        llist_for_each_entry(line, &image->lines, list) {
                axis_position = 0;
                line_removal_candidate = 0;
                PicvizAxisPlot *ap_tbl[PICVIZ_MAX_AXES];

                llist_for_each_entry(axisplot, &line->axisplot, list) {
                        PicvizAxis *axis = (PicvizAxis *)picviz_axis_get(image, axisplot->axis_id);

                        if ( ( !(picviz_axis_is_relative(axis)) ) || (picviz_is_string_algo_basic(axis)) ) {
                                strheight = picviz_line_value_get_from_string_dummy(image, axis, 0,axisplot->strval);
                                maxval = picviz_variable_max(image, 0, axis->type);
                                if (picviz_is_string_algo_basic(axis)) {
                                        if (axis->type == DATATYPE_STRING) {
                                                if (string_max[axisplot->axis_id] > picviz_variable_max(image, 0, axis->type)) {
                                                        maxval = string_max[axisplot->axis_id];
                                                }
                                        }
                                }
                        } else {
                                maxval = picviz_variable_max(image, 1, axis->type);
                                strheight = picviz_line_value_get_from_string_dummy(image, axis, 1,axisplot->strval);
                                strheight -= axis->ymin;
                                maxval = axis->ymax - axis->ymin;
                        }

			if (axis->type == DATATYPE_LN) {
				axisplot->y = picviz_line_value_get_with_minmax(image, axis, axisplot->strval, 0, string_max[axisplot->axis_id]);
			} else if (axis->type == DATATYPE_PORT) {
				float value;
				if (strheight < 1024) {
					value = ((float)image->height / 2) / 1024;
					value *= strheight;
					axisplot->y = (PcvHeight) value;
				} else {
					value = ((float)(image->height - image->header_height) / 2) / (maxval - 1024);
					value *= strheight;
					axisplot->y = (PcvHeight) value + ((float)(image->height - image->header_height) / 2);
				}
			} else {
				axisplot->y = picviz_values_mapping_get_from_y(image, maxval, strheight);
			}

                        assert(axis_position < PICVIZ_MAX_AXES);
                        ap_tbl[axis_position++] = axisplot;
                }

                if ( image->filter ) {
                        ret = picviz_filter_display(image->filter, image, ap_tbl, axis_position);
                        if ( ret < 0 )
                                return;

                        line->hidden = ret;
                }
        }

}
