/***************************************************************************
 *   Copyright (C) 2005 Nicolas Hadacek <hadacek@kde.org>                  *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 ***************************************************************************/
#include "main_global.h"

#include <qpopupmenu.h>

#include "toplevel.h"
#include "common/global/about.h"
#include "global_config.h"
#include "devices/list/device_list.h"
#include "project_manager.h"
#include "editor_manager.h"
#include "tools/list/compile_config.h"
#include "gui_prog_manager.h"
#include "device_editor.h"

Main::State           Main::_state = Main::Idle;
EditorManager*        Main::_editorManager = NULL;
ProjectManager::View* Main::_projectManager = NULL;
Breakpoint::View*     Main::_breakpointsView = NULL;
Register::WatchView*  Main::_watchView = NULL;
Compile::LogWidget*   Main::_compileLog = NULL;
Compile::Manager*     Main::_compileManager = NULL;
ConsoleView*          Main::_consoleView = NULL;

void Main::setState(State state)
{
  _state = state;
  MainWindow::self().updateGUI();
}

Programmer::Generic* Main::programmer()
{
  return Programmer::manager->programmer();
}

const Programmer::Group& Main::programmerGroup()
{
  return Compile::Config::programmerGroup(Main::project());
}

Programmer::State Main::programmerState()
{
  return (programmer() != NULL ? programmer()->state() : Programmer::NotConnected);
}

KAction* Main::action(const char* name)
{
  return MainWindow::self().KMainWindow::action(name);
}
KAction* Main::action(KStdAction::StdAction action)
{
  return MainWindow::self().KMainWindow::action(KStdAction::name(action));
}

QPopupMenu& Main::popup(const char* name)
{
  QPopupMenu *popup = static_cast<QPopupMenu *>(MainWindow::self().factory()->container(name, &MainWindow::self()));
  Q_ASSERT(popup != NULL);
  return *popup;
}

QString Main::device()
{
 return Compile::Config::device(project());
}

const Device::Data* Main::deviceData()
{
  return Device::lister().data(device());
}

Editor* Main::currentEditor()
{
  return _editorManager->currentEditor();
}

Project* Main::project()
{
  return _projectManager->project();
}

const Tool::Group* Main::toolGroup()
{
  return (project() != NULL ? &Compile::Config::toolGroup(project()) : NULL);
}
