<?xml version="1.0"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:qof-qsf="http://qof.sourceforge.net/" xmlns:str="http://xsltsl.org/string" version="1.1">
  <xsl:import href="string.xsl"/>
  <!-- our own pilot-qof standard routines -->
  <xsl:import href="pilot-qof-std.xsl"/>
  <xsl:output method="text"/>
<!-- Representing QSF XML address data in a limited VCard 

  This stylesheet converts the output from pilot-qof -d pilot_address
  into a very brief Vcard, suitable for upload to mobile phones. Tested with a
  Motorola E1/ROKR using Bluetooth. For more capable VCard support, see other 
  vcard XSL stylesheets in the pilot-qof collection. Ensure that the file uses 
  the .vcf extension to enable the phone to understand the file type.

 This stylesheet is deceptively simple but surprisingly practical. It allows
 users to create mobile phone phonebook entries from existing Palm data - 
 there's no point in re-entering existing data.

 Only the first two phone number entries are tested, entryPhone1 is
 preferred to entryPhone2.

 Each VCard is written into a separate .vcf file, named after the 
 contact described in the pilot_address records. Spaces are replaced with
 underscores. Specify the '-o dir/' option to xsltproc to output all vcards
 into a directory.
-->
<!-- Licence

  This file is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
-->

  <xsl:template match="/">
    <xsl:for-each select="/*/qof-qsf:book/qof-qsf:object[@type='pilot_address']">
    <!-- Replace with a pattern match for only 0-9 or whitespace
      in XSLT 2.0 when supported by xsltproc -->
      <xsl:variable name="phone_test">
        <xsl:choose>
          <xsl:when test="qof-qsf:string[@type='entryPhone1'] = ''">
            <xsl:call-template name="str:subst">
              <xsl:with-param name="text" select="qof-qsf:string[@type='entryPhone2']"/>
              <xsl:with-param name="replace">
                <xsl:text> </xsl:text>
              </xsl:with-param>
              <xsl:with-param name="with"/>
            </xsl:call-template>
          </xsl:when>
          <xsl:otherwise>
            <xsl:call-template name="str:subst">
              <xsl:with-param name="text" select="qof-qsf:string[@type='entryPhone1']"/>
              <xsl:with-param name="replace">
                <xsl:text> </xsl:text>
              </xsl:with-param>
              <xsl:with-param name="with"/>
            </xsl:call-template>
          </xsl:otherwise>
        </xsl:choose>
      </xsl:variable>
      <xsl:variable name="contactName">
        <xsl:value-of select="qof-qsf:string[@type='entryFirstname']"/>
        <xsl:value-of select="qof-qsf:string[@type='entryLastname']"/>
      </xsl:variable>
      <xsl:variable name="card_title">
      <xsl:call-template name="get_chunk_name">
        <xsl:with-param name="entryCompany" select="qof-qsf:string[@type='entryCompany']"/>
        <xsl:with-param name="entryName" select="$contactName" />
      </xsl:call-template>
      </xsl:variable>
      <!-- chunking support -->
      <xsl:document href="{$card_title}.vcf" method="text">
        <xsl:choose>
          <xsl:when test="number($phone_test) &gt; 0">
            <xsl:text>BEGIN:VCARD&#10;VERSION:2.1&#10;N:</xsl:text>
            <xsl:value-of select="$card_title"/>
            <xsl:text>&#10;TEL;WORK:</xsl:text>
            <xsl:value-of select="$phone_test"/>
            <xsl:text>&#10;END:VCARD&#10;</xsl:text>
          </xsl:when>
          <!-- Mobile phones may reject vcards that have no number, so don't output a vcard
           if the $phone_test calculation did not return a usable number. -->
          <xsl:otherwise>
          </xsl:otherwise>
        </xsl:choose>
      </xsl:document>
    </xsl:for-each>
  </xsl:template>
</xsl:stylesheet>
