/*
 * Default cfg/header file for PIMPPA. Change to suit your needs.
 * You can later modify these values with "pcfg" or "bowser".
 *
 */

#ifndef P_PROTOH
#define P_PROTOH

// A directory where temporary files are stored.
// It should have lots of free space, probably twice
// as much as your newsserver can send you one run
// from one newsgroup.
#define P_TMPDIR "/tmp/"

// These are the filetype extensions the system will consider 
// when leeching news. The expression must be a modern/extended
// POSIX regular expression. (Use "man 7 regex" for help).
// Note that \\ must be used to escape special regexp chars like a dot.
//
// E.g. if you want to leech .RAR, .R00, .R01 to .R99 
// -style files, use something like 
// #define P_FILETYPES "\\.rar|\\.r[0-9][0-9]"
//
// Just plain pictures:
// #define P_FILETYPES "\\.jpg|\\.png|\\.gif|\\.jpeg"
//
//
#define P_FILETYPES "\\.jpg|\\.png|\\.gif|\\.mpg|\\.avi|\\.asf|\\.wmv|\\.swf|\\.rm|\\.jpeg|\\.mpeg|\\.ecc|\\.mp3|\\.rar|\\.r[0-9][0-9]|\\.s[0-9][0-9]|\\.zip|\\.ace|\\.a[0-9][0-9]|\\.[0-9][0-9][0-9]|\\.c[0-9][0-9]"

// Convert all files from news to lowercase
#define P_TOLOWERCASE			"1" 
// How many numbers should filenames from news have? (0=disable)
#define P_NEEDNUMBERS			"0"
// How many non-number chars should filenames have before extension? (0=dis)
#define P_NEEDOTHERS			"0"
// Discard files which have spaces in filenames
#define P_NOSPACE				"0"
// Use strict md5sum checking (delete colliding files, leave the oldest one)
// Otherwise gives just a warning
#define P_STRICTMD5				"1"
// Minimun length of filename (before the first dot) to 
// create an assign pattern from. E.g. length of "12.jpg" is 2
#define P_MIN_ASS_NAMELENGTH	"4"
// When leeching news, how many seconds should we wait after downloading
// a certain number of messages? (To not choke the server)
// Default: After processing 10 messages, wait 2 seconds.
#define P_NEWS_WAIT_AFTER		"10"
#define P_NEWS_WAIT_SECS		"2"
// Hom many days to show backwards when starting bowser? (0=Unl / All files)
#define P_BOWSER_DEFAULT_SINCE	"1"

// Picture viewer used by "bowser". The viewer should accept 
// path as a command line argument.
#define P_VIEWER				"gqview"

// Options for suck. You should not modify these unless you know 
// precisely what you're trying to do (man suck may help).
// Note that options -U, -P, -g, -q and -dd are passed automatically
// by pimppa. The first line below is for header dl phase,
// the second for article dl phase.
#define P_SUCKOPTS_HEADER		"-c -n"
#define P_SUCKOPTS_BODY			"-c"

/*********************************************************************/
/* Should be NOTHING to edit below this                              */
/*********************************************************************/

#include "common.h"

// The database user and the actual database name. You probably
// shouldn't change these unless you have excellent reasons.
#define P_USER	"pimppa"
#define P_DBASE "pimppa"

// QUERY_MAX should not be made smaller!!! 
#define QUERY_MAX 4096
#define BUFFSIZE 2048

#define P_CP_BUFFSIZE 65536

#define bint unsigned long long

typedef enum
{
	FILE_OFFLINE	=	(1L<<0),		// 1
	FILE_DELETE		=	(1L<<1)			// 2
} FileType;

typedef enum
{
	AREA_NOTRANS	=	(1L<<0),		// 1
	AREA_INCOMING	=	(1L<<1),		// 2
	AREA_NOASSIGN   =	(1L<<2)			// 4
} AreaType;

typedef enum
{
	GROUP_DISABLED	=	(1L<<0)			// 1
} GroupType;

typedef enum
{
	INTEG_NEW 		= 0,
	INTEG_PASSED 	= 1,
	INTEG_FAILED 	= 2,
	INTEG_UNKNOWN 	= 3
} IntegrityType;

typedef enum
{
	TRANS_NEW		=	0,
	TRANS_PASSED	=	1,
	TRANS_FAILED	=	2,
	TRANS_UNKNOWN	=	3
} TransType;

typedef enum
{
	RULE_FILENAME   =	0,
	RULE_KEYWORD	=	1
} RuleType;

#define OPT_NAZI						(1L<<0)		// 1
#define OPT_VERBOSE						(1L<<1)		// 2
#define OPT_MOVE						(1L<<2)		// 4
#define OPT_STATS						(1L<<3)		// 8
#define OPT_LENIENT						(1L<<4)		// 16
#define OPT_QUIET						(1L<<5)		// 32
#define OPT_RESTART						(1L<<6)		// 64
#define OPT_SLOPPY                      (1L<<7)		// 128
#define OPT_INSERTSUBJECTS              (1L<<8)		// 256
#define OPT_KEYNAZI                     (1L<<9)		// 512

#define P_LEN_AREA_NAME		50
#define P_LEN_AREA_PATH		255

// Too bad folks, filenames longer than this won't do
#define P_LEN_FILE_NAME		128

#define P_KEY_BOWSERSINCE   "CFG_BOWSERSINCE"
#define P_KEY_FILETYPES		"CFG_FILETYPES"
#define P_KEY_MINASSNAMELEN "CFG_MINASSIGNNAMELEN"
#define P_KEY_NEEDNUMBERS   "CFG_NEEDNUMBERS"
#define P_KEY_NEEDOTHERS    "CFG_NEEDOTHERS"
#define P_KEY_NEWSWAITAFTER	"CFG_NEWSWAITAFTER"
#define P_KEY_NEWSWAITSECS	"CFG_NEWSWAITSECS"
#define P_KEY_NOSPACE		"CFG_NOSPACE"
#define P_KEY_STRICTMD5     "CFG_STRICTMD5"
#define P_KEY_TMPDIR		"CFG_TMPDIR"
#define P_KEY_TOLOWERCASE	"CFG_TOLOWERCASE"
#define P_KEY_VIEWER		"CFG_VIEWER"

#define P_KEY_PBACK			"PBACK_LASTAREA"
#define P_KEY_STATS			"PIMPPA_BOWSERSTATS"
#define P_KEY_VIEW_LAST		"PIMPPA_PVLAST"	

#endif
