/*
 * $Id: os.h,v 1.22 2001/07/22 15:59:01 nordstrom Exp $
 *
 * Viewer - a part of Plucker, the free off-line HTML viewer for PalmOS
 * Copyright (c) 1998-2001, Mark Ian Lillywhite and Michael Nordstrm
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 */

#ifndef __PLUCKER_OS_H
#define __PLUCKER_OS_H

#include "viewer.h"


/* font style */
#define MINSTYLES       0
#define MAXSTYLES       9
#define DEFAULTSTYLE    0


Boolean AutoCFSupported( void );
Boolean BeamSupported( void );
Boolean DefaultScreenMode( void );
Boolean FfsSupported( void );
Boolean ZLibSupported( void );
Err OS_Start( void );
FontID GetStyle( const Int16 style );
UInt16 GetFsfRef( void );
UInt32 GetMaxScreenDepth( void );
UInt32 GetOSVersion( void );
void OS_Stop( void );
void SetFontStylesOS2( void );
void SetFontStylesOS3( void );

void ( *fontStyles ) ( void );

#define SetFontStyles() ( *fontStyles )()

#endif
