/*
 * $Id: screen.h,v 1.16 2001/07/18 20:01:37 nordstrom Exp $
 *
 * Viewer - a part of Plucker, the free off-line HTML viewer for PalmOS
 * Copyright (c) 1998-2001, Mark Ian Lillywhite and Michael Nordstrm
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 */

#ifndef __PLUCKER_SCREEN_H
#define __PLUCKER_SCREEN_H

#include "viewer.h"


void SetScreenModeOS3( void );
void SetScreenModeOS2( void );
void SetDefaultScreenModeOS3( Boolean save );
void SetDefaultScreenModeOS2( Boolean save );

Boolean TooHighBitDepth_Default( UInt32 depth );
Boolean TooHighBitDepth_Max( UInt32 depth );

Boolean (*depthCheck)( UInt32 );
void (*screenMode)( void );
void (*defaultMode)( Boolean );


#define TooHighBitDepth( depth )        (*depthCheck)( depth )
#define SetScreenMode()                 (*screenMode)()
#define SetDefaultScreenMode( save )    (*defaultMode)( save )

#endif
