/*
 * $Id: util.c,v 1.23 2001/10/27 18:56:41 nordstrom Exp $
 *
 * Viewer - a part of Plucker, the free off-line HTML viewer for PalmOS
 * Copyright (c) 1998-2001, Mark Ian Lillywhite and Michael Nordstrm
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 */

#include "const.h"
#include "debug.h"
#include "prefsdata.h"
#include "util.h"
#include "os.h"
#include "AutoCF.h"


void InitializeViewportBoundaries(void) PLKRDB_SECTION;
Boolean DatabaseInCF( LocalID dbID ) PLKRDB_SECTION;
Int16 MaxExtentX(void) PLKRDB_SECTION;
Int16 MaxExtentY(void) PLKRDB_SECTION;
Int16 TopLeftX( void ) PLKRDB_SECTION;
Int16 TopLeftY( void ) PLKRDB_SECTION;
Int16 ExtentX( void ) PLKRDB_SECTION;
Int16 ExtentY( void ) PLKRDB_SECTION;
Int16 GetScrollValue( void ) PLKRDB_SECTION;
void* GetObjectPtr( const Int16 objectID ) PLKRDB_SECTION;
void TrimText( Char* text, Int16 len ) PLKRDB_SECTION;
void SendAppStopEvent( void ) PLKRDB_SECTION;
void StrikeThrough( const RectangleType* box ) PLKRDB_SECTION;


/***********************************************************************
 *
 *      Internal Constants
 *
 ***********************************************************************/
 static Int16 maxExtentX;
 static Int16 maxExtentY;
 static Int16 topLeftX;
 static Int16 topLeftY;
 static Int16 extentX;
 static Int16 extentY;


/* Initialize screen boundaries */
void InitializeViewportBoundaries( void )
{
    WinGetDisplayExtent( &maxExtentX, &maxExtentY );

    topLeftX    = 2;
    topLeftY    = 15;
    extentX     = maxExtentX - 7 - topLeftX;
    extentY     = maxExtentY - topLeftY;
}



/* Return X coordinate for viewport boundary */
Int16 TopLeftX( void )
{
    if ( Prefs()->scrollbar == SCROLLBAR_LEFT )
        return topLeftX + 7;
    else
        return topLeftX;
}



/* Return Y coordinate for viewport boundary */
Int16 TopLeftY( void )
{
    if ( Prefs()->toolbar == frmMainTop )
        return topLeftY;
    else
        return 0;
}



/* Return width for viewport boundary */
Int16 ExtentX( void )
{
    if ( Prefs()->scrollbar == SCROLLBAR_NONE )
        return extentX + 5;
    else
        return extentX;
}



/* Return height for viewport boundary */
Int16 ExtentY( void )
{
    if ( Prefs()->toolbar == frmMainNone )
        return extentY + 15;
    else
        return extentY;
}



/* Return max width for viewport boundary */
Int16 MaxExtentX( void )
{
    return maxExtentX;
}



/* Return max height for viewport boundary */
Int16 MaxExtentY( void )
{
    return maxExtentY;
}



/* Return a pointer to an object in a form */
void* GetObjectPtr
    (
    const Int16 objectID    /* ID of an object in the form */
    )
{
    FormType* frm;

    frm = FrmGetActiveForm();
    return FrmGetObjectPtr( frm, FrmGetObjectIndex( frm, objectID ) );
}



/* Trim text for specified length */
void TrimText
    (
    Char* text, /* pointer to text */
    Int16 len   /* max lenght of string, i.e. trim up to this length */
    )
{
    if ( len < FntCharsWidth( text, StrLen( text ) ) ) {
        while ( ( len - 6 ) < FntCharsWidth( text, StrLen( text ) ) )
            text[ StrLen( text ) - 1 ] = 0;
        StrCat( text, "\205" );
    }
}



/* Return number of pixels to scroll for one page */
Int16 GetScrollValue( void )
{
    if ( Prefs()->toolbar == frmMainNone )
        return SCROLL_ONE_PAGE - FntLineHeight() + 15;
    else
        return SCROLL_ONE_PAGE - FntLineHeight();
}



/* Check if document is located on CF card */
Boolean DatabaseInCF
    (
    LocalID dbID    /* document ID */
    )
{
    if ( AutoCFSupported() )
        return AcfIsCfDatabase( dbID );
    else
        return false;
}



/* Send appStopEvent */
void SendAppStopEvent( void )
{
    EventType stop;

    MemSet( &stop, sizeof( EventType ), 0 );
    stop.eType = appStopEvent;
    EvtAddEventToQueue( &stop );
}



/* Add a strike-through for anchor/text */
void StrikeThrough
    (
    const RectangleType* box    /* boundaries for anchor/text */
    )
{
    Int16 anchorY;

    anchorY = box->topLeft.y + box->extent.y - FntCharHeight() / 2;
    WinDrawLine( box->topLeft.x, anchorY, box->topLeft.x + box->extent.x, anchorY );
}
