# This file is released to the Public Domain by Moshe Zadka
# Author: Moshe Zadka <pms@zadka.site.co.il>
import Configuration, Servers, Runner, Folder, MailMessage, rfc822
import os, string, re
from cStringIO import StringIO

def serialize_message(message, fp):
	for (key, value) in message.items():
		key = MailMessage.capitalize_header(key)
		fp.write("%s: %s\n" % (key, value))
	fp.write("\n")
	while 1:
		buf = message.fp.read(4096)
		if not buf:
			break
		fp.write(buf)

def save_draft(message, index=None):
	config = Configuration.Configuration()
	return config.special('draft').save_message(message, index)

def get_draft(index):
	config = Configuration.Configuration()
	message = config.special('draft').get_message(index)
	return message

def remove_draft(index):
	config = Configuration.Configuration()
	return config.special('draft').remove_message(index)

class new:

	args = ['without_sig']

	def __call__(self, runner, without_sig=0):
		config = Configuration.Configuration()
		template = config.config.get('new', {}).get('template', '')
		message = MailMessage.Message()
		message.update(config.headers)
		if not without_sig:
			message.fp.write(config.signature)
		message.fp.seek(0)
		uid = save_draft(message)
		return uid

Runner.Runner().register('new', new())

class new_reply:

	args = ['without_sig', 'to_all', 'no_include_text', 'group']

	def __call__(self, runner, without_sig=0, to_all=0, no_include_text=0, 
	                           group=0):
		config = Configuration.Configuration()
		self.message = config.status.get_folder().get_message()
		self.to_all, self.group = to_all, group
		message = MailMessage.Message()
		message.update(config.headers)
		message['to'] = self._to()
		message['cc'] = self._cc()
		user = message.get('from')
		reply = config.config.get('reply', {})
		alternates = reply.get('alternates')
		alternates = map(re.compile, alternates)
		if user is not None:
	        	user = rfc822.AddrlistClass(user).getaddrlist()[0][1]
			for header in ['to', 'cc']:
				message[header] = self._filter_user(user, 
				                                    alternates,
				                               message[header])
		message['subject'] = self._subject()
		message['references'] = self._references()
		message['in-reply-to'] = self._in_reply_to()
		if not no_include_text:
			message.fp.write(self._quote())
		if not without_sig:
			message.fp.write(config.signature)
		message.fp.seek(0)
		return save_draft(message)

	def _filter_user(self, user, alternates, addresses):
		ret = []
	        addresses = rfc822.AddrlistClass(addresses).getaddrlist()
		for address in addresses:
			if address[1] == user:
				continue
			for alternative in alternates:
				if alternative.match(address[1]):
					break
			else:
				ret.append(rfc822.dump_address_pair(address))
		return string.join(ret, ', ')

	def _to(self):
		if self.group:
			try:
				return self.message['mail-followup-to']
			except KeyError:
				to = self.message.get('to', '')
				from_ = self.message.get('reply-to', '') 
				if not from_:
					self.message.get('from', '') 
				if to and from_:
					return to+', '+from_
				return to+from_
		else:
			try:
				return self.message['reply-to']
			except KeyError:
				return self.message.get('from', '')

	def _cc(self):
		if self.group or not self.to_all:
			return ''
		to = self.message.get('to', '')
		cc = self.message.get('cc', '')
		if to and cc:
			return to+', '+cc
		return to+cc

	def _subject(self):
		subject = self.message.get('subject', 'no subject')
		if string.lower(subject[:3]) != 're:':
			subject = 'Re: '+subject
		return subject

	def _references(self):
		old = self.message.get('references')
		new = self.message['message-id']
		if old:
			return new+', '+old
		else:
			return new

	def _in_reply_to(self):
		return self.message['message-id']

	def _quote(self):
		body = self.message.fp.read()
		body = string.split(body, '\n')
		body = map(lambda x: '> '+x, body)
		body = string.join(body, '\n')+'\n'
		attr = "On %s, %s wrote:\n" % (self.message['date'], 
		                               self.message['from'])
		return attr+body
Runner.Runner().register('new_reply', new_reply())

class new_forward:

	args = ['without_sig']

	def __call__(self, runner, without_sig=0):
		config = Configuration.Configuration()
		self.message = config.status.get_folder().get_message()
		message = MailMessage.Message()
		message.update(config.headers)
		message['subject'] = self._subject()
		message.fp.write(self._quote())
		if not without_sig:
			message.fp.write(config.signature)
		message.fp.seek(0)
		return save_draft(message)

	def _subject(self):
		subject = 'fwd: ' + self.message.get('subject', 'no subject')
		return subject

	def _quote(self):
		fp = StringIO()
		for header in ['to', 'from', 'cc', 'subject']:
			try:
				value = self.message[header]
			except KeyError:
				pass
			else:
				header = MailMessage.capitalize_header(header)
				fp.write('%s: %s\n' % (header, value))
		fp.write('\n')
		fp.write(self.message.fp.read())
		return fp.getvalue()

Runner.Runner().register('new_forward', new_forward())

class send:

	args = ['no_fcc']

	def __call__(self, runner, index, no_fcc=0):
		fp = os.popen("/usr/lib/sendmail -t -bm", "w")
		try:
			serialize_message(get_draft(index), fp)
		finally:
			fp.close()
		if not no_fcc:
			try:
				config = Configuration.Configuration()
				fcc = config.special('fcc')
			except KeyError:
				pass
			else:
				fcc.save_message(get_draft(index))
			
Runner.Runner().register('send', send())

class folder:

	args = ['relative', 'push']

	def __call__(self, runner, name, relative=0, push=0):
		config = Configuration.Configuration()
		status = config.status
		if not relative:
			new_folder = Folder.Folder(status.server, name)
			if push:
				status.push_folder(new_folder)
			else:
				status.set_folder(new_folder)
		else:
			status.push_folder(status.get_folder().folder(name))

Runner.Runner().register('folder', folder())
