# This file is released to the Public Domain by Moshe Zadka
# Author: Moshe Zadka <pms@zadka.site.co.il>
import Configuration, Server, Folder, Actions, MailMessage, Log
import os, string, re

class MHServer(Server.Server):

	def __init__(self, name, root):
		Log.log("initializing MHServer with", name, root)
		self.name = name
		self.root = root

	int = re.compile('[1-9][0-9]*$').match

        def get_message(self, folder, uid):
		Log.log("getting message", uid, "from", folder)
		fp = open(os.path.join(self.root, folder, uid))
		Log.log("got message from file", fp.name)
		return MailMessage.parse(fp)
		
        def remove_message(self, folder, uid):
		Log.log("removing", uid, "from", folder)
		os.rename(os.path.join(self.root, folder, uid), 
		          os.path.join(self.root, folder, ','+uid))
		Log.log("removed")

	def _choose_uid(self, folder):
		Log.log("choosing free uid for", folder)
		uids = map(int, self.get_list(folder))
		Log.log("got list", len(uids), "long")
		if not uids:
			Log.log("no uids, choosing 1")
			uid = '1'
		else:
			uids.sort()
			uid = str(uids[-1]+1)
			Log.log("chose next uid", uid)
		return uid

        def save_message(self, message, folder, uid):
		Log.log("saving message to ", folder, "as", uid)
		if uid is None:
			Log.log("saving to free uid")
			uid = self._choose_uid(folder)
		fp = open(os.path.join(self.root, folder, uid), 'w')
		Log.log("saving to file", fp.name)
		try:
			Actions.serialize_message(message, fp)
		finally:
			fp.close()
		Log.log("saved")
		return uid

        def get_list(self, folder):
		Log.log("getting list of messages from", folder)
		return filter(self.int, 
		              os.listdir(os.path.join(self.root, folder)))

        def get_subfolders(self, folder):
		Log.log("getting list of subfolders from", folder)
		folders = os.listdir(os.path.join(self.root, folder))
		ret = []
		for subfolder in folders:
			Log.log("checking whether to add", subfolder)
			if os.path.isdir(os.path.join(self.root, folder, 
			                                         subfolder)):
				Log.log("adding", subfolder)
				ret.append(subfolder)
		return ret

	def subfolder(self, folder, subfolder):
		Log.log("getting folder", subfolder, "from", folder)
		return Folder.Folder(self.name, os.path.join(folder, subfolder))

	def create(self, folder):
		Log.log("creating folder", folder)
		os.makedirs(os.path.join(self.root, folder))
