# This file is released to the Public Domain by Moshe Zadka
# Author: Moshe Zadka <pms@zadka.site.co.il>

runner = None
def Runner():
	global runner
	if runner is None:
		runner = _Runner()
	return runner

class StopExecution(Exception):
	pass

class _Runner:

	def __init__(self):
		self.actions = {}
		self.prehooks = {}
		self.posthooks = {}

	def register(self, action, function):
		self.actions[action] = function

	def register_prehook(self, action, function):
		self.prehooks[action] = self.prehooks.get(action, [])
		self.prehooks[action].insert(0, function)

	def register_posthook(self, action, function):
		self.posthooks[action] = self.posthooks.get(action, [])
		self.posthooks[action].append(function)

	def _do_action(self, action, *args, **kw):
		for hook in self.prehooks.get(action, []):
			apply(hook, (self,)+args, kw)
		ret = apply(self.actions[action], (self,)+args, kw)
		for hook in self.posthooks.get(action, []):
			apply(hook, (self, ret)+args, kw)
		return ret

	def get_args(self, action):
		return self.actions[action].args

	def new(self, **kw):
		return apply(self._do_action, ('new',), kw)

	def new_reply(self, **kw):
		return apply(self._do_action, ('new_reply',), kw)

	def new_forward(self, **kw):
		return apply(self._do_action, ('new_forward',), kw)

	def edit_draft(self, uid, **kw):
		return apply(self._do_action, ('edit_draft', uid), kw)

	def send(self, uid, **kw):
		return apply(self._do_action, ('send', uid), kw)

	def show(self, **kw):
		return apply(self._do_action, ('show',), kw)

	def folder(self, name, **kw):
		return apply(self._do_action, ('folder', name), kw)

	def prompt(self, question, answers, **kw):
		return apply(self._do_action, ('prompt', question, answers), kw)

	def scan(self, **kw):
		return apply(self._do_action, ('scan',), kw)
