# This file is released to the Public Domain by Moshe Zadka
# Author: Moshe Zadka <pms@zadka.site.co.il>
from PMS import Configuration, Server, Folder, Actions, MailMessage, Log
import os, string, re

class SshMHServer(Server.Server):

	cmd = 'ssh'

	def __init__(self, name, root, server):
		Log.log("initializing SshMHServer with", server, name, root)
		self.name = name
		self.root = root
		self.server = server

	int = re.compile('[1-9][0-9]*$').match

        def get_message(self, folder, uid):
		Log.log("getting message", uid, "from", folder)
		name = os.path.join(self.root, folder, uid)
		fp = os.popen("%s %s cat %s" % (self.cmd, self.server, name))
		Log.log("got message from file", name)
		return MailMessage.parse(fp)
		
        def remove_message(self, folder, uid):
		Log.log("removing", uid, "from", folder)
		orig_name = os.path.join(self.root, folder, uid)
		dest_name = os.path.join(self.root, folder, ','+uid)
		server = self.server
		cmd= self.cmd
		os.system("%(cmd)s %(server)s mv %(orig_name)s %(dest_name)s" %
		          vars())
		Log.log("removed")

	def _choose_uid(self, folder):
		Log.log("choosing free uid for", folder)
		uids = map(int, self.get_list(folder))
		Log.log("got list", len(uids), "long")
		if not uids:
			Log.log("no uids, choosing 1")
			uid = '1'
		else:
			uids.sort()
			uid = str(uids[-1]+1)
			Log.log("chose next uid", uid)
		return uid

        def save_message(self, message, folder, uid):
		Log.log("saving message to ", folder, "as", uid)
		if uid is None:
			Log.log("saving to free uid")
			uid = self._choose_uid(folder)
		name = os.path.join(self.root, folder, uid)
		fp = os.popen("%s %s cat > %s" % (self.cmd, self.server, name))
		Log.log("saving to file", fp.name)
		try:
			Actions.serialize_message(message, fp)
		finally:
			fp.close()
		Log.log("saved")
		return uid

	def os_listdir(self, name, criteria=''):
		fp = os.popen("%s %s find %s -maxdepth 1 "
		              "%s -printf '%%f\\\\n'" % 
		              (self.cmd, self.server, name, criteria))
		s = fp.read()
		files = string.split(s, '\n')[:-1]
		return files

        def get_list(self, folder):
		Log.log("getting list of messages from", folder)
		return filter(self.int, 
		              self.os_listdir(os.path.join(self.root, folder)))

        def get_subfolders(self, folder):
		Log.log("getting list of subfolders from", folder)
		return self.os_listdir(os.path.join(self.root, folder),
		                       '-type d')

	def subfolder(self, folder, subfolder):
		Log.log("getting folder", subfolder, "from", folder)
		return Folder.Folder(self.name, os.path.join(folder, subfolder))

	def create(self, folder):
		Log.log("creating folder", folder)
		name = os.path.join(self.root, folder)
		os.system("%s %s mkdirhier %s" % (self.cmd, self.server, name))
