#include <stdlib.h>
#include <stdio.h>
#include <stdarg.h>

#include "sys/wcebase.h"
#include "sys/wcetrace.h"
#include "sys/wcefile.h"

static HANDLE __wcetracehnd = NULL;
static int   __wcetrace = 0;

void
WCETRACESET(int trace)
{
  __wcetrace = trace;
}

void
WCETRACE(int level, const char *fmt, ...)
{
  char buf[1024];
  char tracepath[256];
  wchar_t tracepathw[256];
  int nwritten;
  int len = 0;
  va_list ap;

  if(!(__wcetrace & level))
    return;

  if (__wcetracehnd == NULL) {
    strcpy(tracepath, "/temp/wcetrace.log");
    mbstowcs(tracepathw, tracepath, strlen(tracepath) + 1);
    __wcetracehnd = CreateFileW(tracepathw, GENERIC_WRITE, 
      FILE_SHARE_WRITE, NULL, OPEN_ALWAYS, 0, NULL);
  }

#if 1
  len = sprintf(buf, "T%08x: ", GetCurrentThreadId());
#else
  len = sprintf(buf, "%08d:%08x: ", GetTickCount(), GetCurrentProcessId());
#endif

  if(__wcetracehnd != INVALID_HANDLE_VALUE) {
    va_start(ap, fmt);
    vsprintf(buf + len, fmt, ap);
    strcat(buf, "\n");

    WriteFile(__wcetracehnd, buf, strlen(buf), (DWORD *)&nwritten, NULL);
  }
}
