#include "poker_defs.h"

/* 
 * Table nBitsAndStrTable
 */

/*
nBitsAndStrTable[].  Maps 13-bit rank masks onto an 8 bit quantity,
packed with both the number of bits set in the mask (nBitsTable) and
a value indicating if a straight is present (straightTable). 
It is possible, using just this table and bit masking operations, 
to determine the type of hand.  Since this table is only 8K it should
in L1 cache on some processors.
 The layout of the result is as follows: 
  Bit 0: (nBits >= 5)
  Bit 1: is-straight
  Bits 2-6: nBits

 */

uint8 nBitsAndStrTable[8192] = { 
     0x00 ,
     0x04 ,
     0x04 ,
     0x08 ,
     0x04 ,
     0x08 ,
     0x08 ,
     0x0c ,
     0x04 ,
     0x08 ,
     0x08 ,
     0x0c ,
     0x08 ,
     0x0c ,
     0x0c ,
     0x10 ,
     0x04 ,
     0x08 ,
     0x08 ,
     0x0c ,
     0x08 ,
     0x0c ,
     0x0c ,
     0x10 ,
     0x08 ,
     0x0c ,
     0x0c ,
     0x10 ,
     0x0c ,
     0x10 ,
     0x10 ,
     0x17 ,
     0x04 ,
     0x08 ,
     0x08 ,
     0x0c ,
     0x08 ,
     0x0c ,
     0x0c ,
     0x10 ,
     0x08 ,
     0x0c ,
     0x0c ,
     0x10 ,
     0x0c ,
     0x10 ,
     0x10 ,
     0x15 ,
     0x08 ,
     0x0c ,
     0x0c ,
     0x10 ,
     0x0c ,
     0x10 ,
     0x10 ,
     0x15 ,
     0x0c ,
     0x10 ,
     0x10 ,
     0x15 ,
     0x10 ,
     0x15 ,
     0x17 ,
     0x1b ,
     0x04 ,
     0x08 ,
     0x08 ,
     0x0c ,
     0x08 ,
     0x0c ,
     0x0c ,
     0x10 ,
     0x08 ,
     0x0c ,
     0x0c ,
     0x10 ,
     0x0c ,
     0x10 ,
     0x10 ,
     0x15 ,
     0x08 ,
     0x0c ,
     0x0c ,
     0x10 ,
     0x0c ,
     0x10 ,
     0x10 ,
     0x15 ,
     0x0c ,
     0x10 ,
     0x10 ,
     0x15 ,
     0x10 ,
     0x15 ,
     0x15 ,
     0x1b ,
     0x08 ,
     0x0c ,
     0x0c ,
     0x10 ,
     0x0c ,
     0x10 ,
     0x10 ,
     0x15 ,
     0x0c ,
     0x10 ,
     0x10 ,
     0x15 ,
     0x10 ,
     0x15 ,
     0x15 ,
     0x19 ,
     0x0c ,
     0x10 ,
     0x10 ,
     0x15 ,
     0x10 ,
     0x15 ,
     0x15 ,
     0x19 ,
     0x10 ,
     0x15 ,
     0x15 ,
     0x19 ,
     0x17 ,
     0x1b ,
     0x1b ,
     0x1f ,
     0x04 ,
     0x08 ,
     0x08 ,
     0x0c ,
     0x08 ,
     0x0c ,
     0x0c ,
     0x10 ,
     0x08 ,
     0x0c ,
     0x0c ,
     0x10 ,
     0x0c ,
     0x10 ,
     0x10 ,
     0x15 ,
     0x08 ,
     0x0c ,
     0x0c ,
     0x10 ,
     0x0c ,
     0x10 ,
     0x10 ,
     0x15 ,
     0x0c ,
     0x10 ,
     0x10 ,
     0x15 ,
     0x10 ,
     0x15 ,
     0x15 ,
     0x1b ,
     0x08 ,
     0x0c ,
     0x0c ,
     0x10 ,
     0x0c ,
     0x10 ,
     0x10 ,
     0x15 ,
     0x0c ,
     0x10 ,
     0x10 ,
     0x15 ,
     0x10 ,
     0x15 ,
     0x15 ,
     0x19 ,
     0x0c ,
     0x10 ,
     0x10 ,
     0x15 ,
     0x10 ,
     0x15 ,
     0x15 ,
     0x19 ,
     0x10 ,
     0x15 ,
     0x15 ,
     0x19 ,
     0x15 ,
     0x19 ,
     0x1b ,
     0x1f ,
     0x08 ,
     0x0c ,
     0x0c ,
     0x10 ,
     0x0c ,
     0x10 ,
     0x10 ,
     0x15 ,
     0x0c ,
     0x10 ,
     0x10 ,
     0x15 ,
     0x10 ,
     0x15 ,
     0x15 ,
     0x19 ,
     0x0c ,
     0x10 ,
     0x10 ,
     0x15 ,
     0x10 ,
     0x15 ,
     0x15 ,
     0x19 ,
     0x10 ,
     0x15 ,
     0x15 ,
     0x19 ,
     0x15 ,
     0x19 ,
     0x19 ,
     0x1f ,
     0x0c ,
     0x10 ,
     0x10 ,
     0x15 ,
     0x10 ,
     0x15 ,
     0x15 ,
     0x19 ,
     0x10 ,
     0x15 ,
     0x15 ,
     0x19 ,
     0x15 ,
     0x19 ,
     0x19 ,
     0x1d ,
     0x10 ,
     0x15 ,
     0x15 ,
     0x19 ,
     0x15 ,
     0x19 ,
     0x19 ,
     0x1d ,
     0x17 ,
     0x1b ,
     0x1b ,
     0x1f ,
     0x1b ,
     0x1f ,
     0x1f ,
     0x23 ,
     0x04 ,
     0x08 ,
     0x08 ,
     0x0c ,
     0x08 ,
     0x0c ,
     0x0c ,
     0x10 ,
     0x08 ,
     0x0c ,
     0x0c ,
     0x10 ,
     0x0c ,
     0x10 ,
     0x10 ,
     0x15 ,
     0x08 ,
     0x0c ,
     0x0c ,
     0x10 ,
     0x0c ,
     0x10 ,
     0x10 ,
     0x15 ,
     0x0c ,
     0x10 ,
     0x10 ,
     0x15 ,
     0x10 ,
     0x15 ,
     0x15 ,
     0x1b ,
     0x08 ,
     0x0c ,
     0x0c ,
     0x10 ,
     0x0c ,
     0x10 ,
     0x10 ,
     0x15 ,
     0x0c ,
     0x10 ,
     0x10 ,
     0x15 ,
     0x10 ,
     0x15 ,
     0x15 ,
     0x19 ,
     0x0c ,
     0x10 ,
     0x10 ,
     0x15 ,
     0x10 ,
     0x15 ,
     0x15 ,
     0x19 ,
     0x10 ,
     0x15 ,
     0x15 ,
     0x19 ,
     0x15 ,
     0x19 ,
     0x1b ,
     0x1f ,
     0x08 ,
     0x0c ,
     0x0c ,
     0x10 ,
     0x0c ,
     0x10 ,
     0x10 ,
     0x15 ,
     0x0c ,
     0x10 ,
     0x10 ,
     0x15 ,
     0x10 ,
     0x15 ,
     0x15 ,
     0x19 ,
     0x0c ,
     0x10 ,
     0x10 ,
     0x15 ,
     0x10 ,
     0x15 ,
     0x15 ,
     0x19 ,
     0x10 ,
     0x15 ,
     0x15 ,
     0x19 ,
     0x15 ,
     0x19 ,
     0x19 ,
     0x1f ,
     0x0c ,
     0x10 ,
     0x10 ,
     0x15 ,
     0x10 ,
     0x15 ,
     0x15 ,
     0x19 ,
     0x10 ,
     0x15 ,
     0x15 ,
     0x19 ,
     0x15 ,
     0x19 ,
     0x19 ,
     0x1d ,
     0x10 ,
     0x15 ,
     0x15 ,
     0x19 ,
     0x15 ,
     0x19 ,
     0x19 ,
     0x1d ,
     0x15 ,
     0x19 ,
     0x19 ,
     0x1d ,
     0x1b ,
     0x1f ,
     0x1f ,
     0x23 ,
     0x08 ,
     0x0c ,
     0x0c ,
     0x10 ,
     0x0c ,
     0x10 ,
     0x10 ,
     0x15 ,
     0x0c ,
     0x10 ,
     0x10 ,
     0x15 ,
     0x10 ,
     0x15 ,
     0x15 ,
     0x19 ,
     0x0c ,
     0x10 ,
     0x10 ,
     0x15 ,
     0x10 ,
     0x15 ,
     0x15 ,
     0x19 ,
     0x10 ,
     0x15 ,
     0x15 ,
     0x19 ,
     0x15 ,
     0x19 ,
     0x19 ,
     0x1f ,
     0x0c ,
     0x10 ,
     0x10 ,
     0x15 ,
     0x10 ,
     0x15 ,
     0x15 ,
     0x19 ,
     0x10 ,
     0x15 ,
     0x15 ,
     0x19 ,
     0x15 ,
     0x19 ,
     0x19 ,
     0x1d ,
     0x10 ,
     0x15 ,
     0x15 ,
     0x19 ,
     0x15 ,
     0x19 ,
     0x19 ,
     0x1d ,
     0x15 ,
     0x19 ,
     0x19 ,
     0x1d ,
     0x19 ,
     0x1d ,
     0x1f ,
     0x23 ,
     0x0c ,
     0x10 ,
     0x10 ,
     0x15 ,
     0x10 ,
     0x15 ,
     0x15 ,
     0x19 ,
     0x10 ,
     0x15 ,
     0x15 ,
     0x19 ,
     0x15 ,
     0x19 ,
     0x19 ,
     0x1d ,
     0x10 ,
     0x15 ,
     0x15 ,
     0x19 ,
     0x15 ,
     0x19 ,
     0x19 ,
     0x1d ,
     0x15 ,
     0x19 ,
     0x19 ,
     0x1d ,
     0x19 ,
     0x1d ,
     0x1d ,
     0x23 ,
     0x10 ,
     0x15 ,
     0x15 ,
     0x19 ,
     0x15 ,
     0x19 ,
     0x19 ,
     0x1d ,
     0x15 ,
     0x19 ,
     0x19 ,
     0x1d ,
     0x19 ,
     0x1d ,
     0x1d ,
     0x21 ,
     0x17 ,
     0x1b ,
     0x1b ,
     0x1f ,
     0x1b ,
     0x1f ,
     0x1f ,
     0x23 ,
     0x1b ,
     0x1f ,
     0x1f ,
     0x23 ,
     0x1f ,
     0x23 ,
     0x23 ,
     0x27 ,
     0x04 ,
     0x08 ,
     0x08 ,
     0x0c ,
     0x08 ,
     0x0c ,
     0x0c ,
     0x10 ,
     0x08 ,
     0x0c ,
     0x0c ,
     0x10 ,
     0x0c ,
     0x10 ,
     0x10 ,
     0x15 ,
     0x08 ,
     0x0c ,
     0x0c ,
     0x10 ,
     0x0c ,
     0x10 ,
     0x10 ,
     0x15 ,
     0x0c ,
     0x10 ,
     0x10 ,
     0x15 ,
     0x10 ,
     0x15 ,
     0x15 ,
     0x1b ,
     0x08 ,
     0x0c ,
     0x0c ,
     0x10 ,
     0x0c ,
     0x10 ,
     0x10 ,
     0x15 ,
     0x0c ,
     0x10 ,
     0x10 ,
     0x15 ,
     0x10 ,
     0x15 ,
     0x15 ,
     0x19 ,
     0x0c ,
     0x10 ,
     0x10 ,
     0x15 ,
     0x10 ,
     0x15 ,
     0x15 ,
     0x19 ,
     0x10 ,
     0x15 ,
     0x15 ,
     0x19 ,
     0x15 ,
     0x19 ,
     0x1b ,
     0x1f ,
     0x08 ,
     0x0c ,
     0x0c ,
     0x10 ,
     0x0c ,
     0x10 ,
     0x10 ,
     0x15 ,
     0x0c ,
     0x10 ,
     0x10 ,
     0x15 ,
     0x10 ,
     0x15 ,
     0x15 ,
     0x19 ,
     0x0c ,
     0x10 ,
     0x10 ,
     0x15 ,
     0x10 ,
     0x15 ,
     0x15 ,
     0x19 ,
     0x10 ,
     0x15 ,
     0x15 ,
     0x19 ,
     0x15 ,
     0x19 ,
     0x19 ,
     0x1f ,
     0x0c ,
     0x10 ,
     0x10 ,
     0x15 ,
     0x10 ,
     0x15 ,
     0x15 ,
     0x19 ,
     0x10 ,
     0x15 ,
     0x15 ,
     0x19 ,
     0x15 ,
     0x19 ,
     0x19 ,
     0x1d ,
     0x10 ,
     0x15 ,
     0x15 ,
     0x19 ,
     0x15 ,
     0x19 ,
     0x19 ,
     0x1d ,
     0x15 ,
     0x19 ,
     0x19 ,
     0x1d ,
     0x1b ,
     0x1f ,
     0x1f ,
     0x23 ,
     0x08 ,
     0x0c ,
     0x0c ,
     0x10 ,
     0x0c ,
     0x10 ,
     0x10 ,
     0x15 ,
     0x0c ,
     0x10 ,
     0x10 ,
     0x15 ,
     0x10 ,
     0x15 ,
     0x15 ,
     0x19 ,
     0x0c ,
     0x10 ,
     0x10 ,
     0x15 ,
     0x10 ,
     0x15 ,
     0x15 ,
     0x19 ,
     0x10 ,
     0x15 ,
     0x15 ,
     0x19 ,
     0x15 ,
     0x19 ,
     0x19 ,
     0x1f ,
     0x0c ,
     0x10 ,
     0x10 ,
     0x15 ,
     0x10 ,
     0x15 ,
     0x15 ,
     0x19 ,
     0x10 ,
     0x15 ,
     0x15 ,
     0x19 ,
     0x15 ,
     0x19 ,
     0x19 ,
     0x1d ,
     0x10 ,
     0x15 ,
     0x15 ,
     0x19 ,
     0x15 ,
     0x19 ,
     0x19 ,
     0x1d ,
     0x15 ,
     0x19 ,
     0x19 ,
     0x1d ,
     0x19 ,
     0x1d ,
     0x1f ,
     0x23 ,
     0x0c ,
     0x10 ,
     0x10 ,
     0x15 ,
     0x10 ,
     0x15 ,
     0x15 ,
     0x19 ,
     0x10 ,
     0x15 ,
     0x15 ,
     0x19 ,
     0x15 ,
     0x19 ,
     0x19 ,
     0x1d ,
     0x10 ,
     0x15 ,
     0x15 ,
     0x19 ,
     0x15 ,
     0x19 ,
     0x19 ,
     0x1d ,
     0x15 ,
     0x19 ,
     0x19 ,
     0x1d ,
     0x19 ,
     0x1d ,
     0x1d ,
     0x23 ,
     0x10 ,
     0x15 ,
     0x15 ,
     0x19 ,
     0x15 ,
     0x19 ,
     0x19 ,
     0x1d ,
     0x15 ,
     0x19 ,
     0x19 ,
     0x1d ,
     0x19 ,
     0x1d ,
     0x1d ,
     0x21 ,
     0x15 ,
     0x19 ,
     0x19 ,
     0x1d ,
     0x19 ,
     0x1d ,
     0x1d ,
     0x21 ,
     0x1b ,
     0x1f ,
     0x1f ,
     0x23 ,
     0x1f ,
     0x23 ,
     0x23 ,
     0x27 ,
     0x08 ,
     0x0c ,
     0x0c ,
     0x10 ,
     0x0c ,
     0x10 ,
     0x10 ,
     0x15 ,
     0x0c ,
     0x10 ,
     0x10 ,
     0x15 ,
     0x10 ,
     0x15 ,
     0x15 ,
     0x19 ,
     0x0c ,
     0x10 ,
     0x10 ,
     0x15 ,
     0x10 ,
     0x15 ,
     0x15 ,
     0x19 ,
     0x10 ,
     0x15 ,
     0x15 ,
     0x19 ,
     0x15 ,
     0x19 ,
     0x19 ,
     0x1f ,
     0x0c ,
     0x10 ,
     0x10 ,
     0x15 ,
     0x10 ,
     0x15 ,
     0x15 ,
     0x19 ,
     0x10 ,
     0x15 ,
     0x15 ,
     0x19 ,
     0x15 ,
     0x19 ,
     0x19 ,
     0x1d ,
     0x10 ,
     0x15 ,
     0x15 ,
     0x19 ,
     0x15 ,
     0x19 ,
     0x19 ,
     0x1d ,
     0x15 ,
     0x19 ,
     0x19 ,
     0x1d ,
     0x19 ,
     0x1d ,
     0x1f ,
     0x23 ,
     0x0c ,
     0x10 ,
     0x10 ,
     0x15 ,
     0x10 ,
     0x15 ,
     0x15 ,
     0x19 ,
     0x10 ,
     0x15 ,
     0x15 ,
     0x19 ,
     0x15 ,
     0x19 ,
     0x19 ,
     0x1d ,
     0x10 ,
     0x15 ,
     0x15 ,
     0x19 ,
     0x15 ,
     0x19 ,
     0x19 ,
     0x1d ,
     0x15 ,
     0x19 ,
     0x19 ,
     0x1d ,
     0x19 ,
     0x1d ,
     0x1d ,
     0x23 ,
     0x10 ,
     0x15 ,
     0x15 ,
     0x19 ,
     0x15 ,
     0x19 ,
     0x19 ,
     0x1d ,
     0x15 ,
     0x19 ,
     0x19 ,
     0x1d ,
     0x19 ,
     0x1d ,
     0x1d ,
     0x21 ,
     0x15 ,
     0x19 ,
     0x19 ,
     0x1d ,
     0x19 ,
     0x1d ,
     0x1d ,
     0x21 ,
     0x19 ,
     0x1d ,
     0x1d ,
     0x21 ,
     0x1f ,
     0x23 ,
     0x23 ,
     0x27 ,
     0x0c ,
     0x10 ,
     0x10 ,
     0x15 ,
     0x10 ,
     0x15 ,
     0x15 ,
     0x19 ,
     0x10 ,
     0x15 ,
     0x15 ,
     0x19 ,
     0x15 ,
     0x19 ,
     0x19 ,
     0x1d ,
     0x10 ,
     0x15 ,
     0x15 ,
     0x19 ,
     0x15 ,
     0x19 ,
     0x19 ,
     0x1d ,
     0x15 ,
     0x19 ,
     0x19 ,
     0x1d ,
     0x19 ,
     0x1d ,
     0x1d ,
     0x23 ,
     0x10 ,
     0x15 ,
     0x15 ,
     0x19 ,
     0x15 ,
     0x19 ,
     0x19 ,
     0x1d ,
     0x15 ,
     0x19 ,
     0x19 ,
     0x1d ,
     0x19 ,
     0x1d ,
     0x1d ,
     0x21 ,
     0x15 ,
     0x19 ,
     0x19 ,
     0x1d ,
     0x19 ,
     0x1d ,
     0x1d ,
     0x21 ,
     0x19 ,
     0x1d ,
     0x1d ,
     0x21 ,
     0x1d ,
     0x21 ,
     0x23 ,
     0x27 ,
     0x10 ,
     0x15 ,
     0x15 ,
     0x19 ,
     0x15 ,
     0x19 ,
     0x19 ,
     0x1d ,
     0x15 ,
     0x19 ,
     0x19 ,
     0x1d ,
     0x19 ,
     0x1d ,
     0x1d ,
     0x21 ,
     0x15 ,
     0x19 ,
     0x19 ,
     0x1d ,
     0x19 ,
     0x1d ,
     0x1d ,
     0x21 ,
     0x19 ,
     0x1d ,
     0x1d ,
     0x21 ,
     0x1d ,
     0x21 ,
     0x21 ,
     0x27 ,
     0x17 ,
     0x1b ,
     0x1b ,
     0x1f ,
     0x1b ,
     0x1f ,
     0x1f ,
     0x23 ,
     0x1b ,
     0x1f ,
     0x1f ,
     0x23 ,
     0x1f ,
     0x23 ,
     0x23 ,
     0x27 ,
     0x1b ,
     0x1f ,
     0x1f ,
     0x23 ,
     0x1f ,
     0x23 ,
     0x23 ,
     0x27 ,
     0x1f ,
     0x23 ,
     0x23 ,
     0x27 ,
     0x23 ,
     0x27 ,
     0x27 ,
     0x2b ,
     0x04 ,
     0x08 ,
     0x08 ,
     0x0c ,
     0x08 ,
     0x0c ,
     0x0c ,
     0x10 ,
     0x08 ,
     0x0c ,
     0x0c ,
     0x10 ,
     0x0c ,
     0x10 ,
     0x10 ,
     0x15 ,
     0x08 ,
     0x0c ,
     0x0c ,
     0x10 ,
     0x0c ,
     0x10 ,
     0x10 ,
     0x15 ,
     0x0c ,
     0x10 ,
     0x10 ,
     0x15 ,
     0x10 ,
     0x15 ,
     0x15 ,
     0x1b ,
     0x08 ,
     0x0c ,
     0x0c ,
     0x10 ,
     0x0c ,
     0x10 ,
     0x10 ,
     0x15 ,
     0x0c ,
     0x10 ,
     0x10 ,
     0x15 ,
     0x10 ,
     0x15 ,
     0x15 ,
     0x19 ,
     0x0c ,
     0x10 ,
     0x10 ,
     0x15 ,
     0x10 ,
     0x15 ,
     0x15 ,
     0x19 ,
     0x10 ,
     0x15 ,
     0x15 ,
     0x19 ,
     0x15 ,
     0x19 ,
     0x1b ,
     0x1f ,
     0x08 ,
     0x0c ,
     0x0c ,
     0x10 ,
     0x0c ,
     0x10 ,
     0x10 ,
     0x15 ,
     0x0c ,
     0x10 ,
     0x10 ,
     0x15 ,
     0x10 ,
     0x15 ,
     0x15 ,
     0x19 ,
     0x0c ,
     0x10 ,
     0x10 ,
     0x15 ,
     0x10 ,
     0x15 ,
     0x15 ,
     0x19 ,
     0x10 ,
     0x15 ,
     0x15 ,
     0x19 ,
     0x15 ,
     0x19 ,
     0x19 ,
     0x1f ,
     0x0c ,
     0x10 ,
     0x10 ,
     0x15 ,
     0x10 ,
     0x15 ,
     0x15 ,
     0x19 ,
     0x10 ,
     0x15 ,
     0x15 ,
     0x19 ,
     0x15 ,
     0x19 ,
     0x19 ,
     0x1d ,
     0x10 ,
     0x15 ,
     0x15 ,
     0x19 ,
     0x15 ,
     0x19 ,
     0x19 ,
     0x1d ,
     0x15 ,
     0x19 ,
     0x19 ,
     0x1d ,
     0x1b ,
     0x1f ,
     0x1f ,
     0x23 ,
     0x08 ,
     0x0c ,
     0x0c ,
     0x10 ,
     0x0c ,
     0x10 ,
     0x10 ,
     0x15 ,
     0x0c ,
     0x10 ,
     0x10 ,
     0x15 ,
     0x10 ,
     0x15 ,
     0x15 ,
     0x19 ,
     0x0c ,
     0x10 ,
     0x10 ,
     0x15 ,
     0x10 ,
     0x15 ,
     0x15 ,
     0x19 ,
     0x10 ,
     0x15 ,
     0x15 ,
     0x19 ,
     0x15 ,
     0x19 ,
     0x19 ,
     0x1f ,
     0x0c ,
     0x10 ,
     0x10 ,
     0x15 ,
     0x10 ,
     0x15 ,
     0x15 ,
     0x19 ,
     0x10 ,
     0x15 ,
     0x15 ,
     0x19 ,
     0x15 ,
     0x19 ,
     0x19 ,
     0x1d ,
     0x10 ,
     0x15 ,
     0x15 ,
     0x19 ,
     0x15 ,
     0x19 ,
     0x19 ,
     0x1d ,
     0x15 ,
     0x19 ,
     0x19 ,
     0x1d ,
     0x19 ,
     0x1d ,
     0x1f ,
     0x23 ,
     0x0c ,
     0x10 ,
     0x10 ,
     0x15 ,
     0x10 ,
     0x15 ,
     0x15 ,
     0x19 ,
     0x10 ,
     0x15 ,
     0x15 ,
     0x19 ,
     0x15 ,
     0x19 ,
     0x19 ,
     0x1d ,
     0x10 ,
     0x15 ,
     0x15 ,
     0x19 ,
     0x15 ,
     0x19 ,
     0x19 ,
     0x1d ,
     0x15 ,
     0x19 ,
     0x19 ,
     0x1d ,
     0x19 ,
     0x1d ,
     0x1d ,
     0x23 ,
     0x10 ,
     0x15 ,
     0x15 ,
     0x19 ,
     0x15 ,
     0x19 ,
     0x19 ,
     0x1d ,
     0x15 ,
     0x19 ,
     0x19 ,
     0x1d ,
     0x19 ,
     0x1d ,
     0x1d ,
     0x21 ,
     0x15 ,
     0x19 ,
     0x19 ,
     0x1d ,
     0x19 ,
     0x1d ,
     0x1d ,
     0x21 ,
     0x1b ,
     0x1f ,
     0x1f ,
     0x23 ,
     0x1f ,
     0x23 ,
     0x23 ,
     0x27 ,
     0x08 ,
     0x0c ,
     0x0c ,
     0x10 ,
     0x0c ,
     0x10 ,
     0x10 ,
     0x15 ,
     0x0c ,
     0x10 ,
     0x10 ,
     0x15 ,
     0x10 ,
     0x15 ,
     0x15 ,
     0x19 ,
     0x0c ,
     0x10 ,
     0x10 ,
     0x15 ,
     0x10 ,
     0x15 ,
     0x15 ,
     0x19 ,
     0x10 ,
     0x15 ,
     0x15 ,
     0x19 ,
     0x15 ,
     0x19 ,
     0x19 ,
     0x1f ,
     0x0c ,
     0x10 ,
     0x10 ,
     0x15 ,
     0x10 ,
     0x15 ,
     0x15 ,
     0x19 ,
     0x10 ,
     0x15 ,
     0x15 ,
     0x19 ,
     0x15 ,
     0x19 ,
     0x19 ,
     0x1d ,
     0x10 ,
     0x15 ,
     0x15 ,
     0x19 ,
     0x15 ,
     0x19 ,
     0x19 ,
     0x1d ,
     0x15 ,
     0x19 ,
     0x19 ,
     0x1d ,
     0x19 ,
     0x1d ,
     0x1f ,
     0x23 ,
     0x0c ,
     0x10 ,
     0x10 ,
     0x15 ,
     0x10 ,
     0x15 ,
     0x15 ,
     0x19 ,
     0x10 ,
     0x15 ,
     0x15 ,
     0x19 ,
     0x15 ,
     0x19 ,
     0x19 ,
     0x1d ,
     0x10 ,
     0x15 ,
     0x15 ,
     0x19 ,
     0x15 ,
     0x19 ,
     0x19 ,
     0x1d ,
     0x15 ,
     0x19 ,
     0x19 ,
     0x1d ,
     0x19 ,
     0x1d ,
     0x1d ,
     0x23 ,
     0x10 ,
     0x15 ,
     0x15 ,
     0x19 ,
     0x15 ,
     0x19 ,
     0x19 ,
     0x1d ,
     0x15 ,
     0x19 ,
     0x19 ,
     0x1d ,
     0x19 ,
     0x1d ,
     0x1d ,
     0x21 ,
     0x15 ,
     0x19 ,
     0x19 ,
     0x1d ,
     0x19 ,
     0x1d ,
     0x1d ,
     0x21 ,
     0x19 ,
     0x1d ,
     0x1d ,
     0x21 ,
     0x1f ,
     0x23 ,
     0x23 ,
     0x27 ,
     0x0c ,
     0x10 ,
     0x10 ,
     0x15 ,
     0x10 ,
     0x15 ,
     0x15 ,
     0x19 ,
     0x10 ,
     0x15 ,
     0x15 ,
     0x19 ,
     0x15 ,
     0x19 ,
     0x19 ,
     0x1d ,
     0x10 ,
     0x15 ,
     0x15 ,
     0x19 ,
     0x15 ,
     0x19 ,
     0x19 ,
     0x1d ,
     0x15 ,
     0x19 ,
     0x19 ,
     0x1d ,
     0x19 ,
     0x1d ,
     0x1d ,
     0x23 ,
     0x10 ,
     0x15 ,
     0x15 ,
     0x19 ,
     0x15 ,
     0x19 ,
     0x19 ,
     0x1d ,
     0x15 ,
     0x19 ,
     0x19 ,
     0x1d ,
     0x19 ,
     0x1d ,
     0x1d ,
     0x21 ,
     0x15 ,
     0x19 ,
     0x19 ,
     0x1d ,
     0x19 ,
     0x1d ,
     0x1d ,
     0x21 ,
     0x19 ,
     0x1d ,
     0x1d ,
     0x21 ,
     0x1d ,
     0x21 ,
     0x23 ,
     0x27 ,
     0x10 ,
     0x15 ,
     0x15 ,
     0x19 ,
     0x15 ,
     0x19 ,
     0x19 ,
     0x1d ,
     0x15 ,
     0x19 ,
     0x19 ,
     0x1d ,
     0x19 ,
     0x1d ,
     0x1d ,
     0x21 ,
     0x15 ,
     0x19 ,
     0x19 ,
     0x1d ,
     0x19 ,
     0x1d ,
     0x1d ,
     0x21 ,
     0x19 ,
     0x1d ,
     0x1d ,
     0x21 ,
     0x1d ,
     0x21 ,
     0x21 ,
     0x27 ,
     0x15 ,
     0x19 ,
     0x19 ,
     0x1d ,
     0x19 ,
     0x1d ,
     0x1d ,
     0x21 ,
     0x19 ,
     0x1d ,
     0x1d ,
     0x21 ,
     0x1d ,
     0x21 ,
     0x21 ,
     0x25 ,
     0x1b ,
     0x1f ,
     0x1f ,
     0x23 ,
     0x1f ,
     0x23 ,
     0x23 ,
     0x27 ,
     0x1f ,
     0x23 ,
     0x23 ,
     0x27 ,
     0x23 ,
     0x27 ,
     0x27 ,
     0x2b ,
     0x08 ,
     0x0c ,
     0x0c ,
     0x10 ,
     0x0c ,
     0x10 ,
     0x10 ,
     0x15 ,
     0x0c ,
     0x10 ,
     0x10 ,
     0x15 ,
     0x10 ,
     0x15 ,
     0x15 ,
     0x19 ,
     0x0c ,
     0x10 ,
     0x10 ,
     0x15 ,
     0x10 ,
     0x15 ,
     0x15 ,
     0x19 ,
     0x10 ,
     0x15 ,
     0x15 ,
     0x19 ,
     0x15 ,
     0x19 ,
     0x19 ,
     0x1f ,
     0x0c ,
     0x10 ,
     0x10 ,
     0x15 ,
     0x10 ,
     0x15 ,
     0x15 ,
     0x19 ,
     0x10 ,
     0x15 ,
     0x15 ,
     0x19 ,
     0x15 ,
     0x19 ,
     0x19 ,
     0x1d ,
     0x10 ,
     0x15 ,
     0x15 ,
     0x19 ,
     0x15 ,
     0x19 ,
     0x19 ,
     0x1d ,
     0x15 ,
     0x19 ,
     0x19 ,
     0x1d ,
     0x19 ,
     0x1d ,
     0x1f ,
     0x23 ,
     0x0c ,
     0x10 ,
     0x10 ,
     0x15 ,
     0x10 ,
     0x15 ,
     0x15 ,
     0x19 ,
     0x10 ,
     0x15 ,
     0x15 ,
     0x19 ,
     0x15 ,
     0x19 ,
     0x19 ,
     0x1d ,
     0x10 ,
     0x15 ,
     0x15 ,
     0x19 ,
     0x15 ,
     0x19 ,
     0x19 ,
     0x1d ,
     0x15 ,
     0x19 ,
     0x19 ,
     0x1d ,
     0x19 ,
     0x1d ,
     0x1d ,
     0x23 ,
     0x10 ,
     0x15 ,
     0x15 ,
     0x19 ,
     0x15 ,
     0x19 ,
     0x19 ,
     0x1d ,
     0x15 ,
     0x19 ,
     0x19 ,
     0x1d ,
     0x19 ,
     0x1d ,
     0x1d ,
     0x21 ,
     0x15 ,
     0x19 ,
     0x19 ,
     0x1d ,
     0x19 ,
     0x1d ,
     0x1d ,
     0x21 ,
     0x19 ,
     0x1d ,
     0x1d ,
     0x21 ,
     0x1f ,
     0x23 ,
     0x23 ,
     0x27 ,
     0x0c ,
     0x10 ,
     0x10 ,
     0x15 ,
     0x10 ,
     0x15 ,
     0x15 ,
     0x19 ,
     0x10 ,
     0x15 ,
     0x15 ,
     0x19 ,
     0x15 ,
     0x19 ,
     0x19 ,
     0x1d ,
     0x10 ,
     0x15 ,
     0x15 ,
     0x19 ,
     0x15 ,
     0x19 ,
     0x19 ,
     0x1d ,
     0x15 ,
     0x19 ,
     0x19 ,
     0x1d ,
     0x19 ,
     0x1d ,
     0x1d ,
     0x23 ,
     0x10 ,
     0x15 ,
     0x15 ,
     0x19 ,
     0x15 ,
     0x19 ,
     0x19 ,
     0x1d ,
     0x15 ,
     0x19 ,
     0x19 ,
     0x1d ,
     0x19 ,
     0x1d ,
     0x1d ,
     0x21 ,
     0x15 ,
     0x19 ,
     0x19 ,
     0x1d ,
     0x19 ,
     0x1d ,
     0x1d ,
     0x21 ,
     0x19 ,
     0x1d ,
     0x1d ,
     0x21 ,
     0x1d ,
     0x21 ,
     0x23 ,
     0x27 ,
     0x10 ,
     0x15 ,
     0x15 ,
     0x19 ,
     0x15 ,
     0x19 ,
     0x19 ,
     0x1d ,
     0x15 ,
     0x19 ,
     0x19 ,
     0x1d ,
     0x19 ,
     0x1d ,
     0x1d ,
     0x21 ,
     0x15 ,
     0x19 ,
     0x19 ,
     0x1d ,
     0x19 ,
     0x1d ,
     0x1d ,
     0x21 ,
     0x19 ,
     0x1d ,
     0x1d ,
     0x21 ,
     0x1d ,
     0x21 ,
     0x21 ,
     0x27 ,
     0x15 ,
     0x19 ,
     0x19 ,
     0x1d ,
     0x19 ,
     0x1d ,
     0x1d ,
     0x21 ,
     0x19 ,
     0x1d ,
     0x1d ,
     0x21 ,
     0x1d ,
     0x21 ,
     0x21 ,
     0x25 ,
     0x19 ,
     0x1d ,
     0x1d ,
     0x21 ,
     0x1d ,
     0x21 ,
     0x21 ,
     0x25 ,
     0x1f ,
     0x23 ,
     0x23 ,
     0x27 ,
     0x23 ,
     0x27 ,
     0x27 ,
     0x2b ,
     0x0c ,
     0x10 ,
     0x10 ,
     0x15 ,
     0x10 ,
     0x15 ,
     0x15 ,
     0x19 ,
     0x10 ,
     0x15 ,
     0x15 ,
     0x19 ,
     0x15 ,
     0x19 ,
     0x19 ,
     0x1d ,
     0x10 ,
     0x15 ,
     0x15 ,
     0x19 ,
     0x15 ,
     0x19 ,
     0x19 ,
     0x1d ,
     0x15 ,
     0x19 ,
     0x19 ,
     0x1d ,
     0x19 ,
     0x1d ,
     0x1d ,
     0x23 ,
     0x10 ,
     0x15 ,
     0x15 ,
     0x19 ,
     0x15 ,
     0x19 ,
     0x19 ,
     0x1d ,
     0x15 ,
     0x19 ,
     0x19 ,
     0x1d ,
     0x19 ,
     0x1d ,
     0x1d ,
     0x21 ,
     0x15 ,
     0x19 ,
     0x19 ,
     0x1d ,
     0x19 ,
     0x1d ,
     0x1d ,
     0x21 ,
     0x19 ,
     0x1d ,
     0x1d ,
     0x21 ,
     0x1d ,
     0x21 ,
     0x23 ,
     0x27 ,
     0x10 ,
     0x15 ,
     0x15 ,
     0x19 ,
     0x15 ,
     0x19 ,
     0x19 ,
     0x1d ,
     0x15 ,
     0x19 ,
     0x19 ,
     0x1d ,
     0x19 ,
     0x1d ,
     0x1d ,
     0x21 ,
     0x15 ,
     0x19 ,
     0x19 ,
     0x1d ,
     0x19 ,
     0x1d ,
     0x1d ,
     0x21 ,
     0x19 ,
     0x1d ,
     0x1d ,
     0x21 ,
     0x1d ,
     0x21 ,
     0x21 ,
     0x27 ,
     0x15 ,
     0x19 ,
     0x19 ,
     0x1d ,
     0x19 ,
     0x1d ,
     0x1d ,
     0x21 ,
     0x19 ,
     0x1d ,
     0x1d ,
     0x21 ,
     0x1d ,
     0x21 ,
     0x21 ,
     0x25 ,
     0x19 ,
     0x1d ,
     0x1d ,
     0x21 ,
     0x1d ,
     0x21 ,
     0x21 ,
     0x25 ,
     0x1d ,
     0x21 ,
     0x21 ,
     0x25 ,
     0x23 ,
     0x27 ,
     0x27 ,
     0x2b ,
     0x10 ,
     0x15 ,
     0x15 ,
     0x19 ,
     0x15 ,
     0x19 ,
     0x19 ,
     0x1d ,
     0x15 ,
     0x19 ,
     0x19 ,
     0x1d ,
     0x19 ,
     0x1d ,
     0x1d ,
     0x21 ,
     0x15 ,
     0x19 ,
     0x19 ,
     0x1d ,
     0x19 ,
     0x1d ,
     0x1d ,
     0x21 ,
     0x19 ,
     0x1d ,
     0x1d ,
     0x21 ,
     0x1d ,
     0x21 ,
     0x21 ,
     0x27 ,
     0x15 ,
     0x19 ,
     0x19 ,
     0x1d ,
     0x19 ,
     0x1d ,
     0x1d ,
     0x21 ,
     0x19 ,
     0x1d ,
     0x1d ,
     0x21 ,
     0x1d ,
     0x21 ,
     0x21 ,
     0x25 ,
     0x19 ,
     0x1d ,
     0x1d ,
     0x21 ,
     0x1d ,
     0x21 ,
     0x21 ,
     0x25 ,
     0x1d ,
     0x21 ,
     0x21 ,
     0x25 ,
     0x21 ,
     0x25 ,
     0x27 ,
     0x2b ,
     0x17 ,
     0x1b ,
     0x1b ,
     0x1f ,
     0x1b ,
     0x1f ,
     0x1f ,
     0x23 ,
     0x1b ,
     0x1f ,
     0x1f ,
     0x23 ,
     0x1f ,
     0x23 ,
     0x23 ,
     0x27 ,
     0x1b ,
     0x1f ,
     0x1f ,
     0x23 ,
     0x1f ,
     0x23 ,
     0x23 ,
     0x27 ,
     0x1f ,
     0x23 ,
     0x23 ,
     0x27 ,
     0x23 ,
     0x27 ,
     0x27 ,
     0x2b ,
     0x1b ,
     0x1f ,
     0x1f ,
     0x23 ,
     0x1f ,
     0x23 ,
     0x23 ,
     0x27 ,
     0x1f ,
     0x23 ,
     0x23 ,
     0x27 ,
     0x23 ,
     0x27 ,
     0x27 ,
     0x2b ,
     0x1f ,
     0x23 ,
     0x23 ,
     0x27 ,
     0x23 ,
     0x27 ,
     0x27 ,
     0x2b ,
     0x23 ,
     0x27 ,
     0x27 ,
     0x2b ,
     0x27 ,
     0x2b ,
     0x2b ,
     0x2f ,
     0x04 ,
     0x08 ,
     0x08 ,
     0x0c ,
     0x08 ,
     0x0c ,
     0x0c ,
     0x10 ,
     0x08 ,
     0x0c ,
     0x0c ,
     0x10 ,
     0x0c ,
     0x10 ,
     0x10 ,
     0x15 ,
     0x08 ,
     0x0c ,
     0x0c ,
     0x10 ,
     0x0c ,
     0x10 ,
     0x10 ,
     0x15 ,
     0x0c ,
     0x10 ,
     0x10 ,
     0x15 ,
     0x10 ,
     0x15 ,
     0x15 ,
     0x1b ,
     0x08 ,
     0x0c ,
     0x0c ,
     0x10 ,
     0x0c ,
     0x10 ,
     0x10 ,
     0x15 ,
     0x0c ,
     0x10 ,
     0x10 ,
     0x15 ,
     0x10 ,
     0x15 ,
     0x15 ,
     0x19 ,
     0x0c ,
     0x10 ,
     0x10 ,
     0x15 ,
     0x10 ,
     0x15 ,
     0x15 ,
     0x19 ,
     0x10 ,
     0x15 ,
     0x15 ,
     0x19 ,
     0x15 ,
     0x19 ,
     0x1b ,
     0x1f ,
     0x08 ,
     0x0c ,
     0x0c ,
     0x10 ,
     0x0c ,
     0x10 ,
     0x10 ,
     0x15 ,
     0x0c ,
     0x10 ,
     0x10 ,
     0x15 ,
     0x10 ,
     0x15 ,
     0x15 ,
     0x19 ,
     0x0c ,
     0x10 ,
     0x10 ,
     0x15 ,
     0x10 ,
     0x15 ,
     0x15 ,
     0x19 ,
     0x10 ,
     0x15 ,
     0x15 ,
     0x19 ,
     0x15 ,
     0x19 ,
     0x19 ,
     0x1f ,
     0x0c ,
     0x10 ,
     0x10 ,
     0x15 ,
     0x10 ,
     0x15 ,
     0x15 ,
     0x19 ,
     0x10 ,
     0x15 ,
     0x15 ,
     0x19 ,
     0x15 ,
     0x19 ,
     0x19 ,
     0x1d ,
     0x10 ,
     0x15 ,
     0x15 ,
     0x19 ,
     0x15 ,
     0x19 ,
     0x19 ,
     0x1d ,
     0x15 ,
     0x19 ,
     0x19 ,
     0x1d ,
     0x1b ,
     0x1f ,
     0x1f ,
     0x23 ,
     0x08 ,
     0x0c ,
     0x0c ,
     0x10 ,
     0x0c ,
     0x10 ,
     0x10 ,
     0x15 ,
     0x0c ,
     0x10 ,
     0x10 ,
     0x15 ,
     0x10 ,
     0x15 ,
     0x15 ,
     0x19 ,
     0x0c ,
     0x10 ,
     0x10 ,
     0x15 ,
     0x10 ,
     0x15 ,
     0x15 ,
     0x19 ,
     0x10 ,
     0x15 ,
     0x15 ,
     0x19 ,
     0x15 ,
     0x19 ,
     0x19 ,
     0x1f ,
     0x0c ,
     0x10 ,
     0x10 ,
     0x15 ,
     0x10 ,
     0x15 ,
     0x15 ,
     0x19 ,
     0x10 ,
     0x15 ,
     0x15 ,
     0x19 ,
     0x15 ,
     0x19 ,
     0x19 ,
     0x1d ,
     0x10 ,
     0x15 ,
     0x15 ,
     0x19 ,
     0x15 ,
     0x19 ,
     0x19 ,
     0x1d ,
     0x15 ,
     0x19 ,
     0x19 ,
     0x1d ,
     0x19 ,
     0x1d ,
     0x1f ,
     0x23 ,
     0x0c ,
     0x10 ,
     0x10 ,
     0x15 ,
     0x10 ,
     0x15 ,
     0x15 ,
     0x19 ,
     0x10 ,
     0x15 ,
     0x15 ,
     0x19 ,
     0x15 ,
     0x19 ,
     0x19 ,
     0x1d ,
     0x10 ,
     0x15 ,
     0x15 ,
     0x19 ,
     0x15 ,
     0x19 ,
     0x19 ,
     0x1d ,
     0x15 ,
     0x19 ,
     0x19 ,
     0x1d ,
     0x19 ,
     0x1d ,
     0x1d ,
     0x23 ,
     0x10 ,
     0x15 ,
     0x15 ,
     0x19 ,
     0x15 ,
     0x19 ,
     0x19 ,
     0x1d ,
     0x15 ,
     0x19 ,
     0x19 ,
     0x1d ,
     0x19 ,
     0x1d ,
     0x1d ,
     0x21 ,
     0x15 ,
     0x19 ,
     0x19 ,
     0x1d ,
     0x19 ,
     0x1d ,
     0x1d ,
     0x21 ,
     0x1b ,
     0x1f ,
     0x1f ,
     0x23 ,
     0x1f ,
     0x23 ,
     0x23 ,
     0x27 ,
     0x08 ,
     0x0c ,
     0x0c ,
     0x10 ,
     0x0c ,
     0x10 ,
     0x10 ,
     0x15 ,
     0x0c ,
     0x10 ,
     0x10 ,
     0x15 ,
     0x10 ,
     0x15 ,
     0x15 ,
     0x19 ,
     0x0c ,
     0x10 ,
     0x10 ,
     0x15 ,
     0x10 ,
     0x15 ,
     0x15 ,
     0x19 ,
     0x10 ,
     0x15 ,
     0x15 ,
     0x19 ,
     0x15 ,
     0x19 ,
     0x19 ,
     0x1f ,
     0x0c ,
     0x10 ,
     0x10 ,
     0x15 ,
     0x10 ,
     0x15 ,
     0x15 ,
     0x19 ,
     0x10 ,
     0x15 ,
     0x15 ,
     0x19 ,
     0x15 ,
     0x19 ,
     0x19 ,
     0x1d ,
     0x10 ,
     0x15 ,
     0x15 ,
     0x19 ,
     0x15 ,
     0x19 ,
     0x19 ,
     0x1d ,
     0x15 ,
     0x19 ,
     0x19 ,
     0x1d ,
     0x19 ,
     0x1d ,
     0x1f ,
     0x23 ,
     0x0c ,
     0x10 ,
     0x10 ,
     0x15 ,
     0x10 ,
     0x15 ,
     0x15 ,
     0x19 ,
     0x10 ,
     0x15 ,
     0x15 ,
     0x19 ,
     0x15 ,
     0x19 ,
     0x19 ,
     0x1d ,
     0x10 ,
     0x15 ,
     0x15 ,
     0x19 ,
     0x15 ,
     0x19 ,
     0x19 ,
     0x1d ,
     0x15 ,
     0x19 ,
     0x19 ,
     0x1d ,
     0x19 ,
     0x1d ,
     0x1d ,
     0x23 ,
     0x10 ,
     0x15 ,
     0x15 ,
     0x19 ,
     0x15 ,
     0x19 ,
     0x19 ,
     0x1d ,
     0x15 ,
     0x19 ,
     0x19 ,
     0x1d ,
     0x19 ,
     0x1d ,
     0x1d ,
     0x21 ,
     0x15 ,
     0x19 ,
     0x19 ,
     0x1d ,
     0x19 ,
     0x1d ,
     0x1d ,
     0x21 ,
     0x19 ,
     0x1d ,
     0x1d ,
     0x21 ,
     0x1f ,
     0x23 ,
     0x23 ,
     0x27 ,
     0x0c ,
     0x10 ,
     0x10 ,
     0x15 ,
     0x10 ,
     0x15 ,
     0x15 ,
     0x19 ,
     0x10 ,
     0x15 ,
     0x15 ,
     0x19 ,
     0x15 ,
     0x19 ,
     0x19 ,
     0x1d ,
     0x10 ,
     0x15 ,
     0x15 ,
     0x19 ,
     0x15 ,
     0x19 ,
     0x19 ,
     0x1d ,
     0x15 ,
     0x19 ,
     0x19 ,
     0x1d ,
     0x19 ,
     0x1d ,
     0x1d ,
     0x23 ,
     0x10 ,
     0x15 ,
     0x15 ,
     0x19 ,
     0x15 ,
     0x19 ,
     0x19 ,
     0x1d ,
     0x15 ,
     0x19 ,
     0x19 ,
     0x1d ,
     0x19 ,
     0x1d ,
     0x1d ,
     0x21 ,
     0x15 ,
     0x19 ,
     0x19 ,
     0x1d ,
     0x19 ,
     0x1d ,
     0x1d ,
     0x21 ,
     0x19 ,
     0x1d ,
     0x1d ,
     0x21 ,
     0x1d ,
     0x21 ,
     0x23 ,
     0x27 ,
     0x10 ,
     0x15 ,
     0x15 ,
     0x19 ,
     0x15 ,
     0x19 ,
     0x19 ,
     0x1d ,
     0x15 ,
     0x19 ,
     0x19 ,
     0x1d ,
     0x19 ,
     0x1d ,
     0x1d ,
     0x21 ,
     0x15 ,
     0x19 ,
     0x19 ,
     0x1d ,
     0x19 ,
     0x1d ,
     0x1d ,
     0x21 ,
     0x19 ,
     0x1d ,
     0x1d ,
     0x21 ,
     0x1d ,
     0x21 ,
     0x21 ,
     0x27 ,
     0x15 ,
     0x19 ,
     0x19 ,
     0x1d ,
     0x19 ,
     0x1d ,
     0x1d ,
     0x21 ,
     0x19 ,
     0x1d ,
     0x1d ,
     0x21 ,
     0x1d ,
     0x21 ,
     0x21 ,
     0x25 ,
     0x1b ,
     0x1f ,
     0x1f ,
     0x23 ,
     0x1f ,
     0x23 ,
     0x23 ,
     0x27 ,
     0x1f ,
     0x23 ,
     0x23 ,
     0x27 ,
     0x23 ,
     0x27 ,
     0x27 ,
     0x2b ,
     0x08 ,
     0x0c ,
     0x0c ,
     0x10 ,
     0x0c ,
     0x10 ,
     0x10 ,
     0x15 ,
     0x0c ,
     0x10 ,
     0x10 ,
     0x15 ,
     0x10 ,
     0x15 ,
     0x15 ,
     0x19 ,
     0x0c ,
     0x10 ,
     0x10 ,
     0x15 ,
     0x10 ,
     0x15 ,
     0x15 ,
     0x19 ,
     0x10 ,
     0x15 ,
     0x15 ,
     0x19 ,
     0x15 ,
     0x19 ,
     0x19 ,
     0x1f ,
     0x0c ,
     0x10 ,
     0x10 ,
     0x15 ,
     0x10 ,
     0x15 ,
     0x15 ,
     0x19 ,
     0x10 ,
     0x15 ,
     0x15 ,
     0x19 ,
     0x15 ,
     0x19 ,
     0x19 ,
     0x1d ,
     0x10 ,
     0x15 ,
     0x15 ,
     0x19 ,
     0x15 ,
     0x19 ,
     0x19 ,
     0x1d ,
     0x15 ,
     0x19 ,
     0x19 ,
     0x1d ,
     0x19 ,
     0x1d ,
     0x1f ,
     0x23 ,
     0x0c ,
     0x10 ,
     0x10 ,
     0x15 ,
     0x10 ,
     0x15 ,
     0x15 ,
     0x19 ,
     0x10 ,
     0x15 ,
     0x15 ,
     0x19 ,
     0x15 ,
     0x19 ,
     0x19 ,
     0x1d ,
     0x10 ,
     0x15 ,
     0x15 ,
     0x19 ,
     0x15 ,
     0x19 ,
     0x19 ,
     0x1d ,
     0x15 ,
     0x19 ,
     0x19 ,
     0x1d ,
     0x19 ,
     0x1d ,
     0x1d ,
     0x23 ,
     0x10 ,
     0x15 ,
     0x15 ,
     0x19 ,
     0x15 ,
     0x19 ,
     0x19 ,
     0x1d ,
     0x15 ,
     0x19 ,
     0x19 ,
     0x1d ,
     0x19 ,
     0x1d ,
     0x1d ,
     0x21 ,
     0x15 ,
     0x19 ,
     0x19 ,
     0x1d ,
     0x19 ,
     0x1d ,
     0x1d ,
     0x21 ,
     0x19 ,
     0x1d ,
     0x1d ,
     0x21 ,
     0x1f ,
     0x23 ,
     0x23 ,
     0x27 ,
     0x0c ,
     0x10 ,
     0x10 ,
     0x15 ,
     0x10 ,
     0x15 ,
     0x15 ,
     0x19 ,
     0x10 ,
     0x15 ,
     0x15 ,
     0x19 ,
     0x15 ,
     0x19 ,
     0x19 ,
     0x1d ,
     0x10 ,
     0x15 ,
     0x15 ,
     0x19 ,
     0x15 ,
     0x19 ,
     0x19 ,
     0x1d ,
     0x15 ,
     0x19 ,
     0x19 ,
     0x1d ,
     0x19 ,
     0x1d ,
     0x1d ,
     0x23 ,
     0x10 ,
     0x15 ,
     0x15 ,
     0x19 ,
     0x15 ,
     0x19 ,
     0x19 ,
     0x1d ,
     0x15 ,
     0x19 ,
     0x19 ,
     0x1d ,
     0x19 ,
     0x1d ,
     0x1d ,
     0x21 ,
     0x15 ,
     0x19 ,
     0x19 ,
     0x1d ,
     0x19 ,
     0x1d ,
     0x1d ,
     0x21 ,
     0x19 ,
     0x1d ,
     0x1d ,
     0x21 ,
     0x1d ,
     0x21 ,
     0x23 ,
     0x27 ,
     0x10 ,
     0x15 ,
     0x15 ,
     0x19 ,
     0x15 ,
     0x19 ,
     0x19 ,
     0x1d ,
     0x15 ,
     0x19 ,
     0x19 ,
     0x1d ,
     0x19 ,
     0x1d ,
     0x1d ,
     0x21 ,
     0x15 ,
     0x19 ,
     0x19 ,
     0x1d ,
     0x19 ,
     0x1d ,
     0x1d ,
     0x21 ,
     0x19 ,
     0x1d ,
     0x1d ,
     0x21 ,
     0x1d ,
     0x21 ,
     0x21 ,
     0x27 ,
     0x15 ,
     0x19 ,
     0x19 ,
     0x1d ,
     0x19 ,
     0x1d ,
     0x1d ,
     0x21 ,
     0x19 ,
     0x1d ,
     0x1d ,
     0x21 ,
     0x1d ,
     0x21 ,
     0x21 ,
     0x25 ,
     0x19 ,
     0x1d ,
     0x1d ,
     0x21 ,
     0x1d ,
     0x21 ,
     0x21 ,
     0x25 ,
     0x1f ,
     0x23 ,
     0x23 ,
     0x27 ,
     0x23 ,
     0x27 ,
     0x27 ,
     0x2b ,
     0x0c ,
     0x10 ,
     0x10 ,
     0x15 ,
     0x10 ,
     0x15 ,
     0x15 ,
     0x19 ,
     0x10 ,
     0x15 ,
     0x15 ,
     0x19 ,
     0x15 ,
     0x19 ,
     0x19 ,
     0x1d ,
     0x10 ,
     0x15 ,
     0x15 ,
     0x19 ,
     0x15 ,
     0x19 ,
     0x19 ,
     0x1d ,
     0x15 ,
     0x19 ,
     0x19 ,
     0x1d ,
     0x19 ,
     0x1d ,
     0x1d ,
     0x23 ,
     0x10 ,
     0x15 ,
     0x15 ,
     0x19 ,
     0x15 ,
     0x19 ,
     0x19 ,
     0x1d ,
     0x15 ,
     0x19 ,
     0x19 ,
     0x1d ,
     0x19 ,
     0x1d ,
     0x1d ,
     0x21 ,
     0x15 ,
     0x19 ,
     0x19 ,
     0x1d ,
     0x19 ,
     0x1d ,
     0x1d ,
     0x21 ,
     0x19 ,
     0x1d ,
     0x1d ,
     0x21 ,
     0x1d ,
     0x21 ,
     0x23 ,
     0x27 ,
     0x10 ,
     0x15 ,
     0x15 ,
     0x19 ,
     0x15 ,
     0x19 ,
     0x19 ,
     0x1d ,
     0x15 ,
     0x19 ,
     0x19 ,
     0x1d ,
     0x19 ,
     0x1d ,
     0x1d ,
     0x21 ,
     0x15 ,
     0x19 ,
     0x19 ,
     0x1d ,
     0x19 ,
     0x1d ,
     0x1d ,
     0x21 ,
     0x19 ,
     0x1d ,
     0x1d ,
     0x21 ,
     0x1d ,
     0x21 ,
     0x21 ,
     0x27 ,
     0x15 ,
     0x19 ,
     0x19 ,
     0x1d ,
     0x19 ,
     0x1d ,
     0x1d ,
     0x21 ,
     0x19 ,
     0x1d ,
     0x1d ,
     0x21 ,
     0x1d ,
     0x21 ,
     0x21 ,
     0x25 ,
     0x19 ,
     0x1d ,
     0x1d ,
     0x21 ,
     0x1d ,
     0x21 ,
     0x21 ,
     0x25 ,
     0x1d ,
     0x21 ,
     0x21 ,
     0x25 ,
     0x23 ,
     0x27 ,
     0x27 ,
     0x2b ,
     0x10 ,
     0x15 ,
     0x15 ,
     0x19 ,
     0x15 ,
     0x19 ,
     0x19 ,
     0x1d ,
     0x15 ,
     0x19 ,
     0x19 ,
     0x1d ,
     0x19 ,
     0x1d ,
     0x1d ,
     0x21 ,
     0x15 ,
     0x19 ,
     0x19 ,
     0x1d ,
     0x19 ,
     0x1d ,
     0x1d ,
     0x21 ,
     0x19 ,
     0x1d ,
     0x1d ,
     0x21 ,
     0x1d ,
     0x21 ,
     0x21 ,
     0x27 ,
     0x15 ,
     0x19 ,
     0x19 ,
     0x1d ,
     0x19 ,
     0x1d ,
     0x1d ,
     0x21 ,
     0x19 ,
     0x1d ,
     0x1d ,
     0x21 ,
     0x1d ,
     0x21 ,
     0x21 ,
     0x25 ,
     0x19 ,
     0x1d ,
     0x1d ,
     0x21 ,
     0x1d ,
     0x21 ,
     0x21 ,
     0x25 ,
     0x1d ,
     0x21 ,
     0x21 ,
     0x25 ,
     0x21 ,
     0x25 ,
     0x27 ,
     0x2b ,
     0x15 ,
     0x19 ,
     0x19 ,
     0x1d ,
     0x19 ,
     0x1d ,
     0x1d ,
     0x21 ,
     0x19 ,
     0x1d ,
     0x1d ,
     0x21 ,
     0x1d ,
     0x21 ,
     0x21 ,
     0x25 ,
     0x19 ,
     0x1d ,
     0x1d ,
     0x21 ,
     0x1d ,
     0x21 ,
     0x21 ,
     0x25 ,
     0x1d ,
     0x21 ,
     0x21 ,
     0x25 ,
     0x21 ,
     0x25 ,
     0x25 ,
     0x2b ,
     0x1b ,
     0x1f ,
     0x1f ,
     0x23 ,
     0x1f ,
     0x23 ,
     0x23 ,
     0x27 ,
     0x1f ,
     0x23 ,
     0x23 ,
     0x27 ,
     0x23 ,
     0x27 ,
     0x27 ,
     0x2b ,
     0x1f ,
     0x23 ,
     0x23 ,
     0x27 ,
     0x23 ,
     0x27 ,
     0x27 ,
     0x2b ,
     0x23 ,
     0x27 ,
     0x27 ,
     0x2b ,
     0x27 ,
     0x2b ,
     0x2b ,
     0x2f ,
     0x08 ,
     0x0c ,
     0x0c ,
     0x10 ,
     0x0c ,
     0x10 ,
     0x10 ,
     0x15 ,
     0x0c ,
     0x10 ,
     0x10 ,
     0x15 ,
     0x10 ,
     0x15 ,
     0x15 ,
     0x19 ,
     0x0c ,
     0x10 ,
     0x10 ,
     0x15 ,
     0x10 ,
     0x15 ,
     0x15 ,
     0x19 ,
     0x10 ,
     0x15 ,
     0x15 ,
     0x19 ,
     0x15 ,
     0x19 ,
     0x19 ,
     0x1f ,
     0x0c ,
     0x10 ,
     0x10 ,
     0x15 ,
     0x10 ,
     0x15 ,
     0x15 ,
     0x19 ,
     0x10 ,
     0x15 ,
     0x15 ,
     0x19 ,
     0x15 ,
     0x19 ,
     0x19 ,
     0x1d ,
     0x10 ,
     0x15 ,
     0x15 ,
     0x19 ,
     0x15 ,
     0x19 ,
     0x19 ,
     0x1d ,
     0x15 ,
     0x19 ,
     0x19 ,
     0x1d ,
     0x19 ,
     0x1d ,
     0x1f ,
     0x23 ,
     0x0c ,
     0x10 ,
     0x10 ,
     0x15 ,
     0x10 ,
     0x15 ,
     0x15 ,
     0x19 ,
     0x10 ,
     0x15 ,
     0x15 ,
     0x19 ,
     0x15 ,
     0x19 ,
     0x19 ,
     0x1d ,
     0x10 ,
     0x15 ,
     0x15 ,
     0x19 ,
     0x15 ,
     0x19 ,
     0x19 ,
     0x1d ,
     0x15 ,
     0x19 ,
     0x19 ,
     0x1d ,
     0x19 ,
     0x1d ,
     0x1d ,
     0x23 ,
     0x10 ,
     0x15 ,
     0x15 ,
     0x19 ,
     0x15 ,
     0x19 ,
     0x19 ,
     0x1d ,
     0x15 ,
     0x19 ,
     0x19 ,
     0x1d ,
     0x19 ,
     0x1d ,
     0x1d ,
     0x21 ,
     0x15 ,
     0x19 ,
     0x19 ,
     0x1d ,
     0x19 ,
     0x1d ,
     0x1d ,
     0x21 ,
     0x19 ,
     0x1d ,
     0x1d ,
     0x21 ,
     0x1f ,
     0x23 ,
     0x23 ,
     0x27 ,
     0x0c ,
     0x10 ,
     0x10 ,
     0x15 ,
     0x10 ,
     0x15 ,
     0x15 ,
     0x19 ,
     0x10 ,
     0x15 ,
     0x15 ,
     0x19 ,
     0x15 ,
     0x19 ,
     0x19 ,
     0x1d ,
     0x10 ,
     0x15 ,
     0x15 ,
     0x19 ,
     0x15 ,
     0x19 ,
     0x19 ,
     0x1d ,
     0x15 ,
     0x19 ,
     0x19 ,
     0x1d ,
     0x19 ,
     0x1d ,
     0x1d ,
     0x23 ,
     0x10 ,
     0x15 ,
     0x15 ,
     0x19 ,
     0x15 ,
     0x19 ,
     0x19 ,
     0x1d ,
     0x15 ,
     0x19 ,
     0x19 ,
     0x1d ,
     0x19 ,
     0x1d ,
     0x1d ,
     0x21 ,
     0x15 ,
     0x19 ,
     0x19 ,
     0x1d ,
     0x19 ,
     0x1d ,
     0x1d ,
     0x21 ,
     0x19 ,
     0x1d ,
     0x1d ,
     0x21 ,
     0x1d ,
     0x21 ,
     0x23 ,
     0x27 ,
     0x10 ,
     0x15 ,
     0x15 ,
     0x19 ,
     0x15 ,
     0x19 ,
     0x19 ,
     0x1d ,
     0x15 ,
     0x19 ,
     0x19 ,
     0x1d ,
     0x19 ,
     0x1d ,
     0x1d ,
     0x21 ,
     0x15 ,
     0x19 ,
     0x19 ,
     0x1d ,
     0x19 ,
     0x1d ,
     0x1d ,
     0x21 ,
     0x19 ,
     0x1d ,
     0x1d ,
     0x21 ,
     0x1d ,
     0x21 ,
     0x21 ,
     0x27 ,
     0x15 ,
     0x19 ,
     0x19 ,
     0x1d ,
     0x19 ,
     0x1d ,
     0x1d ,
     0x21 ,
     0x19 ,
     0x1d ,
     0x1d ,
     0x21 ,
     0x1d ,
     0x21 ,
     0x21 ,
     0x25 ,
     0x19 ,
     0x1d ,
     0x1d ,
     0x21 ,
     0x1d ,
     0x21 ,
     0x21 ,
     0x25 ,
     0x1f ,
     0x23 ,
     0x23 ,
     0x27 ,
     0x23 ,
     0x27 ,
     0x27 ,
     0x2b ,
     0x0c ,
     0x10 ,
     0x10 ,
     0x15 ,
     0x10 ,
     0x15 ,
     0x15 ,
     0x19 ,
     0x10 ,
     0x15 ,
     0x15 ,
     0x19 ,
     0x15 ,
     0x19 ,
     0x19 ,
     0x1d ,
     0x10 ,
     0x15 ,
     0x15 ,
     0x19 ,
     0x15 ,
     0x19 ,
     0x19 ,
     0x1d ,
     0x15 ,
     0x19 ,
     0x19 ,
     0x1d ,
     0x19 ,
     0x1d ,
     0x1d ,
     0x23 ,
     0x10 ,
     0x15 ,
     0x15 ,
     0x19 ,
     0x15 ,
     0x19 ,
     0x19 ,
     0x1d ,
     0x15 ,
     0x19 ,
     0x19 ,
     0x1d ,
     0x19 ,
     0x1d ,
     0x1d ,
     0x21 ,
     0x15 ,
     0x19 ,
     0x19 ,
     0x1d ,
     0x19 ,
     0x1d ,
     0x1d ,
     0x21 ,
     0x19 ,
     0x1d ,
     0x1d ,
     0x21 ,
     0x1d ,
     0x21 ,
     0x23 ,
     0x27 ,
     0x10 ,
     0x15 ,
     0x15 ,
     0x19 ,
     0x15 ,
     0x19 ,
     0x19 ,
     0x1d ,
     0x15 ,
     0x19 ,
     0x19 ,
     0x1d ,
     0x19 ,
     0x1d ,
     0x1d ,
     0x21 ,
     0x15 ,
     0x19 ,
     0x19 ,
     0x1d ,
     0x19 ,
     0x1d ,
     0x1d ,
     0x21 ,
     0x19 ,
     0x1d ,
     0x1d ,
     0x21 ,
     0x1d ,
     0x21 ,
     0x21 ,
     0x27 ,
     0x15 ,
     0x19 ,
     0x19 ,
     0x1d ,
     0x19 ,
     0x1d ,
     0x1d ,
     0x21 ,
     0x19 ,
     0x1d ,
     0x1d ,
     0x21 ,
     0x1d ,
     0x21 ,
     0x21 ,
     0x25 ,
     0x19 ,
     0x1d ,
     0x1d ,
     0x21 ,
     0x1d ,
     0x21 ,
     0x21 ,
     0x25 ,
     0x1d ,
     0x21 ,
     0x21 ,
     0x25 ,
     0x23 ,
     0x27 ,
     0x27 ,
     0x2b ,
     0x10 ,
     0x15 ,
     0x15 ,
     0x19 ,
     0x15 ,
     0x19 ,
     0x19 ,
     0x1d ,
     0x15 ,
     0x19 ,
     0x19 ,
     0x1d ,
     0x19 ,
     0x1d ,
     0x1d ,
     0x21 ,
     0x15 ,
     0x19 ,
     0x19 ,
     0x1d ,
     0x19 ,
     0x1d ,
     0x1d ,
     0x21 ,
     0x19 ,
     0x1d ,
     0x1d ,
     0x21 ,
     0x1d ,
     0x21 ,
     0x21 ,
     0x27 ,
     0x15 ,
     0x19 ,
     0x19 ,
     0x1d ,
     0x19 ,
     0x1d ,
     0x1d ,
     0x21 ,
     0x19 ,
     0x1d ,
     0x1d ,
     0x21 ,
     0x1d ,
     0x21 ,
     0x21 ,
     0x25 ,
     0x19 ,
     0x1d ,
     0x1d ,
     0x21 ,
     0x1d ,
     0x21 ,
     0x21 ,
     0x25 ,
     0x1d ,
     0x21 ,
     0x21 ,
     0x25 ,
     0x21 ,
     0x25 ,
     0x27 ,
     0x2b ,
     0x15 ,
     0x19 ,
     0x19 ,
     0x1d ,
     0x19 ,
     0x1d ,
     0x1d ,
     0x21 ,
     0x19 ,
     0x1d ,
     0x1d ,
     0x21 ,
     0x1d ,
     0x21 ,
     0x21 ,
     0x25 ,
     0x19 ,
     0x1d ,
     0x1d ,
     0x21 ,
     0x1d ,
     0x21 ,
     0x21 ,
     0x25 ,
     0x1d ,
     0x21 ,
     0x21 ,
     0x25 ,
     0x21 ,
     0x25 ,
     0x25 ,
     0x2b ,
     0x19 ,
     0x1d ,
     0x1d ,
     0x21 ,
     0x1d ,
     0x21 ,
     0x21 ,
     0x25 ,
     0x1d ,
     0x21 ,
     0x21 ,
     0x25 ,
     0x21 ,
     0x25 ,
     0x25 ,
     0x29 ,
     0x1f ,
     0x23 ,
     0x23 ,
     0x27 ,
     0x23 ,
     0x27 ,
     0x27 ,
     0x2b ,
     0x23 ,
     0x27 ,
     0x27 ,
     0x2b ,
     0x27 ,
     0x2b ,
     0x2b ,
     0x2f ,
     0x0c ,
     0x10 ,
     0x10 ,
     0x15 ,
     0x10 ,
     0x15 ,
     0x15 ,
     0x19 ,
     0x10 ,
     0x15 ,
     0x15 ,
     0x19 ,
     0x15 ,
     0x19 ,
     0x19 ,
     0x1d ,
     0x10 ,
     0x15 ,
     0x15 ,
     0x19 ,
     0x15 ,
     0x19 ,
     0x19 ,
     0x1d ,
     0x15 ,
     0x19 ,
     0x19 ,
     0x1d ,
     0x19 ,
     0x1d ,
     0x1d ,
     0x23 ,
     0x10 ,
     0x15 ,
     0x15 ,
     0x19 ,
     0x15 ,
     0x19 ,
     0x19 ,
     0x1d ,
     0x15 ,
     0x19 ,
     0x19 ,
     0x1d ,
     0x19 ,
     0x1d ,
     0x1d ,
     0x21 ,
     0x15 ,
     0x19 ,
     0x19 ,
     0x1d ,
     0x19 ,
     0x1d ,
     0x1d ,
     0x21 ,
     0x19 ,
     0x1d ,
     0x1d ,
     0x21 ,
     0x1d ,
     0x21 ,
     0x23 ,
     0x27 ,
     0x10 ,
     0x15 ,
     0x15 ,
     0x19 ,
     0x15 ,
     0x19 ,
     0x19 ,
     0x1d ,
     0x15 ,
     0x19 ,
     0x19 ,
     0x1d ,
     0x19 ,
     0x1d ,
     0x1d ,
     0x21 ,
     0x15 ,
     0x19 ,
     0x19 ,
     0x1d ,
     0x19 ,
     0x1d ,
     0x1d ,
     0x21 ,
     0x19 ,
     0x1d ,
     0x1d ,
     0x21 ,
     0x1d ,
     0x21 ,
     0x21 ,
     0x27 ,
     0x15 ,
     0x19 ,
     0x19 ,
     0x1d ,
     0x19 ,
     0x1d ,
     0x1d ,
     0x21 ,
     0x19 ,
     0x1d ,
     0x1d ,
     0x21 ,
     0x1d ,
     0x21 ,
     0x21 ,
     0x25 ,
     0x19 ,
     0x1d ,
     0x1d ,
     0x21 ,
     0x1d ,
     0x21 ,
     0x21 ,
     0x25 ,
     0x1d ,
     0x21 ,
     0x21 ,
     0x25 ,
     0x23 ,
     0x27 ,
     0x27 ,
     0x2b ,
     0x10 ,
     0x15 ,
     0x15 ,
     0x19 ,
     0x15 ,
     0x19 ,
     0x19 ,
     0x1d ,
     0x15 ,
     0x19 ,
     0x19 ,
     0x1d ,
     0x19 ,
     0x1d ,
     0x1d ,
     0x21 ,
     0x15 ,
     0x19 ,
     0x19 ,
     0x1d ,
     0x19 ,
     0x1d ,
     0x1d ,
     0x21 ,
     0x19 ,
     0x1d ,
     0x1d ,
     0x21 ,
     0x1d ,
     0x21 ,
     0x21 ,
     0x27 ,
     0x15 ,
     0x19 ,
     0x19 ,
     0x1d ,
     0x19 ,
     0x1d ,
     0x1d ,
     0x21 ,
     0x19 ,
     0x1d ,
     0x1d ,
     0x21 ,
     0x1d ,
     0x21 ,
     0x21 ,
     0x25 ,
     0x19 ,
     0x1d ,
     0x1d ,
     0x21 ,
     0x1d ,
     0x21 ,
     0x21 ,
     0x25 ,
     0x1d ,
     0x21 ,
     0x21 ,
     0x25 ,
     0x21 ,
     0x25 ,
     0x27 ,
     0x2b ,
     0x15 ,
     0x19 ,
     0x19 ,
     0x1d ,
     0x19 ,
     0x1d ,
     0x1d ,
     0x21 ,
     0x19 ,
     0x1d ,
     0x1d ,
     0x21 ,
     0x1d ,
     0x21 ,
     0x21 ,
     0x25 ,
     0x19 ,
     0x1d ,
     0x1d ,
     0x21 ,
     0x1d ,
     0x21 ,
     0x21 ,
     0x25 ,
     0x1d ,
     0x21 ,
     0x21 ,
     0x25 ,
     0x21 ,
     0x25 ,
     0x25 ,
     0x2b ,
     0x19 ,
     0x1d ,
     0x1d ,
     0x21 ,
     0x1d ,
     0x21 ,
     0x21 ,
     0x25 ,
     0x1d ,
     0x21 ,
     0x21 ,
     0x25 ,
     0x21 ,
     0x25 ,
     0x25 ,
     0x29 ,
     0x1d ,
     0x21 ,
     0x21 ,
     0x25 ,
     0x21 ,
     0x25 ,
     0x25 ,
     0x29 ,
     0x23 ,
     0x27 ,
     0x27 ,
     0x2b ,
     0x27 ,
     0x2b ,
     0x2b ,
     0x2f ,
     0x10 ,
     0x15 ,
     0x15 ,
     0x19 ,
     0x15 ,
     0x19 ,
     0x19 ,
     0x1d ,
     0x15 ,
     0x19 ,
     0x19 ,
     0x1d ,
     0x19 ,
     0x1d ,
     0x1d ,
     0x21 ,
     0x15 ,
     0x19 ,
     0x19 ,
     0x1d ,
     0x19 ,
     0x1d ,
     0x1d ,
     0x21 ,
     0x19 ,
     0x1d ,
     0x1d ,
     0x21 ,
     0x1d ,
     0x21 ,
     0x21 ,
     0x27 ,
     0x15 ,
     0x19 ,
     0x19 ,
     0x1d ,
     0x19 ,
     0x1d ,
     0x1d ,
     0x21 ,
     0x19 ,
     0x1d ,
     0x1d ,
     0x21 ,
     0x1d ,
     0x21 ,
     0x21 ,
     0x25 ,
     0x19 ,
     0x1d ,
     0x1d ,
     0x21 ,
     0x1d ,
     0x21 ,
     0x21 ,
     0x25 ,
     0x1d ,
     0x21 ,
     0x21 ,
     0x25 ,
     0x21 ,
     0x25 ,
     0x27 ,
     0x2b ,
     0x15 ,
     0x19 ,
     0x19 ,
     0x1d ,
     0x19 ,
     0x1d ,
     0x1d ,
     0x21 ,
     0x19 ,
     0x1d ,
     0x1d ,
     0x21 ,
     0x1d ,
     0x21 ,
     0x21 ,
     0x25 ,
     0x19 ,
     0x1d ,
     0x1d ,
     0x21 ,
     0x1d ,
     0x21 ,
     0x21 ,
     0x25 ,
     0x1d ,
     0x21 ,
     0x21 ,
     0x25 ,
     0x21 ,
     0x25 ,
     0x25 ,
     0x2b ,
     0x19 ,
     0x1d ,
     0x1d ,
     0x21 ,
     0x1d ,
     0x21 ,
     0x21 ,
     0x25 ,
     0x1d ,
     0x21 ,
     0x21 ,
     0x25 ,
     0x21 ,
     0x25 ,
     0x25 ,
     0x29 ,
     0x1d ,
     0x21 ,
     0x21 ,
     0x25 ,
     0x21 ,
     0x25 ,
     0x25 ,
     0x29 ,
     0x21 ,
     0x25 ,
     0x25 ,
     0x29 ,
     0x27 ,
     0x2b ,
     0x2b ,
     0x2f ,
     0x17 ,
     0x1b ,
     0x1b ,
     0x1f ,
     0x1b ,
     0x1f ,
     0x1f ,
     0x23 ,
     0x1b ,
     0x1f ,
     0x1f ,
     0x23 ,
     0x1f ,
     0x23 ,
     0x23 ,
     0x27 ,
     0x1b ,
     0x1f ,
     0x1f ,
     0x23 ,
     0x1f ,
     0x23 ,
     0x23 ,
     0x27 ,
     0x1f ,
     0x23 ,
     0x23 ,
     0x27 ,
     0x23 ,
     0x27 ,
     0x27 ,
     0x2b ,
     0x1b ,
     0x1f ,
     0x1f ,
     0x23 ,
     0x1f ,
     0x23 ,
     0x23 ,
     0x27 ,
     0x1f ,
     0x23 ,
     0x23 ,
     0x27 ,
     0x23 ,
     0x27 ,
     0x27 ,
     0x2b ,
     0x1f ,
     0x23 ,
     0x23 ,
     0x27 ,
     0x23 ,
     0x27 ,
     0x27 ,
     0x2b ,
     0x23 ,
     0x27 ,
     0x27 ,
     0x2b ,
     0x27 ,
     0x2b ,
     0x2b ,
     0x2f ,
     0x1b ,
     0x1f ,
     0x1f ,
     0x23 ,
     0x1f ,
     0x23 ,
     0x23 ,
     0x27 ,
     0x1f ,
     0x23 ,
     0x23 ,
     0x27 ,
     0x23 ,
     0x27 ,
     0x27 ,
     0x2b ,
     0x1f ,
     0x23 ,
     0x23 ,
     0x27 ,
     0x23 ,
     0x27 ,
     0x27 ,
     0x2b ,
     0x23 ,
     0x27 ,
     0x27 ,
     0x2b ,
     0x27 ,
     0x2b ,
     0x2b ,
     0x2f ,
     0x1f ,
     0x23 ,
     0x23 ,
     0x27 ,
     0x23 ,
     0x27 ,
     0x27 ,
     0x2b ,
     0x23 ,
     0x27 ,
     0x27 ,
     0x2b ,
     0x27 ,
     0x2b ,
     0x2b ,
     0x2f ,
     0x23 ,
     0x27 ,
     0x27 ,
     0x2b ,
     0x27 ,
     0x2b ,
     0x2b ,
     0x2f ,
     0x27 ,
     0x2b ,
     0x2b ,
     0x2f ,
     0x2b ,
     0x2f ,
     0x2f ,
     0x33 ,
     0x04 ,
     0x08 ,
     0x08 ,
     0x0c ,
     0x08 ,
     0x0c ,
     0x0c ,
     0x10 ,
     0x08 ,
     0x0c ,
     0x0c ,
     0x10 ,
     0x0c ,
     0x10 ,
     0x10 ,
     0x17 ,
     0x08 ,
     0x0c ,
     0x0c ,
     0x10 ,
     0x0c ,
     0x10 ,
     0x10 ,
     0x15 ,
     0x0c ,
     0x10 ,
     0x10 ,
     0x15 ,
     0x10 ,
     0x15 ,
     0x15 ,
     0x1b ,
     0x08 ,
     0x0c ,
     0x0c ,
     0x10 ,
     0x0c ,
     0x10 ,
     0x10 ,
     0x15 ,
     0x0c ,
     0x10 ,
     0x10 ,
     0x15 ,
     0x10 ,
     0x15 ,
     0x15 ,
     0x1b ,
     0x0c ,
     0x10 ,
     0x10 ,
     0x15 ,
     0x10 ,
     0x15 ,
     0x15 ,
     0x19 ,
     0x10 ,
     0x15 ,
     0x15 ,
     0x19 ,
     0x15 ,
     0x19 ,
     0x1b ,
     0x1f ,
     0x08 ,
     0x0c ,
     0x0c ,
     0x10 ,
     0x0c ,
     0x10 ,
     0x10 ,
     0x15 ,
     0x0c ,
     0x10 ,
     0x10 ,
     0x15 ,
     0x10 ,
     0x15 ,
     0x15 ,
     0x1b ,
     0x0c ,
     0x10 ,
     0x10 ,
     0x15 ,
     0x10 ,
     0x15 ,
     0x15 ,
     0x19 ,
     0x10 ,
     0x15 ,
     0x15 ,
     0x19 ,
     0x15 ,
     0x19 ,
     0x19 ,
     0x1f ,
     0x0c ,
     0x10 ,
     0x10 ,
     0x15 ,
     0x10 ,
     0x15 ,
     0x15 ,
     0x19 ,
     0x10 ,
     0x15 ,
     0x15 ,
     0x19 ,
     0x15 ,
     0x19 ,
     0x19 ,
     0x1f ,
     0x10 ,
     0x15 ,
     0x15 ,
     0x19 ,
     0x15 ,
     0x19 ,
     0x19 ,
     0x1d ,
     0x15 ,
     0x19 ,
     0x19 ,
     0x1d ,
     0x1b ,
     0x1f ,
     0x1f ,
     0x23 ,
     0x08 ,
     0x0c ,
     0x0c ,
     0x10 ,
     0x0c ,
     0x10 ,
     0x10 ,
     0x15 ,
     0x0c ,
     0x10 ,
     0x10 ,
     0x15 ,
     0x10 ,
     0x15 ,
     0x15 ,
     0x1b ,
     0x0c ,
     0x10 ,
     0x10 ,
     0x15 ,
     0x10 ,
     0x15 ,
     0x15 ,
     0x19 ,
     0x10 ,
     0x15 ,
     0x15 ,
     0x19 ,
     0x15 ,
     0x19 ,
     0x19 ,
     0x1f ,
     0x0c ,
     0x10 ,
     0x10 ,
     0x15 ,
     0x10 ,
     0x15 ,
     0x15 ,
     0x19 ,
     0x10 ,
     0x15 ,
     0x15 ,
     0x19 ,
     0x15 ,
     0x19 ,
     0x19 ,
     0x1f ,
     0x10 ,
     0x15 ,
     0x15 ,
     0x19 ,
     0x15 ,
     0x19 ,
     0x19 ,
     0x1d ,
     0x15 ,
     0x19 ,
     0x19 ,
     0x1d ,
     0x19 ,
     0x1d ,
     0x1f ,
     0x23 ,
     0x0c ,
     0x10 ,
     0x10 ,
     0x15 ,
     0x10 ,
     0x15 ,
     0x15 ,
     0x19 ,
     0x10 ,
     0x15 ,
     0x15 ,
     0x19 ,
     0x15 ,
     0x19 ,
     0x19 ,
     0x1f ,
     0x10 ,
     0x15 ,
     0x15 ,
     0x19 ,
     0x15 ,
     0x19 ,
     0x19 ,
     0x1d ,
     0x15 ,
     0x19 ,
     0x19 ,
     0x1d ,
     0x19 ,
     0x1d ,
     0x1d ,
     0x23 ,
     0x10 ,
     0x15 ,
     0x15 ,
     0x19 ,
     0x15 ,
     0x19 ,
     0x19 ,
     0x1d ,
     0x15 ,
     0x19 ,
     0x19 ,
     0x1d ,
     0x19 ,
     0x1d ,
     0x1d ,
     0x23 ,
     0x15 ,
     0x19 ,
     0x19 ,
     0x1d ,
     0x19 ,
     0x1d ,
     0x1d ,
     0x21 ,
     0x1b ,
     0x1f ,
     0x1f ,
     0x23 ,
     0x1f ,
     0x23 ,
     0x23 ,
     0x27 ,
     0x08 ,
     0x0c ,
     0x0c ,
     0x10 ,
     0x0c ,
     0x10 ,
     0x10 ,
     0x15 ,
     0x0c ,
     0x10 ,
     0x10 ,
     0x15 ,
     0x10 ,
     0x15 ,
     0x15 ,
     0x1b ,
     0x0c ,
     0x10 ,
     0x10 ,
     0x15 ,
     0x10 ,
     0x15 ,
     0x15 ,
     0x19 ,
     0x10 ,
     0x15 ,
     0x15 ,
     0x19 ,
     0x15 ,
     0x19 ,
     0x19 ,
     0x1f ,
     0x0c ,
     0x10 ,
     0x10 ,
     0x15 ,
     0x10 ,
     0x15 ,
     0x15 ,
     0x19 ,
     0x10 ,
     0x15 ,
     0x15 ,
     0x19 ,
     0x15 ,
     0x19 ,
     0x19 ,
     0x1f ,
     0x10 ,
     0x15 ,
     0x15 ,
     0x19 ,
     0x15 ,
     0x19 ,
     0x19 ,
     0x1d ,
     0x15 ,
     0x19 ,
     0x19 ,
     0x1d ,
     0x19 ,
     0x1d ,
     0x1f ,
     0x23 ,
     0x0c ,
     0x10 ,
     0x10 ,
     0x15 ,
     0x10 ,
     0x15 ,
     0x15 ,
     0x19 ,
     0x10 ,
     0x15 ,
     0x15 ,
     0x19 ,
     0x15 ,
     0x19 ,
     0x19 ,
     0x1f ,
     0x10 ,
     0x15 ,
     0x15 ,
     0x19 ,
     0x15 ,
     0x19 ,
     0x19 ,
     0x1d ,
     0x15 ,
     0x19 ,
     0x19 ,
     0x1d ,
     0x19 ,
     0x1d ,
     0x1d ,
     0x23 ,
     0x10 ,
     0x15 ,
     0x15 ,
     0x19 ,
     0x15 ,
     0x19 ,
     0x19 ,
     0x1d ,
     0x15 ,
     0x19 ,
     0x19 ,
     0x1d ,
     0x19 ,
     0x1d ,
     0x1d ,
     0x23 ,
     0x15 ,
     0x19 ,
     0x19 ,
     0x1d ,
     0x19 ,
     0x1d ,
     0x1d ,
     0x21 ,
     0x19 ,
     0x1d ,
     0x1d ,
     0x21 ,
     0x1f ,
     0x23 ,
     0x23 ,
     0x27 ,
     0x0c ,
     0x10 ,
     0x10 ,
     0x15 ,
     0x10 ,
     0x15 ,
     0x15 ,
     0x19 ,
     0x10 ,
     0x15 ,
     0x15 ,
     0x19 ,
     0x15 ,
     0x19 ,
     0x19 ,
     0x1f ,
     0x10 ,
     0x15 ,
     0x15 ,
     0x19 ,
     0x15 ,
     0x19 ,
     0x19 ,
     0x1d ,
     0x15 ,
     0x19 ,
     0x19 ,
     0x1d ,
     0x19 ,
     0x1d ,
     0x1d ,
     0x23 ,
     0x10 ,
     0x15 ,
     0x15 ,
     0x19 ,
     0x15 ,
     0x19 ,
     0x19 ,
     0x1d ,
     0x15 ,
     0x19 ,
     0x19 ,
     0x1d ,
     0x19 ,
     0x1d ,
     0x1d ,
     0x23 ,
     0x15 ,
     0x19 ,
     0x19 ,
     0x1d ,
     0x19 ,
     0x1d ,
     0x1d ,
     0x21 ,
     0x19 ,
     0x1d ,
     0x1d ,
     0x21 ,
     0x1d ,
     0x21 ,
     0x23 ,
     0x27 ,
     0x10 ,
     0x15 ,
     0x15 ,
     0x19 ,
     0x15 ,
     0x19 ,
     0x19 ,
     0x1d ,
     0x15 ,
     0x19 ,
     0x19 ,
     0x1d ,
     0x19 ,
     0x1d ,
     0x1d ,
     0x23 ,
     0x15 ,
     0x19 ,
     0x19 ,
     0x1d ,
     0x19 ,
     0x1d ,
     0x1d ,
     0x21 ,
     0x19 ,
     0x1d ,
     0x1d ,
     0x21 ,
     0x1d ,
     0x21 ,
     0x21 ,
     0x27 ,
     0x15 ,
     0x19 ,
     0x19 ,
     0x1d ,
     0x19 ,
     0x1d ,
     0x1d ,
     0x21 ,
     0x19 ,
     0x1d ,
     0x1d ,
     0x21 ,
     0x1d ,
     0x21 ,
     0x21 ,
     0x27 ,
     0x1b ,
     0x1f ,
     0x1f ,
     0x23 ,
     0x1f ,
     0x23 ,
     0x23 ,
     0x27 ,
     0x1f ,
     0x23 ,
     0x23 ,
     0x27 ,
     0x23 ,
     0x27 ,
     0x27 ,
     0x2b ,
     0x08 ,
     0x0c ,
     0x0c ,
     0x10 ,
     0x0c ,
     0x10 ,
     0x10 ,
     0x15 ,
     0x0c ,
     0x10 ,
     0x10 ,
     0x15 ,
     0x10 ,
     0x15 ,
     0x15 ,
     0x1b ,
     0x0c ,
     0x10 ,
     0x10 ,
     0x15 ,
     0x10 ,
     0x15 ,
     0x15 ,
     0x19 ,
     0x10 ,
     0x15 ,
     0x15 ,
     0x19 ,
     0x15 ,
     0x19 ,
     0x19 ,
     0x1f ,
     0x0c ,
     0x10 ,
     0x10 ,
     0x15 ,
     0x10 ,
     0x15 ,
     0x15 ,
     0x19 ,
     0x10 ,
     0x15 ,
     0x15 ,
     0x19 ,
     0x15 ,
     0x19 ,
     0x19 ,
     0x1f ,
     0x10 ,
     0x15 ,
     0x15 ,
     0x19 ,
     0x15 ,
     0x19 ,
     0x19 ,
     0x1d ,
     0x15 ,
     0x19 ,
     0x19 ,
     0x1d ,
     0x19 ,
     0x1d ,
     0x1f ,
     0x23 ,
     0x0c ,
     0x10 ,
     0x10 ,
     0x15 ,
     0x10 ,
     0x15 ,
     0x15 ,
     0x19 ,
     0x10 ,
     0x15 ,
     0x15 ,
     0x19 ,
     0x15 ,
     0x19 ,
     0x19 ,
     0x1f ,
     0x10 ,
     0x15 ,
     0x15 ,
     0x19 ,
     0x15 ,
     0x19 ,
     0x19 ,
     0x1d ,
     0x15 ,
     0x19 ,
     0x19 ,
     0x1d ,
     0x19 ,
     0x1d ,
     0x1d ,
     0x23 ,
     0x10 ,
     0x15 ,
     0x15 ,
     0x19 ,
     0x15 ,
     0x19 ,
     0x19 ,
     0x1d ,
     0x15 ,
     0x19 ,
     0x19 ,
     0x1d ,
     0x19 ,
     0x1d ,
     0x1d ,
     0x23 ,
     0x15 ,
     0x19 ,
     0x19 ,
     0x1d ,
     0x19 ,
     0x1d ,
     0x1d ,
     0x21 ,
     0x19 ,
     0x1d ,
     0x1d ,
     0x21 ,
     0x1f ,
     0x23 ,
     0x23 ,
     0x27 ,
     0x0c ,
     0x10 ,
     0x10 ,
     0x15 ,
     0x10 ,
     0x15 ,
     0x15 ,
     0x19 ,
     0x10 ,
     0x15 ,
     0x15 ,
     0x19 ,
     0x15 ,
     0x19 ,
     0x19 ,
     0x1f ,
     0x10 ,
     0x15 ,
     0x15 ,
     0x19 ,
     0x15 ,
     0x19 ,
     0x19 ,
     0x1d ,
     0x15 ,
     0x19 ,
     0x19 ,
     0x1d ,
     0x19 ,
     0x1d ,
     0x1d ,
     0x23 ,
     0x10 ,
     0x15 ,
     0x15 ,
     0x19 ,
     0x15 ,
     0x19 ,
     0x19 ,
     0x1d ,
     0x15 ,
     0x19 ,
     0x19 ,
     0x1d ,
     0x19 ,
     0x1d ,
     0x1d ,
     0x23 ,
     0x15 ,
     0x19 ,
     0x19 ,
     0x1d ,
     0x19 ,
     0x1d ,
     0x1d ,
     0x21 ,
     0x19 ,
     0x1d ,
     0x1d ,
     0x21 ,
     0x1d ,
     0x21 ,
     0x23 ,
     0x27 ,
     0x10 ,
     0x15 ,
     0x15 ,
     0x19 ,
     0x15 ,
     0x19 ,
     0x19 ,
     0x1d ,
     0x15 ,
     0x19 ,
     0x19 ,
     0x1d ,
     0x19 ,
     0x1d ,
     0x1d ,
     0x23 ,
     0x15 ,
     0x19 ,
     0x19 ,
     0x1d ,
     0x19 ,
     0x1d ,
     0x1d ,
     0x21 ,
     0x19 ,
     0x1d ,
     0x1d ,
     0x21 ,
     0x1d ,
     0x21 ,
     0x21 ,
     0x27 ,
     0x15 ,
     0x19 ,
     0x19 ,
     0x1d ,
     0x19 ,
     0x1d ,
     0x1d ,
     0x21 ,
     0x19 ,
     0x1d ,
     0x1d ,
     0x21 ,
     0x1d ,
     0x21 ,
     0x21 ,
     0x27 ,
     0x19 ,
     0x1d ,
     0x1d ,
     0x21 ,
     0x1d ,
     0x21 ,
     0x21 ,
     0x25 ,
     0x1f ,
     0x23 ,
     0x23 ,
     0x27 ,
     0x23 ,
     0x27 ,
     0x27 ,
     0x2b ,
     0x0c ,
     0x10 ,
     0x10 ,
     0x15 ,
     0x10 ,
     0x15 ,
     0x15 ,
     0x19 ,
     0x10 ,
     0x15 ,
     0x15 ,
     0x19 ,
     0x15 ,
     0x19 ,
     0x19 ,
     0x1f ,
     0x10 ,
     0x15 ,
     0x15 ,
     0x19 ,
     0x15 ,
     0x19 ,
     0x19 ,
     0x1d ,
     0x15 ,
     0x19 ,
     0x19 ,
     0x1d ,
     0x19 ,
     0x1d ,
     0x1d ,
     0x23 ,
     0x10 ,
     0x15 ,
     0x15 ,
     0x19 ,
     0x15 ,
     0x19 ,
     0x19 ,
     0x1d ,
     0x15 ,
     0x19 ,
     0x19 ,
     0x1d ,
     0x19 ,
     0x1d ,
     0x1d ,
     0x23 ,
     0x15 ,
     0x19 ,
     0x19 ,
     0x1d ,
     0x19 ,
     0x1d ,
     0x1d ,
     0x21 ,
     0x19 ,
     0x1d ,
     0x1d ,
     0x21 ,
     0x1d ,
     0x21 ,
     0x23 ,
     0x27 ,
     0x10 ,
     0x15 ,
     0x15 ,
     0x19 ,
     0x15 ,
     0x19 ,
     0x19 ,
     0x1d ,
     0x15 ,
     0x19 ,
     0x19 ,
     0x1d ,
     0x19 ,
     0x1d ,
     0x1d ,
     0x23 ,
     0x15 ,
     0x19 ,
     0x19 ,
     0x1d ,
     0x19 ,
     0x1d ,
     0x1d ,
     0x21 ,
     0x19 ,
     0x1d ,
     0x1d ,
     0x21 ,
     0x1d ,
     0x21 ,
     0x21 ,
     0x27 ,
     0x15 ,
     0x19 ,
     0x19 ,
     0x1d ,
     0x19 ,
     0x1d ,
     0x1d ,
     0x21 ,
     0x19 ,
     0x1d ,
     0x1d ,
     0x21 ,
     0x1d ,
     0x21 ,
     0x21 ,
     0x27 ,
     0x19 ,
     0x1d ,
     0x1d ,
     0x21 ,
     0x1d ,
     0x21 ,
     0x21 ,
     0x25 ,
     0x1d ,
     0x21 ,
     0x21 ,
     0x25 ,
     0x23 ,
     0x27 ,
     0x27 ,
     0x2b ,
     0x10 ,
     0x15 ,
     0x15 ,
     0x19 ,
     0x15 ,
     0x19 ,
     0x19 ,
     0x1d ,
     0x15 ,
     0x19 ,
     0x19 ,
     0x1d ,
     0x19 ,
     0x1d ,
     0x1d ,
     0x23 ,
     0x15 ,
     0x19 ,
     0x19 ,
     0x1d ,
     0x19 ,
     0x1d ,
     0x1d ,
     0x21 ,
     0x19 ,
     0x1d ,
     0x1d ,
     0x21 ,
     0x1d ,
     0x21 ,
     0x21 ,
     0x27 ,
     0x15 ,
     0x19 ,
     0x19 ,
     0x1d ,
     0x19 ,
     0x1d ,
     0x1d ,
     0x21 ,
     0x19 ,
     0x1d ,
     0x1d ,
     0x21 ,
     0x1d ,
     0x21 ,
     0x21 ,
     0x27 ,
     0x19 ,
     0x1d ,
     0x1d ,
     0x21 ,
     0x1d ,
     0x21 ,
     0x21 ,
     0x25 ,
     0x1d ,
     0x21 ,
     0x21 ,
     0x25 ,
     0x21 ,
     0x25 ,
     0x27 ,
     0x2b ,
     0x15 ,
     0x19 ,
     0x19 ,
     0x1d ,
     0x19 ,
     0x1d ,
     0x1d ,
     0x21 ,
     0x19 ,
     0x1d ,
     0x1d ,
     0x21 ,
     0x1d ,
     0x21 ,
     0x21 ,
     0x27 ,
     0x19 ,
     0x1d ,
     0x1d ,
     0x21 ,
     0x1d ,
     0x21 ,
     0x21 ,
     0x25 ,
     0x1d ,
     0x21 ,
     0x21 ,
     0x25 ,
     0x21 ,
     0x25 ,
     0x25 ,
     0x2b ,
     0x1b ,
     0x1f ,
     0x1f ,
     0x23 ,
     0x1f ,
     0x23 ,
     0x23 ,
     0x27 ,
     0x1f ,
     0x23 ,
     0x23 ,
     0x27 ,
     0x23 ,
     0x27 ,
     0x27 ,
     0x2b ,
     0x1f ,
     0x23 ,
     0x23 ,
     0x27 ,
     0x23 ,
     0x27 ,
     0x27 ,
     0x2b ,
     0x23 ,
     0x27 ,
     0x27 ,
     0x2b ,
     0x27 ,
     0x2b ,
     0x2b ,
     0x2f ,
     0x08 ,
     0x0c ,
     0x0c ,
     0x10 ,
     0x0c ,
     0x10 ,
     0x10 ,
     0x15 ,
     0x0c ,
     0x10 ,
     0x10 ,
     0x15 ,
     0x10 ,
     0x15 ,
     0x15 ,
     0x1b ,
     0x0c ,
     0x10 ,
     0x10 ,
     0x15 ,
     0x10 ,
     0x15 ,
     0x15 ,
     0x19 ,
     0x10 ,
     0x15 ,
     0x15 ,
     0x19 ,
     0x15 ,
     0x19 ,
     0x19 ,
     0x1f ,
     0x0c ,
     0x10 ,
     0x10 ,
     0x15 ,
     0x10 ,
     0x15 ,
     0x15 ,
     0x19 ,
     0x10 ,
     0x15 ,
     0x15 ,
     0x19 ,
     0x15 ,
     0x19 ,
     0x19 ,
     0x1f ,
     0x10 ,
     0x15 ,
     0x15 ,
     0x19 ,
     0x15 ,
     0x19 ,
     0x19 ,
     0x1d ,
     0x15 ,
     0x19 ,
     0x19 ,
     0x1d ,
     0x19 ,
     0x1d ,
     0x1f ,
     0x23 ,
     0x0c ,
     0x10 ,
     0x10 ,
     0x15 ,
     0x10 ,
     0x15 ,
     0x15 ,
     0x19 ,
     0x10 ,
     0x15 ,
     0x15 ,
     0x19 ,
     0x15 ,
     0x19 ,
     0x19 ,
     0x1f ,
     0x10 ,
     0x15 ,
     0x15 ,
     0x19 ,
     0x15 ,
     0x19 ,
     0x19 ,
     0x1d ,
     0x15 ,
     0x19 ,
     0x19 ,
     0x1d ,
     0x19 ,
     0x1d ,
     0x1d ,
     0x23 ,
     0x10 ,
     0x15 ,
     0x15 ,
     0x19 ,
     0x15 ,
     0x19 ,
     0x19 ,
     0x1d ,
     0x15 ,
     0x19 ,
     0x19 ,
     0x1d ,
     0x19 ,
     0x1d ,
     0x1d ,
     0x23 ,
     0x15 ,
     0x19 ,
     0x19 ,
     0x1d ,
     0x19 ,
     0x1d ,
     0x1d ,
     0x21 ,
     0x19 ,
     0x1d ,
     0x1d ,
     0x21 ,
     0x1f ,
     0x23 ,
     0x23 ,
     0x27 ,
     0x0c ,
     0x10 ,
     0x10 ,
     0x15 ,
     0x10 ,
     0x15 ,
     0x15 ,
     0x19 ,
     0x10 ,
     0x15 ,
     0x15 ,
     0x19 ,
     0x15 ,
     0x19 ,
     0x19 ,
     0x1f ,
     0x10 ,
     0x15 ,
     0x15 ,
     0x19 ,
     0x15 ,
     0x19 ,
     0x19 ,
     0x1d ,
     0x15 ,
     0x19 ,
     0x19 ,
     0x1d ,
     0x19 ,
     0x1d ,
     0x1d ,
     0x23 ,
     0x10 ,
     0x15 ,
     0x15 ,
     0x19 ,
     0x15 ,
     0x19 ,
     0x19 ,
     0x1d ,
     0x15 ,
     0x19 ,
     0x19 ,
     0x1d ,
     0x19 ,
     0x1d ,
     0x1d ,
     0x23 ,
     0x15 ,
     0x19 ,
     0x19 ,
     0x1d ,
     0x19 ,
     0x1d ,
     0x1d ,
     0x21 ,
     0x19 ,
     0x1d ,
     0x1d ,
     0x21 ,
     0x1d ,
     0x21 ,
     0x23 ,
     0x27 ,
     0x10 ,
     0x15 ,
     0x15 ,
     0x19 ,
     0x15 ,
     0x19 ,
     0x19 ,
     0x1d ,
     0x15 ,
     0x19 ,
     0x19 ,
     0x1d ,
     0x19 ,
     0x1d ,
     0x1d ,
     0x23 ,
     0x15 ,
     0x19 ,
     0x19 ,
     0x1d ,
     0x19 ,
     0x1d ,
     0x1d ,
     0x21 ,
     0x19 ,
     0x1d ,
     0x1d ,
     0x21 ,
     0x1d ,
     0x21 ,
     0x21 ,
     0x27 ,
     0x15 ,
     0x19 ,
     0x19 ,
     0x1d ,
     0x19 ,
     0x1d ,
     0x1d ,
     0x21 ,
     0x19 ,
     0x1d ,
     0x1d ,
     0x21 ,
     0x1d ,
     0x21 ,
     0x21 ,
     0x27 ,
     0x19 ,
     0x1d ,
     0x1d ,
     0x21 ,
     0x1d ,
     0x21 ,
     0x21 ,
     0x25 ,
     0x1f ,
     0x23 ,
     0x23 ,
     0x27 ,
     0x23 ,
     0x27 ,
     0x27 ,
     0x2b ,
     0x0c ,
     0x10 ,
     0x10 ,
     0x15 ,
     0x10 ,
     0x15 ,
     0x15 ,
     0x19 ,
     0x10 ,
     0x15 ,
     0x15 ,
     0x19 ,
     0x15 ,
     0x19 ,
     0x19 ,
     0x1f ,
     0x10 ,
     0x15 ,
     0x15 ,
     0x19 ,
     0x15 ,
     0x19 ,
     0x19 ,
     0x1d ,
     0x15 ,
     0x19 ,
     0x19 ,
     0x1d ,
     0x19 ,
     0x1d ,
     0x1d ,
     0x23 ,
     0x10 ,
     0x15 ,
     0x15 ,
     0x19 ,
     0x15 ,
     0x19 ,
     0x19 ,
     0x1d ,
     0x15 ,
     0x19 ,
     0x19 ,
     0x1d ,
     0x19 ,
     0x1d ,
     0x1d ,
     0x23 ,
     0x15 ,
     0x19 ,
     0x19 ,
     0x1d ,
     0x19 ,
     0x1d ,
     0x1d ,
     0x21 ,
     0x19 ,
     0x1d ,
     0x1d ,
     0x21 ,
     0x1d ,
     0x21 ,
     0x23 ,
     0x27 ,
     0x10 ,
     0x15 ,
     0x15 ,
     0x19 ,
     0x15 ,
     0x19 ,
     0x19 ,
     0x1d ,
     0x15 ,
     0x19 ,
     0x19 ,
     0x1d ,
     0x19 ,
     0x1d ,
     0x1d ,
     0x23 ,
     0x15 ,
     0x19 ,
     0x19 ,
     0x1d ,
     0x19 ,
     0x1d ,
     0x1d ,
     0x21 ,
     0x19 ,
     0x1d ,
     0x1d ,
     0x21 ,
     0x1d ,
     0x21 ,
     0x21 ,
     0x27 ,
     0x15 ,
     0x19 ,
     0x19 ,
     0x1d ,
     0x19 ,
     0x1d ,
     0x1d ,
     0x21 ,
     0x19 ,
     0x1d ,
     0x1d ,
     0x21 ,
     0x1d ,
     0x21 ,
     0x21 ,
     0x27 ,
     0x19 ,
     0x1d ,
     0x1d ,
     0x21 ,
     0x1d ,
     0x21 ,
     0x21 ,
     0x25 ,
     0x1d ,
     0x21 ,
     0x21 ,
     0x25 ,
     0x23 ,
     0x27 ,
     0x27 ,
     0x2b ,
     0x10 ,
     0x15 ,
     0x15 ,
     0x19 ,
     0x15 ,
     0x19 ,
     0x19 ,
     0x1d ,
     0x15 ,
     0x19 ,
     0x19 ,
     0x1d ,
     0x19 ,
     0x1d ,
     0x1d ,
     0x23 ,
     0x15 ,
     0x19 ,
     0x19 ,
     0x1d ,
     0x19 ,
     0x1d ,
     0x1d ,
     0x21 ,
     0x19 ,
     0x1d ,
     0x1d ,
     0x21 ,
     0x1d ,
     0x21 ,
     0x21 ,
     0x27 ,
     0x15 ,
     0x19 ,
     0x19 ,
     0x1d ,
     0x19 ,
     0x1d ,
     0x1d ,
     0x21 ,
     0x19 ,
     0x1d ,
     0x1d ,
     0x21 ,
     0x1d ,
     0x21 ,
     0x21 ,
     0x27 ,
     0x19 ,
     0x1d ,
     0x1d ,
     0x21 ,
     0x1d ,
     0x21 ,
     0x21 ,
     0x25 ,
     0x1d ,
     0x21 ,
     0x21 ,
     0x25 ,
     0x21 ,
     0x25 ,
     0x27 ,
     0x2b ,
     0x15 ,
     0x19 ,
     0x19 ,
     0x1d ,
     0x19 ,
     0x1d ,
     0x1d ,
     0x21 ,
     0x19 ,
     0x1d ,
     0x1d ,
     0x21 ,
     0x1d ,
     0x21 ,
     0x21 ,
     0x27 ,
     0x19 ,
     0x1d ,
     0x1d ,
     0x21 ,
     0x1d ,
     0x21 ,
     0x21 ,
     0x25 ,
     0x1d ,
     0x21 ,
     0x21 ,
     0x25 ,
     0x21 ,
     0x25 ,
     0x25 ,
     0x2b ,
     0x19 ,
     0x1d ,
     0x1d ,
     0x21 ,
     0x1d ,
     0x21 ,
     0x21 ,
     0x25 ,
     0x1d ,
     0x21 ,
     0x21 ,
     0x25 ,
     0x21 ,
     0x25 ,
     0x25 ,
     0x2b ,
     0x1f ,
     0x23 ,
     0x23 ,
     0x27 ,
     0x23 ,
     0x27 ,
     0x27 ,
     0x2b ,
     0x23 ,
     0x27 ,
     0x27 ,
     0x2b ,
     0x27 ,
     0x2b ,
     0x2b ,
     0x2f ,
     0x0c ,
     0x10 ,
     0x10 ,
     0x15 ,
     0x10 ,
     0x15 ,
     0x15 ,
     0x19 ,
     0x10 ,
     0x15 ,
     0x15 ,
     0x19 ,
     0x15 ,
     0x19 ,
     0x19 ,
     0x1f ,
     0x10 ,
     0x15 ,
     0x15 ,
     0x19 ,
     0x15 ,
     0x19 ,
     0x19 ,
     0x1d ,
     0x15 ,
     0x19 ,
     0x19 ,
     0x1d ,
     0x19 ,
     0x1d ,
     0x1d ,
     0x23 ,
     0x10 ,
     0x15 ,
     0x15 ,
     0x19 ,
     0x15 ,
     0x19 ,
     0x19 ,
     0x1d ,
     0x15 ,
     0x19 ,
     0x19 ,
     0x1d ,
     0x19 ,
     0x1d ,
     0x1d ,
     0x23 ,
     0x15 ,
     0x19 ,
     0x19 ,
     0x1d ,
     0x19 ,
     0x1d ,
     0x1d ,
     0x21 ,
     0x19 ,
     0x1d ,
     0x1d ,
     0x21 ,
     0x1d ,
     0x21 ,
     0x23 ,
     0x27 ,
     0x10 ,
     0x15 ,
     0x15 ,
     0x19 ,
     0x15 ,
     0x19 ,
     0x19 ,
     0x1d ,
     0x15 ,
     0x19 ,
     0x19 ,
     0x1d ,
     0x19 ,
     0x1d ,
     0x1d ,
     0x23 ,
     0x15 ,
     0x19 ,
     0x19 ,
     0x1d ,
     0x19 ,
     0x1d ,
     0x1d ,
     0x21 ,
     0x19 ,
     0x1d ,
     0x1d ,
     0x21 ,
     0x1d ,
     0x21 ,
     0x21 ,
     0x27 ,
     0x15 ,
     0x19 ,
     0x19 ,
     0x1d ,
     0x19 ,
     0x1d ,
     0x1d ,
     0x21 ,
     0x19 ,
     0x1d ,
     0x1d ,
     0x21 ,
     0x1d ,
     0x21 ,
     0x21 ,
     0x27 ,
     0x19 ,
     0x1d ,
     0x1d ,
     0x21 ,
     0x1d ,
     0x21 ,
     0x21 ,
     0x25 ,
     0x1d ,
     0x21 ,
     0x21 ,
     0x25 ,
     0x23 ,
     0x27 ,
     0x27 ,
     0x2b ,
     0x10 ,
     0x15 ,
     0x15 ,
     0x19 ,
     0x15 ,
     0x19 ,
     0x19 ,
     0x1d ,
     0x15 ,
     0x19 ,
     0x19 ,
     0x1d ,
     0x19 ,
     0x1d ,
     0x1d ,
     0x23 ,
     0x15 ,
     0x19 ,
     0x19 ,
     0x1d ,
     0x19 ,
     0x1d ,
     0x1d ,
     0x21 ,
     0x19 ,
     0x1d ,
     0x1d ,
     0x21 ,
     0x1d ,
     0x21 ,
     0x21 ,
     0x27 ,
     0x15 ,
     0x19 ,
     0x19 ,
     0x1d ,
     0x19 ,
     0x1d ,
     0x1d ,
     0x21 ,
     0x19 ,
     0x1d ,
     0x1d ,
     0x21 ,
     0x1d ,
     0x21 ,
     0x21 ,
     0x27 ,
     0x19 ,
     0x1d ,
     0x1d ,
     0x21 ,
     0x1d ,
     0x21 ,
     0x21 ,
     0x25 ,
     0x1d ,
     0x21 ,
     0x21 ,
     0x25 ,
     0x21 ,
     0x25 ,
     0x27 ,
     0x2b ,
     0x15 ,
     0x19 ,
     0x19 ,
     0x1d ,
     0x19 ,
     0x1d ,
     0x1d ,
     0x21 ,
     0x19 ,
     0x1d ,
     0x1d ,
     0x21 ,
     0x1d ,
     0x21 ,
     0x21 ,
     0x27 ,
     0x19 ,
     0x1d ,
     0x1d ,
     0x21 ,
     0x1d ,
     0x21 ,
     0x21 ,
     0x25 ,
     0x1d ,
     0x21 ,
     0x21 ,
     0x25 ,
     0x21 ,
     0x25 ,
     0x25 ,
     0x2b ,
     0x19 ,
     0x1d ,
     0x1d ,
     0x21 ,
     0x1d ,
     0x21 ,
     0x21 ,
     0x25 ,
     0x1d ,
     0x21 ,
     0x21 ,
     0x25 ,
     0x21 ,
     0x25 ,
     0x25 ,
     0x2b ,
     0x1d ,
     0x21 ,
     0x21 ,
     0x25 ,
     0x21 ,
     0x25 ,
     0x25 ,
     0x29 ,
     0x23 ,
     0x27 ,
     0x27 ,
     0x2b ,
     0x27 ,
     0x2b ,
     0x2b ,
     0x2f ,
     0x10 ,
     0x15 ,
     0x15 ,
     0x19 ,
     0x15 ,
     0x19 ,
     0x19 ,
     0x1d ,
     0x15 ,
     0x19 ,
     0x19 ,
     0x1d ,
     0x19 ,
     0x1d ,
     0x1d ,
     0x23 ,
     0x15 ,
     0x19 ,
     0x19 ,
     0x1d ,
     0x19 ,
     0x1d ,
     0x1d ,
     0x21 ,
     0x19 ,
     0x1d ,
     0x1d ,
     0x21 ,
     0x1d ,
     0x21 ,
     0x21 ,
     0x27 ,
     0x15 ,
     0x19 ,
     0x19 ,
     0x1d ,
     0x19 ,
     0x1d ,
     0x1d ,
     0x21 ,
     0x19 ,
     0x1d ,
     0x1d ,
     0x21 ,
     0x1d ,
     0x21 ,
     0x21 ,
     0x27 ,
     0x19 ,
     0x1d ,
     0x1d ,
     0x21 ,
     0x1d ,
     0x21 ,
     0x21 ,
     0x25 ,
     0x1d ,
     0x21 ,
     0x21 ,
     0x25 ,
     0x21 ,
     0x25 ,
     0x27 ,
     0x2b ,
     0x15 ,
     0x19 ,
     0x19 ,
     0x1d ,
     0x19 ,
     0x1d ,
     0x1d ,
     0x21 ,
     0x19 ,
     0x1d ,
     0x1d ,
     0x21 ,
     0x1d ,
     0x21 ,
     0x21 ,
     0x27 ,
     0x19 ,
     0x1d ,
     0x1d ,
     0x21 ,
     0x1d ,
     0x21 ,
     0x21 ,
     0x25 ,
     0x1d ,
     0x21 ,
     0x21 ,
     0x25 ,
     0x21 ,
     0x25 ,
     0x25 ,
     0x2b ,
     0x19 ,
     0x1d ,
     0x1d ,
     0x21 ,
     0x1d ,
     0x21 ,
     0x21 ,
     0x25 ,
     0x1d ,
     0x21 ,
     0x21 ,
     0x25 ,
     0x21 ,
     0x25 ,
     0x25 ,
     0x2b ,
     0x1d ,
     0x21 ,
     0x21 ,
     0x25 ,
     0x21 ,
     0x25 ,
     0x25 ,
     0x29 ,
     0x21 ,
     0x25 ,
     0x25 ,
     0x29 ,
     0x27 ,
     0x2b ,
     0x2b ,
     0x2f ,
     0x15 ,
     0x19 ,
     0x19 ,
     0x1d ,
     0x19 ,
     0x1d ,
     0x1d ,
     0x21 ,
     0x19 ,
     0x1d ,
     0x1d ,
     0x21 ,
     0x1d ,
     0x21 ,
     0x21 ,
     0x27 ,
     0x19 ,
     0x1d ,
     0x1d ,
     0x21 ,
     0x1d ,
     0x21 ,
     0x21 ,
     0x25 ,
     0x1d ,
     0x21 ,
     0x21 ,
     0x25 ,
     0x21 ,
     0x25 ,
     0x25 ,
     0x2b ,
     0x19 ,
     0x1d ,
     0x1d ,
     0x21 ,
     0x1d ,
     0x21 ,
     0x21 ,
     0x25 ,
     0x1d ,
     0x21 ,
     0x21 ,
     0x25 ,
     0x21 ,
     0x25 ,
     0x25 ,
     0x2b ,
     0x1d ,
     0x21 ,
     0x21 ,
     0x25 ,
     0x21 ,
     0x25 ,
     0x25 ,
     0x29 ,
     0x21 ,
     0x25 ,
     0x25 ,
     0x29 ,
     0x25 ,
     0x29 ,
     0x2b ,
     0x2f ,
     0x1b ,
     0x1f ,
     0x1f ,
     0x23 ,
     0x1f ,
     0x23 ,
     0x23 ,
     0x27 ,
     0x1f ,
     0x23 ,
     0x23 ,
     0x27 ,
     0x23 ,
     0x27 ,
     0x27 ,
     0x2b ,
     0x1f ,
     0x23 ,
     0x23 ,
     0x27 ,
     0x23 ,
     0x27 ,
     0x27 ,
     0x2b ,
     0x23 ,
     0x27 ,
     0x27 ,
     0x2b ,
     0x27 ,
     0x2b ,
     0x2b ,
     0x2f ,
     0x1f ,
     0x23 ,
     0x23 ,
     0x27 ,
     0x23 ,
     0x27 ,
     0x27 ,
     0x2b ,
     0x23 ,
     0x27 ,
     0x27 ,
     0x2b ,
     0x27 ,
     0x2b ,
     0x2b ,
     0x2f ,
     0x23 ,
     0x27 ,
     0x27 ,
     0x2b ,
     0x27 ,
     0x2b ,
     0x2b ,
     0x2f ,
     0x27 ,
     0x2b ,
     0x2b ,
     0x2f ,
     0x2b ,
     0x2f ,
     0x2f ,
     0x33 ,
     0x08 ,
     0x0c ,
     0x0c ,
     0x10 ,
     0x0c ,
     0x10 ,
     0x10 ,
     0x15 ,
     0x0c ,
     0x10 ,
     0x10 ,
     0x15 ,
     0x10 ,
     0x15 ,
     0x15 ,
     0x1b ,
     0x0c ,
     0x10 ,
     0x10 ,
     0x15 ,
     0x10 ,
     0x15 ,
     0x15 ,
     0x19 ,
     0x10 ,
     0x15 ,
     0x15 ,
     0x19 ,
     0x15 ,
     0x19 ,
     0x19 ,
     0x1f ,
     0x0c ,
     0x10 ,
     0x10 ,
     0x15 ,
     0x10 ,
     0x15 ,
     0x15 ,
     0x19 ,
     0x10 ,
     0x15 ,
     0x15 ,
     0x19 ,
     0x15 ,
     0x19 ,
     0x19 ,
     0x1f ,
     0x10 ,
     0x15 ,
     0x15 ,
     0x19 ,
     0x15 ,
     0x19 ,
     0x19 ,
     0x1d ,
     0x15 ,
     0x19 ,
     0x19 ,
     0x1d ,
     0x19 ,
     0x1d ,
     0x1f ,
     0x23 ,
     0x0c ,
     0x10 ,
     0x10 ,
     0x15 ,
     0x10 ,
     0x15 ,
     0x15 ,
     0x19 ,
     0x10 ,
     0x15 ,
     0x15 ,
     0x19 ,
     0x15 ,
     0x19 ,
     0x19 ,
     0x1f ,
     0x10 ,
     0x15 ,
     0x15 ,
     0x19 ,
     0x15 ,
     0x19 ,
     0x19 ,
     0x1d ,
     0x15 ,
     0x19 ,
     0x19 ,
     0x1d ,
     0x19 ,
     0x1d ,
     0x1d ,
     0x23 ,
     0x10 ,
     0x15 ,
     0x15 ,
     0x19 ,
     0x15 ,
     0x19 ,
     0x19 ,
     0x1d ,
     0x15 ,
     0x19 ,
     0x19 ,
     0x1d ,
     0x19 ,
     0x1d ,
     0x1d ,
     0x23 ,
     0x15 ,
     0x19 ,
     0x19 ,
     0x1d ,
     0x19 ,
     0x1d ,
     0x1d ,
     0x21 ,
     0x19 ,
     0x1d ,
     0x1d ,
     0x21 ,
     0x1f ,
     0x23 ,
     0x23 ,
     0x27 ,
     0x0c ,
     0x10 ,
     0x10 ,
     0x15 ,
     0x10 ,
     0x15 ,
     0x15 ,
     0x19 ,
     0x10 ,
     0x15 ,
     0x15 ,
     0x19 ,
     0x15 ,
     0x19 ,
     0x19 ,
     0x1f ,
     0x10 ,
     0x15 ,
     0x15 ,
     0x19 ,
     0x15 ,
     0x19 ,
     0x19 ,
     0x1d ,
     0x15 ,
     0x19 ,
     0x19 ,
     0x1d ,
     0x19 ,
     0x1d ,
     0x1d ,
     0x23 ,
     0x10 ,
     0x15 ,
     0x15 ,
     0x19 ,
     0x15 ,
     0x19 ,
     0x19 ,
     0x1d ,
     0x15 ,
     0x19 ,
     0x19 ,
     0x1d ,
     0x19 ,
     0x1d ,
     0x1d ,
     0x23 ,
     0x15 ,
     0x19 ,
     0x19 ,
     0x1d ,
     0x19 ,
     0x1d ,
     0x1d ,
     0x21 ,
     0x19 ,
     0x1d ,
     0x1d ,
     0x21 ,
     0x1d ,
     0x21 ,
     0x23 ,
     0x27 ,
     0x10 ,
     0x15 ,
     0x15 ,
     0x19 ,
     0x15 ,
     0x19 ,
     0x19 ,
     0x1d ,
     0x15 ,
     0x19 ,
     0x19 ,
     0x1d ,
     0x19 ,
     0x1d ,
     0x1d ,
     0x23 ,
     0x15 ,
     0x19 ,
     0x19 ,
     0x1d ,
     0x19 ,
     0x1d ,
     0x1d ,
     0x21 ,
     0x19 ,
     0x1d ,
     0x1d ,
     0x21 ,
     0x1d ,
     0x21 ,
     0x21 ,
     0x27 ,
     0x15 ,
     0x19 ,
     0x19 ,
     0x1d ,
     0x19 ,
     0x1d ,
     0x1d ,
     0x21 ,
     0x19 ,
     0x1d ,
     0x1d ,
     0x21 ,
     0x1d ,
     0x21 ,
     0x21 ,
     0x27 ,
     0x19 ,
     0x1d ,
     0x1d ,
     0x21 ,
     0x1d ,
     0x21 ,
     0x21 ,
     0x25 ,
     0x1f ,
     0x23 ,
     0x23 ,
     0x27 ,
     0x23 ,
     0x27 ,
     0x27 ,
     0x2b ,
     0x0c ,
     0x10 ,
     0x10 ,
     0x15 ,
     0x10 ,
     0x15 ,
     0x15 ,
     0x19 ,
     0x10 ,
     0x15 ,
     0x15 ,
     0x19 ,
     0x15 ,
     0x19 ,
     0x19 ,
     0x1f ,
     0x10 ,
     0x15 ,
     0x15 ,
     0x19 ,
     0x15 ,
     0x19 ,
     0x19 ,
     0x1d ,
     0x15 ,
     0x19 ,
     0x19 ,
     0x1d ,
     0x19 ,
     0x1d ,
     0x1d ,
     0x23 ,
     0x10 ,
     0x15 ,
     0x15 ,
     0x19 ,
     0x15 ,
     0x19 ,
     0x19 ,
     0x1d ,
     0x15 ,
     0x19 ,
     0x19 ,
     0x1d ,
     0x19 ,
     0x1d ,
     0x1d ,
     0x23 ,
     0x15 ,
     0x19 ,
     0x19 ,
     0x1d ,
     0x19 ,
     0x1d ,
     0x1d ,
     0x21 ,
     0x19 ,
     0x1d ,
     0x1d ,
     0x21 ,
     0x1d ,
     0x21 ,
     0x23 ,
     0x27 ,
     0x10 ,
     0x15 ,
     0x15 ,
     0x19 ,
     0x15 ,
     0x19 ,
     0x19 ,
     0x1d ,
     0x15 ,
     0x19 ,
     0x19 ,
     0x1d ,
     0x19 ,
     0x1d ,
     0x1d ,
     0x23 ,
     0x15 ,
     0x19 ,
     0x19 ,
     0x1d ,
     0x19 ,
     0x1d ,
     0x1d ,
     0x21 ,
     0x19 ,
     0x1d ,
     0x1d ,
     0x21 ,
     0x1d ,
     0x21 ,
     0x21 ,
     0x27 ,
     0x15 ,
     0x19 ,
     0x19 ,
     0x1d ,
     0x19 ,
     0x1d ,
     0x1d ,
     0x21 ,
     0x19 ,
     0x1d ,
     0x1d ,
     0x21 ,
     0x1d ,
     0x21 ,
     0x21 ,
     0x27 ,
     0x19 ,
     0x1d ,
     0x1d ,
     0x21 ,
     0x1d ,
     0x21 ,
     0x21 ,
     0x25 ,
     0x1d ,
     0x21 ,
     0x21 ,
     0x25 ,
     0x23 ,
     0x27 ,
     0x27 ,
     0x2b ,
     0x10 ,
     0x15 ,
     0x15 ,
     0x19 ,
     0x15 ,
     0x19 ,
     0x19 ,
     0x1d ,
     0x15 ,
     0x19 ,
     0x19 ,
     0x1d ,
     0x19 ,
     0x1d ,
     0x1d ,
     0x23 ,
     0x15 ,
     0x19 ,
     0x19 ,
     0x1d ,
     0x19 ,
     0x1d ,
     0x1d ,
     0x21 ,
     0x19 ,
     0x1d ,
     0x1d ,
     0x21 ,
     0x1d ,
     0x21 ,
     0x21 ,
     0x27 ,
     0x15 ,
     0x19 ,
     0x19 ,
     0x1d ,
     0x19 ,
     0x1d ,
     0x1d ,
     0x21 ,
     0x19 ,
     0x1d ,
     0x1d ,
     0x21 ,
     0x1d ,
     0x21 ,
     0x21 ,
     0x27 ,
     0x19 ,
     0x1d ,
     0x1d ,
     0x21 ,
     0x1d ,
     0x21 ,
     0x21 ,
     0x25 ,
     0x1d ,
     0x21 ,
     0x21 ,
     0x25 ,
     0x21 ,
     0x25 ,
     0x27 ,
     0x2b ,
     0x15 ,
     0x19 ,
     0x19 ,
     0x1d ,
     0x19 ,
     0x1d ,
     0x1d ,
     0x21 ,
     0x19 ,
     0x1d ,
     0x1d ,
     0x21 ,
     0x1d ,
     0x21 ,
     0x21 ,
     0x27 ,
     0x19 ,
     0x1d ,
     0x1d ,
     0x21 ,
     0x1d ,
     0x21 ,
     0x21 ,
     0x25 ,
     0x1d ,
     0x21 ,
     0x21 ,
     0x25 ,
     0x21 ,
     0x25 ,
     0x25 ,
     0x2b ,
     0x19 ,
     0x1d ,
     0x1d ,
     0x21 ,
     0x1d ,
     0x21 ,
     0x21 ,
     0x25 ,
     0x1d ,
     0x21 ,
     0x21 ,
     0x25 ,
     0x21 ,
     0x25 ,
     0x25 ,
     0x2b ,
     0x1f ,
     0x23 ,
     0x23 ,
     0x27 ,
     0x23 ,
     0x27 ,
     0x27 ,
     0x2b ,
     0x23 ,
     0x27 ,
     0x27 ,
     0x2b ,
     0x27 ,
     0x2b ,
     0x2b ,
     0x2f ,
     0x0c ,
     0x10 ,
     0x10 ,
     0x15 ,
     0x10 ,
     0x15 ,
     0x15 ,
     0x19 ,
     0x10 ,
     0x15 ,
     0x15 ,
     0x19 ,
     0x15 ,
     0x19 ,
     0x19 ,
     0x1f ,
     0x10 ,
     0x15 ,
     0x15 ,
     0x19 ,
     0x15 ,
     0x19 ,
     0x19 ,
     0x1d ,
     0x15 ,
     0x19 ,
     0x19 ,
     0x1d ,
     0x19 ,
     0x1d ,
     0x1d ,
     0x23 ,
     0x10 ,
     0x15 ,
     0x15 ,
     0x19 ,
     0x15 ,
     0x19 ,
     0x19 ,
     0x1d ,
     0x15 ,
     0x19 ,
     0x19 ,
     0x1d ,
     0x19 ,
     0x1d ,
     0x1d ,
     0x23 ,
     0x15 ,
     0x19 ,
     0x19 ,
     0x1d ,
     0x19 ,
     0x1d ,
     0x1d ,
     0x21 ,
     0x19 ,
     0x1d ,
     0x1d ,
     0x21 ,
     0x1d ,
     0x21 ,
     0x23 ,
     0x27 ,
     0x10 ,
     0x15 ,
     0x15 ,
     0x19 ,
     0x15 ,
     0x19 ,
     0x19 ,
     0x1d ,
     0x15 ,
     0x19 ,
     0x19 ,
     0x1d ,
     0x19 ,
     0x1d ,
     0x1d ,
     0x23 ,
     0x15 ,
     0x19 ,
     0x19 ,
     0x1d ,
     0x19 ,
     0x1d ,
     0x1d ,
     0x21 ,
     0x19 ,
     0x1d ,
     0x1d ,
     0x21 ,
     0x1d ,
     0x21 ,
     0x21 ,
     0x27 ,
     0x15 ,
     0x19 ,
     0x19 ,
     0x1d ,
     0x19 ,
     0x1d ,
     0x1d ,
     0x21 ,
     0x19 ,
     0x1d ,
     0x1d ,
     0x21 ,
     0x1d ,
     0x21 ,
     0x21 ,
     0x27 ,
     0x19 ,
     0x1d ,
     0x1d ,
     0x21 ,
     0x1d ,
     0x21 ,
     0x21 ,
     0x25 ,
     0x1d ,
     0x21 ,
     0x21 ,
     0x25 ,
     0x23 ,
     0x27 ,
     0x27 ,
     0x2b ,
     0x10 ,
     0x15 ,
     0x15 ,
     0x19 ,
     0x15 ,
     0x19 ,
     0x19 ,
     0x1d ,
     0x15 ,
     0x19 ,
     0x19 ,
     0x1d ,
     0x19 ,
     0x1d ,
     0x1d ,
     0x23 ,
     0x15 ,
     0x19 ,
     0x19 ,
     0x1d ,
     0x19 ,
     0x1d ,
     0x1d ,
     0x21 ,
     0x19 ,
     0x1d ,
     0x1d ,
     0x21 ,
     0x1d ,
     0x21 ,
     0x21 ,
     0x27 ,
     0x15 ,
     0x19 ,
     0x19 ,
     0x1d ,
     0x19 ,
     0x1d ,
     0x1d ,
     0x21 ,
     0x19 ,
     0x1d ,
     0x1d ,
     0x21 ,
     0x1d ,
     0x21 ,
     0x21 ,
     0x27 ,
     0x19 ,
     0x1d ,
     0x1d ,
     0x21 ,
     0x1d ,
     0x21 ,
     0x21 ,
     0x25 ,
     0x1d ,
     0x21 ,
     0x21 ,
     0x25 ,
     0x21 ,
     0x25 ,
     0x27 ,
     0x2b ,
     0x15 ,
     0x19 ,
     0x19 ,
     0x1d ,
     0x19 ,
     0x1d ,
     0x1d ,
     0x21 ,
     0x19 ,
     0x1d ,
     0x1d ,
     0x21 ,
     0x1d ,
     0x21 ,
     0x21 ,
     0x27 ,
     0x19 ,
     0x1d ,
     0x1d ,
     0x21 ,
     0x1d ,
     0x21 ,
     0x21 ,
     0x25 ,
     0x1d ,
     0x21 ,
     0x21 ,
     0x25 ,
     0x21 ,
     0x25 ,
     0x25 ,
     0x2b ,
     0x19 ,
     0x1d ,
     0x1d ,
     0x21 ,
     0x1d ,
     0x21 ,
     0x21 ,
     0x25 ,
     0x1d ,
     0x21 ,
     0x21 ,
     0x25 ,
     0x21 ,
     0x25 ,
     0x25 ,
     0x2b ,
     0x1d ,
     0x21 ,
     0x21 ,
     0x25 ,
     0x21 ,
     0x25 ,
     0x25 ,
     0x29 ,
     0x23 ,
     0x27 ,
     0x27 ,
     0x2b ,
     0x27 ,
     0x2b ,
     0x2b ,
     0x2f ,
     0x10 ,
     0x15 ,
     0x15 ,
     0x19 ,
     0x15 ,
     0x19 ,
     0x19 ,
     0x1d ,
     0x15 ,
     0x19 ,
     0x19 ,
     0x1d ,
     0x19 ,
     0x1d ,
     0x1d ,
     0x23 ,
     0x15 ,
     0x19 ,
     0x19 ,
     0x1d ,
     0x19 ,
     0x1d ,
     0x1d ,
     0x21 ,
     0x19 ,
     0x1d ,
     0x1d ,
     0x21 ,
     0x1d ,
     0x21 ,
     0x21 ,
     0x27 ,
     0x15 ,
     0x19 ,
     0x19 ,
     0x1d ,
     0x19 ,
     0x1d ,
     0x1d ,
     0x21 ,
     0x19 ,
     0x1d ,
     0x1d ,
     0x21 ,
     0x1d ,
     0x21 ,
     0x21 ,
     0x27 ,
     0x19 ,
     0x1d ,
     0x1d ,
     0x21 ,
     0x1d ,
     0x21 ,
     0x21 ,
     0x25 ,
     0x1d ,
     0x21 ,
     0x21 ,
     0x25 ,
     0x21 ,
     0x25 ,
     0x27 ,
     0x2b ,
     0x15 ,
     0x19 ,
     0x19 ,
     0x1d ,
     0x19 ,
     0x1d ,
     0x1d ,
     0x21 ,
     0x19 ,
     0x1d ,
     0x1d ,
     0x21 ,
     0x1d ,
     0x21 ,
     0x21 ,
     0x27 ,
     0x19 ,
     0x1d ,
     0x1d ,
     0x21 ,
     0x1d ,
     0x21 ,
     0x21 ,
     0x25 ,
     0x1d ,
     0x21 ,
     0x21 ,
     0x25 ,
     0x21 ,
     0x25 ,
     0x25 ,
     0x2b ,
     0x19 ,
     0x1d ,
     0x1d ,
     0x21 ,
     0x1d ,
     0x21 ,
     0x21 ,
     0x25 ,
     0x1d ,
     0x21 ,
     0x21 ,
     0x25 ,
     0x21 ,
     0x25 ,
     0x25 ,
     0x2b ,
     0x1d ,
     0x21 ,
     0x21 ,
     0x25 ,
     0x21 ,
     0x25 ,
     0x25 ,
     0x29 ,
     0x21 ,
     0x25 ,
     0x25 ,
     0x29 ,
     0x27 ,
     0x2b ,
     0x2b ,
     0x2f ,
     0x15 ,
     0x19 ,
     0x19 ,
     0x1d ,
     0x19 ,
     0x1d ,
     0x1d ,
     0x21 ,
     0x19 ,
     0x1d ,
     0x1d ,
     0x21 ,
     0x1d ,
     0x21 ,
     0x21 ,
     0x27 ,
     0x19 ,
     0x1d ,
     0x1d ,
     0x21 ,
     0x1d ,
     0x21 ,
     0x21 ,
     0x25 ,
     0x1d ,
     0x21 ,
     0x21 ,
     0x25 ,
     0x21 ,
     0x25 ,
     0x25 ,
     0x2b ,
     0x19 ,
     0x1d ,
     0x1d ,
     0x21 ,
     0x1d ,
     0x21 ,
     0x21 ,
     0x25 ,
     0x1d ,
     0x21 ,
     0x21 ,
     0x25 ,
     0x21 ,
     0x25 ,
     0x25 ,
     0x2b ,
     0x1d ,
     0x21 ,
     0x21 ,
     0x25 ,
     0x21 ,
     0x25 ,
     0x25 ,
     0x29 ,
     0x21 ,
     0x25 ,
     0x25 ,
     0x29 ,
     0x25 ,
     0x29 ,
     0x2b ,
     0x2f ,
     0x19 ,
     0x1d ,
     0x1d ,
     0x21 ,
     0x1d ,
     0x21 ,
     0x21 ,
     0x25 ,
     0x1d ,
     0x21 ,
     0x21 ,
     0x25 ,
     0x21 ,
     0x25 ,
     0x25 ,
     0x2b ,
     0x1d ,
     0x21 ,
     0x21 ,
     0x25 ,
     0x21 ,
     0x25 ,
     0x25 ,
     0x29 ,
     0x21 ,
     0x25 ,
     0x25 ,
     0x29 ,
     0x25 ,
     0x29 ,
     0x29 ,
     0x2f ,
     0x1f ,
     0x23 ,
     0x23 ,
     0x27 ,
     0x23 ,
     0x27 ,
     0x27 ,
     0x2b ,
     0x23 ,
     0x27 ,
     0x27 ,
     0x2b ,
     0x27 ,
     0x2b ,
     0x2b ,
     0x2f ,
     0x23 ,
     0x27 ,
     0x27 ,
     0x2b ,
     0x27 ,
     0x2b ,
     0x2b ,
     0x2f ,
     0x27 ,
     0x2b ,
     0x2b ,
     0x2f ,
     0x2b ,
     0x2f ,
     0x2f ,
     0x33 ,
     0x0c ,
     0x10 ,
     0x10 ,
     0x15 ,
     0x10 ,
     0x15 ,
     0x15 ,
     0x19 ,
     0x10 ,
     0x15 ,
     0x15 ,
     0x19 ,
     0x15 ,
     0x19 ,
     0x19 ,
     0x1f ,
     0x10 ,
     0x15 ,
     0x15 ,
     0x19 ,
     0x15 ,
     0x19 ,
     0x19 ,
     0x1d ,
     0x15 ,
     0x19 ,
     0x19 ,
     0x1d ,
     0x19 ,
     0x1d ,
     0x1d ,
     0x23 ,
     0x10 ,
     0x15 ,
     0x15 ,
     0x19 ,
     0x15 ,
     0x19 ,
     0x19 ,
     0x1d ,
     0x15 ,
     0x19 ,
     0x19 ,
     0x1d ,
     0x19 ,
     0x1d ,
     0x1d ,
     0x23 ,
     0x15 ,
     0x19 ,
     0x19 ,
     0x1d ,
     0x19 ,
     0x1d ,
     0x1d ,
     0x21 ,
     0x19 ,
     0x1d ,
     0x1d ,
     0x21 ,
     0x1d ,
     0x21 ,
     0x23 ,
     0x27 ,
     0x10 ,
     0x15 ,
     0x15 ,
     0x19 ,
     0x15 ,
     0x19 ,
     0x19 ,
     0x1d ,
     0x15 ,
     0x19 ,
     0x19 ,
     0x1d ,
     0x19 ,
     0x1d ,
     0x1d ,
     0x23 ,
     0x15 ,
     0x19 ,
     0x19 ,
     0x1d ,
     0x19 ,
     0x1d ,
     0x1d ,
     0x21 ,
     0x19 ,
     0x1d ,
     0x1d ,
     0x21 ,
     0x1d ,
     0x21 ,
     0x21 ,
     0x27 ,
     0x15 ,
     0x19 ,
     0x19 ,
     0x1d ,
     0x19 ,
     0x1d ,
     0x1d ,
     0x21 ,
     0x19 ,
     0x1d ,
     0x1d ,
     0x21 ,
     0x1d ,
     0x21 ,
     0x21 ,
     0x27 ,
     0x19 ,
     0x1d ,
     0x1d ,
     0x21 ,
     0x1d ,
     0x21 ,
     0x21 ,
     0x25 ,
     0x1d ,
     0x21 ,
     0x21 ,
     0x25 ,
     0x23 ,
     0x27 ,
     0x27 ,
     0x2b ,
     0x10 ,
     0x15 ,
     0x15 ,
     0x19 ,
     0x15 ,
     0x19 ,
     0x19 ,
     0x1d ,
     0x15 ,
     0x19 ,
     0x19 ,
     0x1d ,
     0x19 ,
     0x1d ,
     0x1d ,
     0x23 ,
     0x15 ,
     0x19 ,
     0x19 ,
     0x1d ,
     0x19 ,
     0x1d ,
     0x1d ,
     0x21 ,
     0x19 ,
     0x1d ,
     0x1d ,
     0x21 ,
     0x1d ,
     0x21 ,
     0x21 ,
     0x27 ,
     0x15 ,
     0x19 ,
     0x19 ,
     0x1d ,
     0x19 ,
     0x1d ,
     0x1d ,
     0x21 ,
     0x19 ,
     0x1d ,
     0x1d ,
     0x21 ,
     0x1d ,
     0x21 ,
     0x21 ,
     0x27 ,
     0x19 ,
     0x1d ,
     0x1d ,
     0x21 ,
     0x1d ,
     0x21 ,
     0x21 ,
     0x25 ,
     0x1d ,
     0x21 ,
     0x21 ,
     0x25 ,
     0x21 ,
     0x25 ,
     0x27 ,
     0x2b ,
     0x15 ,
     0x19 ,
     0x19 ,
     0x1d ,
     0x19 ,
     0x1d ,
     0x1d ,
     0x21 ,
     0x19 ,
     0x1d ,
     0x1d ,
     0x21 ,
     0x1d ,
     0x21 ,
     0x21 ,
     0x27 ,
     0x19 ,
     0x1d ,
     0x1d ,
     0x21 ,
     0x1d ,
     0x21 ,
     0x21 ,
     0x25 ,
     0x1d ,
     0x21 ,
     0x21 ,
     0x25 ,
     0x21 ,
     0x25 ,
     0x25 ,
     0x2b ,
     0x19 ,
     0x1d ,
     0x1d ,
     0x21 ,
     0x1d ,
     0x21 ,
     0x21 ,
     0x25 ,
     0x1d ,
     0x21 ,
     0x21 ,
     0x25 ,
     0x21 ,
     0x25 ,
     0x25 ,
     0x2b ,
     0x1d ,
     0x21 ,
     0x21 ,
     0x25 ,
     0x21 ,
     0x25 ,
     0x25 ,
     0x29 ,
     0x23 ,
     0x27 ,
     0x27 ,
     0x2b ,
     0x27 ,
     0x2b ,
     0x2b ,
     0x2f ,
     0x10 ,
     0x15 ,
     0x15 ,
     0x19 ,
     0x15 ,
     0x19 ,
     0x19 ,
     0x1d ,
     0x15 ,
     0x19 ,
     0x19 ,
     0x1d ,
     0x19 ,
     0x1d ,
     0x1d ,
     0x23 ,
     0x15 ,
     0x19 ,
     0x19 ,
     0x1d ,
     0x19 ,
     0x1d ,
     0x1d ,
     0x21 ,
     0x19 ,
     0x1d ,
     0x1d ,
     0x21 ,
     0x1d ,
     0x21 ,
     0x21 ,
     0x27 ,
     0x15 ,
     0x19 ,
     0x19 ,
     0x1d ,
     0x19 ,
     0x1d ,
     0x1d ,
     0x21 ,
     0x19 ,
     0x1d ,
     0x1d ,
     0x21 ,
     0x1d ,
     0x21 ,
     0x21 ,
     0x27 ,
     0x19 ,
     0x1d ,
     0x1d ,
     0x21 ,
     0x1d ,
     0x21 ,
     0x21 ,
     0x25 ,
     0x1d ,
     0x21 ,
     0x21 ,
     0x25 ,
     0x21 ,
     0x25 ,
     0x27 ,
     0x2b ,
     0x15 ,
     0x19 ,
     0x19 ,
     0x1d ,
     0x19 ,
     0x1d ,
     0x1d ,
     0x21 ,
     0x19 ,
     0x1d ,
     0x1d ,
     0x21 ,
     0x1d ,
     0x21 ,
     0x21 ,
     0x27 ,
     0x19 ,
     0x1d ,
     0x1d ,
     0x21 ,
     0x1d ,
     0x21 ,
     0x21 ,
     0x25 ,
     0x1d ,
     0x21 ,
     0x21 ,
     0x25 ,
     0x21 ,
     0x25 ,
     0x25 ,
     0x2b ,
     0x19 ,
     0x1d ,
     0x1d ,
     0x21 ,
     0x1d ,
     0x21 ,
     0x21 ,
     0x25 ,
     0x1d ,
     0x21 ,
     0x21 ,
     0x25 ,
     0x21 ,
     0x25 ,
     0x25 ,
     0x2b ,
     0x1d ,
     0x21 ,
     0x21 ,
     0x25 ,
     0x21 ,
     0x25 ,
     0x25 ,
     0x29 ,
     0x21 ,
     0x25 ,
     0x25 ,
     0x29 ,
     0x27 ,
     0x2b ,
     0x2b ,
     0x2f ,
     0x15 ,
     0x19 ,
     0x19 ,
     0x1d ,
     0x19 ,
     0x1d ,
     0x1d ,
     0x21 ,
     0x19 ,
     0x1d ,
     0x1d ,
     0x21 ,
     0x1d ,
     0x21 ,
     0x21 ,
     0x27 ,
     0x19 ,
     0x1d ,
     0x1d ,
     0x21 ,
     0x1d ,
     0x21 ,
     0x21 ,
     0x25 ,
     0x1d ,
     0x21 ,
     0x21 ,
     0x25 ,
     0x21 ,
     0x25 ,
     0x25 ,
     0x2b ,
     0x19 ,
     0x1d ,
     0x1d ,
     0x21 ,
     0x1d ,
     0x21 ,
     0x21 ,
     0x25 ,
     0x1d ,
     0x21 ,
     0x21 ,
     0x25 ,
     0x21 ,
     0x25 ,
     0x25 ,
     0x2b ,
     0x1d ,
     0x21 ,
     0x21 ,
     0x25 ,
     0x21 ,
     0x25 ,
     0x25 ,
     0x29 ,
     0x21 ,
     0x25 ,
     0x25 ,
     0x29 ,
     0x25 ,
     0x29 ,
     0x2b ,
     0x2f ,
     0x19 ,
     0x1d ,
     0x1d ,
     0x21 ,
     0x1d ,
     0x21 ,
     0x21 ,
     0x25 ,
     0x1d ,
     0x21 ,
     0x21 ,
     0x25 ,
     0x21 ,
     0x25 ,
     0x25 ,
     0x2b ,
     0x1d ,
     0x21 ,
     0x21 ,
     0x25 ,
     0x21 ,
     0x25 ,
     0x25 ,
     0x29 ,
     0x21 ,
     0x25 ,
     0x25 ,
     0x29 ,
     0x25 ,
     0x29 ,
     0x29 ,
     0x2f ,
     0x1d ,
     0x21 ,
     0x21 ,
     0x25 ,
     0x21 ,
     0x25 ,
     0x25 ,
     0x29 ,
     0x21 ,
     0x25 ,
     0x25 ,
     0x29 ,
     0x25 ,
     0x29 ,
     0x29 ,
     0x2f ,
     0x23 ,
     0x27 ,
     0x27 ,
     0x2b ,
     0x27 ,
     0x2b ,
     0x2b ,
     0x2f ,
     0x27 ,
     0x2b ,
     0x2b ,
     0x2f ,
     0x2b ,
     0x2f ,
     0x2f ,
     0x33 ,
     0x10 ,
     0x15 ,
     0x15 ,
     0x19 ,
     0x15 ,
     0x19 ,
     0x19 ,
     0x1d ,
     0x15 ,
     0x19 ,
     0x19 ,
     0x1d ,
     0x19 ,
     0x1d ,
     0x1d ,
     0x23 ,
     0x15 ,
     0x19 ,
     0x19 ,
     0x1d ,
     0x19 ,
     0x1d ,
     0x1d ,
     0x21 ,
     0x19 ,
     0x1d ,
     0x1d ,
     0x21 ,
     0x1d ,
     0x21 ,
     0x21 ,
     0x27 ,
     0x15 ,
     0x19 ,
     0x19 ,
     0x1d ,
     0x19 ,
     0x1d ,
     0x1d ,
     0x21 ,
     0x19 ,
     0x1d ,
     0x1d ,
     0x21 ,
     0x1d ,
     0x21 ,
     0x21 ,
     0x27 ,
     0x19 ,
     0x1d ,
     0x1d ,
     0x21 ,
     0x1d ,
     0x21 ,
     0x21 ,
     0x25 ,
     0x1d ,
     0x21 ,
     0x21 ,
     0x25 ,
     0x21 ,
     0x25 ,
     0x27 ,
     0x2b ,
     0x15 ,
     0x19 ,
     0x19 ,
     0x1d ,
     0x19 ,
     0x1d ,
     0x1d ,
     0x21 ,
     0x19 ,
     0x1d ,
     0x1d ,
     0x21 ,
     0x1d ,
     0x21 ,
     0x21 ,
     0x27 ,
     0x19 ,
     0x1d ,
     0x1d ,
     0x21 ,
     0x1d ,
     0x21 ,
     0x21 ,
     0x25 ,
     0x1d ,
     0x21 ,
     0x21 ,
     0x25 ,
     0x21 ,
     0x25 ,
     0x25 ,
     0x2b ,
     0x19 ,
     0x1d ,
     0x1d ,
     0x21 ,
     0x1d ,
     0x21 ,
     0x21 ,
     0x25 ,
     0x1d ,
     0x21 ,
     0x21 ,
     0x25 ,
     0x21 ,
     0x25 ,
     0x25 ,
     0x2b ,
     0x1d ,
     0x21 ,
     0x21 ,
     0x25 ,
     0x21 ,
     0x25 ,
     0x25 ,
     0x29 ,
     0x21 ,
     0x25 ,
     0x25 ,
     0x29 ,
     0x27 ,
     0x2b ,
     0x2b ,
     0x2f ,
     0x15 ,
     0x19 ,
     0x19 ,
     0x1d ,
     0x19 ,
     0x1d ,
     0x1d ,
     0x21 ,
     0x19 ,
     0x1d ,
     0x1d ,
     0x21 ,
     0x1d ,
     0x21 ,
     0x21 ,
     0x27 ,
     0x19 ,
     0x1d ,
     0x1d ,
     0x21 ,
     0x1d ,
     0x21 ,
     0x21 ,
     0x25 ,
     0x1d ,
     0x21 ,
     0x21 ,
     0x25 ,
     0x21 ,
     0x25 ,
     0x25 ,
     0x2b ,
     0x19 ,
     0x1d ,
     0x1d ,
     0x21 ,
     0x1d ,
     0x21 ,
     0x21 ,
     0x25 ,
     0x1d ,
     0x21 ,
     0x21 ,
     0x25 ,
     0x21 ,
     0x25 ,
     0x25 ,
     0x2b ,
     0x1d ,
     0x21 ,
     0x21 ,
     0x25 ,
     0x21 ,
     0x25 ,
     0x25 ,
     0x29 ,
     0x21 ,
     0x25 ,
     0x25 ,
     0x29 ,
     0x25 ,
     0x29 ,
     0x2b ,
     0x2f ,
     0x19 ,
     0x1d ,
     0x1d ,
     0x21 ,
     0x1d ,
     0x21 ,
     0x21 ,
     0x25 ,
     0x1d ,
     0x21 ,
     0x21 ,
     0x25 ,
     0x21 ,
     0x25 ,
     0x25 ,
     0x2b ,
     0x1d ,
     0x21 ,
     0x21 ,
     0x25 ,
     0x21 ,
     0x25 ,
     0x25 ,
     0x29 ,
     0x21 ,
     0x25 ,
     0x25 ,
     0x29 ,
     0x25 ,
     0x29 ,
     0x29 ,
     0x2f ,
     0x1d ,
     0x21 ,
     0x21 ,
     0x25 ,
     0x21 ,
     0x25 ,
     0x25 ,
     0x29 ,
     0x21 ,
     0x25 ,
     0x25 ,
     0x29 ,
     0x25 ,
     0x29 ,
     0x29 ,
     0x2f ,
     0x21 ,
     0x25 ,
     0x25 ,
     0x29 ,
     0x25 ,
     0x29 ,
     0x29 ,
     0x2d ,
     0x27 ,
     0x2b ,
     0x2b ,
     0x2f ,
     0x2b ,
     0x2f ,
     0x2f ,
     0x33 ,
     0x17 ,
     0x1b ,
     0x1b ,
     0x1f ,
     0x1b ,
     0x1f ,
     0x1f ,
     0x23 ,
     0x1b ,
     0x1f ,
     0x1f ,
     0x23 ,
     0x1f ,
     0x23 ,
     0x23 ,
     0x27 ,
     0x1b ,
     0x1f ,
     0x1f ,
     0x23 ,
     0x1f ,
     0x23 ,
     0x23 ,
     0x27 ,
     0x1f ,
     0x23 ,
     0x23 ,
     0x27 ,
     0x23 ,
     0x27 ,
     0x27 ,
     0x2b ,
     0x1b ,
     0x1f ,
     0x1f ,
     0x23 ,
     0x1f ,
     0x23 ,
     0x23 ,
     0x27 ,
     0x1f ,
     0x23 ,
     0x23 ,
     0x27 ,
     0x23 ,
     0x27 ,
     0x27 ,
     0x2b ,
     0x1f ,
     0x23 ,
     0x23 ,
     0x27 ,
     0x23 ,
     0x27 ,
     0x27 ,
     0x2b ,
     0x23 ,
     0x27 ,
     0x27 ,
     0x2b ,
     0x27 ,
     0x2b ,
     0x2b ,
     0x2f ,
     0x1b ,
     0x1f ,
     0x1f ,
     0x23 ,
     0x1f ,
     0x23 ,
     0x23 ,
     0x27 ,
     0x1f ,
     0x23 ,
     0x23 ,
     0x27 ,
     0x23 ,
     0x27 ,
     0x27 ,
     0x2b ,
     0x1f ,
     0x23 ,
     0x23 ,
     0x27 ,
     0x23 ,
     0x27 ,
     0x27 ,
     0x2b ,
     0x23 ,
     0x27 ,
     0x27 ,
     0x2b ,
     0x27 ,
     0x2b ,
     0x2b ,
     0x2f ,
     0x1f ,
     0x23 ,
     0x23 ,
     0x27 ,
     0x23 ,
     0x27 ,
     0x27 ,
     0x2b ,
     0x23 ,
     0x27 ,
     0x27 ,
     0x2b ,
     0x27 ,
     0x2b ,
     0x2b ,
     0x2f ,
     0x23 ,
     0x27 ,
     0x27 ,
     0x2b ,
     0x27 ,
     0x2b ,
     0x2b ,
     0x2f ,
     0x27 ,
     0x2b ,
     0x2b ,
     0x2f ,
     0x2b ,
     0x2f ,
     0x2f ,
     0x33 ,
     0x1b ,
     0x1f ,
     0x1f ,
     0x23 ,
     0x1f ,
     0x23 ,
     0x23 ,
     0x27 ,
     0x1f ,
     0x23 ,
     0x23 ,
     0x27 ,
     0x23 ,
     0x27 ,
     0x27 ,
     0x2b ,
     0x1f ,
     0x23 ,
     0x23 ,
     0x27 ,
     0x23 ,
     0x27 ,
     0x27 ,
     0x2b ,
     0x23 ,
     0x27 ,
     0x27 ,
     0x2b ,
     0x27 ,
     0x2b ,
     0x2b ,
     0x2f ,
     0x1f ,
     0x23 ,
     0x23 ,
     0x27 ,
     0x23 ,
     0x27 ,
     0x27 ,
     0x2b ,
     0x23 ,
     0x27 ,
     0x27 ,
     0x2b ,
     0x27 ,
     0x2b ,
     0x2b ,
     0x2f ,
     0x23 ,
     0x27 ,
     0x27 ,
     0x2b ,
     0x27 ,
     0x2b ,
     0x2b ,
     0x2f ,
     0x27 ,
     0x2b ,
     0x2b ,
     0x2f ,
     0x2b ,
     0x2f ,
     0x2f ,
     0x33 ,
     0x1f ,
     0x23 ,
     0x23 ,
     0x27 ,
     0x23 ,
     0x27 ,
     0x27 ,
     0x2b ,
     0x23 ,
     0x27 ,
     0x27 ,
     0x2b ,
     0x27 ,
     0x2b ,
     0x2b ,
     0x2f ,
     0x23 ,
     0x27 ,
     0x27 ,
     0x2b ,
     0x27 ,
     0x2b ,
     0x2b ,
     0x2f ,
     0x27 ,
     0x2b ,
     0x2b ,
     0x2f ,
     0x2b ,
     0x2f ,
     0x2f ,
     0x33 ,
     0x23 ,
     0x27 ,
     0x27 ,
     0x2b ,
     0x27 ,
     0x2b ,
     0x2b ,
     0x2f ,
     0x27 ,
     0x2b ,
     0x2b ,
     0x2f ,
     0x2b ,
     0x2f ,
     0x2f ,
     0x33 ,
     0x27 ,
     0x2b ,
     0x2b ,
     0x2f ,
     0x2b ,
     0x2f ,
     0x2f ,
     0x33 ,
     0x2b ,
     0x2f ,
     0x2f ,
     0x33 ,
     0x2f ,
     0x33 ,
     0x33 ,
     0x37 
};
