/* GNU polyxmass - the massist's program.
   -------------------------------------- 
   Copyright (C) 2000,2001,2002,2003,2004 Filippo Rusconi

   http://www.polyxmass.org

   This file is part of the "GNU polyxmass" project.
   
   The "GNU polyxmass" project is an official GNU project package (see
   www.gnu.org) released ---in its entirety--- under the GNU General
   Public License and was started at the Centre National de la
   Recherche Scientifique (FRANCE), that granted me the formal
   authorization to publish it under this Free Software License.

   This software is free software; you can redistribute it and/or
   modify it under the terms of the GNU  General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.
   
   This software is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   General Public License for more details.
   
   You should have received a copy of the GNU  General Public
   License along with this software; if not, write to the
   Free Software Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.
*/

#include "polyxdef-defctxt.h"
#include "polyxdef-ui-polchemdef.h"

PxmDefCtxt *
polyxdef_defctxt_new (void)
{
  PxmDefCtxt *defctxt = g_malloc0 (sizeof (PxmDefCtxt));
  
  
  defctxt->atomGPA = g_ptr_array_new ();
  
  defctxt->propGPA = g_ptr_array_new ();

  return defctxt;
}


gboolean 
polyxdef_defctxt_free (PxmDefCtxt *defctxt)
{
  gint count = 0;


  g_assert (defctxt != NULL);

  
  /* Start with most internal data.
   */
  if (defctxt->propGPA != NULL)
    libpolyxmass_prop_GPA_free (defctxt->propGPA);
  
  if (defctxt->polchemdef != NULL)
    pxmchem_polchemdef_free (defctxt->polchemdef);
  
  if (defctxt->filename != NULL)
    g_free (defctxt->filename);
  
  /* This array is not used if the definition is a polymer chemistry
     definition, but it's not a problem, the array --which was
     allocated-- will be freed cheerfully...
  */
  if (defctxt->atomGPA != NULL)
    pxmchem_atom_GPA_free (defctxt->atomGPA);
  
  
  if (defctxt->definition_wnd != NULL)
    {
      count = polyxmass_timeoutmsg_messages_remove 
	((GtkWindow *) defctxt->definition_wnd);
      
      /*
	debug_printf (("Removed %d timed-out messages\n",
	count));
      */
      
      gtk_object_destroy (GTK_OBJECT (defctxt->definition_wnd));
    }
  
  
  if (defctxt->syntax_check_wnd != NULL)
    gtk_object_destroy (GTK_OBJECT (defctxt->syntax_check_wnd));
  
  g_free (defctxt);
  
  return TRUE;
}




/* GPtrArray-RELATED FUNCTIONS
 */
gint
polyxdef_defctxt_GPA_free (GPtrArray *GPA)
{
  gint count = 0;
  
  PxmDefCtxt *defctxt = NULL;

  g_assert (GPA != NULL);
  
  while (GPA->len > 0)
    {
      defctxt = g_ptr_array_remove_index (GPA, 0);
      g_assert (defctxt != NULL);
      polyxdef_defctxt_free (defctxt);
      count++;
    }
  
  g_ptr_array_free (GPA, TRUE);

  return count;
}












