/* GNU polyxmass - the massist's program.
   -------------------------------------- 
   Copyright (C) 2000,2001,2002,2003,2004 Filippo Rusconi

   http://www.polyxmass.org

   This file is part of the "GNU polyxmass" project.
   
   The "GNU polyxmass" project is an official GNU project package (see
   www.gnu.org) released ---in its entirety--- under the GNU General
   Public License and was started at the Centre National de la
   Recherche Scientifique (FRANCE), that granted me the formal
   authorization to publish it under this Free Software License.

   This software is free software; you can redistribute it and/or
   modify it under the terms of the GNU  General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.
   
   This software is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   General Public License for more details.
   
   You should have received a copy of the GNU  General Public
   License along with this software; if not, write to the
   Free Software Foundation, Inc., 51 Franklin St, Fifth Floor,
   Boston, MA 02110-1301, USA.
*/
#ifndef POLYXDEF_UI_ATOMDEF_H
#define POLYXDEF_UI_ATOMDEF_H

#include "polyxdef-globals.h"
#include "polyxdef-defctxt.h"



/* Columns of the treeview where the atom definitions are elaborated.
 */
enum
  {
    COLUMN_ATOM_NAME,
    COLUMN_ATOM_SYMBOL,
    COLUMN_ATOM_AVG_MASS,
    COLUMN_ISOTOPE_MASS,
    COLUMN_ISOTOPE_ABUNDANCE,

    COLUMN_ATOM_POINTER,

    COLUMN_ATOM_VISIBLE,
    COLUMN_ATOM_EDITABLE,

    COLUMN_ATOM_COL_COUNT,
    COLUMN_ATOM_NOT_EDITABLE = 0,
  };



GtkWidget *
polyxdef_ui_atomdef_wnd_setup_window (PxmDefCtxt *defctxt);



/* SYNTAX ERROR CHECKING FUNCTIONS
 */
gboolean
polyxdef_ui_atomdef_wnd_check_syntax_button (GtkWidget *widget, 
					     gpointer data);


/* ATOMS TREEVIEW CREATION STUFF
 */
GtkTreeModel *
polyxdef_ui_atomdef_wnd_create_atoms_treeview_model (GPtrArray *GPA);

GtkWidget *
polyxdef_ui_atomdef_wnd_create_atoms_treeview (PxmDefCtxt *defctxt);


/* TREEVIEW EDITED CELL CALLBACKS
 */
void
polyxdef_ui_atomdef_wnd_atom_name_cell_edited (GtkCellRendererText *cell,
					       const gchar *path_string,
					       const gchar *new_text,
					       gpointer data);

void
polyxdef_ui_atomdef_wnd_atom_symbol_cell_edited (GtkCellRendererText *cell,
						 const gchar *path_string,
						 const gchar *new_text,
						 gpointer data);

void
polyxdef_ui_atomdef_wnd_atom_avg_mass_cell_edited (GtkCellRendererText *cell,
						   const gchar *path_string,
						   const gchar *new_text,
						   gpointer data);

void
polyxdef_ui_atomdef_wnd_isotope_mass_cell_edited (GtkCellRendererText *cell,
						  const gchar *path_string,
						  const gchar *new_text,
						  gpointer data);

void
polyxdef_ui_atomdef_wnd_isotope_abund_cell_edited (GtkCellRendererText *cell,
						   const gchar *path_string,
						   const gchar *new_text,
						   gpointer data);

/* ATOM / ISOTOPE ADD/REMOVE BUTTONS.
 */
void
polyxdef_ui_atomdef_wnd_add_atom_button (GtkWidget *widget,
					 gpointer data);

void
polyxdef_ui_atomdef_wnd_add_isotope_button (GtkWidget *widget,
					 gpointer data);

void
polyxdef_ui_atomdef_wnd_remove_button (GtkWidget *widget,
					 gpointer data);

/*
  ATOM DEFINITION SAVING FUNCTIONS
*/
void
polyxdef_ui_atomdef_wnd_save_button (GtkWidget *widget,
					 gpointer data);

void
polyxdef_ui_atomdef_wnd_saveas_button (GtkWidget *widget,
					 gpointer data);

/* HELPERS
 */
void
polyxdef_ui_atomdef_wnd_update_status_label (PxmDefCtxt *defctxt);

void
polyxdef_ui_atomdef_wnd_atom_avg_mass_cell_update (PxmDefCtxt *defctxt, 
						   gint idx);
gboolean
polyxdef_ui_atomdef_wnd_open_atomdef_file (gchar *file, GPtrArray *atomGPA);

/* WINDOW CLOSING FUNCTIONS
 */
gboolean
polyxdef_ui_atomdef_wnd_delete_event (GtkWidget *window,
				      GdkEvent *event,
				      gpointer data);
gboolean
polyxdef_ui_atomdef_wnd_destroy_event (GtkWidget *window,
				       GdkEvent *event,
				       gpointer data);
















#endif /* ifndef POLYXDEF_UI_ATOMDEF_H */
