/* GNU polyxmass - the massist's program.
   -------------------------------------- 
   Copyright (C) 2000,2001,2002,2003,2004 Filippo Rusconi

   http://www.polyxmass.org

   This file is part of the "GNU polyxmass" project.
   
   The "GNU polyxmass" project is an official GNU project package (see
   www.gnu.org) released ---in its entirety--- under the GNU General
   Public License and was started at the Centre National de la
   Recherche Scientifique (FRANCE), that granted me the formal
   authorization to publish it under this Free Software License.

   This software is free software; you can redistribute it and/or
   modify it under the terms of the GNU  General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.
   
   This software is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   General Public License for more details.
   
   You should have received a copy of the GNU  General Public
   License along with this software; if not, write to the
   Free Software Foundation, Inc., 51 Franklin St, Fifth Floor,
   Boston, MA 02110-1301, USA.
*/
#ifndef POLYXEDIT_MONICON_H
#define POLYXEDIT_MONICON_H


#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include "polyxedit-globals.h"


typedef struct _PxmMonicon PxmMonicon;


struct _PxmMonicon
{
  /* Canvas item that is created in the canvas by adding a GdkPixbuf
   *  to it.
   */
  GnomeCanvasItem *canvas_item;

  /* the x/y coordinate of the monicon 
   */
  gdouble x;  
  gdouble y;  
};


/* NEW'ING FUNCTIONS, DUPLICATING FUNCTIONS ...
 */
PxmMonicon *
polyxmass_monicon_new (void);



/* FREE'ING FUNCTIONS
 */
gboolean
polyxmass_monicon_free (PxmMonicon *monicon);




/* GPtrArray-RELATED FUNCTIONS
 */
gint
polyxmass_monicon_GPA_empty (GPtrArray *GPA);


gint
polyxmass_monicon_GPA_free (GPtrArray *GPA);







#endif /* POLYXEDIT_MONICON_H */
