/* Generated by GOB (v1.0.9) on Mon Jun  4 03:59:30 2001
   (do not edit directly) */

/* End world hunger, donate to the World Food Programme, http://www.wfp.org */


#line 1 "pong-list-entry.gob"

/* PonG: list entry
 * Author: George Lebl
 * (c) 2000 Eazel, Inc.
 * (c) 2001 George Lebl
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	 See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#line 31 "pong-list-entry.c"
#define GOB_VERSION_MAJOR 1
#define GOB_VERSION_MINOR 0
#define GOB_VERSION_PATCHLEVEL 9

#include <string.h> /* memset() */


#line 27 "pong-list-entry.gob"

#include "config.h"
#include <gnome.h>
#include <gconf/gconf-value.h>

#include "pong-i18n.h"

#include "pongpane.h"
#include "pongutil.h"

#include "pong-list-entry.h"
#include "pong-list-entry-private.h"

#define MINIMUM_LIST_WIDTH 110
#define MINIMUM_LIST_HEIGHT 160

static gboolean is_string_in_list (const GList *list, const char *string);
static gboolean is_string_in_option_list (const GList *list, const char *string);
static gboolean is_value_in_value_list (const GSList *list, const char *string);
static int find_value_in_clist (GtkCList *clist, GConfValue *value);


#line 62 "pong-list-entry.c"
/* self casting macros */
#define SELF(x) PONG_LIST_ENTRY(x)
#define SELF_CONST(x) PONG_LIST_ENTRY_CONST(x)
#define IS_SELF(x) PONG_IS_LIST_ENTRY(x)
#define TYPE_SELF PONG_TYPE_LIST_ENTRY
#define SELF_CLASS(x) PONG_LIST_ENTRY_CLASS(x)

#define SELF_GET_CLASS(x) PONG_LIST_ENTRY_GET_CLASS(x)

/* self typedefs */
typedef PongListEntry Self;
typedef PongListEntryClass SelfClass;

/* GTK_CLASS_TYPE for 1.2<->1.3/2.0 GTK+ compatibility */
#ifndef GTK_CLASS_TYPE
#define GTK_CLASS_TYPE(x) (GTK_OBJECT_CLASS(x)->type)
#endif /* GTK_CLASS_TYPE */

/* here are local prototypes */
static void ___object_set_arg (GtkObject *object, GtkArg *arg, guint arg_id);
static void pong_list_entry_class_init (PongListEntryClass * klass) G_GNUC_UNUSED;
static void pong_list_entry_init (PongListEntry * self) G_GNUC_UNUSED;
static void pong_list_entry_changed (PongListEntry * self) G_GNUC_UNUSED;
static gboolean pong_list_entry_get_value (GtkWidget * w, const char * specifier, PongType type, GConfValue ** value) G_GNUC_UNUSED;
static gboolean pong_list_entry_set_value (GtkWidget * w, const char * specifier, GConfValue * value) G_GNUC_UNUSED;
static void pong_list_entry_add_options (GtkWidget * w, GList * pong_options) G_GNUC_UNUSED;
static void pong_list_entry_move_item (PongListEntry * self, GtkCList * clist1, int row, GtkCList * clist2, gboolean in) G_GNUC_UNUSED;
static void pong_list_entry_move_items (PongListEntry * self, GtkCList * clist1, GtkCList * clist2, gboolean in) G_GNUC_UNUSED;
static void pong_list_entry_move_items_in (PongListEntry * self) G_GNUC_UNUSED;
static void pong_list_entry_move_items_out (PongListEntry * self) G_GNUC_UNUSED;

enum {
	CHANGED_SIGNAL,
	LAST_SIGNAL
};

enum {
	ARG_0,
	ARG_AVAILABLE_LABEL,
	ARG_SELECTED_LABEL
};

static guint object_signals[LAST_SIGNAL] = {0};

/* pointer to the class of our parent */
static GtkHBoxClass *parent_class = NULL;

GtkType
pong_list_entry_get_type (void)
{
	static GtkType type = 0;

	if (type == 0) {
		static const GtkTypeInfo info = {
			"PongListEntry",
			sizeof (PongListEntry),
			sizeof (PongListEntryClass),
			(GtkClassInitFunc) pong_list_entry_class_init,
			(GtkObjectInitFunc) pong_list_entry_init,
			/* reserved_1 */ NULL,
			/* reserved_2 */ NULL,
			(GtkClassInitFunc) NULL
		};

		type = gtk_type_unique (gtk_hbox_get_type(), &info);
	}

	return type;
}

/* Short form macros */
#if defined(__GNUC__) && !defined(__STRICT_ANSI__)
#define new() pong_list_entry_new()
#define new_with_options(args...) pong_list_entry_new_with_options(args)
#define changed(args...) pong_list_entry_changed(args)
#define get_value(args...) pong_list_entry_get_value(args)
#define set_value(args...) pong_list_entry_set_value(args)
#define add_options(args...) pong_list_entry_add_options(args)
#define move_item(args...) pong_list_entry_move_item(args)
#define move_items(args...) pong_list_entry_move_items(args)
#define move_items_in(args...) pong_list_entry_move_items_in(args)
#define move_items_out(args...) pong_list_entry_move_items_out(args)
#endif /* __GNUC__ && !__STRICT_ANSI__ */

/* Short form pointers */
static GtkWidget * (* const new) (void) = pong_list_entry_new;
static GtkWidget * (* const new_with_options) (GList * pong_options) = pong_list_entry_new_with_options;
static void (* const changed) (PongListEntry * self) = pong_list_entry_changed;
static gboolean (* const get_value) (GtkWidget * w, const char * specifier, PongType type, GConfValue ** value) = pong_list_entry_get_value;
static gboolean (* const set_value) (GtkWidget * w, const char * specifier, GConfValue * value) = pong_list_entry_set_value;
static void (* const add_options) (GtkWidget * w, GList * pong_options) = pong_list_entry_add_options;
static void (* const move_item) (PongListEntry * self, GtkCList * clist1, int row, GtkCList * clist2, gboolean in) = pong_list_entry_move_item;
static void (* const move_items) (PongListEntry * self, GtkCList * clist1, GtkCList * clist2, gboolean in) = pong_list_entry_move_items;
static void (* const move_items_in) (PongListEntry * self) = pong_list_entry_move_items_in;
static void (* const move_items_out) (PongListEntry * self) = pong_list_entry_move_items_out;

/* a macro for creating a new object of our type */
#define GET_NEW ((PongListEntry *)gtk_type_new(pong_list_entry_get_type()))


static void
___destroy(GtkObject *obj_self)
{
#define __GOB_FUNCTION__ "Pong:List:Entry::destroy"
	PongListEntry *self = PONG_LIST_ENTRY (obj_self);
	if(GTK_OBJECT_CLASS(parent_class)->destroy) \
		(* GTK_OBJECT_CLASS(parent_class)->destroy)(obj_self);
#define VAR (self->_priv->values)
	{
#line 56 "pong-list-entry.gob"
	
			if (VAR != NULL) {
				g_list_foreach (VAR, (GFunc)g_free, NULL);
				g_list_free (VAR);
			}
		}
#line 179 "pong-list-entry.c"
	memset(&VAR, 0, sizeof(VAR));
#undef VAR
	return;
	self = NULL;
}
#undef __GOB_FUNCTION__


#ifdef G_OBJECT_CLASS
static void
___finalize(GObject *obj_self)
#else /* !G_OBJECT_CLASS */
static void
___finalize(GtkObject *obj_self)
#endif /* G_OBJECT_CLASS */
{
#define __GOB_FUNCTION__ "Pong:List:Entry::finalize"
	PongListEntry *self = PONG_LIST_ENTRY (obj_self);
	gpointer priv = self->_priv;
#ifdef G_OBJECT_CLASS
	if(G_OBJECT_CLASS(parent_class)->finalize) \
		(* G_OBJECT_CLASS(parent_class)->finalize)(obj_self);
#else /* !G_OBJECT_CLASS */
	if(GTK_OBJECT_CLASS(parent_class)->finalize) \
		(* GTK_OBJECT_CLASS(parent_class)->finalize)(obj_self);
#endif /* G_OBJECT_CLASS */
	g_free(priv);
}
#undef __GOB_FUNCTION__

#line 63 "pong-list-entry.gob"
static void 
pong_list_entry_class_init (PongListEntryClass * klass)
#line 213 "pong-list-entry.c"
{
#define __GOB_FUNCTION__ "Pong:List:Entry::class_init"
	GtkObjectClass *gtk_object_class = (GtkObjectClass*) klass;
#ifdef G_OBJECT_CLASS
	GObjectClass *g_object_class = (GObjectClass*) klass;
#endif /* G_OBJECT_CLASS */

	parent_class = gtk_type_class (gtk_hbox_get_type ());

	object_signals[CHANGED_SIGNAL] =
		gtk_signal_new ("changed",
			(GtkSignalRunType)(GTK_RUN_LAST),
			GTK_CLASS_TYPE(gtk_object_class),
			GTK_SIGNAL_OFFSET (PongListEntryClass, changed),
			gtk_signal_default_marshaller,
			GTK_TYPE_NONE, 0);
	gtk_object_class_add_signals (gtk_object_class,
		object_signals, LAST_SIGNAL);


	klass->changed = NULL;
	gtk_object_class->destroy = ___destroy;
#ifdef G_OBJECT_CLASS
	g_object_class->finalize = ___finalize;
#else /* !G_OBJECT_CLASS */
	gtk_object_class->finalize = ___finalize;
#endif /* G_OBJECT_CLASS */

	gtk_object_add_arg_type("PongListEntry::available_label",
		GTK_TYPE_STRING,
		GTK_ARG_WRITABLE,
		ARG_AVAILABLE_LABEL);
	gtk_object_add_arg_type("PongListEntry::selected_label",
		GTK_TYPE_STRING,
		GTK_ARG_WRITABLE,
		ARG_SELECTED_LABEL);

	gtk_object_class->set_arg = ___object_set_arg;
 {
#line 64 "pong-list-entry.gob"

		PongWidgetInterface *iface;

		iface = pong_widget_interface_add (GTK_OBJECT_CLASS (klass));
		iface->changed_signal = "changed";
		iface->get_value = get_value;
		iface->set_value = set_value;
		iface->add_options = add_options;
	
#line 263 "pong-list-entry.c"
 }
	return;
	klass = NULL;
	gtk_object_class = NULL;
#ifdef G_OBJECT_CLASS
	g_object_class = NULL;
#endif /* G_OBJECT_CLASS */
}
#undef __GOB_FUNCTION__
#line 74 "pong-list-entry.gob"
static void 
pong_list_entry_init (PongListEntry * self)
#line 276 "pong-list-entry.c"
{
#define __GOB_FUNCTION__ "Pong:List:Entry::init"
	self->_priv = g_new0 (PongListEntryPrivate, 1);
#line 27 "pong-list-entry.gob"
	self->_priv->values = NULL;
#line 282 "pong-list-entry.c"
 {
#line 75 "pong-list-entry.gob"

		GtkWidget *sw, *arrow, *button, *list, *a;
		GtkWidget *vbox;
		char *titles[1];

		gtk_box_set_spacing (GTK_BOX (self), GNOME_PAD_SMALL);

		/* The available list */
		sw = gtk_scrolled_window_new (NULL, NULL);
		gtk_widget_set_usize (sw,
				      MINIMUM_LIST_WIDTH,
				      MINIMUM_LIST_HEIGHT);
		gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (sw),
						GTK_POLICY_AUTOMATIC,
						GTK_POLICY_AUTOMATIC);
		gtk_box_pack_start (GTK_BOX (self), sw, TRUE, TRUE, 0);
		gtk_widget_show (sw);

		titles[0] = _("Available");
		list = gtk_clist_new_with_titles (1, titles);
		gtk_clist_column_titles_passive (GTK_CLIST (list));
		gtk_clist_set_selection_mode (GTK_CLIST (list),
					      GTK_SELECTION_MULTIPLE);
		gtk_clist_set_column_auto_resize (GTK_CLIST (list), 0, TRUE);
		gtk_container_add (GTK_CONTAINER (sw), list);
		gtk_widget_show (list);

		self->_priv->origin_clist = list;

		/* the buttons */
		a = gtk_alignment_new (0.5, 0.5, 0.0, 0.0);
		gtk_widget_show (a);
		gtk_box_pack_start (GTK_BOX (self), a, FALSE, FALSE, 0);

		vbox = gtk_vbox_new (FALSE, GNOME_PAD_SMALL);
		gtk_container_add (GTK_CONTAINER (a), vbox);
		gtk_widget_show (vbox);

		button = gtk_button_new ();
		gtk_box_pack_start (GTK_BOX (vbox), button, FALSE, FALSE, 0);
		gtk_widget_show (button);

		gtk_signal_connect_object (GTK_OBJECT (button), "clicked",
					   GTK_SIGNAL_FUNC (move_items_in),
					   GTK_OBJECT (self));

		arrow = gtk_arrow_new (GTK_ARROW_RIGHT,
				       GTK_SHADOW_IN);
		gtk_container_add (GTK_CONTAINER (button), arrow);
		gtk_widget_show (arrow);

		button = gtk_button_new ();
		gtk_box_pack_start (GTK_BOX (vbox), button, FALSE, FALSE, 0);
		gtk_widget_show (button);

		gtk_signal_connect_object (GTK_OBJECT (button), "clicked",
					   GTK_SIGNAL_FUNC (move_items_out),
					   GTK_OBJECT (self));

		arrow = gtk_arrow_new (GTK_ARROW_LEFT,
				       GTK_SHADOW_IN);
		gtk_container_add (GTK_CONTAINER (button), arrow);
		gtk_widget_show (arrow);

		/* The selected list */
		sw = gtk_scrolled_window_new (NULL, NULL);
		gtk_widget_set_usize (sw,
				      MINIMUM_LIST_WIDTH,
				      MINIMUM_LIST_HEIGHT);
		gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (sw),
						GTK_POLICY_AUTOMATIC,
						GTK_POLICY_AUTOMATIC);
		gtk_box_pack_start (GTK_BOX (self), sw, TRUE, TRUE, 0);
		gtk_widget_show (sw);

		titles[0] = _("Selected");
		list = gtk_clist_new_with_titles (1, titles);
		gtk_clist_column_titles_passive (GTK_CLIST (list));
		gtk_clist_set_selection_mode (GTK_CLIST (list),
					      GTK_SELECTION_MULTIPLE);
		gtk_clist_set_column_auto_resize (GTK_CLIST (list), 0, TRUE);
		gtk_container_add (GTK_CONTAINER (sw), list);
		gtk_widget_show (list);

		self->_priv->destination_clist = list;
	
#line 371 "pong-list-entry.c"
 }
	return;
	self = NULL;
}
#undef __GOB_FUNCTION__

static void
___object_set_arg (GtkObject *object,
	GtkArg *arg,
	guint arg_id)
#define __GOB_FUNCTION__ "Pong:List:Entry::set_arg"
{
	PongListEntry *self;

	self = PONG_LIST_ENTRY (object);

	switch (arg_id) {
	case ARG_AVAILABLE_LABEL:
#define ARG (GTK_VALUE_STRING(*arg))
		{
#line 163 "pong-list-entry.gob"

			if (ARG == NULL) {
				gtk_clist_column_titles_hide (GTK_CLIST (self->_priv->origin_clist));
			} else {
				gtk_clist_column_titles_show (GTK_CLIST (self->_priv->origin_clist));
				gtk_clist_set_column_title (GTK_CLIST (self->_priv->origin_clist),
							    0, ARG);
			}
		
#line 402 "pong-list-entry.c"
		}
		break;
#undef ARG
	case ARG_SELECTED_LABEL:
#define ARG (GTK_VALUE_STRING(*arg))
		{
#line 173 "pong-list-entry.gob"

			if (ARG == NULL) {
				gtk_clist_column_titles_hide (GTK_CLIST (self->_priv->destination_clist));
			} else {
				gtk_clist_column_titles_show (GTK_CLIST (self->_priv->destination_clist));
				gtk_clist_set_column_title (GTK_CLIST (self->_priv->destination_clist),
							    0, ARG);
			}
		
#line 419 "pong-list-entry.c"
		}
		break;
#undef ARG
	default:
		break;
	}
	return;
	self = NULL;
	arg = NULL;
}
#undef __GOB_FUNCTION__



/**
 * pong_list_entry_new:
 *
 * Description:  Create a new #PongListEntry widget
 *
 * Returns:  A new #PongListEntry widget
 **/
#line 191 "pong-list-entry.gob"
GtkWidget * 
pong_list_entry_new (void)
#line 444 "pong-list-entry.c"
{
#define __GOB_FUNCTION__ "Pong:List:Entry::new"
{
#line 194 "pong-list-entry.gob"
	
		return (GtkWidget *) GET_NEW;
	}}
#line 452 "pong-list-entry.c"
#undef __GOB_FUNCTION__

/**
 * pong_list_entry_new_with_options:
 * @options:  a list of PongOption structs
 *
 * Description:  Create a new #PongListEntry widget and
 * setup the @options.
 *
 * Returns:  A new #PongListEntry widget
 **/
#line 207 "pong-list-entry.gob"
GtkWidget * 
pong_list_entry_new_with_options (GList * pong_options)
#line 467 "pong-list-entry.c"
{
#define __GOB_FUNCTION__ "Pong:List:Entry::new_with_options"
{
#line 210 "pong-list-entry.gob"
	
		GtkWidget *w = (GtkWidget *) GET_NEW;
		add_options (w, pong_options);
		return w;
	}}
#line 477 "pong-list-entry.c"
#undef __GOB_FUNCTION__

#line 216 "pong-list-entry.gob"
static void 
pong_list_entry_changed (PongListEntry * self)
#line 483 "pong-list-entry.c"
{
#line 216 "pong-list-entry.gob"
	g_return_if_fail (self != NULL);
#line 216 "pong-list-entry.gob"
	g_return_if_fail (PONG_IS_LIST_ENTRY (self));
#line 489 "pong-list-entry.c"
	gtk_signal_emit (GTK_OBJECT (self),
		object_signals[CHANGED_SIGNAL]);
}

#line 220 "pong-list-entry.gob"
static gboolean 
pong_list_entry_get_value (GtkWidget * w, const char * specifier, PongType type, GConfValue ** value)
#line 497 "pong-list-entry.c"
{
#define __GOB_FUNCTION__ "Pong:List:Entry::get_value"
#line 220 "pong-list-entry.gob"
	g_return_val_if_fail (w != NULL, (gboolean )0);
#line 220 "pong-list-entry.gob"
	g_return_val_if_fail (GTK_IS_WIDGET (w), (gboolean )0);
#line 220 "pong-list-entry.gob"
	g_return_val_if_fail (value != NULL, (gboolean )0);
#line 506 "pong-list-entry.c"
{
#line 225 "pong-list-entry.gob"
	
		Self *self = SELF (w);
		GSList *value_list;
		GList *li;

		if (type != PONG_TYPE_LIST_OF_STRINGS &&
		    type != PONG_TYPE_LIST_OF_INTS &&
		    type != PONG_TYPE_LIST_OF_FLOATS &&
		    type != PONG_TYPE_LIST_OF_BOOLS) {
			g_warning (_("Unsupported type on Pong:List:Entry. "
				     "Only list types are supported."));
			return FALSE;
		}

		*value = gconf_value_new (GCONF_VALUE_LIST);

		switch (type) {
		case PONG_TYPE_LIST_OF_STRINGS:
			gconf_value_set_list_type (*value, GCONF_VALUE_STRING);
			break;
		case PONG_TYPE_LIST_OF_INTS:
			gconf_value_set_list_type (*value, GCONF_VALUE_INT);
			break;
		case PONG_TYPE_LIST_OF_FLOATS:
			gconf_value_set_list_type (*value, GCONF_VALUE_FLOAT);
			break;
			/* hmm, do bools even make sense? */
		case PONG_TYPE_LIST_OF_BOOLS:
			gconf_value_set_list_type (*value, GCONF_VALUE_BOOL);
			break;
		default:
			g_assert_not_reached ();
		}

		value_list = NULL;
		for (li = self->_priv->values;
		     li != NULL;
		     li = li->next) {
			char *string = li->data;
			GConfValue *val = NULL;

			switch (type) {
			case PONG_TYPE_LIST_OF_STRINGS:
				val = gconf_value_new (GCONF_VALUE_STRING);
				gconf_value_set_string (val, string);
				break;
			case PONG_TYPE_LIST_OF_INTS:
				val = gconf_value_new (GCONF_VALUE_INT);
				gconf_value_set_int (val, atoi (string));
				break;
			case PONG_TYPE_LIST_OF_FLOATS:
				val = gconf_value_new (GCONF_VALUE_FLOAT);
				pong_i18n_push_c_numeric_locale ();
				gconf_value_set_float (val, atof (string));
				pong_i18n_pop_c_numeric_locale ();
				break;
			case PONG_TYPE_LIST_OF_BOOLS:
				val = gconf_value_new (GCONF_VALUE_BOOL);
				gconf_value_set_int (val,
						     pong_bool_from_string
						     (string));
				break;
			default:
				g_assert_not_reached ();
			}
			value_list = g_slist_prepend (value_list, val);
		}
		value_list = g_slist_reverse (value_list);
		gconf_value_set_list_nocopy (*value, value_list);

		return TRUE;
	}}
#line 581 "pong-list-entry.c"
#undef __GOB_FUNCTION__

#line 298 "pong-list-entry.gob"
static gboolean 
pong_list_entry_set_value (GtkWidget * w, const char * specifier, GConfValue * value)
#line 587 "pong-list-entry.c"
{
#define __GOB_FUNCTION__ "Pong:List:Entry::set_value"
#line 298 "pong-list-entry.gob"
	g_return_val_if_fail (w != NULL, (gboolean )0);
#line 298 "pong-list-entry.gob"
	g_return_val_if_fail (GTK_IS_WIDGET (w), (gboolean )0);
#line 298 "pong-list-entry.gob"
	g_return_val_if_fail (value != NULL, (gboolean )0);
#line 596 "pong-list-entry.c"
{
#line 302 "pong-list-entry.gob"
	
		Self *self = SELF (w);
		GtkCList *clist1;
		GtkCList *clist2;
		GList *row_list;
		GList *li;
		GSList *value_list;
		GSList *sli;
		int previous_length, i;

		if (value->type != GCONF_VALUE_LIST) {
			g_warning (_("Unsupported type on Pong:List:Entry. "
				     "Only list types are supported."));
			return FALSE;
		}

		clist1 = GTK_CLIST (self->_priv->origin_clist);
		clist2 = GTK_CLIST (self->_priv->destination_clist);

		previous_length = clist2->rows;

		value_list = gconf_value_get_list (value);

		for (sli = value_list;
		     sli != NULL;
		     sli = sli->next) {
			GConfValue *value = sli->data;
			int row;

			row = find_value_in_clist (clist1, value);
			if (row >= 0) {
				move_item (self, clist1, row, clist2,
					   TRUE /* in */);
				continue;
			}
		}

		row_list = g_list_copy (clist2->row_list);
		for (i = 0, li = row_list;
		     i < previous_length && li != NULL;
		     i++, li = li->next) {
			GtkCListRow *row = li->data;
			char *string = row->data;

			if ( ! is_value_in_value_list (value_list, string)) {
				move_item (self, clist2, i, clist1,
					   FALSE /*in*/);
				/* we need to move down one since we just
				 * truncated the list */
				i--;
				previous_length--;
			}
		}
		g_list_free (row_list);

		return TRUE;
	}}
#line 656 "pong-list-entry.c"
#undef __GOB_FUNCTION__

#line 360 "pong-list-entry.gob"
static void 
pong_list_entry_add_options (GtkWidget * w, GList * pong_options)
#line 662 "pong-list-entry.c"
{
#define __GOB_FUNCTION__ "Pong:List:Entry::add_options"
#line 360 "pong-list-entry.gob"
	g_return_if_fail (w != NULL);
#line 360 "pong-list-entry.gob"
	g_return_if_fail (GTK_IS_WIDGET (w));
#line 669 "pong-list-entry.c"
{
#line 363 "pong-list-entry.gob"
	
		Self *self = SELF (w);
		GList *li, *list;
		GtkCList *clist1;
		GtkCList *clist2;

		clist1 = GTK_CLIST (self->_priv->origin_clist);
		clist2 = GTK_CLIST (self->_priv->destination_clist);

		gtk_clist_freeze (clist1);
		gtk_clist_freeze (clist2);

		gtk_clist_clear (clist1);
		gtk_clist_clear (clist2);

		list = g_list_copy (self->_priv->values);
		for (li = list; li != NULL; li = li->next) {
			char *val = li->data;
			if ( ! is_string_in_option_list (pong_options, val)) {
				li->data = NULL;
				self->_priv->values =
					g_list_remove (self->_priv->values,
						       val);
				g_free (val);
			}
		}
		g_list_free (list);

		for (li = pong_options; li != NULL; li = li->next) {
			PongOption *opt = li->data;
			char *text[1];
			int row;
			GtkCList *clist;

			if (opt->label != NULL)
				text[0] = opt->label;
			else
				text[0] = pong_sure_string (opt->value);

			if (is_string_in_list (self->_priv->values,
					       pong_sure_string (opt->value))) {
				clist = clist2;
			} else {
				clist = clist1;
			}
			row = gtk_clist_append (clist, text);

			gtk_clist_set_row_data_full
				(clist, row,
				 g_strdup (pong_sure_string (opt->value)),
				 (GtkDestroyNotify)g_free);
		}

		gtk_clist_thaw (clist1);
		gtk_clist_thaw (clist2);
	}}
#line 728 "pong-list-entry.c"
#undef __GOB_FUNCTION__

#line 420 "pong-list-entry.gob"
static void 
pong_list_entry_move_item (PongListEntry * self, GtkCList * clist1, int row, GtkCList * clist2, gboolean in)
#line 734 "pong-list-entry.c"
{
#define __GOB_FUNCTION__ "Pong:List:Entry::move_item"
#line 420 "pong-list-entry.gob"
	g_return_if_fail (self != NULL);
#line 420 "pong-list-entry.gob"
	g_return_if_fail (PONG_IS_LIST_ENTRY (self));
#line 420 "pong-list-entry.gob"
	g_return_if_fail (clist1 != NULL);
#line 420 "pong-list-entry.gob"
	g_return_if_fail (GTK_IS_CLIST (clist1));
#line 420 "pong-list-entry.gob"
	g_return_if_fail (clist2 != NULL);
#line 420 "pong-list-entry.gob"
	g_return_if_fail (GTK_IS_CLIST (clist2));
#line 749 "pong-list-entry.c"
{
#line 426 "pong-list-entry.gob"
	
		int new_row;
		char *text[1];
		char *value;

		gtk_clist_get_text (clist1, row, 0, &text[0]);
		value = pong_sure_string
			(gtk_clist_get_row_data (clist1, row));

		/* if this is moving values IN, append it
		 * otherwise, remove */
		if (in) {
			self->_priv->values = g_list_append
				(self->_priv->values, g_strdup (value));
		} else {
			GList *li;
			for (li = self->_priv->values;
			     li != NULL;
			     li = li->next) {
				char *val = li->data;
				if (strcmp (val, value) == 0) {
					li->data = NULL;
					g_free (val);
					self->_priv->values =
						g_list_remove_link
						(self->_priv->values,
						 li);
					g_list_free_1 (li);
					break;
				}
			}
		}

		new_row = gtk_clist_append (clist2, text);
		gtk_clist_set_row_data_full
			(clist2, new_row,
			 g_strdup (pong_sure_string (value)),
			 (GtkDestroyNotify)g_free);

		gtk_clist_remove (clist1, row);

		changed (self);
	}}
#line 795 "pong-list-entry.c"
#undef __GOB_FUNCTION__

#line 470 "pong-list-entry.gob"
static void 
pong_list_entry_move_items (PongListEntry * self, GtkCList * clist1, GtkCList * clist2, gboolean in)
#line 801 "pong-list-entry.c"
{
#define __GOB_FUNCTION__ "Pong:List:Entry::move_items"
#line 470 "pong-list-entry.gob"
	g_return_if_fail (self != NULL);
#line 470 "pong-list-entry.gob"
	g_return_if_fail (PONG_IS_LIST_ENTRY (self));
#line 470 "pong-list-entry.gob"
	g_return_if_fail (clist1 != NULL);
#line 470 "pong-list-entry.gob"
	g_return_if_fail (GTK_IS_CLIST (clist1));
#line 470 "pong-list-entry.gob"
	g_return_if_fail (clist2 != NULL);
#line 470 "pong-list-entry.gob"
	g_return_if_fail (GTK_IS_CLIST (clist2));
#line 816 "pong-list-entry.c"
{
#line 474 "pong-list-entry.gob"
	
		while (clist1->selection != NULL) {
			int row = GPOINTER_TO_INT (clist1->selection->data);

			move_item (self, clist1, row, clist2, in);
		}
	}}
#line 826 "pong-list-entry.c"
#undef __GOB_FUNCTION__

#line 482 "pong-list-entry.gob"
static void 
pong_list_entry_move_items_in (PongListEntry * self)
#line 832 "pong-list-entry.c"
{
#define __GOB_FUNCTION__ "Pong:List:Entry::move_items_in"
#line 482 "pong-list-entry.gob"
	g_return_if_fail (self != NULL);
#line 482 "pong-list-entry.gob"
	g_return_if_fail (PONG_IS_LIST_ENTRY (self));
#line 839 "pong-list-entry.c"
{
#line 484 "pong-list-entry.gob"
	
		move_items (self,
			    GTK_CLIST (self->_priv->origin_clist),
			    GTK_CLIST (self->_priv->destination_clist),
			    TRUE /*in*/);
	}}
#line 848 "pong-list-entry.c"
#undef __GOB_FUNCTION__

#line 491 "pong-list-entry.gob"
static void 
pong_list_entry_move_items_out (PongListEntry * self)
#line 854 "pong-list-entry.c"
{
#define __GOB_FUNCTION__ "Pong:List:Entry::move_items_out"
#line 491 "pong-list-entry.gob"
	g_return_if_fail (self != NULL);
#line 491 "pong-list-entry.gob"
	g_return_if_fail (PONG_IS_LIST_ENTRY (self));
#line 861 "pong-list-entry.c"
{
#line 493 "pong-list-entry.gob"
	
		move_items (self,
			    GTK_CLIST (self->_priv->destination_clist),
			    GTK_CLIST (self->_priv->origin_clist),
			    FALSE /*in*/);
	}}
#line 870 "pong-list-entry.c"
#undef __GOB_FUNCTION__


#if (!defined __GNUC__) || (defined __GNUC__ && defined __STRICT_ANSI__)
/*REALLY BAD HACK
  This is to avoid unused warnings if you don't call
  some method.  I need to find a better way to do
  this, not needed in GCC since we use some gcc
  extentions to make saner, faster code */
static void
___pong_list_entry_really_bad_hack_to_avoid_warnings(void)
{
	((void (*)(void))new)();
	((void (*)(void))new_with_options)();
	((void (*)(void))changed)();
	((void (*)(void))get_value)();
	((void (*)(void))set_value)();
	((void (*)(void))add_options)();
	((void (*)(void))move_item)();
	((void (*)(void))move_items)();
	((void (*)(void))move_items_in)();
	((void (*)(void))move_items_out)();
	___pong_list_entry_really_bad_hack_to_avoid_warnings();
}
#endif /* !__GNUC__ || (__GNUC__ && __STRICT_ANSI__) */


#line 501 "pong-list-entry.gob"

static gboolean
is_string_in_list (const GList *list, const char *string)
{
	g_return_val_if_fail (string != NULL, FALSE);

	while (list != NULL) {
		if (list->data != NULL &&
		    strcmp (string, list->data) == 0)
			return TRUE;

		list = list->next;
	}

	return FALSE;
}

static gboolean
is_string_in_option_list (const GList *list, const char *string)
{
	g_return_val_if_fail (string != NULL, FALSE);

	while (list != NULL) {
		PongOption *opt = list->data;
		if (opt != NULL &&
		    opt->value != NULL &&
		    strcmp (string, opt->value) == 0)
			return TRUE;

		list = list->next;
	}

	return FALSE;
}

static int
find_value_in_clist (GtkCList *clist, GConfValue *value)
{
	GList *li;
	int i;

	for (i = 0, li = clist->row_list; li != NULL; i++, li = li->next) {
		GtkCListRow *row = li->data;
		char *string = row->data;

		if (pong_string_value_equal (string, value))
			return i;
	}

	return -1;
}

static gboolean
is_value_in_value_list (const GSList *list, const char *string)
{
	const GSList *li;

	for (li = list; li != NULL; li = li->next) {
		GConfValue *value = li->data;

		if (pong_string_value_equal (string, value))
			return TRUE;
	}

	return FALSE;
}


#line 967 "pong-list-entry.c"
