/*                                            
Language.cc
*/

#include "Language.h"

Language::Language (int aLANGUAGE) 
  {
  if (aLANGUAGE > MAX_LANG) LANGUAGE = LANG_DEFAULT;
  else LANGUAGE = aLANGUAGE;
  }

Language::Language (const char *pcLANGUAGE) 
  {
  xstrncpy (stLANGUAGE, CMAXLONGLANGUAGE, pcLANGUAGE); xucase (stLANGUAGE);
  xstrncpy (stlLANGUAGE, CMAXLONGLANGUAGE, stLANGUAGE); xlcase (stlLANGUAGE);
  if      (strcmp (stLANGUAGE, "SPA") == 0)  LANGUAGE = LANG_SPANISH;
  else if (strcmp (stLANGUAGE, "ENG") == 0)  LANGUAGE = LANG_ENGLISH;
  else if (strcmp (stLANGUAGE, "CAT" ) == 0) LANGUAGE = LANG_CATALA;
  else if (strcmp (stLANGUAGE, "VAL" ) == 0) LANGUAGE = LANG_CATALA;
  else if (strcmp (stLANGUAGE, "EUS" ) == 0) LANGUAGE = LANG_EUSKERA;
  else LANGUAGE = LANG_DEFAULT;
  }
  
Language::~Language()
  {
  
  }
  
void Language::setLang (const char *pcLANGUAGE)
  {              
  xstrncpy (stLANGUAGE, CMAXLONGLANGUAGE, pcLANGUAGE); xucase (stLANGUAGE);
  xstrncpy (stlLANGUAGE, CMAXLONGLANGUAGE, stLANGUAGE); xlcase (stlLANGUAGE);
  if      (strcmp (stLANGUAGE, "SPA") == 0)  LANGUAGE = LANG_SPANISH;
  else if (strcmp (stLANGUAGE, "ENG") == 0)  LANGUAGE = LANG_ENGLISH;
  else if (strcmp (stLANGUAGE, "CAT" ) == 0) LANGUAGE = LANG_CATALA;
  else if (strcmp (stLANGUAGE, "VAL" ) == 0) LANGUAGE = LANG_CATALA;
  else if (strcmp (stLANGUAGE, "EUS" ) == 0) LANGUAGE = LANG_EUSKERA;
  else LANGUAGE = LANG_DEFAULT;
  }
  
int Language::getLang (void)
  {
  return LANGUAGE;
  }  

const char *Language::getStLang (void)
  {
  return stlLANGUAGE;
  }
  
const char *Language::get (int WHAT)
  {
  switch (LANGUAGE)
    {
    case LANG_ENGLISH: return getStringEnglish (WHAT); 
    case LANG_SPANISH: return getStringSpanish (WHAT); 
    case LANG_CATALA : return getStringCatala (WHAT); 
    case LANG_EUSKERA : return getStringEuskera (WHAT); 
    default: return getStringEnglish (WHAT); 
    }
  }
  
const char *Language::getDescriptionLanguage (int WHAT)
  {
  switch (WHAT)
    {
    case LANG_ENGLISH: return "English";
    case LANG_SPANISH: return "Espa&ntilde;ol";
    case LANG_CATALA : return "Valenci&agrave;";
    case LANG_EUSKERA: return "Euskera";
    default: return "Unknown";
    }
  }  

const char *Language::getStringEnglish (int WHAT)
  {
  switch (WHAT)
    {
    case PREFIX_FORWARD:   return "(Fwd) ";
    case PREFIX_REPLY:     return "Re: ";

    case MSG_CONNREFUSED:       return "Connection refused!";
    case MSG_CANRECONNECTHERE:  return "Press here to reconnect."; 
    case MSG_SERVERISDOWN:      return "Server is down.";
    case MSG_PERHAPSTIMEOUT:    return "Perhaps a timeout?";
    case MSG_CONF_DELETEMAILBOX:return "Are you sure you want to delete mailbox '%s'?";
    case MSG_CONF_CLEARMAILBOX: return "Are you sure you want to empty mailbox '%s'?";    
    case MSG_CONF_EXPUNGE:      return "OK to expunge mailbox?";
    case MSG_CONF_LOGOUT:       return "OK to logout?";
    case MSG_CONF_DBEXPUNGE:    return "OK to expunge the DataBase?";
    case MSG_SEND_OK:           return "Message sent OK.";
    case MSG_ERR_SAVE_SENTMAIL: return "Message sent OK but error saving in sent-mail mailbox. Perhaps Quota exceded?";    
    case MSG_SAVED_SENTMAIL:    return "the message was saved in ";   
    case MSG_SEND_ERR:          return "Problems sending message. Message not sent!";
    case MSG_CANCELMSG:         return "Send message CANCELLED!";
    case MSG_SAVEOPTIONS:       return "Options SAVED!";
    case MSG_CANCEL:            return "Saving CANCELLED!";
    case MSG_ERR_SAVEOPTIONS:   return "ERROR saving Options!";
    case MSG_ADDBOOK:           return "Browsing Addressbook";
    case MSG_SAVEADDBOOK:       return "Addressbook SAVED!";
    case MSG_ERR_SAVEADDBOOK:   return "ERROR saving Addressbook!";
    case MSG_MSGSPURGED_0:      return "No message PURGED.";    
    case MSG_MSGSPURGED:        return "%d message PURGED!";
    case MSG_MSGSPURGED_S:      return "%d messages PURGED!";    
    case MSG_MAILBOXCHANGED:    return "Open mailbox '%s'";
    case MSG_MAILBOXCREATED:    return "New Mailbox Created!";
    case MSG_MAILBOXDELETED:    return "Mailbox Deleted!";
    case MSG_MAILBOXRENAMED:    return "Mailbox name Changed!";
    case MSG_MOVEDMESSAGES:     return "%d message moved to '%s'.";
    case MSG_MOVEDMESSAGES_S:   return "%d messages moved to '%s'.";
    case MSG_COPYMESSAGES:      return "%d message copied to '%s'.";
    case MSG_COPYMESSAGES_S:    return "%d messages copied to '%s'.";
    case MSG_INVALIDPAGE:       return "Incorrect operation. Please refresh the Index screen.";
    case MSG_SHOWATTACHS:       return "Editing attachments";
    case MSG_SAVEATTACHS:       return "Attachments SAVED!";
    case MSG_ERASEATTACHS:      return "Selected attachments deleted!";
    case MSG_ERR_SAVEATTACHS:   return "ERROR saving Attachments!";
    case MSG_AB_EDITENTRY:      return "Editing entry";
    case MSG_AB_SAVEENTRY:      return "Entry SAVED!";
    case MSG_AB_DELEENTRY:      return "Entries DELETED!";
    case MSG_AB_ADDTO:          return "Addresses Added to TO field of composed message";
    case MSG_AB_ADDCC:          return "Addresses Added to CC field of composed message";
    case MSG_AB_ADDBCC:         return "Addresses Added to BCC field of composed message";
    case MSG_NO_ENTRIES_MARKED: return "No selected entries. NO action done!";
    case MSG_FLAGS_CHANGED:     return "%d message marked as %s.";
    case MSG_FLAGS_CHANGED_S:   return "%d messages marked as %s.";
    case MSG_FIELD_TO_EMPTY:    return "Field 'To' is empty.";
    case MSG_FIELD_SUBJ_EMPTY:  return "Field 'Subject' is empty.";    
    case MSG_COMPOSE_TIMEOUT:   return "WARNING: Use the 'Save' button from time to time. If you leave it longer than than 20 minutes, you will lose what you have written!";
    case MSG_TOO_MAX_CONN:      return "Sorry. Too many simultaneous users. Please try later.";
    case MSG_TOO_MAX_TRY_CONN:  return "Sorry. You have repeatedly pressed the button.";
    case MSG_ADDRESS_LINE_CUT:  return "WARNING: Reached Max line length. Can't add all of the addresses.";
    case MSG_MIN_TIMEBETWCONNS: return "Connection retried before min time. Please press \"Login\" button only once.";
    case MSG_ERR_RELOAD_ATTACHS:return "Incorrect number of attachments. Perhaps you have tried to send one attachment already sent.";
    case MSG_NOATTACHSERASED:   return "NO DELETED ATTACHMENTS!";
    case MSG_NOATTACHSSAVED:    return "NO SAVED ATTACHMENTS!";
    case MSG_NO_ELEMENTS:       return "No elements.";
    case MSG_BADCOOKIE:         return "Security problem! Access logged.";
    case MSG_DEBUG:             return "Debug Page";
    case MSG_MALFORMED_MESSAGE: return "<FONT color=\"#FF0000\"><BLINK>[ Empty message possibly malformed. Use \"Download message\" to see raw text. ]</BLINK></FONT>";
    case MSG_MSGSFOUND_0:       return "No message FOUND.";    
    case MSG_MSGSFOUND:         return "%d message FOUND.";
    case MSG_MSGSFOUND_S:       return "%d messages FOUND.";    
    case MSG_MSGS_SORTED:       return "Messages sorted!";
    case MSG_GO_TO_DISABLED:    return "WARNING: Your session will end in 5 minutes unless you send the message or click the 'Save' button to save your text and continue writing.";
    case MSG_AB_ADDFIELDS:      return "Addresses added to fields of composed message: %d.";
    case MSG_NNTP_SEND_WARNING: return "WARNING: News messages colud be seen by thousands of people. Be careful with your post!";
    case MSG_MANAGE_NNTPGROUPS: return "Modifying my subscriptions";
    case MSG_NNTPGROUPS_FOUND:  return "Forums found: %d";         
    case MSG_MAX_NNTPGROUPS_FOUND:return "Maximum number of Forums found: %d";    
    case MSG_NNTPGROUPS_ADDED:  return "Forums added: %d";
    case MSG_NEW_TO_FORUMS:     return "Change to other Forum with the drop-down right list or setting \"Options/Manage Subscribed Forums\""; 
    case MSG_INVALIDCOMMAND:    return "Incorrect command.";    
    case MSG_CHANGEPW_OK:       return "Password changed Ok.";
    case MSG_CONF_DELETEITEMS:  return "Ok to full delete the selected files and directories (recursively)?";
    case MSG_FILESDELETED:      return "%d file DELETED!";    
    case MSG_FILESDELETED_S:    return "%d files DELETED!";
    case MSG_FILESCOPY:         return "Objects copied";
    case MSG_FILESCUT:          return "Objects cut";    
    case MSG_FILESPASTED:       return "Objects pasted";        
    case MSG_FILERENAMED_OK:    return "Object renamed.";
    case MSG_FILESAVED_OK:      return "File saved!";    
    case MSG_FILESORT_OK:       return "Objects sorted!";
    case MSG_FILECREATED_OK:    return "Object created!";
    case MSG_DISKCHANGED_OK:    return "Disk changed!";
    case MSG_NEED_PASSWORD_SERVICE: return "To access to the service '%s', Postman need your password:"; 
    case MSG_NEWMSGS_0:         return "No new messages";
    case MSG_NEWMSGS_1:         return "You have 1 message not read";    
    case MSG_NEWMSGS_n:         return "You have %ld messages not read";
    case MSG_RECONNECT_NOTALLOWED: return "Reconnect to that service is not allowed!";
    case MSG_RECORDSDELETED:    return "%d record marked as %s.";
    case MSG_RECORDSDELETED_S:  return "%d records marked as %s.";
    case MSG_RECORDSPURGED_0:   return "No records PURGED.";    
    case MSG_RECORDSPURGED:     return "%d record PURGED!";
    case MSG_RECORDSPURGED_S:   return "%d records PURGED!";    
    case MSG_RECORDSFOUND_0:    return "No record FOUND.";    
    case MSG_RECORDSFOUND:      return "%d record FOUND.";
    case MSG_RECORDSFOUND_S:    return "%d records FOUND.";    
    case MSG_CONF_DBDELETE:     return "Ok to full delete the DataBase?";
    case MSG_RECORDS_ALL_SHOWN: return "All records shown";
    case MSG_SHOWOPTIONS:       return "Editing options";  
    case MSG_SHOWOPTIONS_CCLIENT: return "Editing Mail options";  
    case MSG_SHOWOPTIONS_NNTP:    return "Editing Forums options";  
    case MSG_SHOWOPTIONS_APPEARANCE: return "Editing Appearance options";
    case MSG_CONF_FILTERSDELETE :return "Ok to delete the selected filters?";
    case MSG_INSERTSPAMFILTER:  return "I will make a filter based in CONTENT for avoid you the reception of publicity nonwished or Spam. "
                                       "The marked messages as Spam will be moved to the folder INBOX.spam that will be created automatically. "
                                       "Remember to review it periodically and to clean it.";
    case MSG_INSERTSPAMFILTER2: return "I will make a filter based in RBL (Relay Blocking List) for avoid you the reception of publicity nonwished or Spam. "
                                       "The marked messages as Spam will be moved to the folder INBOX.spam that will be created automatically. "
                                       "Remember to review it periodically and to clean it.";                                       
    case MSG_CONFDELETEEVENT:   return "Ok to delete the selected Event? ";

    case L_USER:           return "User";
    case L_PASSWORD:       return "Password";
    case L_LOGIN:          return "Login";
    case L_CLEAR:          return "Clear";
    case L_LOGOUT:         return "Logout";
    case L_INDEXMAILBOX:   return "<B>Mailbox '%s' with %ld messages.</B>";
    case L_INDEXMAILBOX2:  return "Mailbox index";
    case L_INDEXMAILBOX3:  return "<B>Mailbox '%s' with %ld messages (%s).</B>";
    case L_INDEXMAILBOX4:  return "<B>Current mailbox: '%s' (%ld messages).</B>";    
    case L_CHOOSELANGUAGE: return "Elige idioma/Tria llenguatge/Choose language";
    case L_COPYRIGHT:      return "&copy;Universitat de Val&egrave;ncia, 2000-2003";
    case L_MESSAGES:       return "messages";
    case L_NEXTPAGE_ACT:   return "Next Page";
    case L_NEXTPAGE_INA:   return "Next Page";
    case L_PREVPAGE_ACT:   return "Previous Page";
    case L_PREVPAGE_INA:   return "Previous Page";
    case L_FIRSTPAGE_ACT:  return "First Page";
    case L_FIRSTPAGE_INA:  return "First Page";
    case L_LASTPAGE_ACT:   return "Last Page";
    case L_LASTPAGE_INA:   return "Last Page";
    case L_MESSAGE:        return "<B>Message %ld/%ld (%s).</B>";
    case L_MESSAGE2:       return "Browsing message:";
    case L_DUMPFULLMSG:    return "Download message";
    case L_NOSUBJECT:      return "(No subject)";
    case L_NEXTMSG:        return "Next message";
    case L_PREVMSG:        return "Previous message";
    case L_NEXTMSG_INA:    return "Next message";
    case L_PREVMSG_INA:    return "Previous message";
    case L_ERROR:          return "Error";
    case L_STRUCTMIME:     return "MIME structure of the message (attachments):";
    case L_EXECUTE:        return "Execute";
    case L_DELETED:        return "Deleted";
    case L_EXPUNGE:        return "Expunge";
    case L_UNDELETED:      return "Undeleted";
    case L_HELP:           return "Help";
    case L_COMPOSEMSG:     return "Compose";
    case L_MAILBOXES:      return "Mailboxes";
    case L_CHANGEMAILBOX:  return "Open mailbox";
    case L_CREATEMAILBOX:  return "Create mailbox";
    case L_DELETEMAILBOX:  return "Delete mailbox";
    case L_RENAMEMAILBOX:  return "Rename mailbox";
    case L_ANSWEREDMSG:    return "Answered";    
    case L_UNANSWEREDMSG:  return "Unanswered";    
    case L_FLAGGEDMSG:     return "Important";    
    case L_UNFLAGGEDMSG:   return "NOT important";    
    case L_SEENMSG:        return "NOT new";    
    case L_UNSEENMSG:      return "New";    
    case L_MOVEMSG:        return "Move messages to";
    case L_COPYMSG:        return "Copy messages to";
    case L_CANCEL:         return "Cancel";
    case L_CONFIRM:        return "Confirm";
    case L_TO:             return "To: ";
    case L_CC:             return "CC: ";
    case L_BCC:            return "BCC: ";
    case L_TO0:            return "To";
    case L_CC0:            return "Cc";
    case L_BCC0:           return "Bcc";    
    case L_SUBJECT:        return "Subject: ";
    case L_TEXTTOSEND:     return "Text to send:";
    case L_CANCELMSG:      return "Cancel";
    case L_SENDMSG:        return "Send";
    case L_ATTACHMSG:      return "Attachments";
    case L_REPLYMSG:       return "Reply";
    case L_REPLYALLMSG:    return "Reply to All";    
    case L_FORWARDMSG:     return "Forward";
    case L_FROM:           return "From: ";
    case L_DATE:           return "Date: ";
    case L_REPLYTO:        return "Reply-to: ";
    case L_SIGNATURE:      return "Signature";
    case L_SHOWOPTIONS:    return "Options";
    case L_ADDBOOK:        return "Addressbook";
    case L_SAVE:           return "Save";
    case L_MSGSPERINDEXPAGE:return "Number of messages shown per Index Page: ";
    case L_INSIGNINNEWMSG: return "Sign new messages";
    case L_ATTACHSHOWED:   return "Attachment shown below";
    case L_PERSONALNAME:   return "Full personal name: ";
    case L_NOFROM:         return "(No from)";
    case L_SAVEMSGSENTMAIL:return "Save sent messages in folder &nbsp;";
    case L_ATTACH_NEW:     return "Attach another file";
    case L_FILE:           return "File";
    case L_NO_ATTACHS:     return "(No attachments)";
    case L_DOATTACH:       return "Attach!";
    case L_DETACH:         return "Detach";
    case L_AB_NICKNAME:    return "Nickname";
    case L_AB_FULLNAME:    return "Full name";
    case L_AB_ADDRESSES:   return "Addresses";
    case L_AB_FCC:         return "Fcc";
    case L_AB_COMMENTS:    return "Comments";
    case L_AB_EDITENTRY:   return "Edit entry";
    case L_AB_NEWENTRY:    return "Add new entry";
    case L_AB_NEWENTRY_S:  return "New";
    case L_DELETE:         return "Delete";
    case L_NUMOFENTRIES:   return "Number of entries";
    case L_BACK:           return "Back";
    case L_CLEANALL:       return "Clean all";
    case L_SAVEADDRESS:    return "Save Address";
    case L_NUMBER:         return "Num.:";
    case L_FLAGS:          return "Flags:";
    case L_SIZE:           return "Size:";
    case L_FLAG_DELETED:   return "Deleted";
    case L_FLAG_ANSWERED:  return "Answered";
    case L_FLAG_FLAGGED:   return "Important!";
    case L_FLAG_NEW:       return "New";
    case L_FLAG_UNSEEN:    return "New";
    case L_FLAG_COPIED:    return "Copied";
    case L_FLAG_UNCOPIED:  return "Uncopied";    
    case L_MARK:           return "Mark";
    case L_MSGS_AS:        return " messages as ";
    case L_PRESS_TO_INDEX: return "Return to the message index";
    case L_SORT:           return "Sort";
    case L_MSGS_SHOWN:     return "<B> Shown %ld to %ld.</B>";
    case L_LEX_TO:         return " to ";
    case L_DELNEXTMSG:     return "Delete";
    case L_UNDELNEXTMSG:   return "Undelete";
    case L_ABOUT:          return "About";  
    case L_REPLYFROM:      return "Reply to 'From:' and not to 'Reply-to:'.";
    case L_FORWATTACHS:    return "Include attachments in Forward.";
    case L_SIZEWRITEAREA:  return "Size (rows / columns) of the text area in compose message screen.";
    case L_NEXTMSGSHOWN:   return "The next message is shown.";
    case L_LASTMSGSHOWN:   return "Last message is shown.";
    case L_NUMATTACHSHOW:  return "<B>Attachment shown: %s</B>";
    case L_DOWNLOADMAILBOX:return "Download Full Mailbox";
    case L_EMPTY_IMAPSERVER:return "Empty IMAP server field!";
    case L_NOTALLOWED_IMAPSERVER: return "That IMAP server is not allowed!";
    case L_AB_DUMP:        return "Dump";
    case L_AB_DUMP_S:      return "Dump";
    case L_TRUNCATELENGTHREADINGMSG: return "Split reading message lines longer than ";
    case L_SKIN:           return "Skin";
    case L_SECURITYPROBLEM:return "Security problem";
    case L_REFRESH:        return "Refresh";
    case L_FLAG_SEARCHED:  return "Found in previous search";
    case L_SEARCH:         return "Search in";
    case L_REFRESHTIME:    return "Time in minutes to auto-refresh the index page (0 for no refresh):";
    case L_SEARCH_SUBJECT: return "Subject";
    case L_SEARCH_FROM:    return "From";
    case L_SEARCH_BODY:    return "Body";
    case L_SEARCH_ALL:     return "All";
    case L_CONFIRMPURGE:   return "Confirm Purge Mailbox";
    case L_CONFIRMLOGOUT:  return "Confirm Logout";
    case L_FLAG_UNDELETED: return "Undeleted";
    case L_FLAG_UNANSWERED:return "Unanswered";
    case L_FLAG_UNFLAGGED: return "No important!";
    case L_FLAG_UNNEW:     return "No New";
    case L_FLAG_SEEN:      return "Seen";
    case L_FLAG_UNSEARCHED:return "No found";                                  
    case L_SEARCHEDMSG:    return "1 message added to the list of found messages.";
    case L_UNSEARCHEDMSG:  return "1 message deleted from the list of found messages.";    
    case L_DUMPFULLHEADER: return "Download header";     
    case L_ADDADDRESS_TO:  return "Add selected entries to field 'TO'";
    case L_ADDADDRESS_CC:  return "Add selected entries to field 'CC'";
    case L_ADDADDRESS_BCC: return "Add selected entries to field 'BCC'";        
    case L_DELADDRESSES:   return "Delete selected entries";    
    case L_ADDADDRESS_FIELD: return "Add selected addresses to message";
    case L_NNTPGROUP:      return "Forums:";    
    case L_SENDTONNTPGROUP:return "Send to Forum";
    case L_COMPOSEMSGNNTP: return "Compose to Forum";
    case L_NNTPSERVER:     return "Forums Server:";
    case L_SUBSCRIBEDGROUPS:return "Subscribed Forums:";
    case L_MANAGE_NNTPGROUPS:return "Manage Subscribed Forums";
    case L_LIST_EMPTY:     return "----------------- [List is empty] -----------------";
    case L_NNTP_LISTSEARCH:return "Search in All Forums List";
    case L_GROUPSTOADD:    return "Forums to add:";
    case L_ADDSELECTEDGROUPS:return "Add selected Forums";
    case L_DUMPFULLLIST:   return "Dump full Forums List";
    case L_FORCEDGROUPS:   return "Permanent Forums:";
    case L_DISPLAY_UUENCODED:return "[Decode and display '%s']";
    case L_GOSELECTEDGROUP:return "Open selected Forum";
    case L_OP_SHOWCLOCK:   return "Display Date and Time.";
    case L_ADD_MORE_FORUMS:return "... (More Forums) ...";
    case L_SORTBYTHREADS:  return "Thread:";    
    case L_CHANGEPASSWORD:    return "Change Password";
    case L_PASSWORD_OLD:      return "Old password";
    case L_PASSWORD_NEW1:     return "New password";
    case L_PASSWORD_NEW2:     return "Retype new password";
    case L_PRESS_TO_ROOTPAGE: return "Return to the begin page";
    case L_FINGER:         return "Finger";
    case L_FILEBROWSER:    return "File Browser";
    case L_FOLDER:         return "Directory";
    case L_PARENTFOLDER:   return "Parent Directory";
    case L_CURRENTFOLDER:  return "Current Directory";
    case L_EDIT:           return "Edit";
    case L_CREATE:         return "Create";
    case L_COPY:           return "Copy";
    case L_CUT:            return "Cut";
    case L_PASTE:          return "Paste";
    case L_LOAD:           return "Load";
    case L_RENAME:         return "Rename";
    case L_ROOT:           return "Begin&nbsp;Page";
    case L_MAIL:           return "Mail";
    case L_NNTP:           return "Forums";
    case L_POPPASS:        return "Change Password";
    case L_FORWARDMAIL:    return "Forwarding mail";  
    case L_CURRENTFORWARDS:return "Current Forwards:";
    case L_FORWARD_ERASE:  return "Erase ALL";
    case L_QUOTAUSAGE:     return "Quota usage";
    case L_RENAME_TO:      return "Rename '%s' to "; 
    case L_CURRENTDISK:    return "Current disk";
    case L_CHANGE_DISK:    return "Change to disk";
    case L_FOLDER_COPY:    return "Copied Folder";
    case L_FOLDER_CUT:     return "Cut Folder";
    case L_FILE_COPY:      return "Copied File";
    case L_FILE_CUT:       return "Cut File";
    case L_TOTAL_SIZE:     return "Total size";
    case L_SECVIRTUAL:     return "Secretaria Virtual";
    case L_SERVICE:        return "Service";
    case L_MAIL_DESCRIPTION       : return "Mail";
    case L_FILEBROWSER_DESCRIPTION: return "File Explorer"; 
    case L_FINGER_DESCRIPTION     : return "Fingering Info"; 
    case L_FORWARDMAIL_DESCRIPTION: return "Forwarding messages"; 
    case L_MAIN_DESCRIPTION       : return "Main"; 
    case L_POPPASS_DESCRIPTION    : return "Changing your password"; 
    case L_SECVIRTUAL_DESCRIPTION : return "Secretaria Virtual"; 
    case L_SYNC                   : return "Sync";
    case L_DATABASES              : return "Databases";
    case L_DATABASES_DESCRIPTION  : return "Databases";
    case L_DISPLAY                : return "Display";
    case L_UNDELETE               : return "Undelete";
    case L_DB_INDEXHEADER         : return "%s, Records: %d, Size: %d bytes";
    case L_DB_CHANGE              : return "Open";
    case L_DUMP                   : return "Dump";    
    case L_DB_MYNEWDB             : return "My New Database";
    case L_LEX_AS                 : return "as";
    case L_IMPORT                 : return "Import";
    case L_EXPORT                 : return "Export";    
    case L_LEX_OF                 : return "of";
    case L_NONE_A                 : return "None";
    case L_DEFINE                 : return "Define";
    case L_FIELD_ADD              : return "Add Field";
    case L_FIELD_DEL              : return "Delete Field";
    case L_DATABASE               : return "Database";
    case L_FIELD_NAME             : return "Name";
    case L_FIELD_ORDER            : return "Order";
    case L_FIELD_TYPE             : return "Type";
    case L_FIELD_MAXLENGTH        : return "Maximum Length";
    case L_FIELD_DISPLAYLENGTH    : return "Display Length";
    case L_FIELD_INDEXLENGTH      : return "Index Length";
    case L_FIELD_LABEL            : return "Label";
    case L_FIELD_DEFAULT          : return "Default";
    case L_FIELD_COULDBENULL      : return "Could be null";
    case L_FIELD_OPTIONAL1        : return "Optional 1";
    case L_FIELD_OPTIONAL2        : return "Optional 2";
    case L_FIELD_OPTIONAL3        : return "Optional 3";
    case L_FIELD_OPTIONAL4        : return "Optional 4";
    case L_DELETESEARCH           : return "Delete Search";
    case L_DISPLAYPERSONALINFO    : return "Display Personal Information at startup";
    case L_USERACCOUNTS           : return "User accounts";
    case L_USERACCOUNTS_DESCRIPTION:return "User accounts";
    case L_CONFIG                 : return "Configuration";
    case L_CONFIG_DESCRIPTION     : return "Configuration";
    case L_APPEARANCE             : return "Appearance";
    case L_SIEVE                  : return "Sieve";
    case L_SIEVE_DESCRIPTION      : return "Sieve";
    case L_MAIN                   : return "Main";
    case L_FILTERS                : return "Filters";
    case L_NAME                   : return "Name";
    case L_LEX_THEN               : return "then";
    case L_SIEVE_IF_IN_THE_MAIL   : return "If in the message...";
    case L_VACATION               : return "Absence";    
    case L_VACATION_TEXT          : return "Notification to send";
    case L_VACATION_DAYS2REPEAT   : return "Days before repeat notification";
    case L_VACATION_ADDRESSES     : return "Absence addresses";
    case L_ACTIVED                : return "Actived";
    case L_UNACTIVED              : return "Unactived";
    case L_REJECT                 : return "Reject";
    case L_REJECTEDTEXT           : return "(Rejected Text)";
    case L_SUBJECT_CONTAINS       : return "the \"Subject:\" contains ";
    case L_FROM_CONTAINS          : return "and the \"From:\" contains ";
    case L_TO_CONTAINS            : return "and the \"To:\" contains ";
    case L_SIZE_IS_OVER           : return "and the size is over ";
    case L_HEADER_CONTAINS        : return "and the header ";
    case L_CONTAINS               : return " contains ";
    case L_VACATION_ADD_EXPLICAT  : return "(Addresses where your mail is sent. Upper and lower case are IMPORTANT.)";
    case L_UP                     : return "Up";
    case L_DOWN                   : return "Down";
    case L_OP_SHOWICONSLABELS     : return "Show icons labels";
    case L_ICONSSIZE              : return "Icons size";
    case L_SMALL                  : return "Small";
    case L_BIG                    : return "Big";
    case L_MEDIUM                 : return "Medium";
    case L_INSERTSPAWNFILTER      : return "By Contents";
    case L_INSERTSPAWNFILTER2     : return "By RBL";    
    case L_SERVICEPW_INCORRECT    : return "The password is not valid for this Service.";
    case L_CALENDAR               : return "Calendar";
    case L_CALENDAR_DESCRIPTION   : return "Calendar";
    case L_CHANGE                 : return "Change";
    case L_WEEK                   : return "Week";
    case L_TODAY                  : return "Today";    
    case L_HOUR                   : return "Hour";
    case L_TITLE                  : return "Title";
    case L_DESCRIPTION            : return "Description";
    case L_STATUS                 : return "Status";
    case L_STATUS_FINISHED        : return "Finished";
    case L_STATUS_OPEN            : return "Open";
    case L_STATUS_DELAYED         : return "Delayed";
    case L_PRIORITY               : return "Priority";
    case L_PRIORITY_LOW           : return "Low";
    case L_PRIORITY_CURRENT       : return "Current";
    case L_PRIORITY_IMPORTANT     : return "Important";
    case L_PRIORITY_VERYIMPORTANT : return "Very Important";
    case L_TYPE                   : return "Type";
    case L_TYPE_CELEBRATION       : return "Celebration";
    case L_TYPE_MEETING           : return "Meeting";
    case L_TYPE_LAUNCH            : return "Launch";
    case L_TYPE_OTHER             : return "Other";
    case L_ADD                    : return "Add";
    case L_YESTERDAY              : return "Yesterday";
    case L_TOMORROW               : return "Tomorrow";
    case L_YEAR                   : return "Year";
    case L_DAY                    : return "Day";
    case L_LEX_SINCE              : return "Since";
    case L_CLEARMAILBOX           : return "Empty mailbox";
    case L_CREATEFILTER           : return "Create predefined Anti-Spam filter: ";
    case L_DOTLEARN               : return "Aula Virtual";
    case L_DOTLEARN_DESCRIPTION   : return "Resources for e-learning";
    case L_MODERATORS             : return "Moderators";
           
    case TIT_COMPOSEMSG:   return "Composing a new message";
    case TIT_HOMEPAGE:     return "University of Valencia: Email Service";    
    case TIT_CONFIRMACTION:return "Confirm action";
    case TIT_INDEXMAILBOX: return "Mailbox index";
    case TIT_MAILBOXES:    return "Operating with mailboxes";
    case TIT_MESSAGEHEADER:return "Browsing message";
    case TIT_REPLYMSG:     return "Replying to message";
    case TIT_REPLYALLMSG:  return "Replying to All";    
    case TIT_FORWARDMSG:   return "Forwarding message";
    case TIT_SHOWOPTIONS:  return "Editing your options";
    case TIT_ADDBOOK:      return "Browsing your Addressbook";
    case TIT_INVALIDPAGE:  return "Incorrect page";
    case TIT_SHOWATTACHS:  return "Working with message attachments";
    case TIT_BADCOOKIE:    return "Security Problem!";
    case TIT_SHOWHEADERS:  return "Full headers"; 
    case TIT_REPLYGROUP:   return "Replying to Forum";
    case TIT_COMPOSEMSGNNTP:return "Compose to Forum";    
    case TIT_SHOWNNTPMANAGEGROUPS:return "Managing Forums";
    case TIT_INVALIDCOMMAND:return "Incorrect command.";    
    case TIT_SERVICES:      return "Services";
    case TIT_POPPASS_DISPLAYPAGE: return "Changing the password";
    case TIT_FINGER_DISPLAYPAGE:  return "Finger";
    case TIT_FILEBROWSER_DISPLAYPAGE: return "File Browser";
    case TIT_FILEBROWSER_EDITFILEPAGE: return "Editing File";
    case TIT_FORWARDMAIL_DISPLAYPAGE: return "Forwarding mail";
    case TIT_DATABASES_EDITRECORD:  return "Editing the Record";
    case TIT_DATABASES_INDEXPAGE: return "Index of Database";
    case TIT_DATABASES_DISPLAYRECORD:  return "Displaying the Record";
    case TIT_DATABASES_MAINPAGE:  return "Databases:";
    case TIT_DATABASES_DB_DEFINE: return "Define your own new database";
    case TIT_SIEVE_DISPLAYPAGE: return "Sieve";
    case TIT_CALENDAR_DISPLAYPAGE : return "Viewing the Calendar";
     
    case ERR_INV_CMD:        return "Incorrect command!";
    case ERR_INV_USER_PW:    return "Incorrect User/Password";   
    case ERR_INV_MAILBOX:    return "Incorrect mailbox: '%s'";
    case ERR_ISOPEN_MAILBOX: return "Mailbox is currently open: '%s'";    
    case ERR_INV_PARMS:      return "They lack data in the form.";
    case ERR_OPENCONN:       return "Opening connection with server";
    case ERR_CREAT_USERDIR:  return "Creating User directory";
    case ERR_CREAT_USERATTACHSDIR:return "Creating User Attachments Directory";
    case ERR_SENDING_MSG:    return "Sending message.";
    case ERR_AB_DELEENTRY:   return "Deleting entry";
    case ERR_MAXSIZEATT:     return "The maximum size of attachments is %ld bytes";
    case ERR_UNHANDLESIZEATTACH: return "Attachment size is too big! Can't handle this attachment.";
    case ERR_QUOTA_USAGE:    return "MESSAGE: Quota usage is %s.";
    case ERR_SERVERISDOWN:   return "Server is down.";
    case ERR_UUDECODING:     return "Decoding message.";
    case ERR_NNTP_NUM_SEL:   return "You have selected more than one Forum";
    case ERR_INV_SERVICE:    return "Incorrect service!";
    case ERR_SERVICE_NOTALLOWED: return "Service not allowed!";
    case ERR_FILE_EXISTS:      return "File exists";
    case ERR_FILE_INVALIDNAME: return "Wrong filename";
    case ERR_FILE_NO_EXISTS:   return "No such file";
    case ERR_FILE_CREATE:      return "Creating file";
    case ERR_FILE_WRITING:     return "Writing in file";
    case ERR_DIR_EXISTS:       return "Directory exists";
    case ERR_DIR_CREATE:       return "Creating directory";
    case ERR_DIR_OPEN:         return "Opening directory";
    case ERR_FILE_DELETING:    return "Deleting file";
    case ERR_MAXSIZEFILEUPLOAD:return "The maximum size for uploaded file is %ld bytes";     
    case ERR_CLIPBOARD_EMPTY:  return "Clipboard is empty";
    case ERR_SELECT_MORE_ONE:  return "There are more than one selected entry";    
    case ERR_FILE_RENAMING:    return "Renaming object";
    case ERR_FILE_COPYING:     return "Copying file";
    case ERR_FILE_MOVING:      return "Moving file";        
    case ERR_FILE_MOV_SAMESITE:return "Can not move it to the same path";
    case ERR_QUOTA_OVER:       return "Quota of disc overstep";
    case ERR_SERVICE_INITIALIZING: return "Initializing service";
    case ERR_CREAT_USERDATABASESDIR: return "Creating User Databases Directory";
    case ERR_FILTERALREADYEXISTS: return "That filter already exists.";

    case ALT_LOGO:         return "Logo";
    case ALT_NEXTPAGE_ACT: return "Next&nbsp;page";    
    case ALT_NEXTPAGE_INA: return "Next&nbsp;page";    
    case ALT_PREVPAGE_ACT: return "Previous&nbsp;page";    
    case ALT_PREVPAGE_INA: return "Previous&nbsp;page";
    case ALT_FIRSTPAGE_ACT:return "First&nbsp;page";
    case ALT_FIRSTPAGE_INA:return "First&nbsp;page";
    case ALT_LASTPAGE_ACT: return "Last&nbsp;page";
    case ALT_LASTPAGE_INA: return "Last&nbsp;page";
    case ALT_DUMPFULLMSG:  return "Download&nbsp;message";
    case ALT_NEXTMSG:      return "Next&nbsp;message";
    case ALT_PREVMSG:      return "Previous&nbsp;message";
    case ALT_NEXTMSG_INA:  return "Next&nbsp;message";
    case ALT_PREVMSG_INA:  return "Previous&nbsp;message"; 
    case ALT_HELP:         return "Help";   
    case ALT_LOGOUT:       return "Logout";
    case ALT_EXPUNGE:      return "Expunge";
    case ALT_COMPOSEMSG:   return "Compose";
    case ALT_MAILBOXES:    return "Mailboxes";    
    case ALT_REPLYMSG:     return "Reply";
    case ALT_REPLYALLMSG:  return "Reply to All";    
    case ALT_FORWARDMSG:   return "Forward";
    case ALT_SHOWOPTIONS:  return "Options";
    case ALT_ADDBOOK:      return "Addressbook";
    case ALT_BACK:         return "Back";
    case ALT_SAVEADDRESS:  return "Save&nbsp;Address";
    case ALT_SORT:         return "Sort";
    case ALT_AB_NEWENTRY:  return "New&nbsp;entry";
    case ALT_AB_NEWENTRY_S:return "New entry";
    case ALT_DELNEXTMSG:   return "Delete";
    case ALT_ABOUT:        return "About";      
    case ALT_UNDELNEXTMSG: return "Undelete";
    case ALT_AB_DUMP:      return "Dump&nbsp;addressbook";    
    case ALT_AB_DUMP_S:    return "Dump";
    case ALT_DUMPFULLHEADER: return "Download&nbsp;header";
    case ALT_SENDTONNTPGROUP:return "Send to Forum";
    case ALT_COMPOSEMSGNNTP:return "Send to Forum";    
    case ALT_ROOT:         return "Begin";
    case ALT_MAIL:         return "Mail";
    case ALT_NNTP:         return "Forums";
    case ALT_POPPASS:      return "Change Password";
    case ALT_FILEBROWSER:  return "File Browser";
    case ALT_FINGER:       return "Finger";
    case ALT_FORWARDMAIL:  return "Forwarding mail";  
    case ALT_SECVIRTUAL:   return "Secretaria Virtual";
    case ALT_UPSORT:       return "Sorted Up";    
    case ALT_DOWNSORT:     return "Sorted Down";        
    case ALT_DATABASES:    return "Databases";
    case ALT_NEXTRECORD:   return "Next&nbsp;Record";
    case ALT_PREVRECORD:   return "Previous&nbsp;Record";
    case ALT_PREV:         return "Previous";
    case ALT_NEXT:         return "Next";

    case FORWARDLINE:      return "---------- Forwarded message ----------";
    
    default:               return "No string";
    }                              
  }
                        
const char *Language::getStringSpanish (int WHAT)
  {
  switch (WHAT)
    {
    case PREFIX_FORWARD:   return "(Fwd) ";
    case PREFIX_REPLY:     return "Re: ";

    case MSG_CONNREFUSED:       return "&iexcl;Conexi&oacute;n fallida!";
    case MSG_CANRECONNECTHERE:  return "Puedes reconectar pulsando aqu&iacute;."; 
    case MSG_SERVERISDOWN:      return "El servidor no responde.";
    case MSG_PERHAPSTIMEOUT:    return "&iquest;Quiz&aacute;s se acab&oacute; el tiempo?";
    case MSG_CONF_DELETEMAILBOX:return "Vamos a borrar el buz&oacute;n '%s'. &iquest;Est&aacute;s seguro?";
    case MSG_CONF_CLEARMAILBOX: return "Vamos a vaciar el buz&oacute;n '%s'. &iquest;Est&aacute;s seguro?";
    case MSG_CONF_EXPUNGE:      return "&iquest;Est&aacute;s seguro de querer purgar el buz&oacute;n?<BR>Esto borrar&aacute; definitivamente todos los mensajes marcados como borrados.";
    case MSG_CONF_LOGOUT:       return "Confirma la desconexi&oacute;n, por favor.";
    case MSG_CONF_DBEXPUNGE:    return "&iquest;Est&aacute;s seguro de querer purgar la Base de Datos?<BR>Esto borrar&aacute; definitivamente todos los registros marcados como borrados.";
    case MSG_SEND_OK:           return "Mensaje enviado correctamente.";
    case MSG_ERR_SAVE_SENTMAIL: return "Mensaje enviado correctamente pero NO se puede guardar el mensaje enviado. Quiz&aacute;s se ha acabado tu espacio en disco.";    
    case MSG_SAVED_SENTMAIL:    return "el mensaje se guard&oacute; en la carpeta ";   
    case MSG_SEND_ERR:          return "Problemas enviando el mensaje. Mensaje no enviado.";
    case MSG_CANCELMSG:         return "&iexcl;Cancelado el env&iacute;o del mensaje!";
    case MSG_SAVEOPTIONS:       return "&iexcl;Opciones GUARDADAS!";
    case MSG_CANCEL:            return "&iexcl;Cancelada la edici&oacute;n!";
    case MSG_ERR_SAVEOPTIONS:   return "&iexcl;ERROR guardando las opciones!";
    case MSG_ADDBOOK:           return "Viendo la Agenda";
    case MSG_SAVEADDBOOK:       return "&iexcl;Agenda GUARDADA!";
    case MSG_ERR_SAVEADDBOOK:   return "&iexcl;ERROR guardando la Agenda!";
    case MSG_MSGSPURGED_0:      return "Ning&uacute;n mensaje borrado.";    
    case MSG_MSGSPURGED:        return "&iexcl;%d mensaje BORRADO!";
    case MSG_MSGSPURGED_S:      return "&iexcl;%d mensajes BORRADOS!";    
    case MSG_MAILBOXCHANGED:    return "Abierto el buz&oacute;n '%s'";
    case MSG_MAILBOXCREATED:    return "&iexcl;Creado un nuevo buz&oacute;n!";
    case MSG_MAILBOXDELETED:    return "&iexcl;Borrado el buz&oacute;n!";
    case MSG_MAILBOXRENAMED:    return "&iexcl;Renombrado el buz&oacute;n!";
    case MSG_MOVEDMESSAGES:     return "%d mensaje movido a '%s'.";
    case MSG_MOVEDMESSAGES_S:   return "%d mensajes movidos a '%s'.";
    case MSG_COPYMESSAGES:      return "%d mensaje copiado a '%s'.";
    case MSG_COPYMESSAGES_S:    return "%d mensajes copiados a '%s'.";    
    case MSG_INVALIDPAGE:       return "Operaci&oacute;n incorrecta. Por favor, actualizar el &Iacute;ndice.";
    case MSG_SHOWATTACHS:       return "Modificando los Adjuntos";
    case MSG_SAVEATTACHS:       return "&iexcl;Adjuntos GUARDADOS!";
    case MSG_ERASEATTACHS:      return "&iexcl;Adjuntos seleccionados borrados!";
    case MSG_ERR_SAVEATTACHS:   return "&iexcl;ERROR guardando los Adjuntos!";
    case MSG_AB_EDITENTRY:      return "Modificando la entrada";
    case MSG_AB_SAVEENTRY:      return "&iexcl;Entrada GUARDADA!";
    case MSG_AB_DELEENTRY:      return "&iexcl;Entradas BORRADAS!";
    case MSG_AB_ADDTO:          return "A&ntilde;adidas direcciones al campo TO en Componer Mensaje";
    case MSG_AB_ADDCC:          return "A&ntilde;adidas direcciones al campo CC en Componer Mensaje";
    case MSG_AB_ADDBCC:         return "A&ntilde;adidas direcciones al campo BCC en Componer Mensaje";
    case MSG_NO_ENTRIES_MARKED: return "No hab&iacute;a entradas seleccionadas. &iexcl;NO se ejecut&oacute; ninguna acci&oacute;n!";
    case MSG_FLAGS_CHANGED:     return "%d mensaje marcado como %s.";
    case MSG_FLAGS_CHANGED_S:   return "%d mensajes marcados como %ss.";
    case MSG_FIELD_TO_EMPTY:    return "El campo 'Para' est&aacute; vacio.";
    case MSG_FIELD_SUBJ_EMPTY:  return "El campo 'Asunto' est&aacute; vacio..";
    case MSG_COMPOSE_TIMEOUT:   return "IMPORTANTE: Usa el bot&oacute;n de 'Guardar' de vez en cuando. &iexcl;A los 20 minutos de inactividad se cierra la conexi&oacute;n sin avisar y puedes perder lo escrito!";
    case MSG_TOO_MAX_CONN:      return "Demasiadas conexiones. Int&eacute;ntalo m&aacute;s tarde.";
    case MSG_TOO_MAX_TRY_CONN:  return "Lo siento. Has pulsado el bot&oacute;n muchas veces.";
    case MSG_ADDRESS_LINE_CUT:  return "&iexcl;CUIDADO! Longitud m&aacute;xima de linea alcanzada. No se pudieron a&ntilde;adir todas las direcciones.";
    case MSG_MIN_TIMEBETWCONNS: return "Conexi&oacute;n reintentada demasiado pronto. Por favor pulse el bot&oacute;n \"Entrar\" s&oacute;lo una vez y espere.";
    case MSG_ERR_RELOAD_ATTACHS:return "N&uacute;mero incorrecto de adjuntos. Posiblemente has intentado reenviar un adjunto ya enviado.";
    case MSG_NOATTACHSERASED:   return "&iexcl;NING&Uacute;N ADJUNTO HA SIDO ELIMINADO!";
    case MSG_NOATTACHSSAVED:    return "&iexcl;NING&Uacute;N ADJUNTO HA SIDO GUARDADO!";
    case MSG_NO_ELEMENTS:       return "No hay elementos.";
    case MSG_BADCOOKIE:         return "Problema de seguridad! Acceso archivado.";
    case MSG_DEBUG:             return "Debug Page";
    case MSG_MALFORMED_MESSAGE: return "<FONT color=\"#FF0000\"><BLINK>[ Mensaje vac&iacute;o posiblemente malformado. Usa \"Descargar mensaje\" para verlo como texto. ]</BLINK></FONT>";
    case MSG_MSGSFOUND_0:       return "Ning&uacute;n mensaje ENCONTRADO.";    
    case MSG_MSGSFOUND:         return "%d mensaje ENCONTRADO.";
    case MSG_MSGSFOUND_S:       return "%d mensajes ENCONTRADOS.";    
    case MSG_MSGS_SORTED:       return "&iexcl;Mensajes ordenados!";
    case MSG_GO_TO_DISABLED:    return "CUIDADO: Faltan 5 minutos para desconectar la sesion. Usa el boton de 'Guardar' o puedes perder lo escrito!";
    case MSG_AB_ADDFIELDS:      return "Direcciones a&ntilde;adidas a los campos indicados: %d.";
    case MSG_NNTP_SEND_WARNING: return "Aviso: Los mensajes de News pueden ser le&iacute;dos por mucha gente. &iexcl;Ten cuidado con lo que mandas!";
    case MSG_MANAGE_NNTPGROUPS: return "Modificando mis subscripciones";
    case MSG_NNTPGROUPS_FOUND:  return "Foros encontrados: %d";         
    case MSG_MAX_NNTPGROUPS_FOUND:return "M&aacute;ximo n&uacute;mero de Foros alcanzado: %d";    
    case MSG_NNTPGROUPS_ADDED:  return "Foros a&ntilde;adidos: %d";
    case MSG_NEW_TO_FORUMS:     return "Cambia a otro Foro con el desplegable inferior o suscribi&eacute;ndote a otros en \"Opciones/Organizar los Foros Suscritos\""; 
    case MSG_INVALIDCOMMAND:    return "Comando incorrecto.";    
    case MSG_CHANGEPW_OK:       return "Contrase&ntilde;a cambiada correctamente.";
    case MSG_CONF_DELETEITEMS:  return "&iquest;Est&aacute;s seguro de querer borrar completamente los ficheros y directorios seleccionados (recursivamente)?";
    case MSG_FILESDELETED:      return "&iexcl;%d fichero BORRADO!";    
    case MSG_FILESDELETED_S:    return "&iexcl;%d ficheros BORRADOS!";
    case MSG_FILESCOPY:         return "Elementos copiados";
    case MSG_FILESCUT:          return "Elementos cortados";    
    case MSG_FILESPASTED:       return "Elementos pegados";        
    case MSG_FILERENAMED_OK:    return "Elemento renombrado.";
    case MSG_FILESAVED_OK:      return "Fichero guardado correctamente.";    
    case MSG_FILESORT_OK:       return "Elementos ordenados correctamente.";
    case MSG_FILECREATED_OK:    return "Elemento creado correctamente.";
    case MSG_DISKCHANGED_OK:    return "Disco cambiado.";
    case MSG_NEED_PASSWORD_SERVICE: return "Para acceder al servicio '%s', Postman necesita tu contrase&ntilde;a:"; 
    case MSG_NEWMSGS_0:         return "No tienes mensajes nuevos";
    case MSG_NEWMSGS_1:         return "Tienes 1 mensaje no le&iacute;do";    
    case MSG_NEWMSGS_n:         return "Tienes %ld mensajes no le&iacute;dos";
    case MSG_RECONNECT_NOTALLOWED: return "La reconexi&oacute;n a este servicio no est&aacute; permitido!";
    case MSG_RECORDSDELETED:    return "%d registro marcado como %s.";
    case MSG_RECORDSDELETED_S:  return "%d registros marcados como %s.";
    case MSG_RECORDSPURGED_0:   return "Ning&uacute;n registro borrado.";    
    case MSG_RECORDSPURGED:     return "&iexcl;%d registro BORRADO!";
    case MSG_RECORDSPURGED_S:   return "&iexcl;%d registros BORRADOS!";    
    case MSG_RECORDSFOUND_0:    return "Ning&uacute;n registro ENCONTRADO.";    
    case MSG_RECORDSFOUND:      return "%d registro ENCONTRADO.";
    case MSG_RECORDSFOUND_S:    return "%d registros ENCONTRADOS.";    
    case MSG_CONF_DBDELETE:     return "&iquest;Est&aacute;s seguro de querer borrar entera la Base de Datos?";
    case MSG_RECORDS_ALL_SHOWN: return "Todos los registros mostrados.";
    case MSG_SHOWOPTIONS:       return "Modificando las opciones";
    case MSG_SHOWOPTIONS_CCLIENT: return "Modificando las opciones de Correo";  
    case MSG_SHOWOPTIONS_NNTP:    return "Modificando las opciones de los Foros";  
    case MSG_SHOWOPTIONS_APPEARANCE: return "Modificando las opciones de Apariencia";
    case MSG_CONF_FILTERSDELETE :return "&iquest;Est&aacute;s seguro de querer borrar los filtros seleccionados?";
    case MSG_INSERTSPAMFILTER:  return "Se va a crear un filtro basado en CONTENIDO para evitarte la recepci&oacute;n de publicidad no deseada o spam. " 
                                       "Los mensajes marcados como spam ser&aacute;n movidos a la carpeta INBOX.SPAM que ser&aacute; creada autom&aacute;ticamente. "
                                       "Acu&eacute;rdate de revisarla peri&oacute;dicamente y vaciarla.";
    case MSG_INSERTSPAMFILTER2: return "Se va a crear un filtro basado en LISTAS NEGRAS (RBL) para evitarte la recepci&oacute;n de publicidad no deseada o spam. " 
                                       "Los mensajes marcados como spam ser&aacute;n movidos a la carpeta INBOX.SPAM que ser&aacute; creada autom&aacute;ticamente. "
                                       "Acu&eacute;rdate de revisarla peri&oacute;dicamente y vaciarla.";    
    case MSG_CONFDELETEEVENT:   return "&iquest;Est&aacute;s seguro de querer borrar el evento? ";
                
    case L_USER:           return "Usuario";
    case L_PASSWORD:       return "Contrase&ntilde;a";
    case L_LOGIN:          return "Entrar";
    case L_CLEAR:          return "Limpiar";
    case L_LOGOUT:         return "Salir";
    case L_INDEXMAILBOX:   return "<B>Buz&oacute;n '%s' con %ld mensajes.</B>";
    case L_INDEXMAILBOX2:  return "&Iacute;ndice del buz&oacute;n";
    case L_INDEXMAILBOX3:  return "<B>Buz&oacute;n '%s' con %ld mensajes (%s).</B>";
    case L_INDEXMAILBOX4:  return "<B>Buz&oacute;n actual abierto: '%s' (%ld mensajes).</B>";    
    case L_CHOOSELANGUAGE: return "Elige idioma/Tria llenguatge/Choose language";
    case L_COPYRIGHT:      return "&copy;Universitat de Val&egrave;ncia, 2000-2003";
    case L_MESSAGES:       return "mensajes";
    case L_NEXTPAGE_ACT:   return "P&aacute;g. siguiente";
    case L_NEXTPAGE_INA:   return "P&aacute;g. siguiente";
    case L_PREVPAGE_ACT:   return "P&aacute;g. previa";
    case L_PREVPAGE_INA:   return "P&aacute;g. previa";
    case L_FIRSTPAGE_ACT:  return "P&aacute;g. Primera";
    case L_FIRSTPAGE_INA:  return "P&aacute;g. Primera";
    case L_LASTPAGE_ACT:   return "P&aacute;g. &Uacute;ltima";
    case L_LASTPAGE_INA:   return "P&aacute;g. &Uacute;ltima";
    case L_MESSAGE:        return "<B>Mensaje %ld/%ld (%s).</B>";
    case L_MESSAGE2:       return "Leyendo el mensaje:";
    case L_DUMPFULLMSG:    return "Descargar mensaje";
    case L_NOSUBJECT:      return "(Sin tema)";    
    case L_NEXTMSG:        return "Mensaje Siguiente";
    case L_PREVMSG:        return "Mensaje Anterior";
    case L_NEXTMSG_INA:    return "Mensaje Siguiente";
    case L_PREVMSG_INA:    return "Mensaje Anterior";
    case L_ERROR:          return "Error";
    case L_STRUCTMIME:     return "Estructura del mensaje y adjuntos:";    
    case L_EXECUTE:        return "Ejecutar";
    case L_DELETED:        return "Borrado";
    case L_EXPUNGE:        return "Purgar";
    case L_UNDELETED:      return "NO borrado";
    case L_HELP:           return "Ayuda";
    case L_COMPOSEMSG:     return "Componer"; 
    case L_MAILBOXES:      return "Buzones";       
    case L_CHANGEMAILBOX:  return "Abrir buz&oacute;n";    
    case L_CREATEMAILBOX:  return "Crear buz&oacute;n";
    case L_DELETEMAILBOX:  return "Borrar buz&oacute;n";    
    case L_RENAMEMAILBOX:  return "Renombrar buz&oacute;n";
    case L_ANSWEREDMSG:    return "Respondido";    
    case L_UNANSWEREDMSG:  return "NO respondido";    
    case L_FLAGGEDMSG:     return "Importante";    
    case L_UNFLAGGEDMSG:   return "NO importante";    
    case L_SEENMSG:        return "NO nuevo";    
    case L_UNSEENMSG:      return "Nuevo";    
    case L_MOVEMSG:        return "Mover mensajes a";
    case L_COPYMSG:        return "Copiar mensajes a";
    case L_CANCEL:         return "Cancelar";
    case L_CONFIRM:        return "Confirmar";
    case L_TO:             return "Para: ";
    case L_CC:             return "CC: ";
    case L_BCC:            return "BCC: ";
    case L_TO0:            return "To";
    case L_CC0:            return "Cc";
    case L_BCC0:           return "Bcc";    
    case L_SUBJECT:        return "Asunto: ";
    case L_TEXTTOSEND:     return "Texto a enviar:";
    case L_CANCELMSG:      return "Cancelar";
    case L_SENDMSG:        return "Enviar";
    case L_ATTACHMSG:      return "Adjuntos";
    case L_REPLYMSG:       return "Contestar";
    case L_REPLYALLMSG:    return "Contestar a todos";        
    case L_FORWARDMSG:     return "Reenviar";
    case L_FROM:           return "De: ";
    case L_DATE:           return "Fecha: ";
    case L_REPLYTO:        return "Reply-to: ";
    case L_SIGNATURE:      return "Firma";
    case L_SHOWOPTIONS:    return "Opciones";
    case L_ADDBOOK:        return "Agenda";
    case L_SAVE:           return "Guardar";
    case L_MSGSPERINDEXPAGE:return "N&uacute;mero de mensajes mostrados por p&aacute;gina en el &iacute;ndice: ";
    case L_INSIGNINNEWMSG: return "Firmar los mensajes nuevos";
    case L_ATTACHSHOWED:   return "Adjunto mostrado debajo";    
    case L_PERSONALNAME:   return "Nombre personal completo: ";    
    case L_NOFROM:         return "(Sin remitente)";    
    case L_SAVEMSGSENTMAIL:return "Guardar mensajes enviados en el buz&oacute;n &nbsp;";    
    case L_ATTACH_NEW:     return "Adjuntar otro fichero";
    case L_FILE:           return "Fichero";
    case L_NO_ATTACHS:     return "(No hay ficheros adjuntados)";
    case L_DOATTACH:       return "&iexcl;Adjuntar!";    
    case L_DETACH:         return "Quitar";
    case L_AB_NICKNAME:    return "Alias";
    case L_AB_FULLNAME:    return "Nombre";
    case L_AB_ADDRESSES:   return "Direcciones (email)";
    case L_AB_FCC:         return "Fcc";
    case L_AB_COMMENTS:    return "Comentarios";
    case L_AB_EDITENTRY:   return "Modificar entrada";
    case L_AB_NEWENTRY:    return "A&ntilde;adir nueva entrada";
    case L_AB_NEWENTRY_S:  return "A&ntilde;adir";
    case L_DELETE:         return "Borrar";
    case L_NUMOFENTRIES:   return "N&uacute;mero de entradas";
    case L_BACK:           return "Atr&aacute;s";
    case L_CLEANALL:       return "Limpiar todo";
    case L_SAVEADDRESS:    return "Guardar Direcci&oacute;n";    
    case L_NUMBER:         return "Num.:";
    case L_FLAGS:          return "Marcas:";
    case L_SIZE:           return "Tamao:";    
    case L_FLAG_DELETED:   return "Borrado";
    case L_FLAG_ANSWERED:  return "Respondido";
    case L_FLAG_FLAGGED:   return "&iexcl;Importante!";
    case L_FLAG_NEW:       return "Nuevo";
    case L_FLAG_UNSEEN:    return "Nuevo";
    case L_FLAG_COPIED:    return "Copiado";
    case L_FLAG_UNCOPIED:  return "No copiado";    
    case L_MARK:           return "Marcar";
    case L_MSGS_AS:        return " mensajes como ";
    case L_PRESS_TO_INDEX: return "Volver al &Iacute;ndice de mensajes";
    case L_SORT:           return "Ordenar";
    case L_MSGS_SHOWN:     return "<B> Mostrados del %ld al %ld.</B>";
    case L_LEX_TO:         return " a ";
    case L_DELNEXTMSG:     return "Borrar";    
    case L_UNDELNEXTMSG:   return "Recuperar";    
    case L_ABOUT:          return "Acerca de";      
    case L_REPLYFROM:      return "Contestar a 'From:' en vez de 'Reply-to:'.";
    case L_FORWATTACHS:    return "Incluir adjuntos en el Reenv&iacute;o del mensaje.";
    case L_SIZEWRITEAREA:  return "Tama&ntilde;o (filas / columnas) del area de texto en Componer mensaje.";
    case L_NEXTMSGSHOWN:   return "Mostrado el siguiente mensaje.";
    case L_LASTMSGSHOWN:   return "Mostrado el &uacute;ltimo mensaje.";
    case L_NUMATTACHSHOW:  return "<B>Adjunto mostrado: %s</B>";
    case L_DOWNLOADMAILBOX:return "Descargar el Buz&oacute;n completo";
    case L_EMPTY_IMAPSERVER:return "Campo servidor IMAP vac&iacute;o!";    
    case L_NOTALLOWED_IMAPSERVER: return "Servidor IMAP no permitido!";    
    case L_AB_DUMP:        return "Descargar";
    case L_AB_DUMP_S:      return "Descargar";
    case L_TRUNCATELENGTHREADINGMSG: return "Truncar las l&iacute;neas del mensaje que se est&aacute; leyendo si son m&aacute;s largas que ";    
    case L_SKIN:           return "Apariencia";
    case L_SECURITYPROBLEM:return "Problema de seguridad";
    case L_REFRESH        :return "Actualizar";
    case L_FLAG_SEARCHED:  return "Encontrado en la b&uacute;squeda previa";
    case L_SEARCH:         return "Buscar en";
    case L_REFRESHTIME:    return "Minutos para refrescar autom&aacute;ticamente la p&aacute;gina &iacute;ndice (0 para no hacerlo):";
    case L_SEARCH_SUBJECT: return "Asunto";
    case L_SEARCH_FROM:    return "De";
    case L_SEARCH_BODY:    return "Cuerpo";
    case L_SEARCH_ALL:     return "Todo";
    case L_CONFIRMPURGE:   return "Confirmar el purgado del Buz&oacute;n";
    case L_CONFIRMLOGOUT:  return "Confirmar la Desconexi&oacute;n";
    case L_FLAG_UNDELETED:   return "No Borrado";
    case L_FLAG_UNANSWERED:  return "No Contestado";
    case L_FLAG_UNFLAGGED:   return "No Importante";
    case L_FLAG_UNNEW:       return "No Nuevo";
    case L_FLAG_SEEN:        return "Visto";
    case L_FLAG_UNSEARCHED:  return "NO Encontrado";                      
    case L_SEARCHEDMSG:    return "1 mensaje a&ntilde;adido a la lista de mensajes encontrados.";
    case L_UNSEARCHEDMSG:  return "1 mensaje borrado de la lista de mensajes encontrados.";    
    case L_DUMPFULLHEADER: return "Descargar cabeceras";          
    case L_ADDADDRESS_TO:  return "A&ntilde;adir entradas al campo 'Para'";
    case L_ADDADDRESS_CC:  return "A&ntilde;adir entradas al campo 'CC'";
    case L_ADDADDRESS_BCC: return "A&ntilde;adir entradas al campo 'BCC'";        
    case L_DELADDRESSES:   return "Borrar entradas seleccionadas";             
    case L_ADDADDRESS_FIELD: return "Copiar direcciones seleccionadas";         
    case L_NNTPGROUP:      return "Foros:";    
    case L_SENDTONNTPGROUP:return "Enviar a Foro";
    case L_COMPOSEMSGNNTP: return "Enviar a Foro";
    case L_NNTPSERVER:     return "Servidor de Foros:";
    case L_SUBSCRIBEDGROUPS:return "Foros suscritos:";
    case L_MANAGE_NNTPGROUPS:return "Organizar los Foros Suscritos";
    case L_LIST_EMPTY:     return "----------------- [La lista est vaca] -----------------";
    case L_NNTP_LISTSEARCH:return "Buscar en la lista de Foros";
    case L_GROUPSTOADD:    return "Foros a a&ntilde;adir:";
    case L_ADDSELECTEDGROUPS:return "A&ntilde;adir Foros seleccionados";
    case L_DUMPFULLLIST:   return "Ver la Lista de Foros completa";
    case L_FORCEDGROUPS:   return "Foros permanentes:";
    case L_DISPLAY_UUENCODED:return "[Decodificar y mostrar '%s']";
    case L_GOSELECTEDGROUP:return "Abrir Foro seleccionado";
    case L_OP_SHOWCLOCK:   return "Mostrar fecha y hora.";
    case L_ADD_MORE_FORUMS:return "... (M&aacute;s Foros) ...";
    case L_SORTBYTHREADS:  return "Conversaci&oacute;n:";    
    case L_CHANGEPASSWORD:    return "Cambiar Contrase&ntilde;a";
    case L_PASSWORD_OLD:      return "Contrase&ntilde;a vieja";
    case L_PASSWORD_NEW1:     return "Contrase&ntilde;a nueva";
    case L_PASSWORD_NEW2:     return "Contrase&ntilde;a nueva";
    case L_PRESS_TO_ROOTPAGE: return "Volver a la p&aacute;gina inicial";
    case L_FINGER:         return "Finger";
    case L_FILEBROWSER:    return "Explorador de Ficheros";
    case L_FOLDER:         return "Directorio";
    case L_PARENTFOLDER:   return "Directorio Padre";
    case L_CURRENTFOLDER:  return "Directorio Actual";
    case L_EDIT:           return "Modificar";
    case L_CREATE:         return "Crear";
    case L_COPY:           return "Copiar";
    case L_CUT:            return "Cortar";
    case L_PASTE:          return "Pegar";
    case L_LOAD:           return "Cargar";
    case L_RENAME:         return "Renombrar";
    case L_ROOT:           return "Inicio";
    case L_MAIL:           return "Correo";
    case L_NNTP:           return "Foros";
    case L_POPPASS:        return "Cambiar Contrase&ntilde;a";
    case L_FORWARDMAIL:    return "Redireccionar el Correo";  
    case L_CURRENTFORWARDS:return "Redirecciones presentes:";
    case L_FORWARD_ERASE:  return "Borrar TODAS";
    case L_QUOTAUSAGE:     return "Uso de espacio";
    case L_RENAME_TO:      return "Renombrar '%s' como "; 
    case L_CURRENTDISK:    return "Disco actual";
    case L_CHANGE_DISK:    return "Cambiar al disco";
    case L_FOLDER_COPY:    return "Directorio Copiado";
    case L_FOLDER_CUT:     return "Directorio Cortado";
    case L_FILE_COPY:      return "Fichero Copiado";
    case L_FILE_CUT:       return "Fichero Cortado";
    case L_TOTAL_SIZE:     return "Total";
    case L_SECVIRTUAL:     return "Secretar&iacute;a Virtual";
    case L_SERVICE:        return "Servicio";
    case L_MAIL_DESCRIPTION       : return "Correo";
    case L_FILEBROWSER_DESCRIPTION: return "Explorador de Ficheros"; 
    case L_FINGER_DESCRIPTION     : return "Informaci&oacute;n de Finger"; 
    case L_FORWARDMAIL_DESCRIPTION: return "Redireccionando los mensajes"; 
    case L_MAIN_DESCRIPTION       : return "Principal"; 
    case L_POPPASS_DESCRIPTION    : return "Cambiando la contrase&ntilde;a"; 
    case L_SECVIRTUAL_DESCRIPTION : return "Secretaria Virtual"; 
    case L_SYNC                   : return "Sync";
    case L_DATABASES              : return "Databases";
    case L_DATABASES_DESCRIPTION  : return "Bases de Datos";
    case L_DISPLAY                : return "Mostrar";
    case L_UNDELETE               : return "Restaurar";
    case L_DB_INDEXHEADER         : return "%s, Registros: %d, Tama&ntilde;o: %d bytes";
    case L_DB_CHANGE              : return "Abrir";
    case L_DUMP                   : return "Descargar";    
    case L_DB_MYNEWDB             : return "Mi Nueva Base de Datos";
    case L_LEX_AS                 : return "como";
    case L_IMPORT                 : return "Importar";
    case L_EXPORT                 : return "Exportar";    
    case L_LEX_OF                 : return "de";
    case L_NONE_A                 : return "Ninguna";
    case L_DEFINE                 : return "Definir";
    case L_FIELD_ADD              : return "A&ntilde;adir Campo";
    case L_FIELD_DEL              : return "Borrar Campo";
    case L_DATABASE               : return "Base de Datos";
    case L_FIELD_NAME             : return "Nombre";
    case L_FIELD_ORDER            : return "Orden";
    case L_FIELD_TYPE             : return "Tipo";
    case L_FIELD_MAXLENGTH        : return "M&aacute;xima longitud";
    case L_FIELD_DISPLAYLENGTH    : return "Longitud mostrada";
    case L_FIELD_INDEXLENGTH      : return "Longitud en el &iacute;ndice";
    case L_FIELD_LABEL            : return "Etiqueta";
    case L_FIELD_DEFAULT          : return "Defecto";
    case L_FIELD_COULDBENULL      : return "Puede ser nulo";
    case L_FIELD_OPTIONAL1        : return "Opcional 1";
    case L_FIELD_OPTIONAL2        : return "Opcional 2";
    case L_FIELD_OPTIONAL3        : return "Opcional 3";
    case L_FIELD_OPTIONAL4        : return "Opcional 4";
    case L_DELETESEARCH           : return "Eliminar B&uacute;squeda";
    case L_DISPLAYPERSONALINFO    : return "Mostrar Informaci&oacute;n Personal en el Inicio";
    case L_USERACCOUNTS           : return "Cuentas de Usuario";
    case L_USERACCOUNTS_DESCRIPTION:return "Cuentas de Usuario";
    case L_CONFIG                 : return "Configuraci&oacute;n";
    case L_CONFIG_DESCRIPTION     : return "Configuraci&oacute;n";
    case L_APPEARANCE             : return "Apariencia";
    case L_SIEVE                  : return "Sieve";
    case L_SIEVE_DESCRIPTION      : return "Sieve";
    case L_MAIN                   : return "Principal";
    case L_FILTERS                : return "Filtros";
    case L_NAME                   : return "Nombre";
    case L_LEX_THEN               : return "entonces";
    case L_SIEVE_IF_IN_THE_MAIL   : return "Si en el mensaje...";
    case L_VACATION               : return "Ausencia";    
    case L_VACATION_TEXT          : return "Notificaci&oacute;n a enviar";
    case L_VACATION_DAYS2REPEAT   : return "Dias antes de reenviar la notificaci&oacute;n";
    case L_VACATION_ADDRESSES     : return "Direcciones de ausencia";
    case L_ACTIVED                : return "Activada";
    case L_UNACTIVED              : return "Desactivada";
    case L_REJECT                 : return "Rechazar";
    case L_REJECTEDTEXT           : return "(Texto de rechazo)";
    case L_SUBJECT_CONTAINS       : return "el \"Tema:\" contiene ";
    case L_FROM_CONTAINS          : return "y el \"De:\" contiene ";
    case L_TO_CONTAINS            : return "y el \"Para:\" contiene ";
    case L_SIZE_IS_OVER           : return "y el tama&ntilde;o es mayor que ";
    case L_HEADER_CONTAINS        : return "y la cabecera ";
    case L_CONTAINS               : return " contiene ";
    case L_VACATION_ADD_EXPLICAT  : return "(Direcciones a las que te mandan los mensajes que llegan a tu buz&oacute;n INBOX. Las may&uacute;sculas/min&uacute;sculas SON importantes.)";
    case L_UP                     : return "Arriba";
    case L_DOWN                   : return "Abajo";
    case L_OP_SHOWICONSLABELS     : return "Mostrar etiquetas de los iconos";
    case L_ICONSSIZE              : return "Tama&ntilde;o de los iconos";
    case L_SMALL                  : return "Peque&ntilde;o";
    case L_BIG                    : return "Grande";
    case L_MEDIUM                 : return "Medio";
    case L_INSERTSPAWNFILTER      : return "Por contenido";
    case L_INSERTSPAWNFILTER2     : return "Por lista negra";    
    case L_SERVICEPW_INCORRECT    : return "La contrase&ntilde;a no es correcta para este Servicio.";
    case L_CALENDAR               : return "Calendario";
    case L_CALENDAR_DESCRIPTION   : return "Calendario";
    case L_CHANGE                 : return "Cambiar";
    case L_WEEK                   : return "Semana";
    case L_TODAY                  : return "Hoy";    
    case L_HOUR                   : return "Hora";
    case L_TITLE                  : return "T&iacute;tulo";
    case L_DESCRIPTION            : return "Descripci&oacute;n";
    case L_STATUS                 : return "Estatus";
    case L_STATUS_FINISHED        : return "Acabado";
    case L_STATUS_OPEN            : return "Abierto";
    case L_STATUS_DELAYED         : return "Aplazado";
    case L_PRIORITY               : return "Prioridad";
    case L_PRIORITY_LOW           : return "Baja";
    case L_PRIORITY_CURRENT       : return "Normal";
    case L_PRIORITY_IMPORTANT     : return "Importante";
    case L_PRIORITY_VERYIMPORTANT : return "Muy Importante";
    case L_TYPE                   : return "Tipo";
    case L_TYPE_CELEBRATION       : return "Celebraci&oacute;n";
    case L_TYPE_MEETING           : return "Reuni&oacute;n";
    case L_TYPE_LAUNCH            : return "Comida";
    case L_TYPE_OTHER             : return "Otro";
    case L_ADD                    : return "A&ntilde;adir";
    case L_YESTERDAY              : return "Ayer";
    case L_TOMORROW               : return "Ma&ntilde;ana";
    case L_YEAR                   : return "A&ntilde;o";
    case L_DAY                    : return "Dia";
    case L_LEX_SINCE              : return "Desde";
    case L_CLEARMAILBOX           : return "Vaciar buz&oacute;n";
    case L_CREATEFILTER           : return "Crear filtro Anti-Spam predefinido: ";
    case L_DOTLEARN               : return "Aula Virtual";
    case L_DOTLEARN_DESCRIPTION   : return "Recursos de e-learning";
    case L_MODERATORS             : return "Moderadores";           
                                         
    case TIT_COMPOSEMSG:   return "Componiendo nuevo mensaje";
    case TIT_HOMEPAGE:     return "Servicio de Correo de la Universitat de Val&egrave;ncia";
    case TIT_CONFIRMACTION:return "Confirmar acci&oacute;n";
    case TIT_INDEXMAILBOX: return "&Iacute;ndice del buz&oacute;n";    
    case TIT_MAILBOXES:    return "Trabajando con los buzones";
    case TIT_MESSAGEHEADER:return "Viendo el mensaje";
    case TIT_REPLYMSG:     return "Contestando el mensaje";
    case TIT_REPLYALLMSG:  return "Contestando a todos";    
    case TIT_FORWARDMSG:   return "Reenviando el mensaje";
    case TIT_SHOWOPTIONS:  return "Modificando tus opciones";
    case TIT_ADDBOOK:      return "Viendo la Agenda";
    case TIT_INVALIDPAGE:  return "P&aacute;gina incorrecta.";
    case TIT_SHOWATTACHS:  return "Trabajando con los adjuntos del mensaje";
    case TIT_BADCOOKIE:    return "Problema de seguridad!";
    case TIT_SHOWHEADERS:  return "Todas las cabeceras"; 
    case TIT_REPLYGROUP:   return "Contestando al Foro";
    case TIT_COMPOSEMSGNNTP:return "Enviar a Foro";    
    case TIT_SHOWNNTPMANAGEGROUPS:return "Seleccionando los Foros de Noticias";
    case TIT_INVALIDCOMMAND:return "Comando incorrecto.";    
    case TIT_SERVICES:      return "Servicios";
    case TIT_POPPASS_DISPLAYPAGE: return "Cambiando la contrase&ntilde;a";
    case TIT_FINGER_DISPLAYPAGE:  return "Finger";
    case TIT_FILEBROWSER_DISPLAYPAGE: return "Explorador de Ficheros";
    case TIT_FILEBROWSER_EDITFILEPAGE: return "Editando el fichero";
    case TIT_FORWARDMAIL_DISPLAYPAGE: return "Redireccionar el Correo";
    case TIT_DATABASES_EDITRECORD:  return "Editando el Registro";
    case TIT_DATABASES_INDEXPAGE: return "&Iacute;ndice de la Base de Datos";        
    case TIT_DATABASES_DISPLAYRECORD:  return "Mostrando el Registro";
    case TIT_DATABASES_MAINPAGE:  return "Bases de Datos:";
    case TIT_DATABASES_DB_DEFINE: return "Define tu Propia Base de Datos";
    case TIT_SIEVE_DISPLAYPAGE: return "Sieve";
    case TIT_CALENDAR_DISPLAYPAGE : return "Viendo el Calendario";
    
    case ERR_INV_CMD:        return "&iexcl;Comando incorrecto!";
    case ERR_INV_USER_PW:    return "&iexcl;Usuario o Contrase&ntilde;a incorrecto!";   
    case ERR_INV_MAILBOX:    return "Buz&oacute;n incorrecto: '%s'";    
    case ERR_ISOPEN_MAILBOX: return "Buz&oacute;n abierto: '%s'";    
    case ERR_INV_PARMS:      return "Faltan datos en el formulario.";
    case ERR_OPENCONN:       return "Abriendo la conexi&oacute;n con el servidor";
    case ERR_CREAT_USERDIR:  return "Creando directorio del Usuario";
    case ERR_CREAT_USERATTACHSDIR:return "Creando directorio para adjuntos de usuario";
    case ERR_SENDING_MSG:    return "Enviando el mensaje";
    case ERR_AB_DELEENTRY:   return "Borrando entrada";
    case ERR_MAXSIZEATT:     return "El tama&ntilde;o m&aacute;ximo de adjunto es %ld bytes";
    case ERR_UNHANDLESIZEATTACH: return "El tama&ntilde;o del adjunto es muy grande. No puedo manejarlo.";
    case ERR_QUOTA_USAGE:    return "AVISO: El uso de espacio es del %s.";
    case ERR_SERVERISDOWN:   return "El servidor no responde.";
    case ERR_UUDECODING:     return "Descodificando mensaje.";
    case ERR_NNTP_NUM_SEL:   return "Has seleccionado m&aacute;s de un Foro";
    case ERR_INV_SERVICE:    return "Servicio no v&aacute;lido!";
    case ERR_SERVICE_NOTALLOWED: return "Servicio no permitido!";
    case ERR_FILE_EXISTS:      return "El fichero existe";
    case ERR_FILE_INVALIDNAME: return "Nombre de fichero no v&aacute;lido";
    case ERR_FILE_NO_EXISTS:   return "No existe el fichero";
    case ERR_FILE_CREATE:      return "Creando el fichero";
    case ERR_FILE_WRITING:     return "Escribiendo en el fichero";
    case ERR_DIR_EXISTS:       return "El directorio existe";
    case ERR_DIR_CREATE:       return "Creando el directorio";
    case ERR_DIR_OPEN:         return "Abriendo el directorio";
    case ERR_FILE_DELETING:    return "Borrando el fichero";
    case ERR_MAXSIZEFILEUPLOAD:return "El tama&ntilde;o m&aacute;ximo de fichero es %ld bytes";     
    case ERR_CLIPBOARD_EMPTY:  return "El portapapeles est&aacute; vacio";
    case ERR_SELECT_MORE_ONE:  return "Hay m&aacute;s de una entrada seleccionada";
    case ERR_FILE_RENAMING:    return "Renombrando el elemento";
    case ERR_FILE_COPYING:     return "Copiando el fichero";    
    case ERR_FILE_MOVING:      return "Moviendo el fichero";        
    case ERR_FILE_MOV_SAMESITE:return "No se puede mover un fichero al mismo directorio";
    case ERR_QUOTA_OVER:       return "Cuota de disco sobrepasada";
    case ERR_SERVICE_INITIALIZING: return "Initializando servicio";
    case ERR_CREAT_USERDATABASESDIR: return "Creando el Directorio de Bases de Datos del usuario";
    case ERR_FILTERALREADYEXISTS: return "Ese filtro ya existe.";
   
    case ALT_LOGO:         return "Logo";
    case ALT_NEXTPAGE_ACT: return "P&aacute;g.&nbsp;sig.";    
    case ALT_NEXTPAGE_INA: return "P&aacute;g.&nbsp;sig.";    
    case ALT_PREVPAGE_ACT: return "P&aacute;g.&nbsp;prev.";
    case ALT_PREVPAGE_INA: return "P&aacute;g.&nbsp;prev.";
    case ALT_FIRSTPAGE_ACT:return "P&aacute;g.&nbsp;prim.";
    case ALT_FIRSTPAGE_INA:return "P&aacute;g.&nbsp;prim.";
    case ALT_LASTPAGE_ACT: return "P&aacute;g.&nbsp;&uacute;lt.";
    case ALT_LASTPAGE_INA: return "P&aacute;g.&nbsp;&uacute;lt.";
    case ALT_DUMPFULLMSG:  return "Descargar&nbsp;mensaje";
    case ALT_NEXTMSG:      return "Mens.&nbsp;sig.";
    case ALT_PREVMSG:      return "Mens.&nbsp;ant.";
    case ALT_NEXTMSG_INA:  return "Mens.&nbsp;sig.";
    case ALT_PREVMSG_INA:  return "Mens.&nbsp;ant.";    
    case ALT_HELP:         return "Ayuda";   
    case ALT_LOGOUT:       return "Salir";
    case ALT_EXPUNGE:      return "Purgar"; 
    case ALT_COMPOSEMSG:   return "Componer";     
    case ALT_MAILBOXES:    return "Buzones";          
    case ALT_REPLYMSG:     return "Contestar";
    case ALT_REPLYALLMSG:  return "Contestar a todos";    
    case ALT_FORWARDMSG:   return "Reenviar";
    case ALT_SHOWOPTIONS:  return "Opciones";
    case ALT_ADDBOOK:      return "Agenda";
    case ALT_BACK:         return "Atr&aacute;s";
    case ALT_SAVEADDRESS:  return "Guardar&nbsp;Direcci&oacute;n";        
    case ALT_SORT:         return "Ordenar";
    case ALT_AB_NEWENTRY:  return "Nueva&nbsp;entrada";
    case ALT_AB_NEWENTRY_S:return "Nueva entrada";
    case ALT_DELNEXTMSG:   return "Borrar";
    case ALT_ABOUT:        return "Acerca&nbsp;de";      
    case ALT_UNDELNEXTMSG: return "Recuperar";
    case ALT_AB_DUMP:      return "Descargar&nbsp;agenda"; 
    case ALT_AB_DUMP_S:    return "Descargar";       
    case ALT_DUMPFULLHEADER: return "Descargar&nbsp;cabeceras";
    case ALT_SENDTONNTPGROUP:return "Enviar a Foro";
    case ALT_COMPOSEMSGNNTP:return "Enviar a Foro";    
    case ALT_ROOT:         return "Inicio";
    case ALT_MAIL:         return "Correo";
    case ALT_NNTP:         return "Foros";
    case ALT_POPPASS:      return "Cambiar Contrase&ntilde;a";
    case ALT_FILEBROWSER:  return "Explorador de Ficheros";
    case ALT_FINGER:       return "Finger";
    case ALT_FORWARDMAIL:  return "Redireccionar el Correo";  
    case ALT_SECVIRTUAL:   return "Secretar&iacute;a Virtual";
    case ALT_UPSORT:       return "Ordenado";    
    case ALT_DOWNSORT:     return "Ordenado al rev&eacute;s";        
    case ALT_DATABASES:    return "Bases de Datos";
    case ALT_NEXTRECORD:   return "Reg.&nbsp;sig.";
    case ALT_PREVRECORD:   return "Reg.&nbsp;ant.";
    case ALT_PREV:         return "Previo";
    case ALT_NEXT:         return "Siguiente";
                
    case FORWARDLINE:      return "---------- Mensaje reenviado ----------";
    
    default:               return "No string";
    }                            
  }
  
const char *Language::getStringCatala (int WHAT)
  {
  switch (WHAT)
    {
    case PREFIX_FORWARD:   return "(Fwd) ";
    case PREFIX_REPLY:     return "Re: ";

    case MSG_CONNREFUSED:       return "Conexi&oacute; fallida!";
    case MSG_CANRECONNECTHERE:  return "Podeu reconnectar prement ac&iacute;.";        
    case MSG_SERVERISDOWN:      return "El servidor no respon.";
    case MSG_PERHAPSTIMEOUT:    return "Potser s'ha acabat el temps";
    case MSG_CONF_DELETEMAILBOX:return "Esborrarem la b&uacute;stia '%s'. N'esteu segurs?";
    case MSG_CONF_CLEARMAILBOX: return "Buidarem la b&uacute;stia '%s'. N'esteu segurs?";
    case MSG_CONF_EXPUNGE:      return "Esteu segurs que voleu purgar la b&uacute;stia?<BR>A&ccedil;&ograve; esborrar&agrave; definitivament tots els missatges.";
    case MSG_CONF_LOGOUT:       return "Confirmeu la desconnexi&oacute, per favor.";
    case MSG_CONF_DBEXPUNGE:    return "Esteu segurs que voleu purgar la base de dades?<BR>A&ccedil;&ograve; esborrar&agrave; definitivament tots els registres.";
    case MSG_SEND_OK:           return "Missatge enviat correctament.";
    case MSG_ERR_SAVE_SENTMAIL: return "Missatge enviat correctament per&ograve; NO es pot guardar el missatge enviat. Potser s'ha acabat l'espai de disc.";
    case MSG_SAVED_SENTMAIL:    return "El missatge es va guardar en la carpeta ";   
    case MSG_SEND_ERR:          return "Problemes enviant el missatge. Missatge no enviat!";
    case MSG_CANCELMSG:         return "Enviament del missatge CANCELLAT!";
    case MSG_SAVEOPTIONS:       return "Opcions GUARDADES!";
    case MSG_CANCEL:            return "Cancellada l'edici&oacute;!";
    case MSG_ERR_SAVEOPTIONS:   return "ERROR en guardar les opcions!";
    case MSG_ADDBOOK:           return "Veient l'agenda";
    case MSG_SAVEADDBOOK:       return "Agenda GUARDADA!";
    case MSG_ERR_SAVEADDBOOK:   return "ERROR en guardar l'agenda!";    
    case MSG_MSGSPURGED_0:      return "Cap missatge esborrat.";    
    case MSG_MSGSPURGED:        return "%d missatge ESBORRAT!";
    case MSG_MSGSPURGED_S:      return "%d missatges ESBORRATS!";    
    case MSG_MAILBOXCHANGED:    return "Oberta la b&uacute;stia '%s'";
    case MSG_MAILBOXCREATED:    return "Nova b&uacute;stia creada!";
    case MSG_MAILBOXDELETED:    return "B&uacute;stia esborrada!";
    case MSG_MAILBOXRENAMED:    return "B&uacute;stia reanomenada!";
    case MSG_MOVEDMESSAGES:     return "%d missatge mogut a '%s'.";
    case MSG_MOVEDMESSAGES_S:   return "%d missatges moguts a '%s'.";
    case MSG_COPYMESSAGES:      return "%d missatge copiat a '%s'.";
    case MSG_COPYMESSAGES_S:    return "%d missatges copiats a '%s'.";        
    case MSG_INVALIDPAGE:       return "Operaci&oacute; incorrecta. Per favor, actualitzeu l'&iacute;ndex.";    
    case MSG_SHOWATTACHS:       return "Editant els adjunts";
    case MSG_SAVEATTACHS:       return "Adjunts GUARDATS!";
    case MSG_ERASEATTACHS:      return "Adjunts seleccionats esborrats!";
    case MSG_ERR_SAVEATTACHS:   return "ERROR en guardar els adjunts!";    
    case MSG_AB_EDITENTRY:      return "Editant l'entrada";
    case MSG_AB_SAVEENTRY:      return "Entrada GUARDADA!";
    case MSG_AB_DELEENTRY:      return "Entrades ESBORRADES!";
    case MSG_AB_ADDTO:          return "Afegides les adreces al camp TO en Compondre Missatge";
    case MSG_AB_ADDCC:          return "Afegides les adreces al camp CC en Compondre Missatge";
    case MSG_AB_ADDBCC:         return "Afegides les adreces al camp BCC en Compondre Missatge";
    case MSG_NO_ENTRIES_MARKED: return "No hi havia entrades seleccionades. No s'hi executar&agrave; cap acci&oacute;!";        
    case MSG_FLAGS_CHANGED:     return "%d missatge marcat com %s.";
    case MSG_FLAGS_CHANGED_S:   return "%d missatges marcats com %ss.";
    case MSG_FIELD_TO_EMPTY:    return "El camp 'Per a' est&agrave; buit.";
    case MSG_FIELD_SUBJ_EMPTY:  return "El camp 'Assumpte' est&agrave; buit.";
    case MSG_COMPOSE_TIMEOUT:   return "IMPORTANT: Useu el bot&oacute; de 'Guardar' de tant en tant. Als vint minuts d'inactivitat es tancar&agrave; la connexi&oacute; sense avisar i podeu perdre el que heu escrit!";
    case MSG_TOO_MAX_CONN:      return "Massa connexions. Proveu-ho m&eacute;s tard.";
    case MSG_TOO_MAX_TRY_CONN:  return "Ho sentim, heu premut el bot&oacute; moltes vegades.";    
    case MSG_ADDRESS_LINE_CUT:  return "COMPTE! Espai m&agrave;xim de l&iacute;nia usat. No es van poder afegir totes les adreces.";
    case MSG_MIN_TIMEBETWCONNS: return "Connexi&oacute; reintentada massa prompte. Per favor premeu el bot&oacute; \"Entrar\" nom&eacute;s una vegada i espereu.";
    case MSG_ERR_RELOAD_ATTACHS:return "Nombre d'adjunts incorrecte. Potser heu tornat a reenviar un adjunt ja enviat.";
    case MSG_NOATTACHSERASED:   return "CAP ADJUNT HA ESTAT ESBORRAT!";
    case MSG_NOATTACHSSAVED:    return "CAP ADJUNT HA ESTAT GUARDAT!";
    case MSG_NO_ELEMENTS:       return "No hi ha elements.";
    case MSG_BADCOOKIE:         return "Problema de seguretat! Acc&eacute;s arxivat.";    
    case MSG_DEBUG:             return "Debug Page";
    case MSG_MALFORMED_MESSAGE: return "<FONT color=\"#FF0000\"><BLINK>[ Missatge buit possiblement malformat. Utilitzeu \"Descarregar missatge\" per a veure'l com a text. ]</BLINK></FONT>";
    case MSG_MSGSFOUND_0:       return "Cap missatge TROBAT.";    
    case MSG_MSGSFOUND:         return "%d missatge TROBAT.";
    case MSG_MSGSFOUND_S:       return "%d missatges TROBATS.";    
    case MSG_MSGS_SORTED:       return "Missatges ordenats!";
    case MSG_GO_TO_DISABLED:    return "COMPTE: Falten 5 minuts per tancar la connexi&oacute;. Useu el bot&oacute; de 'Guardar' o podeu perdre l'escrit!"; 
    case MSG_AB_ADDFIELDS:      return "Adreces afegides als camps indicats: %d.";
    case MSG_NNTP_SEND_WARNING: return "COMPTE: Els missatges de News poden ser llegits per molta gent.";
    case MSG_MANAGE_NNTPGROUPS: return "Editant les meues subscripcions";
    case MSG_NNTPGROUPS_FOUND:  return "F&ograve;rums trobats: %d";         
    case MSG_MAX_NNTPGROUPS_FOUND:return "M&agrave;ax. nombre de f&ograve;rums trobats: %d";    
    case MSG_NNTPGROUPS_ADDED:  return "F&ograve;rums sumats: %d";
    case MSG_NEW_TO_FORUMS:     return "Canvia a un altre F&ograve;rum amb el desplegable inferior o ajustant \"Opcions/Organitzar els F&ograve;rums subscrits\""; 
    case MSG_INVALIDCOMMAND:    return "Operaci&oacute; incorrecta.";
    case MSG_CHANGEPW_OK:       return "Contrasenya canviada correctament.";
    case MSG_CONF_DELETEITEMS:  return "Esteu segurs que voleu esborrar tots els fitxers i directoris seleccionats (recursivament)?";
    case MSG_FILESDELETED:      return "%d fitxer ESBORRAT!";
    case MSG_FILESDELETED_S:    return "%d fitxers ESBORRATS!";
    case MSG_FILESCOPY:         return "Elements copiats";
    case MSG_FILESCUT:          return "Elements tallats";    
    case MSG_FILESPASTED:       return "Elements pegats";        
    case MSG_FILERENAMED_OK:    return "Element reanomenat.";
    case MSG_FILESAVED_OK:      return "Fitxer guardat correctament.";    
    case MSG_FILESORT_OK:       return "Elements ordenats!";
    case MSG_FILECREATED_OK:    return "Element creat correctament.";
    case MSG_DISKCHANGED_OK:    return "Disc canviat!";
    case MSG_NEED_PASSWORD_SERVICE: return "Per a accedir al servei '%s', Postman necessita la vostra contrasenya:"; 
    case MSG_NEWMSGS_0:         return "No teniu missatges nous";
    case MSG_NEWMSGS_1:         return "Teniu 1 missatge no llegit";    
    case MSG_NEWMSGS_n:         return "Teniu %ld missatges no llegits";
    case MSG_RECONNECT_NOTALLOWED: return "La reconnexi&oacute; a aquest servei no est&agrave; perm&egrave;sa!";
    case MSG_RECORDSDELETED:    return "%d registre marcat com %s";
    case MSG_RECORDSDELETED_S:  return "%d registres marcats com %s";    
    case MSG_RECORDSPURGED_0:   return "Cap registre esborrat";    
    case MSG_RECORDSPURGED:     return "&iexcl;%d registre ESBORRAT!";
    case MSG_RECORDSPURGED_S:   return "&iexcl;%d registres ESBORRATS!";    
    case MSG_RECORDSFOUND_0:    return "Cap registre TROBAT.";    
    case MSG_RECORDSFOUND:      return "%d registre TROBAT.";
    case MSG_RECORDSFOUND_S:    return "%d registres TROBATS.";    
    case MSG_CONF_DBDELETE:     return "Esteu segurs que voleu esborrar tota la Base de Dades?";
    case MSG_RECORDS_ALL_SHOWN: return "Tots els registres mostrats.";
    case MSG_SHOWOPTIONS:       return "Editant les opcions";
    case MSG_SHOWOPTIONS_CCLIENT: return "Editant les opcions del Correu ";  
    case MSG_SHOWOPTIONS_NNTP:    return "Editant les opcions dels F&ograve;rums";  
    case MSG_SHOWOPTIONS_APPEARANCE: return "Editant les opcions d'aparen&ccedil;a";
    case MSG_CONF_FILTERSDELETE :return "Esteu segurs que voleu esborrar els filtres seleccionats?";
    case MSG_INSERTSPAMFILTER:  return "Es crear&agrave; un filtre basat en CONTINGUT per a evitar-vos la recepci&oacute; de publicitat no desitjada o spam. "
                                       "Els missatges marcats com spam seran moguts a la carpeta INBOX.SPAM que ser&agrave; creada autom&agrave;ticament. "
                                       "Recordeu revisar-la peri&ograve;dicament i buidar-la.";
    case MSG_INSERTSPAMFILTER2: return "Es crear&agrave; un filtre basat en LLISTES NEGRES (RBL) per a evitar-vos la recepci&oacute; de publicitat no desitjada o spam. "
                                       "Els missatges marcats com spam seran moguts a la carpeta INBOX.SPAM que ser&agrave; creada autom&agrave;ticament. "
                                       "Recordeu revisar-la peri&ograve;dicament i buidar-la.";                                       
    case MSG_CONFDELETEEVENT:   return "Esteu segurs que voleu esborrar l'event?";
    
    case L_USER:           return "Usuari";
    case L_PASSWORD:       return "Contrasenya";
    case L_LOGIN:          return "Entrar";
    case L_CLEAR:          return "Netejar";
    case L_LOGOUT:         return "Eixir";
    case L_INDEXMAILBOX:   return "<B>B&uacute;stia '%s' amb %ld missatges.</B>";
    case L_INDEXMAILBOX2:  return "&Iacute;ndex de la b&uacute;stia";
    case L_INDEXMAILBOX3:  return "<B>B&uacute;stia '%s' amb %ld missatges (%s).</B>";    
    case L_INDEXMAILBOX4:  return "<B>B&uacute;stia oberta: '%s' (%ld missatges).</B>";    
    case L_CHOOSELANGUAGE: return "Elige idioma/Trieu llengua/Choose language";
    case L_COPYRIGHT:      return "&copy;Universitat de Val&egrave;ncia, 2000-2003";
    case L_MESSAGES:       return "Missatges";
    case L_NEXTPAGE_ACT:   return "P&agrave;gina seg&uuml;ent";
    case L_NEXTPAGE_INA:   return "P&agrave;gina seg&uuml;ent";
    case L_PREVPAGE_ACT:   return "P&agrave;gina pr&egrave;via";
    case L_PREVPAGE_INA:   return "P&agrave;gina pr&egrave;via";
    case L_FIRSTPAGE_ACT:  return "Primera p&agrave;gina";
    case L_FIRSTPAGE_INA:  return "Primera p&agrave;gina";
    case L_LASTPAGE_ACT:   return "&Uacute;ltima p&agrave;gina";
    case L_LASTPAGE_INA:   return "&Uacute;ltima p&agrave;gina";
    case L_MESSAGE:        return "<B>Missatge %ld/%ld (%s).</B>";
    case L_MESSAGE2:       return "Llegint el missatge:";
    case L_DUMPFULLMSG:    return "Descarregar el missatge";
    case L_NOSUBJECT:      return "(Sense tema)";
    case L_NEXTMSG:        return "Seg. miss.";
    case L_PREVMSG:        return "Miss. ant.";
    case L_NEXTMSG_INA:    return "Seg. miss.";
    case L_PREVMSG_INA:    return "Miss. ant.";    
    case L_ERROR:          return "Error";
    case L_STRUCTMIME:     return "Estructura del missatge i adjunts:";    
    case L_EXECUTE:        return "Executar";
    case L_DELETED:        return "Esborrat";
    case L_EXPUNGE:        return "Purgar";
    case L_UNDELETED:      return "No esborrat";
    case L_HELP:           return "Ajuda";
    case L_COMPOSEMSG:     return "Compon";
    case L_MAILBOXES:      return "B&uacute;sties";        
    case L_CHANGEMAILBOX:  return "Obrir b&uacute;stia";    
    case L_CREATEMAILBOX:  return "Crear b&uacute;stia";
    case L_DELETEMAILBOX:  return "Esborrar b&uacute;stia";    
    case L_RENAMEMAILBOX:  return "Reanomenar b&uacute;stia";
    case L_ANSWEREDMSG:    return "Contestat";    
    case L_UNANSWEREDMSG:  return "NO contestat";    
    case L_FLAGGEDMSG:     return "Important";    
    case L_UNFLAGGEDMSG:   return "NO important";    
    case L_SEENMSG:        return "NO nou";    
    case L_UNSEENMSG:      return "Nou";    
    case L_MOVEMSG:        return "Moure missatges a";
    case L_COPYMSG:        return "Copiar missatge a";
    case L_CANCEL:         return "Cancellar";
    case L_CONFIRM:        return "Confirmar";
    case L_TO:             return "Per a: ";
    case L_CC:             return "CC: ";
    case L_BCC:            return "BCC: ";
    case L_TO0:            return "To";
    case L_CC0:            return "Cc";
    case L_BCC0:           return "Bcc";    
    case L_SUBJECT:        return "Assumpte: ";
    case L_TEXTTOSEND:     return "Text per enviar:";    
    case L_CANCELMSG:      return "Cancellar";
    case L_SENDMSG:        return "Enviar";
    case L_ATTACHMSG:      return "Adjunts";
    case L_REPLYMSG:       return "Contestar";
    case L_REPLYALLMSG:    return "Contestat a tots";        
    case L_FORWARDMSG:     return "Reenviar";
    case L_FROM:           return "De: ";
    case L_DATE:           return "Data: ";
    case L_REPLYTO:        return "Reply-to: ";
    case L_SIGNATURE:      return "Firma";    
    case L_SHOWOPTIONS:    return "Opcions";
    case L_ADDBOOK:        return "Agenda";
    case L_SAVE:           return "Guardar";
    case L_MSGSPERINDEXPAGE:return "Nombre de missatges mostrats per p&agrave;gina en l'&iacute;ndex: ";    
    case L_INSIGNINNEWMSG: return "Firmar els missatges nous";
    case L_ATTACHSHOWED:   return "Adjunts mostrats baix";    
    case L_PERSONALNAME:   return "Nom personal complet: ";    
    case L_NOFROM:         return "(Sense remitent)";    
    case L_SAVEMSGSENTMAIL:return "Guardar missatges enviats a la b&uacute;stia &nbsp;";    
    case L_ATTACH_NEW:     return "Adjuntar un altre fitxer";    
    case L_FILE:           return "Fitxer";
    case L_NO_ATTACHS:     return "(No hi ha adjunts)";
    case L_DOATTACH:       return "Adjuntar!";    
    case L_DETACH:         return "Desenganxar";    
    case L_AB_NICKNAME:    return "&Agrave;lies";
    case L_AB_FULLNAME:    return "Nom";
    case L_AB_ADDRESSES:   return "Adreces (email)";
    case L_AB_FCC:         return "Fcc";
    case L_AB_COMMENTS:    return "Comentaris";
    case L_AB_EDITENTRY:   return "Editar entrada";    
    case L_AB_NEWENTRY:    return "Afegir nova entrada";
    case L_AB_NEWENTRY_S:  return "Afegir";
    case L_DELETE:         return "Esborrar";    
    case L_NUMOFENTRIES:   return "Nombre d'entrades";
    case L_BACK:           return "Arrere";    
    case L_CLEANALL:       return "Netejar-ho tot";
    case L_SAVEADDRESS:    return "Guardar adrea";    
    case L_NUMBER:         return "N&uacute;m.:";
    case L_FLAGS:          return "Marques:";
    case L_SIZE:           return "Grand&agrave;ria:";
    case L_FLAG_DELETED:   return "Esborrat";
    case L_FLAG_ANSWERED:  return "Contestat";
    case L_FLAG_FLAGGED:   return "Important!";
    case L_FLAG_NEW:       return "Nou";
    case L_FLAG_UNSEEN:    return "Nou";    
    case L_FLAG_COPIED:    return "Copiat";
    case L_FLAG_UNCOPIED:  return "No copiat";    
    case L_MARK:           return "Marcar";
    case L_MSGS_AS:        return " Missatges com ";
    case L_PRESS_TO_INDEX: return "Tornar a l'&iacute;ndex de missatges";
    case L_SORT:           return "Ordenar";
    case L_MSGS_SHOWN:     return "<B> Mostrats del %ld al %ld.</B>";
    case L_LEX_TO:         return " a ";
    case L_DELNEXTMSG:     return "Esborrar";                      
    case L_UNDELNEXTMSG:   return "No esborrar";    
    case L_ABOUT:          return "A prop&ograve;sit";                    
    case L_REPLYFROM:      return "Contestar a 'From:' en compte de 'Reply-to:'.";
    case L_FORWATTACHS:    return "Incloure adjunts en el Reenviament del missatge.";
    case L_SIZEWRITEAREA:  return "Grand&agrave;ria (files / columnes) de l'&agrave;rea de text en crear missatge.";
    case L_NEXTMSGSHOWN:   return "Mostrat el seg&uuml;ent missatge.";
    case L_LASTMSGSHOWN:   return "Mostrat el &uacute;ltim missatge.";    
    case L_NUMATTACHSHOW:  return "<B>Adjunt mostrat: %s</B>";
    case L_DOWNLOADMAILBOX:return "Descarregar tota la b&uacute;stia";
    case L_EMPTY_IMAPSERVER:return "No hi ha servidor IMAP!";             
    case L_NOTALLOWED_IMAPSERVER: return "Servidor IMAP no v&agrave;lid!";         
    case L_AB_DUMP:        return "Descarregar";    
    case L_AB_DUMP_S:      return "Descarregar";
    case L_TRUNCATELENGTHREADINGMSG: return "Truncar les l&iacute;nies del missatge que est&agrave; llegint-se si s&oacute;n m&eacute;s llargues que ";    
    case L_SKIN:           return "Semblant";
    case L_SECURITYPROBLEM:return "Problema de seguretat";    
    case L_REFRESH        :return "Actualitzar";
    case L_FLAG_SEARCHED:  return "Trobat en la recerca pr&egrave;via";
    case L_SEARCH:         return "Buscar en";
    case L_REFRESHTIME:    return "Minuts per actualitzar autom&agrave;ticament la p&agrave;gina &iacute;ndex (0 per no fer-ho).";
    case L_SEARCH_SUBJECT: return "Assumpte";
    case L_SEARCH_FROM:    return "De";
    case L_SEARCH_BODY:    return "Cos";
    case L_SEARCH_ALL:     return "Tot";
    case L_CONFIRMPURGE:   return "Confirmar la purga de la B&uacute;stia";
    case L_CONFIRMLOGOUT:  return "Confirmar la Desconnexi&oacute;";
    case L_FLAG_UNDELETED:   return "No Esborrat";
    case L_FLAG_UNANSWERED:  return "No Contestat";
    case L_FLAG_UNFLAGGED:   return "No Important";
    case L_FLAG_UNNEW:       return "No Nou";
    case L_FLAG_SEEN:        return "Vist";
    case L_FLAG_UNSEARCHED:  return "No trobat";                      
    case L_SEARCHEDMSG:    return "1 missatge sumat a la llista de missatges trobats.";
    case L_UNSEARCHEDMSG:  return "1 missatge esborrat de la llista de missatges trobats.";
    case L_DUMPFULLHEADER: return "Descarregar cap&ccedil;aleres";                   
    case L_ADDADDRESS_TO:  return "Afegir entrades al camp 'Per a'";
    case L_ADDADDRESS_CC:  return "Afegir entrades al camp 'CC'";
    case L_ADDADDRESS_BCC: return "Afegir entrades al camp 'BCC'";
    case L_DELADDRESSES:   return "Esborrar entrades seleccionades";             
    case L_ADDADDRESS_FIELD: return "Copiar adreces seleccionades";         
    case L_NNTPGROUP:      return "F&ograve;rums:";    
    case L_SENDTONNTPGROUP:return "Enviar a F&ograve;rum";
    case L_COMPOSEMSGNNTP: return "Enviar a F&ograve;rum";
    case L_NNTPSERVER:     return "Servidor de F&ograve;rums:";
    case L_SUBSCRIBEDGROUPS:return "F&ograve;rums subscrits:";         
    case L_MANAGE_NNTPGROUPS:return "Organitzar els F&ograve;rums subscrits";
    case L_LIST_EMPTY:     return "----------------- [La llista est buida] -----------------";
    case L_NNTP_LISTSEARCH:return "Buscar en la llista de F&ograve;rums";
    case L_GROUPSTOADD:    return "F&ograve;rums per afegir:";         
    case L_ADDSELECTEDGROUPS:return "Afegir F&ograve;rums seleccionats";
    case L_DUMPFULLLIST:   return "Descarregar la llista de F&ograve;rums ";
    case L_FORCEDGROUPS:   return "F&ograve;rums permanents:";
    case L_DISPLAY_UUENCODED:return "[Descodificar i mostrar '%s']";         
    case L_GOSELECTEDGROUP:return "Obrir F&ograve;rum seleccionat";
    case L_OP_SHOWCLOCK:   return "Mostrar Data i Hora.";
    case L_ADD_MORE_FORUMS:return "... (M&eacute;s F&ograve;rums) ...";
    case L_SORTBYTHREADS:  return "Conversa:";    
    case L_CHANGEPASSWORD:    return "Canviar contrasenya";
    case L_PASSWORD_OLD:      return "Contrasenya antiga";
    case L_PASSWORD_NEW1:     return "Contrasenya nova";
    case L_PASSWORD_NEW2:     return "Contrasenya nova";
    case L_PRESS_TO_ROOTPAGE: return "Tornar a la primera p&agrave;gina";
    case L_FINGER:         return "Finger";
    case L_FILEBROWSER:    return "Explorador de Fitxers";
    case L_FOLDER:         return "Directori";
    case L_PARENTFOLDER:   return "Directori Pare";
    case L_CURRENTFOLDER:  return "Directori Actual";
    case L_EDIT:           return "Editar";
    case L_CREATE:         return "Crear";
    case L_COPY:           return "Copiar";
    case L_CUT:            return "Tallar";
    case L_PASTE:          return "Pegar";
    case L_LOAD:           return "Carregar";
    case L_RENAME:         return "Reanomenar";
    case L_ROOT:           return "Inici";
    case L_MAIL:           return "Correu";
    case L_NNTP:           return "F&ograve;rums";
    case L_POPPASS:        return "Canviar contrasenya";
    case L_FORWARDMAIL:    return "Readre&ccedil;ament del Correu";
    case L_CURRENTFORWARDS:return "Readre&ccedil;aments presents:";
    case L_FORWARD_ERASE:  return "Esborrar TOTES";
    case L_QUOTAUSAGE:     return "&Uacute;s d'espai";
    case L_RENAME_TO:      return "Reanomenar '%s' com "; 
    case L_CURRENTDISK:    return "Disc Actual";
    case L_CHANGE_DISK:    return "Canviar al disc";
    case L_FOLDER_COPY:    return "Directori Copiat";
    case L_FOLDER_CUT:     return "Directori Tallat";
    case L_FILE_COPY:      return "Fitxer Copiat";
    case L_FILE_CUT:       return "Fitxer Tallat";
    case L_TOTAL_SIZE:     return "Total";
    case L_SECVIRTUAL:     return "Secretaria Virtual";
    case L_SERVICE:        return "Servei";
    case L_MAIL_DESCRIPTION       : return "Correu";
    case L_FILEBROWSER_DESCRIPTION: return "Explorador de Fitxers"; 
    case L_FINGER_DESCRIPTION     : return "Informaci&oacute; de Finger"; 
    case L_FORWARDMAIL_DESCRIPTION: return "Readre&ccedil;ament del Correu"; 
    case L_MAIN_DESCRIPTION       : return "Principal"; 
    case L_POPPASS_DESCRIPTION    : return "Canviar Contrasenya"; 
    case L_SECVIRTUAL_DESCRIPTION : return "Secretaria Virtual"; 
    case L_SYNC                   : return "Sync";
    case L_DATABASES              : return "Databases";
    case L_DATABASES_DESCRIPTION  : return "Bases de Dades";
    case L_DISPLAY                : return "Mostrar";
    case L_UNDELETE               : return "Restaurar";
    case L_DB_INDEXHEADER         : return "%s, Registres: %d, Grand&agrave;ria: %d bytes";
    case L_DB_CHANGE              : return "Obrir";
    case L_DUMP                   : return "Descarregar";    
    case L_DB_MYNEWDB             : return "La meua nova base de dades";
    case L_LEX_AS                 : return "com";
    case L_IMPORT                 : return "Importar";
    case L_EXPORT                 : return "Exportar";    
    case L_LEX_OF                 : return "de";
    case L_NONE_A                 : return "Cap";
    case L_DEFINE                 : return "Defineix";
    case L_FIELD_ADD              : return "Afegir camp";
    case L_FIELD_DEL              : return "Esborrar camp";
    case L_DATABASE               : return "Base de Dades";
    case L_FIELD_NAME             : return "Nom";
    case L_FIELD_ORDER            : return "Ordre";
    case L_FIELD_TYPE             : return "Tipus";
    case L_FIELD_MAXLENGTH        : return "M&agrave;xima Longitud";
    case L_FIELD_DISPLAYLENGTH    : return "Longitud Mostrada";
    case L_FIELD_INDEXLENGTH      : return "Longitud a l'&iacute;ndex";
    case L_FIELD_LABEL            : return "Etiqueta";
    case L_FIELD_DEFAULT          : return "Defecte";
    case L_FIELD_COULDBENULL      : return "Pot ser nul";
    case L_FIELD_OPTIONAL1        : return "Opcional 1";
    case L_FIELD_OPTIONAL2        : return "Opcional 2";
    case L_FIELD_OPTIONAL3        : return "Opcional 3";
    case L_FIELD_OPTIONAL4        : return "Opcional 4";
    case L_DELETESEARCH           : return "Eliminar recerca";
    case L_DISPLAYPERSONALINFO    : return "Mostrar Informaci&oacute; Personal a l'Inici";
    case L_USERACCOUNTS           : return "Comptes d'usuari";
    case L_USERACCOUNTS_DESCRIPTION:return "Comptes d'usuari";
    case L_CONFIG                 : return "Configuraci&oacute;";
    case L_CONFIG_DESCRIPTION     : return "Configuraci&oacute;";
    case L_APPEARANCE             : return "Aparen&ccedil;a";
    case L_SIEVE                  : return "Sieve";
    case L_SIEVE_DESCRIPTION      : return "Sieve";
    case L_MAIN                   : return "Principal";
    case L_FILTERS                : return "Filtres";
    case L_NAME                   : return "Nom";
    case L_LEX_THEN               : return "aleshores";
    case L_SIEVE_IF_IN_THE_MAIL   : return "Si en el missatge...";
    case L_VACATION               : return "Abs&egrave;ncia";    
    case L_VACATION_TEXT          : return "Notificaci&oacute; per enviar";
    case L_VACATION_DAYS2REPEAT   : return "Dies abans de reenviar la notificaci&oacute;";
    case L_VACATION_ADDRESSES     : return "Adreces d'abs&egrave;ncia";         
    case L_ACTIVED                : return "Activat";
    case L_UNACTIVED              : return "Desactivat";
    case L_REJECT                 : return "Rebutjar";
    case L_REJECTEDTEXT           : return "(Text de rebot)";
    case L_SUBJECT_CONTAINS       : return "el \"Tema:\" cont&eacute; ";
    case L_FROM_CONTAINS          : return "i el \"De:\" cont&eacute; ";
    case L_TO_CONTAINS            : return "i el \"Per a:\" cont&eacute; ";
    case L_SIZE_IS_OVER           : return "i la grand&agrave;ria &egrave;s major que ";
    case L_HEADER_CONTAINS        : return "i la cap&ccedil;elera ";
    case L_CONTAINS               : return " cont&eacute; ";
    case L_VACATION_ADD_EXPLICAT  : return "(Adreces a les quals us envien els missatges que arriben a la vostra b&uacute;stia INBOX. Les maj&uacute;scules/min&uacute;scules S&Oacute;N importants)";
    case L_UP                     : return "Dalt";
    case L_DOWN                   : return "Baix";
    case L_OP_SHOWICONSLABELS     : return "Mostrar etiquetes de les icones";
    case L_ICONSSIZE              : return "Grand&agrave;ria de les icones";
    case L_SMALL                  : return "Menuda";
    case L_BIG                    : return "Gran";
    case L_MEDIUM                 : return "Mitjana";
    case L_INSERTSPAWNFILTER      : return "Per contingut";
    case L_INSERTSPAWNFILTER2     : return "Per llista negra";    
    case L_SERVICEPW_INCORRECT    : return "La contrasenya no &eacute;s correcta per a aquest Servei.";
    case L_CALENDAR               : return "Calendari";
    case L_CALENDAR_DESCRIPTION   : return "Calendari";
    case L_CHANGE                 : return "Canviar";
    case L_WEEK                   : return "Setmana";
    case L_TODAY                  : return "Avuy";    
    case L_HOUR                   : return "Hora";
    case L_TITLE                  : return "T&iacute;tol";
    case L_DESCRIPTION            : return "Descripci&oacute;";
    case L_STATUS                 : return "Estatus";
    case L_STATUS_FINISHED        : return "Acabat";
    case L_STATUS_OPEN            : return "Obert";
    case L_STATUS_DELAYED         : return "Ajornat";
    case L_PRIORITY               : return "Prioritat";
    case L_PRIORITY_LOW           : return "Baixa";
    case L_PRIORITY_CURRENT       : return "Normal";
    case L_PRIORITY_IMPORTANT     : return "Important";
    case L_PRIORITY_VERYIMPORTANT : return "Molt Important";
    case L_TYPE                   : return "Tipus";
    case L_TYPE_CELEBRATION       : return "Celebraci&oacute;";
    case L_TYPE_MEETING           : return "Reuni&oacute;";
    case L_TYPE_LAUNCH            : return "Moderi";
    case L_TYPE_OTHER             : return "Altre";
    case L_ADD                    : return "Afegir";
    case L_YESTERDAY              : return "Ahir";
    case L_TOMORROW               : return "Dem&agrave;";
    case L_YEAR                   : return "Any";
    case L_DAY                    : return "Dia";
    case L_LEX_SINCE              : return "Des de";
    case L_CLEARMAILBOX           : return "Buidar b&uacute;stia";
    case L_CREATEFILTER           : return "Crear filtre Anti-Spam predefinit: ";
    case L_DOTLEARN               : return "Aula Virtual";
    case L_DOTLEARN_DESCRIPTION   : return "Resources for e-learning";
    case L_MODERATORS             : return "Moderadors";
                                  
    case TIT_COMPOSEMSG:   return "Creant missatge nou";    
    case TIT_HOMEPAGE:     return "Servei de Correu de la Universitat de Val&egrave;ncia";
    case TIT_CONFIRMACTION:return "Confirmar acci&oacute;";
    case TIT_INDEXMAILBOX: return "&Iacute;ndex de la b&uacute;stia";  
    case TIT_MAILBOXES:    return "Treballant amb les b&uacute;usties";
    case TIT_MESSAGEHEADER:return "Veient missatge";      
    case TIT_REPLYMSG:     return "Contestant missatge";
    case TIT_REPLYALLMSG:  return "Contestant a tots";    
    case TIT_FORWARDMSG:   return "Reenviant missatge";
    case TIT_SHOWOPTIONS:  return "Editant les vostres opcions";
    case TIT_ADDBOOK:      return "Veient l'agenda";
    case TIT_INVALIDPAGE:  return "P&agrave;gina incorrecta";    
    case TIT_SHOWATTACHS:  return "Treballant amb els adjunts del missatge";
    case TIT_BADCOOKIE:    return "Problema de seguretat!";    
    case TIT_SHOWHEADERS:  return "Totes les cap&ccedil;aleres"; 
    case TIT_REPLYGROUP:   return "Contestant al F&ograve;rum";
    case TIT_COMPOSEMSGNNTP:return "Enviar al F&ograve;rum";    
    case TIT_SHOWNNTPMANAGEGROUPS:return "Seleccionant els F&ograve;rums de Not&iacute;cies";
    case TIT_INVALIDCOMMAND:return "Operaci&oacute; incorrecta.";
    case TIT_SERVICES:              return "Serveis";
    case TIT_POPPASS_DISPLAYPAGE:   return "Canviant la contrasenya";
    case TIT_FINGER_DISPLAYPAGE:  return "Finger";
    case TIT_FILEBROWSER_DISPLAYPAGE: return "Explorador de Fitxers";
    case TIT_FILEBROWSER_EDITFILEPAGE: return "Editant el fitxer";
    case TIT_FORWARDMAIL_DISPLAYPAGE: return "Readre&ccedil;ament del Correu";
    case TIT_DATABASES_EDITRECORD:  return "Editant el Registre";   
    case TIT_DATABASES_INDEXPAGE: return "Base de Dades";
    case TIT_DATABASES_DISPLAYRECORD:  return "Veient el Registre";
    case TIT_DATABASES_MAINPAGE:  return "Bases de Dades:";
    case TIT_DATABASES_DB_DEFINE: return "Defineix la vostra Base de Dades";
    case TIT_SIEVE_DISPLAYPAGE: return "Sieve";
    case TIT_CALENDAR_DISPLAYPAGE : return "Veient el Calendari";
        
    case ERR_INV_CMD:        return "Commandament incorrecte!";    
    case ERR_INV_USER_PW:    return "Usuari o contrasenya incorrectes";       
    case ERR_INV_MAILBOX:    return "B&uacute;stia incorrecta: '%s'";    
    case ERR_ISOPEN_MAILBOX: return "B&uacute;stia oberta: '%s'";    
    case ERR_INV_PARMS:      return "Falten dades en el formulari.";    
    case ERR_OPENCONN:       return "Obrint la connexi&oacute; amb el servidor";
    case ERR_CREAT_USERDIR:  return "Creant directori de l'usuari";    
    case ERR_CREAT_USERATTACHSDIR:return "Creant directori per a adjunts de l'usuari";
    case ERR_SENDING_MSG:    return "Enviant el missatge.";
    case ERR_AB_DELEENTRY:   return "Esborrant entrada";
    case ERR_MAXSIZEATT:     return "La grandaria m&agrave;xima d'adjunt &eacute;s %ld bytes";
    case ERR_UNHANDLESIZEATTACH: return "La grand&agrave;ria de l'adjunt &eacute;s molt gran. No es pot manejar.";
    case ERR_QUOTA_USAGE:    return "AV&Iacute;S: L'&uacute;s d'espai &eacute;s del %s.";
    case ERR_SERVERISDOWN:   return "El servidor no respon.";
    case ERR_UUDECODING:     return "Descodificant missatge.";
    case ERR_NNTP_NUM_SEL:   return "Heu seleccionat m&eacute;s d'un F&ograve;rum";
    case ERR_INV_SERVICE:    return "Servei equivocat!";
    case ERR_SERVICE_NOTALLOWED: return "Servei no perm&egrave;s!";    
    case ERR_FILE_EXISTS:      return "El fitxer existeix";
    case ERR_FILE_INVALIDNAME: return "Nom de fitxer no v&agrave;lid";
    case ERR_FILE_NO_EXISTS:   return "El fitxer no existeix";
    case ERR_FILE_CREATE:      return "Creant el fitxer";
    case ERR_FILE_WRITING:     return "Escrivint en el fitxer";
    case ERR_DIR_EXISTS:       return "El directori no existeix";
    case ERR_DIR_CREATE:       return "Creant el directori";
    case ERR_DIR_OPEN:         return "Obrint el directori";
    case ERR_FILE_DELETING:    return "Esborrant el fitxer";
    case ERR_MAXSIZEFILEUPLOAD:return "La grand&agrave;aria m&agrave;xima de fitxer &eacute;s %ld bytes";     
    case ERR_CLIPBOARD_EMPTY:  return "El portapapers est&agrave; buit";
    case ERR_SELECT_MORE_ONE:  return "Hi ha m&eacute;s d'una entrada seleccionada";
    case ERR_FILE_RENAMING:    return "Reanomenant l'element";
    case ERR_FILE_COPYING:     return "Copiant fitxer";    
    case ERR_FILE_MOVING:      return "Movent el fitxer";        
    case ERR_FILE_MOV_SAMESITE:return "No es pot moure un fitxer al mateix directori";
    case ERR_QUOTA_OVER:       return "Espai de disc sobrepassat";
    case ERR_SERVICE_INITIALIZING: return "Iniciant servei";
    case ERR_CREAT_USERDATABASESDIR: return "Creant el Directori de Bases de Dades de l'usuari";
    case ERR_FILTERALREADYEXISTS: return "Aquest filtre ja existeix.";
    
    case ALT_LOGO:         return "Logo";
    case ALT_NEXTPAGE_ACT: return "P&agrave;g.&nbsp;seg.";    
    case ALT_NEXTPAGE_INA: return "P&agrave;g.&nbsp;seg.";    
    case ALT_PREVPAGE_ACT: return "P&agrave;g.&nbsp;ant.";    
    case ALT_PREVPAGE_INA: return "P&agrave;g.&nbsp;ant.";
    case ALT_FIRSTPAGE_ACT:return "Prim.&nbsp;p&agrave;g.";
    case ALT_FIRSTPAGE_INA:return "Prim.&nbsp;p&agrave;g.";
    case ALT_LASTPAGE_ACT: return "&Uacute;lt.&nbsp;p&agrave;g.";
    case ALT_LASTPAGE_INA: return "&Uacute;lt.&nbsp;p&agrave;g.";
    case ALT_DUMPFULLMSG:  return "Descarregar&nbsp;missatge";
    case ALT_NEXTMSG:      return "Miss.&nbsp;seg.";
    case ALT_PREVMSG:      return "Miss.&nbsp;ant.";
    case ALT_NEXTMSG_INA:  return "Miss.&nbsp;seg.";
    case ALT_PREVMSG_INA:  return "Miss.&nbsp;ant.";    
    case ALT_HELP:         return "Ajuda";   
    case ALT_LOGOUT:       return "Eixir";
    case ALT_EXPUNGE:      return "Purgar";
    case ALT_COMPOSEMSG:   return "Compon";
    case ALT_MAILBOXES:    return "B&uacute;sties";                
    case ALT_REPLYMSG:     return "Contestar";
    case ALT_REPLYALLMSG:  return "Contestar a tots";    
    case ALT_FORWARDMSG:   return "Reenviar";
    case ALT_SHOWOPTIONS:  return "Opcions";
    case ALT_ADDBOOK:      return "Agenda";
    case ALT_BACK:         return "Arrere";
    case ALT_SAVEADDRESS:  return "Guardar&nbsp;adrea";    
    case ALT_SORT:         return "Ordenar";
    case ALT_AB_NEWENTRY:  return "Nova&nbsp;entrada";
    case ALT_AB_NEWENTRY_S:return "Nova entrada";
    case ALT_DELNEXTMSG:   return "Esborrar";
    case ALT_ABOUT:        return "A&nbsp;prop&ograve;sit";      
    case ALT_UNDELNEXTMSG: return "No&nbsp;esborrar";
    case ALT_AB_DUMP:      return "Descarregar&nbsp;agenda";      
    case ALT_AB_DUMP_S:    return "Descarregar";
    case ALT_DUMPFULLHEADER: return "Descarregar&nbsp;cap&ccedil;aleres";      
    case ALT_SENDTONNTPGROUP:return "Enviar al F&ograve;rum";
    case ALT_COMPOSEMSGNNTP:return "Enviar al F&ograve;rum";    
    case ALT_ROOT:         return "Inici";
    case ALT_MAIL:         return "Correu";
    case ALT_NNTP:         return "F&ograve;rums";
    case ALT_POPPASS:      return "Canviar Contrasenya";
    case ALT_FILEBROWSER:  return "Explorador de Fitxers";
    case ALT_FINGER:       return "Finger";
    case ALT_FORWARDMAIL:  return "Readre&ccedil;ament del Correu";  
    case ALT_SECVIRTUAL:   return "Secretaria Virtual";
    case ALT_UPSORT:       return "Ordenat";    
    case ALT_DOWNSORT:     return "Ordenat al rev&eacute;s";        
    case ALT_DATABASES:    return "Bases de Dades";
    case ALT_NEXTRECORD:   return "Reg.&nbsp;seg.";
    case ALT_PREVRECORD:   return "Reg.&nbsp;ant.";
    case ALT_PREV:         return "Pr&egrave;vio";
    case ALT_NEXT:         return "Seg&uuml;ent";
                        
    case FORWARDLINE:      return "---------- Missatge reenviat ----------";
    
    default:               return "No string";
    }
  }                                          
   
const char *Language::getStringEuskera (int WHAT)
  {
  switch (WHAT)
    {
    case PREFIX_FORWARD:   return "(Fwd) ";
    case PREFIX_REPLY:     return "Re: ";

    case MSG_CONNREFUSED:       return "Konexioak huts egin du!";
    case MSG_CANRECONNECTHERE:  return "Hemen sakatuta berriz konekta dezakezu."; 
    case MSG_SERVERISDOWN:      return "Zerbitzariak ez du erantzuten.";
    case MSG_PERHAPSTIMEOUT:    return "Denbora amaitu egin ote da?";
    case MSG_CONF_DELETEMAILBOX:return "Postontzia ezabatu egingo dugu '%s'. Ziur al zaude?";
    case MSG_CONF_CLEARMAILBOX: return "Are you sure you want to empty mailbox '%s'?";    
    case MSG_CONF_EXPUNGE:      return "Postontzia purgatu nahi duzula ziur al zaude?<BR>Honek behin betiko ezabatuko ditu ezabatutzat markatutako mezu guztiak";
    case MSG_CONF_LOGOUT:       return "Deskonexioa egiaztatu, mesedez.";
    case MSG_CONF_DBEXPUNGE:    return "OK to expunge the DataBase?";
    case MSG_SEND_OK:           return "Ongi bidalitako mezua.";
    case MSG_ERR_SAVE_SENTMAIL: return "Ongi bidalitako mezua, baina bidalitako mezua EZIN DA gorde. Agian zure diskoko espazioa amaitu egingo zen";    
    case MSG_SAVED_SENTMAIL:    return "the message was saved in ";   
    case MSG_SEND_ERR:          return "Mezua bidaltzen arazoak. Bidali gabeko mezua.";
    case MSG_CANCELMSG:         return "Mezua bidaltzea baliogabetuta!";
    case MSG_SAVEOPTIONS:       return "GORDETAKO aukerak!";
    case MSG_CANCEL:            return "Aukeren edizioa ezabatuta!";
    case MSG_ERR_SAVEOPTIONS:   return "AKATSA aukerak gordetzean!";
    case MSG_ADDBOOK:           return "Agendari begiratuz";
    case MSG_SAVEADDBOOK:       return "Agenda GORDETA!";
    case MSG_ERR_SAVEADDBOOK:   return "AKATSA Agenda gordetzen!";
    case MSG_MSGSPURGED_0:      return "Ezabatutako mezurik ez.";    
    case MSG_MSGSPURGED:        return "%d mezu EZABATUTA!";
    case MSG_MSGSPURGED_S:      return "%d mezu EZABATUTA!";    
    case MSG_MAILBOXCHANGED:    return "Postontzia aldatuta '%s'";
    case MSG_MAILBOXCREATED:    return "Postontzi berria sortuta!";
    case MSG_MAILBOXDELETED:    return "Postontzia ezabatuta!";
    case MSG_MAILBOXRENAMED:    return "Postontzia berriz izendatuta!";
    case MSG_MOVEDMESSAGES:     return "%d mezu '%s'ra mugituta.";
    case MSG_MOVEDMESSAGES_S:   return "%d mezu '%s'ra mugituta.";
    case MSG_COPYMESSAGES:      return "%d mezu '%s'ra kopiatuta.";
    case MSG_COPYMESSAGES_S:    return "%d mezu '%s'ra kopiatuta.";    
    case MSG_INVALIDPAGE:       return "Eragiketa desegokia. Mesedez Aurkibidea eguneratu.";
    case MSG_SHOWATTACHS:       return "Erantsitakoak aldatzen";
    case MSG_SAVEATTACHS:       return "Erantsitakoak GORDETA!";
    case MSG_ERASEATTACHS:      return "Hautatutako Erantsitakoak ezabatuta!";
    case MSG_ERR_SAVEATTACHS:   return "AKATSA Erantsitakoak gordetzen!";
    case MSG_AB_EDITENTRY:      return "Sarrera aldatzen";
    case MSG_AB_SAVEENTRY:      return "Sarrera GORDETA!";
    case MSG_AB_DELEENTRY:      return "Sarrerak EZABATUTA!";
    case MSG_AB_ADDTO:          return "Mezua Osatu-n TO eremuari helbideak gehituta";
    case MSG_AB_ADDCC:          return "Mezua Osatu-n CC eremuari helbideak gehituta";
    case MSG_AB_ADDBCC:         return "Mezua Osatu-n BCC eremuari helbideak gehituta";
    case MSG_NO_ENTRIES_MARKED: return "Hautatutako sarrerarik ez zegoen. Inolako ekintzarik ez da exekutatu!";
    case MSG_FLAGS_CHANGED:     return "%d mezu %s gisa markatuta.";
    case MSG_FLAGS_CHANGED_S:   return "%d mezu %s gisa markatuta.";
    case MSG_FIELD_TO_EMPTY:    return "'Norentzat' eremua hutsik dago.";
    case MSG_FIELD_SUBJ_EMPTY:  return "'Gaia' eremua hutsik dago.";
    case MSG_COMPOSE_TIMEOUT:   return "GARRANTSITSUA: 'Gorde' botoia noizbehinka erabili. Lanik gabe 20 minutu igarota konexioa itxi egiten da abisurik pasa gabe eta idatzitakoa galdu egin dezakezu!";
    case MSG_TOO_MAX_CONN:      return "Konexio gehiegi. Saiatu geroago.";
    case MSG_TOO_MAX_TRY_CONN:  return "Sentitzen dut. Botoia askotan sakatu duzu.";
    case MSG_ADDRESS_LINE_CUT:  return "KONTUZ! Lerroko gehienezko luzera lortu duzu. Helbide guztiak gehitzerik ez da egon.";
    case MSG_MIN_TIMEBETWCONNS: return "Berriz konektatzen azkarregi saiatu zara. Mesedez, sakatu 'Sartu' botoia behin bakarrik eta itxaron.";
    case MSG_ERR_RELOAD_ATTACHS:return "Erantsitakoen kopurua oker. Seguru asko, leen bidalitako erantsitakoren bat berriz bidaltzen saiatu zara";
    case MSG_NOATTACHSERASED:   return "ERANTSITAKORIK EZ DA DEUSEZTATU!";
    case MSG_NOATTACHSSAVED:    return "ERANTSITAKORIK EZ DA GORDE!";
    case MSG_NO_ELEMENTS:       return "Ez dago elementurik.";
    case MSG_BADCOOKIE:         return "Segurtasun-arazoa! Sarbidea artxibatuta.";
    case MSG_DEBUG:             return "Debug Page";
    case MSG_MALFORMED_MESSAGE: return "<FONT color=\"#FF0000\"><BLINK>[ Mezu hutsa, seguru asko gaizki osatua. Testu gisa ikusteko erabili 'Mezua deskargatu'. ]</BLINK></FONT>";
    case MSG_MSGSFOUND_0:       return "Mezurik ez da AURKITU.";    
    case MSG_MSGSFOUND:         return "%d mezu AURKITUTA.";
    case MSG_MSGSFOUND_S:       return "%d mezu AURKITUTA.";    
    case MSG_MSGS_SORTED:       return "Mezu ordenatuak!";
    case MSG_GO_TO_DISABLED:    return "KONTUZ: Saioa deskonektatzeko 5 minutu falta dira. Erabili 'Gorde' botoia edo idatzitakoa galdu egin dezakezu!";
    case MSG_AB_ADDFIELDS:      return "Adierazitako eremuei gehitutako helbideak: %d.";
    case MSG_NNTP_SEND_WARNING: return "CUIDADO: Los mensajes de News pueden ser le&iacute;dos por mucha gente. &iexcl;Ten cuidado con lo que mandas!";
    case MSG_MANAGE_NNTPGROUPS: return "Modifying my subscriptions";
    case MSG_NNTPGROUPS_FOUND:  return "Forums found: %d";         
    case MSG_MAX_NNTPGROUPS_FOUND:return "Maximum number of Forums found: %d";    
    case MSG_NNTPGROUPS_ADDED:  return "Forums added: %d";
    case MSG_NEW_TO_FORUMS:     return "Change to other Forum with the drop-down right list or setting \"Options/Manage Subscribed Forums\""; 
    case MSG_INVALIDCOMMAND:    return "Incorrect command.";    
    case MSG_CHANGEPW_OK:       return "Password changed Ok.";
    case MSG_CONF_DELETEITEMS:  return "Ok to full delete the selected files and directories (recursively)?";
    case MSG_FILESDELETED:      return "%d file DELETED!";    
    case MSG_FILESDELETED_S:    return "%d files DELETED!";
    case MSG_FILESCOPY:         return "Objects copied";
    case MSG_FILESCUT:          return "Objects cut";    
    case MSG_FILESPASTED:       return "Objects pasted";        
    case MSG_FILERENAMED_OK:    return "Object renamed.";
    case MSG_FILESAVED_OK:      return "File saved Ok.";    
    case MSG_FILESORT_OK:       return "Objects sorted!";
    case MSG_FILECREATED_OK:    return "Object created!";
    case MSG_DISKCHANGED_OK:    return "Disk changed!";
    case MSG_NEED_PASSWORD_SERVICE: return "To access to the service '%s', Postman need your password:"; 
    case MSG_NEWMSGS_0:         return "No new messages";
    case MSG_NEWMSGS_1:         return "You have 1 message not read";    
    case MSG_NEWMSGS_n:         return "You have %ld messages not read";
    case MSG_RECONNECT_NOTALLOWED: return "Reconnect to that service is not allowed!";
    case MSG_RECORDSDELETED:    return "%d record marked as %s.";
    case MSG_RECORDSDELETED_S:  return "%d records marked as %s.";        
    case MSG_RECORDSPURGED_0:   return "No records PURGED.";    
    case MSG_RECORDSPURGED:     return "%d record PURGED!";
    case MSG_RECORDSPURGED_S:   return "%d records PURGED!";            
    case MSG_RECORDSFOUND_0:    return "No record FOUND.";    
    case MSG_RECORDSFOUND:      return "%d record FOUND.";
    case MSG_RECORDSFOUND_S:    return "%d records FOUND.";    
    case MSG_CONF_DBDELETE:     return "Ok to full delete the DataBase?";        
    case MSG_RECORDS_ALL_SHOWN: return "All records shown";
    case MSG_SHOWOPTIONS:       return "Aukerak aldatzen";
    case MSG_SHOWOPTIONS_CCLIENT: return "Aukerak aldatzen";  
    case MSG_SHOWOPTIONS_NNTP:    return "Aukerak aldatzen";  
    case MSG_SHOWOPTIONS_APPEARANCE: return "Editing Appearance options";
    case MSG_CONF_FILTERSDELETE :return "Ok to delete the selected filters?";
    case MSG_INSERTSPAMFILTER:  return "I will make a filter based in CONTENT for avoid you the reception of publicity nonwished or Spam. "
                                       "The marked messages as Spam will be moved to the folder INBOX.spam that will be created automatically. "
                                       "Remember to review it periodically and to clean it.";
    case MSG_INSERTSPAMFILTER2: return "I will make a filter based in Relay Blocking List (RBL) for avoid you the reception of publicity nonwished or Spam. "
                                       "The marked messages as Spam will be moved to the folder INBOX.spam that will be created automatically. "
                                       "Remember to review it periodically and to clean it.";                                       
    case MSG_CONFDELETEEVENT:   return "Ok to delete the selected Event? ";

    case L_USER:           return "Erabiltzailea";
    case L_PASSWORD:       return "Pasahitza";
    case L_LOGIN:          return "Sartu";
    case L_CLEAR:          return "Garbitu";
    case L_LOGOUT:         return "Irten";
    case L_INDEXMAILBOX:   return "<B>Postontzia '%s' %ld mezurekin.</B>";
    case L_INDEXMAILBOX2:  return "Postontziaren indizea";
    case L_INDEXMAILBOX3:  return "<B>Postontzia '%s' %ld mezurekin (%s).</B>";
    case L_INDEXMAILBOX4:  return "<B>Oraingo postontzia irekita: '%s' (%ld mezu).</B>";    
    case L_CHOOSELANGUAGE: return "Elige idioma/Tria llenguatge/Choose language/Aukeraru hizkuntza";
    case L_COPYRIGHT:      return "&copy;Universitat de Val&egrave;ncia, 2000-2003";
    case L_MESSAGES:       return "mezuak";
    case L_NEXTPAGE_ACT:   return "Hurrengo orrialdea";
    case L_NEXTPAGE_INA:   return "Hurrengo orrialdea";
    case L_PREVPAGE_ACT:   return "Aurreko orrialdea";
    case L_PREVPAGE_INA:   return "Aurreko orrialdea";
    case L_FIRSTPAGE_ACT:  return "Lehen Orrialdea";
    case L_FIRSTPAGE_INA:  return "Lehen Orrialdea";
    case L_LASTPAGE_ACT:   return "Azken Orrialdea";
    case L_LASTPAGE_INA:   return "Azken Orrialdea";
    case L_MESSAGE:        return "<B>Mezua %ld/%ld (%s).</B>";
    case L_MESSAGE2:       return "Mezua irakurtzen:";
    case L_DUMPFULLMSG:    return "Mezua deskargatu";
    case L_NOSUBJECT:      return "(Gairik gabe)";    
    case L_NEXTMSG:        return "Hurrengo Mezua";
    case L_PREVMSG:        return "Aurreko Mezua";
    case L_NEXTMSG_INA:    return "Hurrengo Mezua";
    case L_PREVMSG_INA:    return "Aurreko Mezua";
    case L_ERROR:          return "Akatsa";
    case L_STRUCTMIME:     return "Mezuaren eta erantsitakoen egitura:";    
    case L_EXECUTE:        return "Exekutatu";
    case L_DELETED:        return "Ezabatzea";
    case L_EXPUNGE:        return "Purgatu";
    case L_UNDELETED:      return "Borratu GABEA";
    case L_HELP:           return "Laguntza";
    case L_COMPOSEMSG:     return "Osatu"; 
    case L_MAILBOXES:      return "Postontziak";       
    case L_CHANGEMAILBOX:  return "Postontzia ireki";    
    case L_CREATEMAILBOX:  return "Postontzia sortu";
    case L_DELETEMAILBOX:  return "Postontzia ezabatu";    
    case L_RENAMEMAILBOX:  return "Postontziari izena berriz ipini";
    case L_ANSWEREDMSG:    return "Erantzuna";    
    case L_UNANSWEREDMSG:  return "Erantzun GABEA";    
    case L_FLAGGEDMSG:     return "Garrantzitsua";    
    case L_UNFLAGGEDMSG:   return "EZ DA garrantzitsua";    
    case L_SEENMSG:        return "Berria EZ";    
    case L_UNSEENMSG:      return "Berria";    
    case L_MOVEMSG:        return "Mezuak  ...ra mugitu";
    case L_COPYMSG:        return "...ra mezuak kopiatu";
    case L_CANCEL:         return "Baliogabetu";
    case L_CONFIRM:        return "Egiaztatu";
    case L_TO:             return "Norentzat: ";
    case L_CC:             return "CC: ";
    case L_BCC:            return "BCC: ";
    case L_TO0:            return "To";
    case L_CC0:            return "Cc";
    case L_BCC0:           return "Bcc";    
    case L_SUBJECT:        return "Gaia: ";
    case L_TEXTTOSEND:     return "Bidaltzeko testua:";
    case L_CANCELMSG:      return "Baliogabetu";
    case L_SENDMSG:        return "Bidali";
    case L_ATTACHMSG:      return "Erantsitakoak";
    case L_REPLYMSG:       return "Erantzun";
    case L_REPLYALLMSG:    return "Reply to All";    
    case L_FORWARDMSG:     return "Berriz bidali";
    case L_FROM:           return "Nork: ";
    case L_DATE:           return "Data: ";
    case L_REPLYTO:        return "Reply-to: ";
    case L_SIGNATURE:      return "Sinadura";
    case L_SHOWOPTIONS:    return "Aukerak";
    case L_ADDBOOK:        return "Agenda";
    case L_SAVE:           return "Gorde";
    case L_MSGSPERINDEXPAGE:return "Aurkibidean orrialdeko erakutsitako mezu-kopurua:";
    case L_INSIGNINNEWMSG: return "Mezu berriak sinatu";
    case L_ATTACHSHOWED:   return "Azpian erakutsitako erantsitakoa";    
    case L_PERSONALNAME:   return "Pertsona izen osoa: ";    
    case L_NOFROM:         return "(Igorlerik gabe)";    
    case L_SAVEMSGSENTMAIL:return "Igorritako mezuak postontzian gorde";    
    case L_ATTACH_NEW:     return "Beste fitxategi bat erantsi";
    case L_FILE:           return "Fitxategia";
    case L_NO_ATTACHS:     return "(Ez dago erantsitako fitxategirik)";
    case L_DOATTACH:       return "Erantsi!";    
    case L_DETACH:         return "Kendu";
    case L_AB_NICKNAME:    return "Goitizena";
    case L_AB_FULLNAME:    return "Izena";
    case L_AB_ADDRESSES:   return "Helbideak (e-maila)";
    case L_AB_FCC:         return "Fcc";
    case L_AB_COMMENTS:    return "Iruzkinak";
    case L_AB_EDITENTRY:   return "Sarrera aldatu";
    case L_AB_NEWENTRY:    return "Beste sarrera bat gehitu";
    case L_AB_NEWENTRY_S:  return "Gehitu";
    case L_DELETE:         return "Ezabatu";
    case L_NUMOFENTRIES:   return "Sarrera-kopurua";
    case L_BACK:           return "Atzera";
    case L_CLEANALL:       return "Dena garbitu";
    case L_SAVEADDRESS:    return "Helbidea Gorde";    
    case L_NUMBER:         return "Zk.:";
    case L_FLAGS:          return "Markak:";
    case L_SIZE:           return "Tamaina:";    
    case L_FLAG_DELETED:   return "Ezabatuta";
    case L_FLAG_ANSWERED:  return "Erantzunda";
    case L_FLAG_FLAGGED:   return "Garrantzitsua!";
    case L_FLAG_NEW:       return "Berria";
    case L_FLAG_UNSEEN:    return "Berria";
    case L_FLAG_COPIED:    return "Copied";
    case L_FLAG_UNCOPIED:  return "Uncopied";    
    case L_MARK:           return "Markatu";
    case L_MSGS_AS:        return " mezuak ... gisa ";
    case L_PRESS_TO_INDEX: return "Mezu-indizera itzuli";
    case L_SORT:           return "Ordenatu";
    case L_MSGS_SHOWN:     return "<B> Erakutsiak %ld etik %ld ra.</B>";
    case L_LEX_TO:         return " a ";
    case L_DELNEXTMSG:     return "Ezabatu";    
    case L_UNDELNEXTMSG:   return "Ezabatzea kendu";    
    case L_ABOUT:          return "...ren inguruan";      
    case L_REPLYFROM:      return "Erantzun 'From:'i 'Reply-to:'ren ordez.";
    case L_FORWATTACHS:    return "Mezua berriz igortzean erantsitakoak barne hartu.";
    case L_SIZEWRITEAREA:  return "Testu-esparruaren tamaina (ilarak / zutabeak) Mezua osatu-n.";
    case L_NEXTMSGSHOWN:   return "Hurrengo mezua erakutsita.";
    case L_LASTMSGSHOWN:   return "Azken mezua erakutsita.";
    case L_NUMATTACHSHOW:  return "<B>Erantsitakoa erakutsita: %s</B>";
    case L_DOWNLOADMAILBOX:return "Postontzi osoa deskargatu";
    case L_EMPTY_IMAPSERVER:return "IMAP zerbitzariaren eremua hutsa!";    
    case L_NOTALLOWED_IMAPSERVER: return "IMAP zerbitzaria ez da onartzen!";    
    case L_AB_DUMP:        return "Deskargatu";
    case L_AB_DUMP_S:      return "Deskargatu";
    case L_TRUNCATELENGTHREADINGMSG: return "Irakurtzen ari den mezuaren lerroak ebaki ... baino luzeagoak badira ";    
    case L_SKIN:           return "Itxura";
    case L_SECURITYPROBLEM:return "Segurtasun-arazoa";
    case L_REFRESH        :return "Eguneratu";
    case L_FLAG_SEARCHED:  return "Aurretiazko bilaketan aurkitua";
    case L_SEARCH:         return "... n bilatu";
    case L_REFRESHTIME:    return "Aurkibide-orrialdea automatikoki freskatzeko minutuak (0 ez egiteko):";
    case L_SEARCH_SUBJECT: return "Gaia";
    case L_SEARCH_FROM:    return "Nork";
    case L_SEARCH_BODY:    return "Gorputza";
    case L_SEARCH_ALL:     return "Dena";
    case L_CONFIRMPURGE:   return "Postontzi-purgaketa egiaztatu";
    case L_CONFIRMLOGOUT:  return "Deskonexioa egiaztatu";
    case L_FLAG_UNDELETED:   return "Ezabatu GABEA";
    case L_FLAG_UNANSWERED:  return "Erantzun GABEA";
    case L_FLAG_UNFLAGGED:   return "Ez da Garrantzitsua";
    case L_FLAG_UNNEW:       return "Ez da Berria";
    case L_FLAG_SEEN:        return "Ikusia";
    case L_FLAG_UNSEARCHED:  return "Aurkitu GABEA";                      
    case L_SEARCHEDMSG:    return "Mezu bat erantsia aurkitutako mezuen zerrendari";
    case L_UNSEARCHEDMSG:  return "Mezu bat ezabatua aurkitutako mezuen zerrendatik";    
    case L_DUMPFULLHEADER: return "Goiburukoak deskargatu";          
    case L_ADDADDRESS_TO:  return "Sarrerak gehitu 'Norentzat' eremuari";
    case L_ADDADDRESS_CC:  return "Sarrerak gehitu 'CC' eremuari";
    case L_ADDADDRESS_BCC: return "Sarrerak gehitu 'BCC' eremuari";        
    case L_DELADDRESSES:   return "Hautatutako sarrerak ezabatu";             
    case L_ADDADDRESS_FIELD: return "Helbideak gehitu";         
    case L_NNTPGROUP:      return "Forums:";    
    case L_SENDTONNTPGROUP:return "Send to Forum";
    case L_COMPOSEMSGNNTP: return "Send to Forum";
    case L_NNTPSERVER:     return "Forums Server:";
    case L_SUBSCRIBEDGROUPS:return "Subscribed Forums:";
    case L_MANAGE_NNTPGROUPS:return "Manage Subscribed Forums";
    case L_LIST_EMPTY:     return "----------------- [List is empty] -----------------";
    case L_NNTP_LISTSEARCH:return "Search in All Forums List";         
    case L_GROUPSTOADD:    return "Forums to add:";         
    case L_ADDSELECTEDGROUPS:return "Add selected Forums";
    case L_DUMPFULLLIST:   return "Dump full Forum List";
    case L_FORCEDGROUPS:   return "Permanent Forums:";    
    case L_DISPLAY_UUENCODED:return "[Decode and display '%s']";
    case L_GOSELECTEDGROUP:return "Open selected Forum";
    case L_OP_SHOWCLOCK:   return "Display Date and Time.";
    case L_ADD_MORE_FORUMS:return "... (More Forums) ...";
    case L_SORTBYTHREADS:  return "Thread:";    
    case L_CHANGEPASSWORD:    return "Change Password";
    case L_PASSWORD_OLD:      return "Old password";
    case L_PASSWORD_NEW1:     return "New password";
    case L_PASSWORD_NEW2:     return "Retype new password";
    case L_PRESS_TO_ROOTPAGE: return "Return to the begin page";
    case L_FINGER:         return "Finger";
    case L_FILEBROWSER:    return "File Browser";
    case L_FOLDER:         return "Directory";
    case L_PARENTFOLDER:   return "Parent Directory";
    case L_CURRENTFOLDER:  return "Current Directory";
    case L_EDIT:           return "Aldatu";
    case L_CREATE:         return "Create";
    case L_COPY:           return "Copy";
    case L_CUT:            return "Cut";
    case L_PASTE:          return "Paste";
    case L_LOAD:           return "Load";
    case L_ROOT:           return "Begin&nbsp;Page";
    case L_MAIL:           return "Mail";
    case L_NNTP:           return "Forums";
    case L_POPPASS:        return "Change Password";
    case L_FORWARDMAIL:    return "Forwarding mail";  
    case L_CURRENTFORWARDS:return "Current Forwards:";
    case L_FORWARD_ERASE:  return "Erase ALL";
    case L_QUOTAUSAGE:     return "Quota usage";
    case L_RENAME_TO:      return "Rename '%s' to "; 
    case L_CURRENTDISK:    return "Current disk";
    case L_CHANGE_DISK:    return "Change to disk";
    case L_FOLDER_COPY:    return "Copied Folder";
    case L_FOLDER_CUT:     return "Cut Folder";
    case L_FILE_COPY:      return "Copied File";
    case L_FILE_CUT:       return "Cut File";
    case L_TOTAL_SIZE:     return "Total size";
    case L_SECVIRTUAL:     return "Secretar&iacute;a Virtual";
    case L_SERVICE:        return "Service";
    case L_MAIL_DESCRIPTION       : return "Mail";
    case L_FILEBROWSER_DESCRIPTION: return "File Explorer"; 
    case L_FINGER_DESCRIPTION     : return "Fingering Info"; 
    case L_FORWARDMAIL_DESCRIPTION: return "Forwarding messages"; 
    case L_MAIN_DESCRIPTION       : return "Main"; 
    case L_POPPASS_DESCRIPTION    : return "Changing your password"; 
    case L_SECVIRTUAL_DESCRIPTION : return "Secretaria Virtual"; 
    case L_SYNC                   : return "Sync";
    case L_DATABASES              : return "Databases";
    case L_DATABASES_DESCRIPTION  : return "Databases";
    case L_DISPLAY                : return "Display";
    case L_UNDELETE               : return "Undelete";
    case L_DB_INDEXHEADER         : return "%s, Records: %d, Size: %d bytes";
    case L_DB_CHANGE              : return "Open";
    case L_DUMP                   : return "Dump";    
    case L_DB_MYNEWDB             : return "My New Database";
    case L_LEX_AS                 : return "as";
    case L_IMPORT                 : return "Import";
    case L_EXPORT                 : return "Export";    
    case L_LEX_OF                 : return "of";
    case L_NONE_A                 : return "None";
    case L_DEFINE                 : return "Define";
    case L_FIELD_ADD              : return "Add Field";
    case L_FIELD_DEL              : return "Delete Field";
    case L_DATABASE               : return "Database";
    case L_FIELD_NAME             : return "Name";
    case L_FIELD_ORDER            : return "Order";
    case L_FIELD_TYPE             : return "Type";
    case L_FIELD_MAXLENGTH        : return "Maximum Length";
    case L_FIELD_DISPLAYLENGTH    : return "Display Length";
    case L_FIELD_INDEXLENGTH      : return "Index Length";
    case L_FIELD_LABEL            : return "Label";
    case L_FIELD_DEFAULT          : return "Default";
    case L_FIELD_COULDBENULL      : return "Could be null";
    case L_FIELD_OPTIONAL1        : return "Optional 1";
    case L_FIELD_OPTIONAL2        : return "Optional 2";
    case L_FIELD_OPTIONAL3        : return "Optional 3";
    case L_FIELD_OPTIONAL4        : return "Optional 4";
    case L_DELETESEARCH           : return "Delete Search";
    case L_DISPLAYPERSONALINFO    : return "Display Personal Information at startup";
    case L_USERACCOUNTS           : return "User accounts";
    case L_USERACCOUNTS_DESCRIPTION:return "User accounts";
    case L_CONFIG                 : return "Configuration";
    case L_CONFIG_DESCRIPTION     : return "Configuration";
    case L_APPEARANCE             : return "Appearance";
    case L_SIEVE                  : return "Sieve";
    case L_SIEVE_DESCRIPTION      : return "Sieve";
    case L_MAIN                   : return "Main";
    case L_FILTERS                : return "Filters";
    case L_NAME                   : return "Name";
    case L_LEX_THEN               : return "then";
    case L_SIEVE_IF_IN_THE_MAIL   : return "If in the message...";
    case L_VACATION               : return "Absence";    
    case L_VACATION_TEXT          : return "Notification to send";
    case L_VACATION_DAYS2REPEAT   : return "Days before repeat notification";
    case L_VACATION_ADDRESSES     : return "Absence addresses";
    case L_ACTIVED                : return "Actived";
    case L_UNACTIVED              : return "Unactived";
    case L_REJECT                 : return "Reject";
    case L_REJECTEDTEXT           : return "(Rejected Text)";
    case L_SUBJECT_CONTAINS       : return "the \"Subject:\" contains ";
    case L_FROM_CONTAINS          : return "and the \"From:\" contains ";
    case L_TO_CONTAINS            : return "and the \"To:\" contains ";
    case L_SIZE_IS_OVER           : return "and the size is over ";
    case L_HEADER_CONTAINS        : return "and the \"Header\" ";
    case L_CONTAINS               : return " contains ";
    case L_VACATION_ADD_EXPLICAT  : return "(Addresses where your mail is sent. Upper and lower case are IMPORTANT.)";
    case L_UP                     : return "Up";
    case L_DOWN                   : return "Down";
    case L_OP_SHOWICONSLABELS     : return "Show icons labels";
    case L_ICONSSIZE              : return "Icons size";
    case L_SMALL                  : return "Small";
    case L_BIG                    : return "Big";
    case L_MEDIUM                 : return "Medium";
    case L_INSERTSPAWNFILTER      : return "By content";
    case L_INSERTSPAWNFILTER2     : return "By RBL";    
    case L_SERVICEPW_INCORRECT    : return "The password is not valid for this Service.";
    case L_CALENDAR               : return "Calendar";
    case L_CALENDAR_DESCRIPTION   : return "Calendar";
    case L_CHANGE                 : return "Change";
    case L_WEEK                   : return "Week";
    case L_TODAY                  : return "Today";    
    case L_HOUR                   : return "Hour";
    case L_TITLE                  : return "Title";
    case L_DESCRIPTION            : return "Description";
    case L_STATUS                 : return "Status";
    case L_STATUS_FINISHED        : return "Finished";
    case L_STATUS_OPEN            : return "Open";
    case L_STATUS_DELAYED         : return "Delayed";
    case L_PRIORITY               : return "Priority";
    case L_PRIORITY_LOW           : return "Low";
    case L_PRIORITY_CURRENT       : return "Current";
    case L_PRIORITY_IMPORTANT     : return "Important";
    case L_PRIORITY_VERYIMPORTANT : return "Very Important";
    case L_TYPE                   : return "Type";
    case L_TYPE_CELEBRATION       : return "Celebration";
    case L_TYPE_MEETING           : return "Meeting";
    case L_TYPE_LAUNCH            : return "Launch";
    case L_TYPE_OTHER             : return "Other";
    case L_ADD                    : return "Add";
    case L_YESTERDAY              : return "Yesterday";
    case L_TOMORROW               : return "Tomorrow";
    case L_YEAR                   : return "Year";
    case L_DAY                    : return "Day";
    case L_LEX_SINCE              : return "Since";
    case L_CLEARMAILBOX           : return "Empty mailbox";
    case L_CREATEFILTER           : return "Create predefined Anti-Spam filter: ";
    case L_DOTLEARN               : return "Aula Virtual";
    case L_DOTLEARN_DESCRIPTION   : return "Resources for e-learning";
    case L_MODERATORS             : return "Moderators";
                                                 
    case TIT_COMPOSEMSG:   return "Mezu berria osatzen";
    case TIT_HOMEPAGE:     return "Universitat de Valncia-ren Posta Zerbitzua";
    case TIT_CONFIRMACTION:return "Ekintza egiaztatu";
    case TIT_INDEXMAILBOX: return "Postontziaren aurkibidea";    
    case TIT_MAILBOXES:    return "Postontziekin lanean";
    case TIT_MESSAGEHEADER:return "Mezua ikusten";
    case TIT_REPLYMSG:     return "Mezuari erantzuten";
    case TIT_REPLYALLMSG:  return "Replying to All";    
    case TIT_FORWARDMSG:   return "Mezua berriz igortzen";
    case TIT_SHOWOPTIONS:  return "Zure aukerak aldatzen";
    case TIT_ADDBOOK:      return "Agenda ikusten";
    case TIT_INVALIDPAGE:  return "Orrialdea oker.";
    case TIT_SHOWATTACHS:  return "Mezuari erantsitakoekin lanean";
    case TIT_BADCOOKIE:    return "Segurtasun-arazoa!";
    case TIT_SHOWHEADERS:  return "Goiburuko guztiak"; 
    case TIT_REPLYGROUP:   return "Replying to Forum";
    case TIT_COMPOSEMSGNNTP:return "Send to Forum";    
    case TIT_SHOWNNTPMANAGEGROUPS:return "Seleccionando los Foros de Noticias";
    case TIT_INVALIDCOMMAND:return "Incorrect command.";    
    case TIT_SERVICES:             return "Services";
    case TIT_POPPASS_DISPLAYPAGE:  return "Changing the password";
    case TIT_FINGER_DISPLAYPAGE:  return "Finger";
    case TIT_FILEBROWSER_DISPLAYPAGE: return "File Browser";    
    case TIT_FILEBROWSER_EDITFILEPAGE: return "Editing File";
    case TIT_FORWARDMAIL_DISPLAYPAGE: return "Forwarding mail";
    case TIT_DATABASES_EDITRECORD:  return "Editing the Record";
    case TIT_DATABASES_INDEXPAGE: return "Index of Database";        
    case TIT_DATABASES_DISPLAYRECORD:  return "Displaying the Record";
    case TIT_DATABASES_MAINPAGE:  return "Databases:";
    case TIT_DATABASES_DB_DEFINE: return "Define your own new database";
    case TIT_SIEVE_DISPLAYPAGE: return "Sieve";
    case TIT_CALENDAR_DISPLAYPAGE : return "Viewing the Calendar";
    
    case ERR_INV_CMD:      return "Komandoa oker!";
    case ERR_INV_USER_PW:  return "Erabiltzailea edo Pasahitza oker!";   
    case ERR_INV_MAILBOX:  return "Postontzia oker: '%s'";    
    case ERR_ISOPEN_MAILBOX: return "Mailbox is currently open: '%s'";    
    case ERR_INV_PARMS:    return "Parametroak oker";
    case ERR_OPENCONN:     return "Zerbitzariaren konexioa irekitzen";
    case ERR_CREAT_USERDIR:return "Erabiltzailearen direktorioa sortzen";
    case ERR_CREAT_USERATTACHSDIR:return "Erabiltzaile-erantsitakoentzat direktorioa sortzen";
    case ERR_SENDING_MSG:  return "Mezua bidaltzen";
    case ERR_AB_DELEENTRY: return "Sarrera ezabatzen";
    case ERR_MAXSIZEATT:   return "Erantsitakoaren gehienezko tamaina %ld bytekoa da";
    case ERR_UNHANDLESIZEATTACH: return "Erantsitakoaren tamaina oso handia da. Ezin dut maneiatu.";
    case ERR_QUOTA_USAGE:  return "OHARRA: Espazio-erabilpena %s   ...koa da.";
    case ERR_SERVERISDOWN: return "Zerbitzariak ez du erantzuten.";
    case ERR_UUDECODING:   return "Decoding message.";
    case ERR_NNTP_NUM_SEL: return "You have selected more than one Forum";
    case ERR_INV_SERVICE:  return "Incorrect service!";
    case ERR_SERVICE_NOTALLOWED: return "Service not allowed!";
    case ERR_FILE_EXISTS:      return "File exists";
    case ERR_FILE_INVALIDNAME: return "Wrong filename";
    case ERR_FILE_NO_EXISTS:   return "No such file";
    case ERR_FILE_CREATE:      return "Creating file";
    case ERR_FILE_WRITING:     return "Writing in file";
    case ERR_DIR_EXISTS:       return "Directory exists";
    case ERR_DIR_CREATE:       return "Creating directory";
    case ERR_DIR_OPEN:         return "Opening directory";
    case ERR_FILE_DELETING:    return "Deleting file";
    case ERR_MAXSIZEFILEUPLOAD:return "The maximum size for uploaded file is %ld bytes";     
    case ERR_CLIPBOARD_EMPTY:  return "Clipboard is empty";
    case ERR_SELECT_MORE_ONE:  return "There are more than one selected entry";    
    case ERR_FILE_RENAMING:    return "Renaming the object";
    case ERR_FILE_COPYING:     return "Copying file";    
    case ERR_FILE_MOVING:      return "Moving file";        
    case ERR_FILE_MOV_SAMESITE:return "Can not move it to the same path";
    case ERR_QUOTA_OVER:       return "Quota of disc overstep";
    case ERR_SERVICE_INITIALIZING: return "Initializing service";
    case ERR_CREAT_USERDATABASESDIR: return "Creating User Databases Directory";
    case ERR_FILTERALREADYEXISTS: return "That filter already exists.";
   
    case ALT_LOGO:         return "Logoa";
    case ALT_NEXTPAGE_ACT: return "Hurrengo&nbsp;orrialdea";    
    case ALT_NEXTPAGE_INA: return "Hurrengo&nbsp;orrialdea";    
    case ALT_PREVPAGE_ACT: return "Aurreko&nbsp;orrialdea";
    case ALT_PREVPAGE_INA: return "Aurreko&nbsp;orrialdea";
    case ALT_FIRSTPAGE_ACT:return "Lehen&nbsp;orrialdea";
    case ALT_FIRSTPAGE_INA:return "Lehen&nbsp;orrialdea";
    case ALT_LASTPAGE_ACT: return "Azken&nbsp;orrialdea";
    case ALT_LASTPAGE_INA: return "Azken&nbsp;orrialdea";
    case ALT_DUMPFULLMSG:  return "Mezua&nbsp;deskargatu";
    case ALT_NEXTMSG:      return "Hurrengo&nbsp;mezua";
    case ALT_PREVMSG:      return "Aurreko&nbsp;mezua";
    case ALT_NEXTMSG_INA:  return "Hurrengo&nbsp;mezua";
    case ALT_PREVMSG_INA:  return "Aurreko&nbsp;mezua";    
    case ALT_HELP:         return "Laguntza";   
    case ALT_LOGOUT:       return "Irten";
    case ALT_EXPUNGE:      return "Purgatu"; 
    case ALT_COMPOSEMSG:   return "Osatu";     
    case ALT_MAILBOXES:    return "Postontziak";          
    case ALT_REPLYMSG:     return "Erantzun";
    case ALT_REPLYALLMSG:  return "Reply to All";    
    case ALT_FORWARDMSG:   return "Berriz&nbsp;igorri";
    case ALT_SHOWOPTIONS:  return "Aukerak";
    case ALT_ADDBOOK:      return "Agenda";
    case ALT_BACK:         return "Atzera";
    case ALT_SAVEADDRESS:  return "Helbidea&nbsp;gorde";        
    case ALT_SORT:         return "Ordenatu";
    case ALT_AB_NEWENTRY:  return "Sarrera&nbsp;berria";
    case ALT_AB_NEWENTRY_S:return "Sarrera&nbsp;berria";
    case ALT_DELNEXTMSG:   return "Ezabatu";
    case ALT_ABOUT:        return "...ren&nbsp;inguruan";      
    case ALT_UNDELNEXTMSG: return "Ezabatzea&nbsp;kendu";
    case ALT_AB_DUMP:      return "Agenda&nbsp;deskargatu"; 
    case ALT_AB_DUMP_S:    return "Deskargatu";       
    case ALT_DUMPFULLHEADER: return "Goiburukoak&nbsp;ezabatu";
    case ALT_SENDTONNTPGROUP:return "Send to Forum";
    case ALT_COMPOSEMSGNNTP:return "Send to Forum";    
    case ALT_ROOT:         return "Begin";
    case ALT_MAIL:         return "Mail";
    case ALT_NNTP:         return "Forums";
    case ALT_POPPASS:      return "Change Password";
    case ALT_FILEBROWSER:  return "File Browser";
    case ALT_FINGER:       return "Finger";
    case ALT_FORWARDMAIL:  return "Forwarding mail";  
    case ALT_SECVIRTUAL:   return "Secretaria Virtual";
    case ALT_UPSORT:       return "Ordenado";    
    case ALT_DOWNSORT:     return "Ordenado al rev&eacute;s";        
    case ALT_DATABASES:    return "Databases";
    case ALT_NEXTRECORD:   return "Next&nbsp;Record";
    case ALT_PREVRECORD:   return "Previous&nbsp;Record";
    case ALT_PREV:         return "Previous";
    case ALT_NEXT:         return "Next";
            
    case FORWARDLINE:      return "---------- Mezua berriz igorria ----------";
    
    default:               return "No string";
    }                            
  }
    

