%option noyywrap
%option yylineno

%{
/*
 * potool is a program aiding editing of po files
 * Copyright (C) 1999-2000 Zbigniew Chyla
 *
 * see LICENSE for licensing info
 */
#include <stdio.h>
#include <string.h>
#include <glib.h>
#include "i18n.h"
#include "po-gram.h"
#include "po.tab.h"

static YY_BUFFER_STATE buf_state = (YY_BUFFER_STATE) 0;
static FILE *buf_file = NULL;

void po_scan_open_file(gchar *fn)
{
	if ( buf_state != (YY_BUFFER_STATE) 0 ) {
		g_error(_("Trying to scan two files!"));
	}
	if ( (buf_file = fopen(fn, "r")) == NULL ) {
		g_error(_("Can't open input file: %s\n"), fn);
	}
	buf_state = yy_create_buffer(buf_file, YY_BUF_SIZE);
	yy_switch_to_buffer(buf_state);
}

void po_scan_close_file(void)
{
	if ( buf_state == (YY_BUFFER_STATE) 0 ) {
		g_error(_("Can't delete input buffer!"));
	}
	buf_state = NULL;
	buf_file = NULL;
	yy_delete_buffer(buf_state);
}


%}

%%
"msgid"             { return MSGID; }
"msgstr"            { return MSGSTR; }
\"(\\.|[^\\"])*\"   {
	int l = strlen(yytext);
	char *s = g_malloc(l - 2 + 1);

	if ( l > 2 ) {
		(void) g_memmove(s, yytext+1, l - 2);
	}
	s[l - 2] = '\0';
	polval.strval = s;
	return STRING;
}
"#:".*"\n"          {
	int l = strlen(yytext);
	char *s = g_malloc(l - 3 + 1);

	if ( l > 3 ) {
		(void) g_memmove(s, yytext+2, l - 3);
	}
	s[l - 3] = '\0';
	polval.strval = s;
	return COMMENT_POS;
}
"#,".*"\n"          {
	int l = strlen(yytext);
	char *s = g_malloc(l - 3 + 1);

	if ( l > 3 ) {
		(void) g_memmove(s, yytext+2, l - 3);
	}
	s[l - 3] = '\0';
	polval.strval = s;
	return COMMENT_SPECIAL;
}

"# ".*"\n"          {
	int l = strlen(yytext);
	char *s = g_malloc(l - 3 + 1);

	if ( l > 3 ) {
		(void) g_memmove(s, yytext+2, l - 3);
	}
	s[l - 3] = '\0';
	polval.strval = s;
	return COMMENT_STD;
}

"#".*"\n"     {
	int l = strlen(yytext);
	char *s = g_malloc(l - 2 + 1);

	if ( l > 2 ) {
		(void) g_memmove(s, yytext + 1, l - 2);
	}
	s[l - 2] = '\0';
	polval.strval = s;
	return COMMENT_RESERVED;
}

[ \t\v\f\n]         { ; }
.                   { return INVALID; }

%%
