/*
 *  $Id: info-page.c,v 1.2 2001/09/07 18:46:17 davej Exp $
 *	This file is part of Powertweak Linux.
 *	(C) 2000 Dave Jones, Arjan van de Ven.
 *
 * 	Licensed under the terms of the GNU GPL License version 2.
 *
 * Show PCI specific info
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <powertweak.h>

#include "pci.h"
#include "PCILIB/pciutils.h"
#include "PCILIB/header.h"


static void do_command_bit(int bit, char *bitname, struct pci_dev *dev, char *Menu1, char *Menu2, char *Menu3, char *devicestring)
{
	struct tweak *tweak;
	struct private_PCI_data *private;
	char *Tab = "PCI Info";
	char *OptionFrame = "PCI Capabilities";

	if ((tweak = alloc_PCI_tweak(dev, TYPE_INFO_BOOL)) != NULL) {
		private = (struct private_PCI_data *)tweak->PrivateData;
		tweak->WidgetText = strdup(bitname);
		if ( (pci_read_word(dev,PCI_COMMAND)&(bit))!=0)
			set_value_int(private->value,1);		
		else
			set_value_int(private->value,0);		
		RegisterTweak (tweak, "mmmmtf", Menu1, Menu2, Menu3, devicestring, Tab, OptionFrame);
	}
}


static void do_status_bit(int bit, char *bitname, struct pci_dev *dev, char *Menu1, char *Menu2, char *Menu3, char *devicestring)
{
	struct tweak *tweak;
	struct private_PCI_data *private;
	char *Tab = "PCI Info";
	char *OptionFrame = "PCI Capabilities";
	
	if ((tweak = alloc_PCI_tweak(dev, TYPE_INFO_BOOL)) != NULL) {
		private = (struct private_PCI_data *)tweak->PrivateData;
		tweak->WidgetText = strdup(bitname);
		if ( (pci_read_word(dev,PCI_STATUS)&(bit))!=0)
			set_value_int(private->value,1);		
		else
			set_value_int(private->value,0);		
		RegisterTweak (tweak, "mmmmtf", Menu1, Menu2, Menu3, devicestring, Tab, OptionFrame);
	}

}


void show_PCI_info (struct pci_dev *dev, char *Menu1, char *Menu2, char *Menu3, char *devicestring)
{
	struct tweak *tweak;
	struct private_PCI_data *private;
	char *Tab = "PCI Info";
	char *VendorID = "Vendor ID:";
	char *DeviceID = "Device ID:";
	char *IDFrame = "ID:";

	/* Display device name as a header. */
	tweak = alloc_PCI_tweak (dev, TYPE_LABEL);
	if (tweak == NULL)
		return;

	private = (struct private_PCI_data *)tweak->PrivateData;
	tweak->WidgetText = strdup (devicestring);
	RegisterTweak (tweak, "mmmmt", Menu1, Menu2, Menu3, devicestring, Tab);

	/* Now the info. */

	if ((tweak = alloc_PCI_tweak(dev, TYPE_INFO_STRING)) != NULL) {
		private = (struct private_PCI_data *)tweak->PrivateData;
		tweak->WidgetText = strdup(VendorID);
		private->value.strVal = malloc (8);
		snprintf (private->value.strVal, 7, "0x%.4x", dev->vendor_id);
		RegisterTweak (tweak, "mmmmth", Menu1, Menu2, Menu3, devicestring, Tab, IDFrame);
	}

	if ((tweak = alloc_PCI_tweak(dev, TYPE_INFO_STRING)) != NULL) {
		private = (struct private_PCI_data *)tweak->PrivateData;
		tweak->WidgetText = strdup(DeviceID);
		private->value.strVal = malloc (8);
		snprintf (private->value.strVal, 7, "0x%.4x", dev->device_id);
		RegisterTweak (tweak, "mmmmth", Menu1, Menu2, Menu3, devicestring, Tab, IDFrame);
	}

	do_command_bit(PCI_COMMAND_MASTER,"Busmaster",dev,Menu1,Menu2,Menu3,devicestring);
	do_command_bit(PCI_COMMAND_VGA_PALETTE,"VGA Palette snoop",dev,Menu1,Menu2,Menu3,devicestring);
	do_command_bit(PCI_COMMAND_FAST_BACK,"Fast back2back",dev,Menu1,Menu2,Menu3,devicestring);

	do_status_bit(PCI_STATUS_66MHZ,"66Mhz operation",dev,Menu1,Menu2,Menu3,devicestring);
}
