/*
 *  $Id: pci.h,v 1.5 2001/09/18 11:47:32 davej Exp $
 *	This file is part of Powertweak Linux.
 *	(C) 2000 Dave Jones, Arjan van de Ven.
 *
 * 	Licensed under the terms of the GNU GPL License version 2.
 *
 */

#ifndef _INCLUDE_GUARD_PCI_H_
#define _INCLUDE_GUARD_PCI_H_

#include "PCILIB/pciutils.h"

extern struct pci_access *pacc;

/* struct private_PCI_data contains
 * everything needed to get/set PCI values from the GUI
 */
struct private_PCI_data {
	struct pci_dev	*device;
	unsigned long base_address;
	unsigned long address_offset;
	unsigned long Mask;
	unsigned long OnMask;
	unsigned long OffMask;
	value_t value;
};

int fill_struct_tweak_from_PCI(struct tweak *tweak);

struct tweak *alloc_PCI_tweak (struct pci_dev *dev, int type);
void load_PCI_xmlfile (char *Filename);
void build_PCI_tree (int showinfo);
void show_PCI_info (struct pci_dev *dev, char *Menu1, char *Menu2, char *Menu3, char *devicestring);
void AddTo_PCI_tree (struct tweak *tweak, struct pci_dev *dev, char *Frame, char *Tab, char *Group, int showinfo);
#endif
